/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenCode;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.UMLAssociation;
import com.ibm.ebaf.gen.base.UMLAttribute;
import com.ibm.ebaf.gen.base.UMLClass;
import com.ibm.ebaf.gen.base.UMLEnumerationValue;
import com.ibm.mof.mof13.FactoryRegister;
import com.ibm.mof.mof13.extn.AggregationKindExtn;
import com.ibm.mof.mof13.extn.AssociationEndExtn;
import com.ibm.mof.mof13.extn.impl.AssociationEndExtnImpl;
import com.ibm.mof.mof13.extn.impl.AssociationExtnImpl;
import com.ibm.mof.mof13.extn.impl.AttributeExtnImpl;
import com.ibm.mof.mof13.extn.impl.ClassifierExtnImpl;
import com.ibm.mof.mof13.extn.impl.LinkHelperImpl;
import com.ibm.mof.mof13.extn.impl.MOFConstants;
import com.ibm.mof.mof13.extn.impl.MOFEnumValue;
import com.ibm.mof.mof13.extn.impl.MOFEnumerationImpl;
import com.ibm.mof.mof13.extn.impl.MofClassExtnImpl;
import com.ibm.mof.mof13.extn.impl.MultiplicityTypeExtnImpl;
import com.ibm.mof.mof13.extn.impl.PackageExtnImpl;
import com.ibm.mof.mof13.ref.extn.impl.RefBaseObjectExtnImpl;
import com.ibm.mof.mof13.ref.extn.impl.RefObjectExtnImpl;
import com.ibm.xmi.xmi11temp.IBMDocumentImport;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xmi.xmi11temp.IBMXMIDocumentRoot;
import com.ibm.xmi.xmi11temp.impl.XMIDOMParser;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentImpl;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentRoot;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DocumentToJava {
    IBMXMIDocument myDoc;
    private String genDir = "e:\\genCode";
    private Hashtable classIdTable = new Hashtable();
    private String fimplPrefix = null;
    private String fimplPostfix = null;
    private String fimplPackage = null;
    private String finterfacePrefix = null;
    private String finterfacePostfix = null;
    private String finterfacePackage = null;
    private String genOption = "ebaf";
    private String schemaDoc = "";
    Vector localClasses = new Vector();

    public DocumentToJava() {
    }

    public DocumentToJava(IBMXMIDocument iBMXMIDocument) {
        this.myDoc = iBMXMIDocument;
    }

    public DocumentToJava(String string) {
        System.out.println(" ************** Processing Document file : " + string);
        XMIDOMParser xMIDOMParser = new XMIDOMParser();
        xMIDOMParser.setDebug();
        XMIDocumentImpl xMIDocumentImpl = new XMIDocumentImpl();
        xMIDOMParser.setDocument(xMIDocumentImpl);
        try {
            xMIDOMParser.parse(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Document File not Found : " + string);
            System.exit(1);
        }
        this.myDoc = xMIDocumentImpl;
    }

    public void generate() {
        if (this.genDir == null) {
            System.out.println("Cannot printXMI because XMI path is not set");
        }
        this.processDocument();
        PackageExtnImpl packageExtnImpl = this.getMOFPackage(this.myDoc);
        this.fimplPackage = packageExtnImpl.getMOFPackageName() == null ? "" : packageExtnImpl.getMOFPackageName();
        this.fimplPrefix = packageExtnImpl.getMOFPrefix() == null ? "" : packageExtnImpl.getMOFPrefix();
        this.fimplPostfix = packageExtnImpl.getMOFPostfix() == null ? "" : packageExtnImpl.getMOFPostfix();
        this.finterfacePackage = packageExtnImpl.getMOFIPackageName() == null ? "" : packageExtnImpl.getMOFIPackageName();
        this.finterfacePrefix = packageExtnImpl.getMOFIPrefix() == null ? "" : packageExtnImpl.getMOFIPrefix();
        this.finterfacePostfix = packageExtnImpl.getMOFIPostfix() == null ? "" : packageExtnImpl.getMOFIPostfix();
        GenCode genCode = new GenCode(this.classIdTable);
        genCode.setGenDir(this.genDir);
        genCode.setImplPackage(this.fimplPackage);
        genCode.setImplPrefix(this.fimplPrefix);
        genCode.setImplPostfix(this.fimplPostfix);
        genCode.setInterfacePackage(this.finterfacePackage);
        genCode.setInterfacePrefix(this.finterfacePrefix);
        genCode.setInterfacePostfix(this.finterfacePostfix);
        genCode.setGenOption(this.genOption);
        genCode.setSchemaDocument(this.schemaDoc);
        genCode.generate();
    }

    public void generate_old() {
    }

    private String getDocumentation(MOFEnumerationImpl mOFEnumerationImpl) {
        System.out.println("\n ---------------------------------------");
        System.out.println("Enumeration Class Name = " + mOFEnumerationImpl.getID());
        String string = "";
        Vector vector = (Vector)mOFEnumerationImpl.getValue(MOFConstants.mofEnumValuesRole);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MOFEnumValue mOFEnumValue = (MOFEnumValue)enumeration.nextElement();
            System.out.println("Enum String = " + mOFEnumValue.getName() + "    Int Value = " + mOFEnumValue.getNumber());
            string = String.valueOf(string) + mOFEnumValue.getName() + "=" + mOFEnumValue.getNumber() + " ";
            System.out.println("doc = " + string);
        }
        return string;
    }

    public PackageExtnImpl getMOFPackage(IBMXMIDocument iBMXMIDocument) {
        PackageExtnImpl packageExtnImpl = null;
        XMIDocumentRoot xMIDocumentRoot = (XMIDocumentRoot)((XMIDocumentImpl)iBMXMIDocument).getDocumentRoot();
        packageExtnImpl = xMIDocumentRoot.getRootPackage();
        return packageExtnImpl;
    }

    public PackageExtnImpl getMOFPackage_old(XMIDocumentImpl xMIDocumentImpl) {
        return null;
    }

    public UMLClass getUMLClass(ClassifierExtnImpl classifierExtnImpl) {
        String string = classifierExtnImpl.getID();
        UMLClass uMLClass = (UMLClass)this.classIdTable.get(string);
        if (uMLClass == null) {
            MofClassExtnImpl mofClassExtnImpl;
            PackageExtnImpl packageExtnImpl;
            uMLClass = new UMLClass();
            uMLClass.setId(string);
            this.classIdTable.put(uMLClass.getId(), uMLClass);
            if (classifierExtnImpl instanceof MofClassExtnImpl && (packageExtnImpl = (PackageExtnImpl)(mofClassExtnImpl = (MofClassExtnImpl)classifierExtnImpl).getContainer()) != null) {
                System.out.println("MOf Impl Package Name = " + packageExtnImpl.getMOFPackageName());
                System.out.println("MOf Impl Postfix      = " + packageExtnImpl.getMOFPostfix());
                System.out.println("MOf Impl Prefix       = " + packageExtnImpl.getMOFPrefix());
                uMLClass.setImplPrefix(packageExtnImpl.getMOFPrefix() == null ? "" : packageExtnImpl.getMOFPrefix());
                uMLClass.setImplPostfix(packageExtnImpl.getMOFPostfix() == null ? "" : packageExtnImpl.getMOFPostfix());
                uMLClass.setImplPackage(packageExtnImpl.getMOFPackageName() == null ? "" : packageExtnImpl.getMOFPackageName());
                uMLClass.setInterfacePrefix(packageExtnImpl.getMOFIPrefix() == null ? "" : packageExtnImpl.getMOFIPrefix());
                uMLClass.setInterfacePostfix(packageExtnImpl.getMOFIPostfix() == null ? "" : packageExtnImpl.getMOFIPostfix());
                uMLClass.setInterfacePackage(packageExtnImpl.getMOFIPackageName() == null ? "" : packageExtnImpl.getMOFIPackageName());
            }
        }
        return uMLClass;
    }

    private Vector getUMLEnumValues(MOFEnumerationImpl mOFEnumerationImpl) {
        System.out.println("\n ---------------------------------------");
        System.out.println("Enumeration Class Name = " + mOFEnumerationImpl.getID());
        Vector<UMLEnumerationValue> vector = new Vector<UMLEnumerationValue>();
        Enumeration enumeration = (Enumeration)mOFEnumerationImpl.getValue(MOFConstants.mofEnumValuesRole);
        while (enumeration.hasMoreElements()) {
            MOFEnumValue mOFEnumValue = (MOFEnumValue)enumeration.nextElement();
            System.out.println("Enum String = " + mOFEnumValue.getName() + "    Int Value = " + mOFEnumValue.getNumber());
            UMLEnumerationValue uMLEnumerationValue = new UMLEnumerationValue();
            uMLEnumerationValue.setLabel(mOFEnumValue.getName());
            uMLEnumerationValue.setValue(mOFEnumValue.getNumber());
            vector.addElement(uMLEnumerationValue);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = "e:\\genMof";
        String string2 = "ebaf.awt";
        String string3 = "";
        String string4 = "ebaf";
        String string5 = "Usage: DocumentToJava doc-file.xml -d<Gen Dir> -p<Package Name> -i<Interface Prefix> -g<GenOption> ";
        if (stringArray.length < 1) {
            System.out.println(string5);
            System.exit(1);
        }
        String string6 = stringArray[0];
        boolean bl = false;
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-d")) {
                string = stringArray[n].substring(2);
            } else if (stringArray[n].startsWith("-p")) {
                string2 = stringArray[n].substring(2);
            } else if (stringArray[n].startsWith("-i")) {
                string3 = stringArray[n].substring(2);
            } else if (stringArray[n].startsWith("-g")) {
                string4 = stringArray[n].substring(2);
            } else {
                System.out.println("Invalid option Specified :" + stringArray[n]);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            System.out.println(string5);
            System.exit(1);
        }
        System.out.println("Begin DocumentToJava..");
        DocumentToJava documentToJava = new DocumentToJava(string6);
        documentToJava.setGenDir(string);
        documentToJava.setImplPrefix(string3);
        documentToJava.setImplPackage(string2);
        documentToJava.setGenOption(string4);
        documentToJava.generate();
        System.out.println("End DocumentToJava");
    }

    public void processAssociationEnds(AssociationEndExtnImpl associationEndExtnImpl) {
        System.out.println("\n--SKK-----------Association Ends ------- \n");
        System.out.println(" Association End = " + associationEndExtnImpl.getID());
        System.out.println("    isNavigable    = " + associationEndExtnImpl.isNavigable());
        System.out.println("    isPrimary      = " + ((LinkHelperImpl)associationEndExtnImpl.getHelper()).isPrimary());
        System.out.println("    isBinary     = " + associationEndExtnImpl.isBinary());
        AggregationKindExtn aggregationKindExtn = (AggregationKindExtn)associationEndExtnImpl.getAggregation();
        System.out.println("    isByValue     = " + aggregationKindExtn.isComposite());
        System.out.println("    Aggregation  = " + aggregationKindExtn);
        System.out.println("    Multiplicity = " + associationEndExtnImpl.getMultiplicity());
        System.out.println("    TargetClass    = " + ((ClassifierExtnImpl)associationEndExtnImpl.getType()).getID());
        if (associationEndExtnImpl.isBinary()) {
            System.out.println("    SourceClass    = " + ((ClassifierExtnImpl)associationEndExtnImpl.otherEnd().getType()).getID());
        }
    }

    public void processAssociations(AssociationExtnImpl associationExtnImpl) {
        System.out.println("\n\nProcess Association  ID = ..... " + associationExtnImpl.getID());
        UMLAssociation uMLAssociation = new UMLAssociation();
        uMLAssociation.setId(associationExtnImpl.getID());
        Enumeration enumeration = (Enumeration)associationExtnImpl.getValue(MOFConstants.mofAssociationEndsRole);
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AssociationEndExtnImpl associationEndExtnImpl = (AssociationEndExtnImpl)enumeration.nextElement();
            System.out.println(" Association End = " + associationEndExtnImpl.getID());
            System.out.println("    roleName       = " + associationEndExtnImpl.getName());
            System.out.println("    isNavigable    = " + associationEndExtnImpl.isNavigable());
            System.out.println("    isPrimary      = " + ((LinkHelperImpl)associationEndExtnImpl.getHelper()).isPrimary());
            System.out.println("    isBinary       = " + associationEndExtnImpl.isBinary());
            AggregationKindExtn aggregationKindExtn = (AggregationKindExtn)associationEndExtnImpl.getAggregation();
            System.out.println("    isByValue      = " + aggregationKindExtn.isComposite());
            System.out.println("    Aggregation    = " + aggregationKindExtn);
            System.out.println("    Multiplicity   = " + associationEndExtnImpl.getMultiplicity());
            System.out.println("    TargetClass    = " + ((ClassifierExtnImpl)associationEndExtnImpl.getType()).getID());
            if (associationEndExtnImpl.isBinary()) {
                System.out.println("    SourceClass    = " + ((ClassifierExtnImpl)associationEndExtnImpl.otherEnd().getType()).getID());
            }
            uMLAssociation.setClassId(((ClassifierExtnImpl)associationEndExtnImpl.getType()).getID(), n);
            uMLAssociation.setId(associationEndExtnImpl.getID(), n);
            uMLAssociation.setLabel(associationEndExtnImpl.getName(), n);
            MultiplicityTypeExtnImpl multiplicityTypeExtnImpl = (MultiplicityTypeExtnImpl)associationEndExtnImpl.getMultiplicity();
            uMLAssociation.setMultiplicity(multiplicityTypeExtnImpl.isMany() ? 2 : 1, n);
            uMLAssociation.setOrdered(multiplicityTypeExtnImpl.isOrdered(), n);
            aggregationKindExtn = (AggregationKindExtn)associationEndExtnImpl.getAggregation();
            uMLAssociation.setContainment(aggregationKindExtn.isComposite() ? "ByValue" : "", n);
            uMLAssociation.setNavigable(associationEndExtnImpl.isNavigable(), n);
            uMLAssociation.setAggregation(associationEndExtnImpl.getAggregationInt(), n);
            uMLAssociation.setDominantRole(((LinkHelperImpl)associationEndExtnImpl.getHelper()).isPrimary(), n);
            UMLClass uMLClass = this.getUMLClass((ClassifierExtnImpl)associationEndExtnImpl.otherEnd().getType());
            UMLClass uMLClass2 = this.getUMLClass((ClassifierExtnImpl)associationEndExtnImpl.getType());
            uMLAssociation.setSourceClass(uMLClass, n);
            uMLAssociation.setTargetClass(uMLClass2, n);
            uMLClass.addAssociation(uMLAssociation);
            uMLClass.addAssociationEnd(uMLAssociation.getAssociationEnd(n));
            ++n;
        }
    }

    public void processAttributes(AttributeExtnImpl attributeExtnImpl, UMLClass uMLClass) {
        System.out.println(" Attr  ID = " + attributeExtnImpl.getID());
        System.out.println("    Label = " + attributeExtnImpl.getName());
        System.out.println("    Type  = " + ((ClassifierExtnImpl)attributeExtnImpl.getType()).getID());
        UMLAttribute uMLAttribute = new UMLAttribute();
        uMLClass.addAttribute(uMLAttribute);
        uMLAttribute.setAttrClass(uMLClass);
        uMLAttribute.setLabel(attributeExtnImpl.getName());
        uMLAttribute.setId(attributeExtnImpl.getID());
        uMLAttribute.setVisibility(attributeExtnImpl.getVisibilityInt());
        UMLClass uMLClass2 = this.getUMLClass((ClassifierExtnImpl)attributeExtnImpl.getType());
        uMLAttribute.setAttrTypeClass(uMLClass2);
        GenOptions.debug("Attr Type Class = " + attributeExtnImpl.getType());
        if (attributeExtnImpl.getType() instanceof MOFEnumerationImpl) {
            this.localClasses.addElement(attributeExtnImpl.getType());
        }
        String string = null;
        Object object = attributeExtnImpl.getValue(MOFConstants.mofAttributeDefaultValueAttr);
        if (object != null) {
            string = object.toString();
        }
        uMLAttribute.setDefaultValue(string);
    }

    public void processClasses(MofClassExtnImpl mofClassExtnImpl) {
        Object object;
        if (mofClassExtnImpl == null) {
            return;
        }
        System.out.println("\n ---------------------------------------");
        System.out.println("Class Name = " + mofClassExtnImpl.getID());
        UMLClass uMLClass = this.getUMLClass(mofClassExtnImpl);
        uMLClass.setAbstract(mofClassExtnImpl.isAbstract());
        uMLClass.setVisibility(mofClassExtnImpl.getVisibilityInt());
        if (mofClassExtnImpl instanceof MOFEnumerationImpl) {
            uMLClass.enumType(true);
            uMLClass.setEnumerationValues(this.getUMLEnumValues((MOFEnumerationImpl)mofClassExtnImpl));
        }
        Collection collection = mofClassExtnImpl.getSupertypes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (MofClassExtnImpl)iterator.next();
            System.out.println(" Super Classes = " + ((RefBaseObjectExtnImpl)object).getID());
            uMLClass.addParentClass(this.getUMLClass((ClassifierExtnImpl)object));
        }
        object = (Enumeration)mofClassExtnImpl.getValue(MOFConstants.mofNamespaceContentsRole);
        while (object.hasMoreElements()) {
            AttributeExtnImpl attributeExtnImpl = (AttributeExtnImpl)object.nextElement();
            if (attributeExtnImpl instanceof AssociationEndExtn) {
                System.out.println("********** Assoc End Attr Name = " + attributeExtnImpl.getName());
                continue;
            }
            if (attributeExtnImpl instanceof AttributeExtnImpl) {
                System.out.println("************ Attr Name = " + attributeExtnImpl.getName());
                this.processAttributes(attributeExtnImpl, uMLClass);
                continue;
            }
            System.out.println("Do not know how to handle type = " + attributeExtnImpl);
        }
    }

    public void processDocument() {
        PackageExtnImpl packageExtnImpl = this.getMOFPackage(this.myDoc);
        if (packageExtnImpl == null) {
            System.out.println("Cannot generate code because Package does not exist in the Schema document ");
            System.exit(1);
        }
        Collection collection = packageExtnImpl.getContents();
        this.processDocument(collection);
        Enumeration enumeration = this.localClasses.elements();
        this.processDocument(enumeration);
        IBMXMIDocumentRoot iBMXMIDocumentRoot = (IBMXMIDocumentRoot)((XMIDocumentImpl)this.myDoc).getDocumentRoot();
        Vector vector = iBMXMIDocumentRoot.getImports();
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            IBMDocumentImport iBMDocumentImport = (IBMDocumentImport)enumeration2.nextElement();
            String string = iBMDocumentImport.getDocumentURL();
            String string2 = iBMDocumentImport.getDocumentAlias();
            System.out.println(" Pkg alias = " + string2 + "  Pkg url = " + string);
        }
    }

    public void processDocument(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)iterator.next();
            if (refObjectExtnImpl instanceof AssociationExtnImpl) {
                System.out.println("\n Top level Object is of type Association = " + refObjectExtnImpl);
                this.processAssociations((AssociationExtnImpl)refObjectExtnImpl);
                continue;
            }
            if (refObjectExtnImpl instanceof AssociationEndExtnImpl) {
                System.out.println("\n Top level Object is of type MOFAssociationEnd = " + refObjectExtnImpl);
                continue;
            }
            if (refObjectExtnImpl instanceof AttributeExtnImpl) {
                System.out.println("\n Top level Object is of type MOFAttribute = " + refObjectExtnImpl);
                continue;
            }
            if (refObjectExtnImpl instanceof MOFEnumerationImpl) {
                System.out.println("\n Top level Object is of type MOFEnumeration = " + refObjectExtnImpl);
                this.processClasses((MofClassExtnImpl)refObjectExtnImpl);
                continue;
            }
            if (refObjectExtnImpl instanceof MofClassExtnImpl) {
                System.out.println("\n Top level Object is of type MOFClass = " + refObjectExtnImpl);
                this.processClasses((MofClassExtnImpl)refObjectExtnImpl);
                continue;
            }
            System.out.println("\n Top level Check the type of Mof Object = " + refObjectExtnImpl);
        }
    }

    public void processDocument(Enumeration enumeration) {
        Collection collection = FactoryRegister.getFactory().createCollection();
        while (enumeration.hasMoreElements()) {
            RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)enumeration.nextElement();
            collection.add(refObjectExtnImpl);
        }
        this.processDocument(collection);
    }

    public void processDocument_old() {
    }

    public void setGenDir(String string) {
        this.genDir = string;
    }

    private void setGenOption(String string) {
        this.genOption = string;
    }

    private void setImplPackage(String string) {
        this.fimplPackage = string;
    }

    private void setImplPostfix(String string) {
        this.fimplPostfix = string;
    }

    private void setImplPrefix(String string) {
        this.fimplPrefix = string;
    }

    private void setInterfacePostfix(String string) {
        this.finterfacePostfix = string;
    }

    private void setInterfacePrefix(String string) {
        this.finterfacePrefix = string;
    }

    public void setSchemaDocument(String string) {
        this.schemaDoc = string;
    }
}

