/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.GenFileUtil;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.GenUtil;
import com.ibm.ebaf.gen.base.UMLClass;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GenDocument {
    private Hashtable classIdTable = null;

    public GenDocument() {
    }

    public GenDocument(Hashtable hashtable) {
        this.classIdTable = hashtable;
    }

    public void genImplDocumentClass() {
        String string = String.valueOf(GenFileUtil.getImplementationDirPath()) + File.separator + GenOptions.instance().getImplDocumentClassName() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplDocumentHeader());
        printWriter.println("package " + GenOptions.instance().getImplPackage() + ";");
        printWriter.println(this.genImplDocumentImports());
        printWriter.println(this.genImplDocumentClassName());
        printWriter.println("{");
        printWriter.println("\n");
        printWriter.println(this.genImplDocumentConstructor());
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public String genImplDocumentClassName() {
        String string = "public class " + GenOptions.instance().getImplDocumentClassName();
        string = String.valueOf(string) + " extends " + GenOptions.instance().getImplGenDocumentClassName();
        string = String.valueOf(string) + " implements " + GenOptions.instance().getDocumentInterface();
        return string;
    }

    public String genImplDocumentConstructor() {
        String string = "  public " + GenOptions.instance().getImplDocumentClassName();
        string = String.valueOf(string) + "()" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  {" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "    super();";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  }";
        String string2 = "  public " + GenOptions.instance().getImplDocumentClassName();
        string2 = String.valueOf(string2) + "(com.ibm.xmi.xmi11temp.IBMXMIDocument doc)" + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "  {" + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "    super(doc);";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "  }";
        return String.valueOf(string) + GenConstants.NEW_LINE + string2;
    }

    private String genImplDocumentHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplDocumentImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage() + ".*;" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "import " + GenOptions.instance().getImplGenPackage() + ".*;" + GenConstants.NEW_LINE;
        return string;
    }

    public String genImplGenAddMethod(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + "void";
        string = String.valueOf(string) + "   add" + GenUtil.toUpperFL(uMLClass.getGenName());
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + "  child)";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "    ((XMIDocumentRoot)fDoc.getDocumentRoot()).setValue(";
        string2 = String.valueOf(string2) + "XMIConstants.xmiDocumentContents, child";
        string2 = String.valueOf(string2) + ");\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplGenAddRemListMethods(UMLClass uMLClass) {
        String string = this.genImplGenAddMethod(uMLClass);
        String string2 = this.genImplGenListMethod(uMLClass);
        String string3 = this.genImplGenRemMethod(uMLClass);
        return String.valueOf(string) + "\n" + string2 + "\n" + string3;
    }

    public void genImplGenDocumentClass() {
        String string = String.valueOf(GenFileUtil.getImplementationGenDirPath()) + File.separator + GenOptions.instance().getImplGenDocumentClassName() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplGenPackageHeader());
        printWriter.println("package " + GenOptions.instance().getImplGenPackage() + ";");
        printWriter.println(this.genImplGenDocumentImports());
        printWriter.println(this.genImplGenDocumentClassName());
        printWriter.println("{");
        printWriter.println(GenConstants.NEW_LINE);
        printWriter.println(this.genImplGenInstanceVars());
        printWriter.println(GenConstants.NEW_LINE);
        printWriter.println(this.genImplGenDocumentConstructor());
        printWriter.println(GenConstants.NEW_LINE);
        printWriter.println(this.genImplGenSupportMethods());
        printWriter.println(GenConstants.NEW_LINE);
        Enumeration enumeration = this.classIdTable.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isAbstract() || uMLClass.isEnumType() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            printWriter.println(this.genImplGenAddRemListMethods(uMLClass));
        }
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public String genImplGenDocumentClassName() {
        String string = "public class " + GenOptions.instance().getImplGenDocumentClassName();
        string = String.valueOf(string) + " implements " + GenOptions.instance().getDocumentGenInterface();
        return string;
    }

    public String genImplGenDocumentConstructor() {
        String string = "  protected " + GenOptions.instance().getImplGenDocumentClassName();
        string = String.valueOf(string) + "()" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  {" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "    super()";
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  }";
        String string2 = "  protected " + GenOptions.instance().getImplGenDocumentClassName();
        string2 = String.valueOf(string2) + "(IBMXMIDocument doc)" + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "  {" + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "    fDoc = (XMIDocumentImpl)doc";
        string2 = String.valueOf(string2) + ";" + GenConstants.NEW_LINE;
        string2 = String.valueOf(string2) + "  }";
        return String.valueOf(string) + GenConstants.NEW_LINE + string2;
    }

    public String genImplGenDocumentImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfaceGenPackage() + ".*;\n";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage() + ".*;\n";
        if (GenOptions.instance().getImplPackage().compareTo(GenOptions.instance().getInterfacePackage()) != 0) {
            string = String.valueOf(string) + "import " + GenOptions.instance().getImplPackage() + ".*;\n";
        }
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + GenConstants.FRAMEWORK_IMPORTS_EBAF : String.valueOf(string) + GenConstants.FRAMEWORK_IMPORTS_XMI;
        string = String.valueOf(string) + GenConstants.JAVA_IMPORTS;
        return string;
    }

    public String genImplGenInstanceVars() {
        String string = "";
        string = String.valueOf(string) + GenConstants.NEW_LINE + "  ";
        string = String.valueOf(string) + "private XMIDocumentImpl fDoc = null;";
        return string;
    }

    public String genImplGenListMethod(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + "[]";
        string = String.valueOf(string) + "   list" + GenUtil.toUpperFL(uMLClass.getGenName());
        string = String.valueOf(string) + "()";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "    Enumeration enum = (Enumeration) ((XMIDocumentRoot)fDoc.getDocumentRoot()).getValue(";
        string2 = String.valueOf(string2) + "XMIConstants.xmiDocumentContents";
        string2 = String.valueOf(string2) + ");\n";
        string2 = String.valueOf(string2) + "    ";
        string2 = String.valueOf(string2) + "return ";
        string2 = String.valueOf(string2) + "(";
        string2 = String.valueOf(string2) + uMLClass.getInterfaceClassName();
        string2 = String.valueOf(string2) + "[]";
        string2 = String.valueOf(string2) + ")";
        string2 = String.valueOf(string2) + "MOFTypedObjectSupport.selectObjectsByClass(enum,";
        string2 = String.valueOf(string2) + GenOptions.instance().getImplFactoryClassName();
        string2 = String.valueOf(string2) + ".";
        string2 = String.valueOf(string2) + uMLClass.getGenName() + "_MOFClass";
        string2 = String.valueOf(string2) + ",";
        string2 = String.valueOf(string2) + uMLClass.getInterfaceClassName() + ".class";
        string2 = String.valueOf(string2) + ");";
        string2 = String.valueOf(string2) + "\n";
        string2 = String.valueOf(string2) + "\n  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    private String genImplGenPackageHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplGenRemMethod(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + "void";
        string = String.valueOf(string) + "   remove" + GenUtil.toUpperFL(uMLClass.getGenName());
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + "  child)";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "    ((XMIDocumentRoot)fDoc.getDocumentRoot()).removeValue(";
        string2 = String.valueOf(string2) + "XMIConstants.xmiDocumentContents, child";
        string2 = String.valueOf(string2) + ");\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplGenSupportMethods() {
        String string = "";
        String string2 = "";
        String string3 = "";
        string2 = String.valueOf(string2) + "  public ";
        string2 = String.valueOf(string2) + "IBMXMIDocument ";
        string2 = String.valueOf(string2) + "   getXMIDocument";
        string2 = String.valueOf(string2) + "()";
        string3 = String.valueOf(string3) + "  {" + GenConstants.NEW_LINE;
        string3 = String.valueOf(string3) + "    ";
        string3 = String.valueOf(string3) + " return fDoc;  ";
        string3 = String.valueOf(string3) + GenConstants.NEW_LINE;
        string3 = String.valueOf(string3) + "  }" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + string2 + GenConstants.NEW_LINE + string3;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string2 = "  public ";
        string2 = String.valueOf(string2) + "void ";
        string2 = String.valueOf(string2) + "   save";
        string2 = String.valueOf(string2) + "() throws java.io.IOException";
        string3 = "  {" + GenConstants.NEW_LINE;
        string3 = String.valueOf(string3) + "    ";
        string3 = String.valueOf(string3) + " fDoc.save();  ";
        string3 = String.valueOf(string3) + GenConstants.NEW_LINE;
        string3 = String.valueOf(string3) + "  }" + GenConstants.NEW_LINE;
        string = String.valueOf(string) + string2 + GenConstants.NEW_LINE + string3;
        return string;
    }

    public void genImplementations() {
        this.genImplGenDocumentClass();
        this.genImplDocumentClass();
    }
}

