/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.GenFileUtil;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.GenUtil;
import com.ibm.ebaf.gen.base.UMLAssociationEnd;
import com.ibm.ebaf.gen.base.UMLAttribute;
import com.ibm.ebaf.gen.base.UMLClass;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GenFactory {
    private Hashtable classIdTable = null;

    public GenFactory() {
    }

    public GenFactory(Hashtable hashtable) {
        this.classIdTable = hashtable;
    }

    private String genImplClassStatics() {
        String string = "";
        string = String.valueOf(string) + "  private static ";
        string = String.valueOf(string) + GenOptions.instance().getFactoryInterface();
        string = String.valueOf(string) + " fFactory = null;" + GenConstants.NEW_LINE;
        return string;
    }

    public String genImplCreateInstanceMethod() {
        String string = "";
        string = String.valueOf(string) + "  public static ";
        string = String.valueOf(string) + GenOptions.instance().getFactoryInterface();
        string = String.valueOf(string) + "   instance()";
        String string2 = "  {";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE4;
        string2 = String.valueOf(string2) + "if (fFactory == null) {";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE6;
        string2 = String.valueOf(string2) + "fFactory = new ";
        string2 = String.valueOf(string2) + GenOptions.instance().getImplFactoryClassName();
        string2 = String.valueOf(string2) + "();";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE4;
        string2 = String.valueOf(string2) + "}";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE4;
        string2 = String.valueOf(string2) + "return fFactory;";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE2;
        string2 = String.valueOf(string2) + "}";
        string2 = String.valueOf(string2) + GenConstants.NEW_LINE;
        return String.valueOf(string) + GenConstants.NEW_LINE + string2;
    }

    public void genImplFactoryClass() {
        String string = String.valueOf(GenFileUtil.getImplementationDirPath()) + File.separator + GenOptions.instance().getImplFactoryClassName() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplFactoryHeader());
        printWriter.println("package " + GenOptions.instance().getImplPackage() + ";");
        printWriter.println(this.genImplFactoryImports());
        printWriter.println(this.genImplFactoryClassName());
        printWriter.println("{");
        printWriter.println("\n");
        printWriter.println(this.genImplClassStatics());
        printWriter.println("\n");
        printWriter.println(this.genImplFactoryConstructor());
        printWriter.println("\n");
        printWriter.println(this.genImplCreateInstanceMethod());
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public String genImplFactoryClassName() {
        String string = "public class " + GenOptions.instance().getImplFactoryClassName();
        string = String.valueOf(string) + " extends " + GenOptions.instance().getImplGenFactoryClassName();
        string = String.valueOf(string) + " implements " + GenOptions.instance().getFactoryInterface();
        return string;
    }

    public String genImplFactoryConstructor() {
        String string = "  private " + GenOptions.instance().getImplFactoryClassName();
        string = String.valueOf(string) + "()\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    super();";
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "  }";
        return string;
    }

    private String genImplFactoryHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplFactoryImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage() + ".";
        string = String.valueOf(string) + GenOptions.instance().getFactoryInterface();
        string = String.valueOf(string) + ";\n";
        string = String.valueOf(string) + "import " + GenOptions.instance().getImplGenPackage() + ".*;\n";
        return string;
    }

    public String genImplGenAdaptorSupportMethods() {
        String string = "";
        string = String.valueOf(string) + "  protected ";
        string = String.valueOf(string) + "void ";
        string = String.valueOf(string) + "   addAdaptorFactories";
        string = String.valueOf(string) + "(com.ibm.xmi.xmi11temp.IBMXMIDocument toDocument)";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplGenCreateMethod(UMLClass uMLClass) {
        if (uMLClass.isEnumType() || uMLClass.isPrimitiveType()) {
            return "";
        }
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + "   create" + GenUtil.toUpperFL(uMLClass.getGenName());
        string = String.valueOf(string) + "()";
        String string2 = "";
        if (uMLClass.isAbstract()) {
            string2 = "  {";
            string2 = String.valueOf(string2) + GenConstants.NEW_LINE4;
            string2 = String.valueOf(string2) + "return null;";
            string2 = String.valueOf(string2) + GenConstants.NEW_LINE2;
            string2 = String.valueOf(string2) + "}" + GenConstants.NEW_LINE;
        } else {
            string2 = String.valueOf(string2) + "  {";
            string2 = String.valueOf(string2) + GenConstants.NEW_LINE4;
            string2 = String.valueOf(string2) + "return ";
            string2 = String.valueOf(string2) + "(";
            string2 = String.valueOf(string2) + uMLClass.getInterfaceClassName();
            string2 = String.valueOf(string2) + ")";
            string2 = String.valueOf(string2) + " fCurrentDocument.newInstance(";
            string2 = String.valueOf(string2) + GenOptions.instance().getImplFactoryClassName() + ".";
            string2 = String.valueOf(string2) + uMLClass.getGenName();
            string2 = String.valueOf(string2) + "_MOFClass";
            string2 = String.valueOf(string2) + ");";
            string2 = String.valueOf(string2) + GenConstants.NEW_LINE2;
            string2 = String.valueOf(string2) + "}" + GenConstants.NEW_LINE;
        }
        return String.valueOf(string) + GenConstants.NEW_LINE + string2;
    }

    public String genImplGenCreateSupportMethods() {
        return "";
    }

    public String genImplGenCreateSupportMethods(UMLClass uMLClass) {
        if (uMLClass.isEnumType() || uMLClass.isPrimitiveType()) {
            return "";
        }
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + "   create" + uMLClass.getName();
        string = String.valueOf(string) + "()";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "    IMOFObject ";
        string2 = String.valueOf(string2) + GenUtil.instanceVariable(uMLClass.getName());
        string2 = String.valueOf(string2) + " = ";
        string2 = String.valueOf(string2) + GenOptions.instance().getImplFactoryClassName() + ".";
        string2 = String.valueOf(string2) + uMLClass.getGenName();
        string2 = String.valueOf(string2) + "_MOFClass";
        string2 = String.valueOf(string2) + ".refCreateInstance();";
        string2 = String.valueOf(string2) + "\n";
        string2 = String.valueOf(string2) + "    ";
        string2 = String.valueOf(string2) + uMLClass.getInterfaceClassName();
        string2 = String.valueOf(string2) + " delegate = ";
        string2 = String.valueOf(string2) + " new  ";
        string2 = String.valueOf(string2) + uMLClass.getImplClassName();
        string2 = String.valueOf(string2) + "();\n";
        string2 = String.valueOf(string2) + "    ";
        string2 = String.valueOf(string2) + "((MOFObjectDelegate)delegate).setMOFObject((IBMMOFObject) ";
        string2 = String.valueOf(string2) + GenUtil.instanceVariable(uMLClass.getName());
        string2 = String.valueOf(string2) + ");\n";
        string2 = String.valueOf(string2) + "    ";
        string2 = String.valueOf(string2) + "((MOFObjectDelegate)delegate).setDomain(domainModel);";
        string2 = String.valueOf(string2) + "\n";
        string2 = String.valueOf(string2) + "    ";
        string2 = String.valueOf(string2) + " return delegate;  ";
        string2 = String.valueOf(string2) + "\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public void genImplGenFactoryClass() {
        String string = String.valueOf(GenFileUtil.getImplementationGenDirPath()) + File.separator + GenOptions.instance().getImplGenFactoryClassName() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplGenFactoryHeader());
        printWriter.println("package " + GenOptions.instance().getImplGenPackage() + ";");
        printWriter.println(this.genImplGenFactoryImports());
        printWriter.println(this.genImplGenFactoryClassName());
        printWriter.println("{");
        printWriter.println("\n");
        printWriter.println(this.genImplGenInstanceVars());
        printWriter.println("\n");
        printWriter.println(this.genImplGenStatics());
        printWriter.println("\n");
        printWriter.println(this.genImplGenFactoryConstructor());
        printWriter.println(this.genImplGenStaticInitialization());
        printWriter.println("\n");
        printWriter.println(this.genImplGenAdaptorSupportMethods());
        printWriter.println("\n");
        printWriter.println(this.genImplGenLoadCreateDocumentMethods());
        printWriter.println("\n");
        Enumeration enumeration = this.classIdTable.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isAbstract() || uMLClass.isReservedClass() || uMLClass.isFromDifferentPackage()) continue;
            printWriter.println(this.genImplGenCreateMethod(uMLClass));
        }
        printWriter.println(this.genImplGenCreateSupportMethods());
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public String genImplGenFactoryClassName() {
        String string = "public class " + GenOptions.instance().getImplGenFactoryClassName();
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + " extends FactoryExtnImpl" : String.valueOf(string) + " extends EMFFactoryImplBase";
        string = String.valueOf(string) + " implements " + GenOptions.instance().getFactoryGenInterface();
        return string;
    }

    public String genImplGenFactoryConstructor() {
        String string = "  protected " + GenOptions.instance().getImplGenFactoryClassName();
        string = String.valueOf(string) + "()\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "     initializeStatics();\n";
        string = String.valueOf(string) + "  }\n";
        return string;
    }

    private String genImplGenFactoryHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplGenFactoryImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfaceGenPackage() + ".*;\n";
        if (GenOptions.instance().getImplPackage().endsWith(".impl")) {
            string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage() + ".*;\n";
            string = String.valueOf(string) + "import " + GenOptions.instance().getImplPackage() + ".*;\n";
        } else {
            string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage() + ".*;\n";
        }
        if (GenOptions.instance().isGenForEBAF()) {
            string = String.valueOf(string) + GenConstants.FACTORY_IMPL_GEN_IMPORTS_EBAF;
        } else {
            string = String.valueOf(string) + GenConstants.FACTORY_IMPL_GEN_IMPORTS_XMI;
            string = String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_XMI;
            string = String.valueOf(string) + ";\n";
        }
        return string;
    }

    public String genImplGenInstanceVars() {
        String string = "";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "private XMIDocumentImpl fCurrentDocument = null;";
        return string;
    }

    private String genImplGenLoadCreateDocumentMethods() {
        String string = "";
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + " " + GenOptions.instance().getDocumentInterface() + " ";
        string = String.valueOf(string) + "   createDocument";
        string = String.valueOf(string) + "(String  name)";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument = new XMIDocumentImpl();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.setDocumentURL(name);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.setFactory(this);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "addAdaptorFactories(fCurrentDocument);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.createDocumentRoot();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.addStandardImports();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "addDocumentImports();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "return ";
        string = String.valueOf(string) + "new " + GenOptions.instance().getImplDocumentClassName();
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + "fCurrentDocument";
        string = String.valueOf(string) + ");";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + " " + GenOptions.instance().getDocumentInterface() + " ";
        string = String.valueOf(string) + "   loadDocument";
        string = String.valueOf(string) + "(String  name) throws java.io.FileNotFoundException";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "XMIDOMParser p = new XMIDOMParser();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument = new XMIDocumentImpl();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.setDocumentURL(name);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.setFactory(this);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "addAdaptorFactories(fCurrentDocument);";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "p.setDocument(fCurrentDocument);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "p.parseResource(name);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "return ";
        string = String.valueOf(string) + "new " + GenOptions.instance().getImplDocumentClassName();
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + "fCurrentDocument";
        string = String.valueOf(string) + ");";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + " void ";
        string = String.valueOf(string) + "   addDocumentImports";
        string = String.valueOf(string) + "() ";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.addImport(\"mof\", MOFConstants.mofNS);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "String temp = fSchemaNS.substring(fSchemaNS.lastIndexOf(\"/\") + 1);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "String nmAlias = temp.substring(0,temp.lastIndexOf(\".\"));";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument.addImport(nmAlias, fSchemaNS );";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public static ";
        string = String.valueOf(string) + "IBMXMIDocument ";
        string = String.valueOf(string) + "   getXMISchemaDocument";
        string = String.valueOf(string) + "()";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "if (xmiSchemaDocument == null)";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "   xmiSchemaDocument = (IBMXMIDocument)XMIDocumentImpl.getDocument(fSchemaNS);";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "return xmiSchemaDocument;";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + "IBMXMIDocument ";
        string = String.valueOf(string) + "   getCurrentDocument()";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "return fCurrentDocument;";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + "void ";
        string = String.valueOf(string) + "   setCurrentDocument(IBMXMIDocument doc)";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument = (XMIDocumentImpl)doc;";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "addDocumentImports();";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        string = String.valueOf(string) + "  public ";
        string = String.valueOf(string) + " " + GenOptions.instance().getDocumentInterface() + " ";
        string = String.valueOf(string) + "   createDocumentProxyFor(IBMXMIDocument doc)";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "{";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "fCurrentDocument = (XMIDocumentImpl)doc;";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "addDocumentImports();";
        string = String.valueOf(string) + GenConstants.NEW_LINE4;
        string = String.valueOf(string) + "return ";
        string = String.valueOf(string) + "new " + GenOptions.instance().getImplDocumentClassName();
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + "fCurrentDocument";
        string = String.valueOf(string) + ");";
        string = String.valueOf(string) + GenConstants.NEW_LINE2 + "}";
        string = String.valueOf(string) + GenConstants.NEW_LINE;
        return string;
    }

    public String genImplGenStaticInitialization() {
        String string = "";
        string = String.valueOf(string) + "  private synchronized static void initializeStatics()";
        String string2 = "  {\n";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "if (hasInitialized) return;";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "hasInitialized = true;";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "try {";
        string2 = String.valueOf(string2) + "\n          ";
        string2 = String.valueOf(string2) + "xmiSchemaDocument = (IBMXMIDocument)XMIDocumentImpl.getDocument(fSchemaNS);";
        string2 = String.valueOf(string2) + "\n";
        Enumeration enumeration = this.classIdTable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isEnumType() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            string2 = String.valueOf(string2) + "\n           // static Decls for class  : " + uMLClass.getGenName();
            string2 = String.valueOf(string2) + "\n          ";
            string2 = String.valueOf(string2) + uMLClass.getGenName() + "_MOFClass";
            string2 = String.valueOf(string2) + " = ";
            string2 = String.valueOf(string2) + "xmiSchemaDocument.getMOFClass(";
            string2 = String.valueOf(string2) + "\"";
            string2 = String.valueOf(string2) + uMLClass.getName();
            string2 = String.valueOf(string2) + "\");\n";
            Enumeration enumeration2 = uMLClass.getAttributes().elements();
            while (enumeration2.hasMoreElements()) {
                object = (UMLAttribute)enumeration2.nextElement();
                string2 = String.valueOf(string2) + "\n          ";
                string2 = String.valueOf(string2) + uMLClass.getGenName() + "_" + ((UMLAttribute)object).getAttrName();
                string2 = String.valueOf(string2) + " = ";
                string2 = String.valueOf(string2) + "(AttributeExtnImpl)";
                string2 = String.valueOf(string2) + uMLClass.getGenName() + "_MOFClass";
                string2 = String.valueOf(string2) + ".getTypedElement(";
                string2 = String.valueOf(string2) + "\"";
                string2 = String.valueOf(string2) + ((UMLAttribute)object).getAttrName();
                string2 = String.valueOf(string2) + "\");\n";
            }
            object = uMLClass.getAssociationEnds().elements();
            while (object.hasMoreElements()) {
                UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)object.nextElement();
                if (!uMLAssociationEnd.isNavigable()) continue;
                string2 = String.valueOf(string2) + "\n          ";
                string2 = String.valueOf(string2) + uMLClass.getGenName() + "_" + uMLAssociationEnd.getRoleName();
                string2 = String.valueOf(string2) + " = ";
                string2 = String.valueOf(string2) + "(AssociationEndExtnImpl)";
                string2 = String.valueOf(string2) + uMLClass.getGenName() + "_MOFClass";
                string2 = String.valueOf(string2) + ".getTypedElement(";
                string2 = String.valueOf(string2) + "\"";
                string2 = String.valueOf(string2) + uMLAssociationEnd.getRoleName();
                string2 = String.valueOf(string2) + "\");\n";
            }
        }
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "} catch (Exception e) {";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "  System.out.println(\"Exception initializing schema: \" + e);";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "}\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplGenStatics() {
        String string = "";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "static { initializeStatics(); };";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "private static boolean hasInitialized = false;";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "public static final String fSchemaNS = ";
        string = String.valueOf(string) + "\"";
        string = String.valueOf(string) + GenOptions.instance().getSchemaDocument();
        string = String.valueOf(string) + "\"";
        string = String.valueOf(string) + ";\n";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "public static IBMXMIDocument xmiSchemaDocument;";
        string = String.valueOf(string) + "\n";
        Enumeration enumeration = this.classIdTable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isEnumType() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            string = String.valueOf(string) + "\n// static Decls for class  : " + uMLClass.getGenName();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "public static MofClassExtnImpl ";
            string = String.valueOf(string) + uMLClass.getGenName() + "_MOFClass;\n";
            Enumeration enumeration2 = uMLClass.getAttributes().elements();
            while (enumeration2.hasMoreElements()) {
                object = (UMLAttribute)enumeration2.nextElement();
                string = String.valueOf(string) + "\n    ";
                string = String.valueOf(string) + "public static AttributeExtnImpl ";
                string = String.valueOf(string) + uMLClass.getGenName() + "_" + ((UMLAttribute)object).getAttrName();
                string = String.valueOf(string) + ";\n";
            }
            object = uMLClass.getAssociationEnds().elements();
            while (object.hasMoreElements()) {
                UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)object.nextElement();
                if (!uMLAssociationEnd.isNavigable()) continue;
                string = String.valueOf(string) + "\n    ";
                string = String.valueOf(string) + "public static AssociationEndExtnImpl ";
                string = String.valueOf(string) + uMLClass.getGenName() + "_" + uMLAssociationEnd.getRoleName();
                string = String.valueOf(string) + ";\n";
            }
        }
        return string;
    }

    public String genImplGenrefCreateInstanceMethod() {
        String string = "";
        String string2 = "";
        String string3 = "";
        string3 = String.valueOf(string3) + "  public RefObject ";
        string3 = String.valueOf(string3) + "   refCreateInstance(MofClassExtn  mofClass)";
        String string4 = "  {\n";
        string4 = String.valueOf(string4) + "    return refCreateInstance(mofClass, null);";
        string4 = String.valueOf(string4) + "\n";
        string4 = String.valueOf(string4) + "  }\n";
        string = String.valueOf(string3) + "\n" + string4;
        string3 = "  public RefObject ";
        string3 = String.valueOf(string3) + "   refCreateInstance(MofClassExtn  mofClass, Class javaClass)";
        string4 = "  {\n";
        string4 = String.valueOf(string4) + "\n    ";
        string4 = String.valueOf(string4) + "RefObject obj = (javaClass == null) ? mofClass.refCreateInstance() : mofClass.refCreateInstance(javaClass);";
        string4 = String.valueOf(string4) + "\n    ";
        string4 = String.valueOf(string4) + "// ((MOFObjectDelegate)obj).setDomain(domainModel);";
        string4 = String.valueOf(string4) + "\n    ";
        string4 = String.valueOf(string4) + "obj.setXMIDocument(fCurrentDocument);";
        string4 = String.valueOf(string4) + "\n    ";
        string4 = String.valueOf(string4) + "return obj;";
        string4 = String.valueOf(string4) + "\n";
        string4 = String.valueOf(string4) + "  }\n";
        string2 = String.valueOf(string3) + "\n" + string4;
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplGenrefCreateInstanceMethod_old() {
        String string = "";
        string = String.valueOf(string) + "  public RefObject ";
        string = String.valueOf(string) + "   refCreateInstance(MofClassExtn  mofClass)";
        String string2 = "  {\n";
        Enumeration enumeration = this.classIdTable.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isAbstract() || uMLClass.isEnumType() || uMLClass.isAbstract() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            string2 = String.valueOf(string2) + "\n    ";
            string2 = String.valueOf(string2) + "if (mofClass == ";
            string2 = String.valueOf(string2) + uMLClass.getGenName() + "_MOFClass)";
            string2 = String.valueOf(string2) + "\n    ";
            string2 = String.valueOf(string2) + "   return create" + GenUtil.toUpperFL(uMLClass.getGenName()) + "();";
            string2 = String.valueOf(string2) + "\n";
        }
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "if (mofClass == ";
        string2 = String.valueOf(string2) + "MOFNamespace.mofPackage";
        string2 = String.valueOf(string2) + ")";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "   return createPackage();";
        string2 = String.valueOf(string2) + "\n";
        string2 = String.valueOf(string2) + "\n    ";
        string2 = String.valueOf(string2) + "return super.refCreateInstance(mofClass);\n";
        string2 = String.valueOf(string2) + "  }\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public void genImplementations() {
        this.genImplGenFactoryClass();
        this.genImplFactoryClass();
    }
}

