/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.GenFileUtil;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.GenUtil;
import com.ibm.ebaf.gen.base.JavaMappingTables;
import com.ibm.ebaf.gen.base.UMLAssociation;
import com.ibm.ebaf.gen.base.UMLAssociationEnd;
import com.ibm.ebaf.gen.base.UMLAttribute;
import com.ibm.ebaf.gen.base.UMLClass;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GenImpls {
    public GenImpls() {
    }

    public GenImpls(Hashtable hashtable) {
        this.genImplementations(hashtable);
    }

    private String genAssociations(UMLAssociation uMLAssociation, UMLClass uMLClass) {
        UMLAssociationEnd uMLAssociationEnd = uMLAssociation.getAssociationEndForTargetClass(uMLClass.getId());
        return uMLAssociationEnd.genImplClasses(uMLClass);
    }

    public void genImplClass(UMLClass uMLClass) {
        if (uMLClass.isEnumType()) {
            return;
        }
        String string = String.valueOf(GenFileUtil.getImplementationDirPath()) + File.separator + uMLClass.getImplClassName() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplClassHeader());
        printWriter.println("package " + uMLClass.getImplPackage() + ";");
        printWriter.println(this.genImplClassImports(uMLClass));
        printWriter.println(this.genImplClassName(uMLClass));
        printWriter.println("{");
        printWriter.println("\n");
        printWriter.println(this.genImplClassConstructor(uMLClass));
        printWriter.println("\n");
        printWriter.println("// Begin User Defined Methods");
        printWriter.println("\n");
        printWriter.println("// End  User Defined Methods");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public String genImplClassConstructor(UMLClass uMLClass) {
        String string = "  public " + uMLClass.getImplClassName();
        string = String.valueOf(string) + "()\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    super();\n";
        string = String.valueOf(string) + "  }";
        string = String.valueOf(string) + "\n";
        return string;
    }

    public String genImplClassConstructor_old(UMLClass uMLClass) {
        String string = "  public " + uMLClass.getImplClassName();
        string = String.valueOf(string) + "()\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    this(";
        string = String.valueOf(string) + uMLClass.getInterfacePrefix() + "FactoryImpl";
        string = String.valueOf(string) + ".T" + uMLClass.getName();
        string = String.valueOf(string) + ");\n";
        string = String.valueOf(string) + "  }";
        string = String.valueOf(string) + "\n";
        String string2 = "  protected " + uMLClass.getImplClassName();
        string2 = String.valueOf(string2) + "(int typeNum)\n";
        string2 = String.valueOf(string2) + "  {\n";
        string2 = String.valueOf(string2) + "    super(typeNum);\n";
        string2 = String.valueOf(string2) + "  }";
        string2 = String.valueOf(string2) + "\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplClassConstructor_old_v1(UMLClass uMLClass) {
        String string = "  public " + uMLClass.getImplClassName();
        string = String.valueOf(string) + "(EMFModel  model,  boolean  isNew)\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    super(model, isNew);\n";
        string = String.valueOf(string) + "  }";
        string = String.valueOf(string) + "\n";
        String string2 = "  protected " + uMLClass.getImplClassName();
        string2 = String.valueOf(string2) + "(EMFModel  model, int name, boolean  isNew)\n";
        string2 = String.valueOf(string2) + "  {\n";
        string2 = String.valueOf(string2) + "    super(model, name, isNew);\n";
        string2 = String.valueOf(string2) + "  }";
        string2 = String.valueOf(string2) + "\n";
        return String.valueOf(string) + "\n" + string2;
    }

    public String genImplClassConstructor_old_v2(UMLClass uMLClass) {
        String string = "";
        string = uMLClass.isAbstract() ? "  protected  " : "  public  ";
        string = String.valueOf(string) + uMLClass.getImplClassName();
        string = String.valueOf(string) + "(EMFDataObject  dataObj, boolean  isNew)\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    super(dataObj,  isNew);\n";
        string = String.valueOf(string) + "  }";
        return string;
    }

    private String genImplClassHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplClassImports(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceImport();
        string = String.valueOf(string) + uMLClass.getImplGenImport();
        return string;
    }

    public String genImplClassName(UMLClass uMLClass) {
        String string = "public ";
        if (uMLClass.isAbstract()) {
            string = String.valueOf(string) + " abstract ";
        }
        string = String.valueOf(string) + " class ";
        string = String.valueOf(string) + uMLClass.getImplClassName();
        string = String.valueOf(string) + " extends " + uMLClass.getImplGenClassName();
        string = String.valueOf(string) + " implements " + uMLClass.getInterfaceClassName();
        return string;
    }

    public void genImplGenApplied(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "  public void applied(MOFAttributeSetting av, int position, MOFAttributeSetting replacedAs)";
        string = String.valueOf(string) + "\n  {";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "super.applied(av, position, replacedAs);";
        printWriter.println(string);
        printWriter.println(this.genImplGenAppliedBody(uMLClass));
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenAppliedBodyForParents(uMLClass2, printWriter);
        }
        printWriter.println("\n  }");
    }

    public void genImplGenAppliedAndCancel(UMLClass uMLClass, PrintWriter printWriter) {
        printWriter.println(String.valueOf(GenConstants.NEW_LINE) + GenConstants.NEW_LINE);
        this.genImplGenApplied_old(uMLClass, printWriter);
        printWriter.println(String.valueOf(GenConstants.NEW_LINE) + GenConstants.NEW_LINE);
        this.genImplGenCancel_old(uMLClass, printWriter);
        printWriter.println(String.valueOf(GenConstants.NEW_LINE) + GenConstants.NEW_LINE);
        this.genImplGenApplied(uMLClass, printWriter);
        printWriter.println(String.valueOf(GenConstants.NEW_LINE) + GenConstants.NEW_LINE);
        this.genImplGenCancel(uMLClass, printWriter);
    }

    public String genImplGenAppliedBody(UMLClass uMLClass) {
        Object object;
        Object object2;
        String string = "";
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (UMLAttribute)enumeration.nextElement();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAttribute)object2).getAttrName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAttribute)object2).getAttrName());
            string = String.valueOf(string) + " = ";
            if (((UMLAttribute)object2).isEnumType()) {
                string = String.valueOf(string) + "((MOFEnumValue)av.getObject()).getNumber()";
            } else {
                object = "";
                object = String.valueOf(object) + "(";
                object = String.valueOf(object) + ((UMLAttribute)object2).getAttrTypeName();
                object = String.valueOf(object) + ")";
                object = String.valueOf(object) + "av.getObject()";
                if (((UMLAttribute)object2).isPrimitiveType() & ((UMLAttribute)object2).getObjectToPrimTypeFunc() != null) {
                    string = String.valueOf(string) + "(";
                    string = String.valueOf(string) + (String)object;
                    string = String.valueOf(string) + ")";
                    string = String.valueOf(string) + ".";
                    string = String.valueOf(string) + ((UMLAttribute)object2).getObjectToPrimTypeFunc();
                } else {
                    string = String.valueOf(string) + (String)object;
                }
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        object2 = uMLClass.getAssociationEnds().elements();
        while (object2.hasMoreElements()) {
            object = (UMLAssociationEnd)object2.nextElement();
            if (!((UMLAssociationEnd)object).isNavigable()) continue;
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAssociationEnd)object).getRoleName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAssociationEnd)object).getRoleName());
            string = String.valueOf(string) + " = ";
            if (((UMLAssociationEnd)object).isMultiplicityMany()) {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + "[]";
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "MOFTypedObjectSupport";
                string = String.valueOf(string) + ".";
                string = String.valueOf(string) + "insertToArrayAt(";
                string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAssociationEnd)object).getRoleName());
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + "av.getObject()";
                string = String.valueOf(string) + ",position,(replacedAs!=null)";
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ".class";
                string = String.valueOf(string) + ")";
            } else {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "av.getObject()";
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        return string;
    }

    public void genImplGenAppliedBodyForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("       //  From Parent Interface  :  " + string);
            printWriter.println(this.genImplGenAppliedBody(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenAppliedBodyForParents(uMLClass2, printWriter);
        }
    }

    public void genImplGenAppliedBodyForParents_old(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("       //  From Parent Interface  :  " + string);
            printWriter.println(this.genImplGenAppliedBody_old(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenAppliedBodyForParents_old(uMLClass2, printWriter);
        }
    }

    public String genImplGenAppliedBody_old(UMLClass uMLClass) {
        Object object;
        Object object2;
        String string = "";
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (UMLAttribute)enumeration.nextElement();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAttribute)object2).getAttrName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAttribute)object2).getAttrName());
            string = String.valueOf(string) + " = ";
            if (((UMLAttribute)object2).isEnumType()) {
                string = String.valueOf(string) + "((MOFEnumValue)av.getObject()).getNumber()";
            } else {
                object = "";
                object = String.valueOf(object) + "(";
                object = String.valueOf(object) + ((UMLAttribute)object2).getAttrTypeName();
                object = String.valueOf(object) + ")";
                object = String.valueOf(object) + "av.getObject()";
                if (((UMLAttribute)object2).isPrimitiveType() & ((UMLAttribute)object2).getObjectToPrimTypeFunc() != null) {
                    string = String.valueOf(string) + "(";
                    string = String.valueOf(string) + (String)object;
                    string = String.valueOf(string) + ")";
                    string = String.valueOf(string) + ".";
                    string = String.valueOf(string) + ((UMLAttribute)object2).getObjectToPrimTypeFunc();
                } else {
                    string = String.valueOf(string) + (String)object;
                }
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        object2 = uMLClass.getAssociationEnds().elements();
        while (object2.hasMoreElements()) {
            object = (UMLAssociationEnd)object2.nextElement();
            if (!((UMLAssociationEnd)object).isNavigable()) continue;
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAssociationEnd)object).getRoleName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAssociationEnd)object).getRoleName());
            string = String.valueOf(string) + " = ";
            if (((UMLAssociationEnd)object).isMultiplicityMany()) {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + "[]";
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "MOFTypedObjectSupport";
                string = String.valueOf(string) + ".";
                string = String.valueOf(string) + "appendToArray(";
                string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAssociationEnd)object).getRoleName());
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + "av.getObject()";
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ".class";
                string = String.valueOf(string) + ")";
            } else {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + ((UMLAssociationEnd)object).getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "av.getObject()";
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        return string;
    }

    public void genImplGenApplied_old(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "  public void applied(MOFAttributeSetting av)";
        string = String.valueOf(string) + "\n  {";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "super.applied(av);";
        printWriter.println(string);
        printWriter.println(this.genImplGenAppliedBody_old(uMLClass));
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenAppliedBodyForParents_old(uMLClass2, printWriter);
        }
        printWriter.println("\n  }");
    }

    public String genImplGenAttributeOperations(UMLClass uMLClass, UMLAttribute uMLAttribute) {
        String string = "";
        String string2 = uMLAttribute.getAttrTypeName();
        if (uMLAttribute.isEnumType()) {
            string = "// Enumeration Constants for following are defined in interface : " + uMLAttribute.getAttrTypeClass().getInterfaceClassName() + "\n";
        }
        String string3 = this.genImplGenGetOperation(uMLClass, uMLAttribute);
        String string4 = this.genImplGenSetOperation(uMLClass, uMLAttribute);
        return String.valueOf(string) + string3 + GenConstants.NEW_LINE + string4 + GenConstants.NEW_LINE;
    }

    public void genImplGenCancel(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "  public void canceled(MOFAttributeSetting av, int position)";
        string = String.valueOf(string) + "\n  {";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "super.canceled(av, position);";
        printWriter.println(string);
        printWriter.println(this.genImplGenCancelBody(uMLClass));
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenCancelBodyForParents(uMLClass2, printWriter);
        }
        printWriter.println("\n  }");
    }

    public String genImplGenCancelBody(UMLClass uMLClass) {
        Object object;
        String string = "";
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            object = (UMLAttribute)enumeration.nextElement();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAttribute)object).getAttrName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAttribute)object).getAttrName());
            string = String.valueOf(string) + " = ";
            string = String.valueOf(string) + ((UMLAttribute)object).getDefaultValue();
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        object = uMLClass.getAssociationEnds().elements();
        while (object.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)object.nextElement();
            if (!uMLAssociationEnd.isNavigable()) continue;
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + uMLAssociationEnd.getRoleName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(uMLAssociationEnd.getRoleName());
            string = String.valueOf(string) + " = ";
            if (uMLAssociationEnd.isMultiplicityMany()) {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + uMLAssociationEnd.getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + "[]";
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "MOFTypedObjectSupport";
                string = String.valueOf(string) + ".";
                string = String.valueOf(string) + "removeFromArray(";
                string = String.valueOf(string) + GenUtil.fieldVariable(uMLAssociationEnd.getRoleName());
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + "position";
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + uMLAssociationEnd.getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ".class";
                string = String.valueOf(string) + ")";
            } else {
                string = String.valueOf(string) + "null";
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        return string;
    }

    public void genImplGenCancelBodyForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("       //  From Parent Interface  :  " + string);
            printWriter.println(this.genImplGenCancelBody(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenCancelBodyForParents(uMLClass2, printWriter);
        }
    }

    public void genImplGenCancelBodyForParents_old(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("       //  From Parent Interface  :  " + string);
            printWriter.println(this.genImplGenCancelBody_old(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenCancelBodyForParents_old(uMLClass2, printWriter);
        }
    }

    public String genImplGenCancelBody_old(UMLClass uMLClass) {
        Object object;
        String string = "";
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            object = (UMLAttribute)enumeration.nextElement();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + ((UMLAttribute)object).getAttrName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(((UMLAttribute)object).getAttrName());
            string = String.valueOf(string) + " = ";
            string = String.valueOf(string) + ((UMLAttribute)object).getDefaultValue();
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        object = uMLClass.getAssociationEnds().elements();
        while (object.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)object.nextElement();
            if (!uMLAssociationEnd.isNavigable()) continue;
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "if (av.getMetaObject() == ";
            string = String.valueOf(string) + GenOptions.instance().getImplFactoryClassName() + "." + uMLClass.getGenName() + "_" + uMLAssociationEnd.getRoleName();
            string = String.valueOf(string) + ") { ";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + GenUtil.fieldVariable(uMLAssociationEnd.getRoleName());
            string = String.valueOf(string) + " = ";
            if (uMLAssociationEnd.isMultiplicityMany()) {
                string = String.valueOf(string) + "(";
                string = String.valueOf(string) + uMLAssociationEnd.getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + "[]";
                string = String.valueOf(string) + ")";
                string = String.valueOf(string) + "MOFTypedObjectSupport";
                string = String.valueOf(string) + ".";
                string = String.valueOf(string) + "removeFromArray(";
                string = String.valueOf(string) + GenUtil.fieldVariable(uMLAssociationEnd.getRoleName());
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + "av.getObject()";
                string = String.valueOf(string) + ",";
                string = String.valueOf(string) + uMLAssociationEnd.getTargetClass().getInterfaceClassName();
                string = String.valueOf(string) + ".class";
                string = String.valueOf(string) + ")";
            } else {
                string = String.valueOf(string) + "null";
            }
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + "\n        ";
            string = String.valueOf(string) + "return;";
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "}";
        }
        return string;
    }

    public void genImplGenCancel_old(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "  public void canceled(MOFAttributeSetting av)";
        string = String.valueOf(string) + "\n  {";
        string = String.valueOf(string) + "\n    ";
        string = String.valueOf(string) + "super.canceled(av);";
        printWriter.println(string);
        printWriter.println(this.genImplGenCancelBody_old(uMLClass));
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenCancelBodyForParents_old(uMLClass2, printWriter);
        }
        printWriter.println("\n  }");
    }

    public void genImplGenClass(UMLClass uMLClass) {
        System.out.println("GenImpl : Class Id = " + uMLClass.getId() + "  EnumType = " + uMLClass.isEnumType());
        if (uMLClass.isEnumType()) {
            return;
        }
        String string = String.valueOf(GenFileUtil.getImplementationGenDirPath()) + File.separator + uMLClass.getImplGenClassName() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genImplGenClassHeader());
        printWriter.println("package " + uMLClass.getImplGenPackage() + ";");
        this.genImplGenClassImports(uMLClass, printWriter);
        printWriter.println(this.genImplGenClassName(uMLClass));
        printWriter.println("{");
        this.genImplGenVars(uMLClass, printWriter);
        printWriter.println("\n");
        printWriter.println(this.genImplGenClassConstructor(uMLClass));
        this.genImplGenClassBody(uMLClass, printWriter);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public void genImplGenClassBody(UMLClass uMLClass, PrintWriter printWriter) {
        printWriter.println("\n");
        printWriter.println("// Model Properties ");
        this.genImplGenClassBodyAttributes(uMLClass, printWriter);
        printWriter.println("\n");
        printWriter.println("// Model Relations  ");
        this.genImplGenClassBodyAssociations(uMLClass, printWriter);
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenClassBodyAttributesForParents(uMLClass2, printWriter);
            this.genImplGenClassBodyAssociationsForParents(uMLClass2, printWriter);
        }
        this.genImplGenAppliedAndCancel(uMLClass, printWriter);
    }

    public void genImplGenClassBodyAssociations(UMLClass uMLClass, PrintWriter printWriter) {
        if (uMLClass.isReservedClass()) {
            return;
        }
        Enumeration enumeration = uMLClass.getAssociationEnds().elements();
        while (enumeration.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)enumeration.nextElement();
            printWriter.println(uMLAssociationEnd.genImplClasses(uMLClass));
        }
    }

    public void genImplGenClassBodyAssociationsForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getGenName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("// Model Relations from Parent Interface  :  " + string);
            this.genImplGenClassBodyAssociations(uMLClass, printWriter);
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenClassBodyAssociationsForParents(uMLClass2, printWriter);
        }
    }

    public void genImplGenClassBodyAttributes(UMLClass uMLClass, PrintWriter printWriter) {
        if (uMLClass.isReservedClass()) {
            return;
        }
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            UMLAttribute uMLAttribute = (UMLAttribute)enumeration.nextElement();
            printWriter.println(this.genImplGenAttributeOperations(uMLClass, uMLAttribute));
        }
    }

    public void genImplGenClassBodyAttributesForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getGenName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("// Model Properties from Parent Interface  :  " + string);
            this.genImplGenClassBodyAttributes(uMLClass, printWriter);
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenClassBodyAttributesForParents(uMLClass2, printWriter);
        }
    }

    public String genImplGenClassConstructor(UMLClass uMLClass) {
        String string = "  protected " + uMLClass.getImplGenClassName();
        string = String.valueOf(string) + "()\n";
        string = String.valueOf(string) + "  {\n";
        string = String.valueOf(string) + "    super();";
        string = String.valueOf(string) + "\n";
        string = String.valueOf(string) + "  }";
        return string;
    }

    private String genImplGenClassHeader() {
        return GenConstants.INTF_HEADER;
    }

    public String genImplGenClassImports(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceGenImport();
        string = String.valueOf(string) + uMLClass.getInterfaceImport();
        if (uMLClass.getImplPackage().compareTo(uMLClass.getInterfacePackage()) != 0) {
            string = String.valueOf(string) + uMLClass.getImplImport();
        }
        string = String.valueOf(string) + this.getFrameWorkImplImports();
        string = String.valueOf(string) + GenConstants.JAVA_IMPORTS;
        string = String.valueOf(string) + uMLClass.getImplImportForParent();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAssociations();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAttributes();
        return string;
    }

    public void genImplGenClassImports(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceGenImport();
        string = String.valueOf(string) + uMLClass.getInterfaceImport();
        if (uMLClass.getImplPackage().compareTo(uMLClass.getInterfacePackage()) != 0) {
            string = String.valueOf(string) + uMLClass.getImplImport();
        }
        string = String.valueOf(string) + this.getFrameWorkImplImports();
        string = String.valueOf(string) + GenConstants.JAVA_IMPORTS;
        string = String.valueOf(string) + uMLClass.getImplImportForParent();
        printWriter.println(string);
        this.genImplGenClassImportsForAttrAndAssoc(uMLClass, printWriter);
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenClassImportsForAttrAndAssocForParents(uMLClass2, printWriter);
        }
    }

    public void genImplGenClassImportsForAttrAndAssoc(UMLClass uMLClass, PrintWriter printWriter) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAssociations();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAttributes();
        printWriter.println(string);
    }

    public void genImplGenClassImportsForAttrAndAssocForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getGenName();
        if (string != null && !uMLClass.isReservedClass()) {
            this.genImplGenClassImportsForAttrAndAssoc(uMLClass, printWriter);
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenClassImportsForAttrAndAssocForParents(uMLClass2, printWriter);
        }
    }

    public String genImplGenClassName(UMLClass uMLClass) {
        String string = "public ";
        string = String.valueOf(string) + " abstract ";
        string = String.valueOf(string) + " class ";
        string = String.valueOf(string) + uMLClass.getImplGenClassName();
        Vector vector = uMLClass.getParentClasses();
        switch (vector.size()) {
            case 0: {
                string = String.valueOf(string) + " extends " + this.getFrameWorkImplName();
                break;
            }
            default: {
                String string2 = uMLClass.getParentClass().getName();
                if (uMLClass.getParentClass().isReservedClass()) {
                    String string3 = uMLClass.getParentClass().getImplClassNameForReservedClass();
                    if (string3 == null) {
                        string = String.valueOf(string) + " extends " + this.getFrameWorkImplName();
                        break;
                    }
                    string = String.valueOf(string) + " extends " + string3;
                    break;
                }
                if (string2 == null || string2.compareTo("") == 0) break;
                string = String.valueOf(string) + " extends " + uMLClass.getParentClass().getImplClassName();
            }
        }
        string = String.valueOf(string) + " implements " + uMLClass.getInterfaceGenClassName();
        return string;
    }

    public String genImplGenGetOperation(UMLClass uMLClass, UMLAttribute uMLAttribute) {
        String string = uMLAttribute.getAttrTypeName();
        if (uMLAttribute.isEnumType()) {
            string = "enum";
        }
        String string2 = GenUtil.genGetOperInterface(uMLAttribute.getAttrName(), string, 16);
        String string3 = "  {";
        string3 = String.valueOf(string3) + GenConstants.NEW_LINE4;
        string3 = String.valueOf(string3) + "return  ";
        string3 = String.valueOf(string3) + GenUtil.fieldVariable(uMLAttribute.getAttrName());
        string3 = String.valueOf(string3) + ";" + GenConstants.NEW_LINE2;
        string3 = String.valueOf(string3) + "}" + GenConstants.NEW_LINE;
        return String.valueOf(string2) + GenConstants.NEW_LINE + string3;
    }

    public String genImplGenGetOperation_v1(UMLClass uMLClass, UMLAttribute uMLAttribute) {
        String string = uMLAttribute.getAttrTypeName();
        if (uMLAttribute.isEnumType()) {
            string = "enum";
        }
        String string2 = JavaMappingTables.instance().getImplMethodForPrimitiveType(string);
        String string3 = GenUtil.genGetOperInterface(uMLAttribute.getAttrName(), string, 16);
        String string4 = "  {\n";
        if (string2 == null && !uMLAttribute.isEnumType()) {
            string4 = String.valueOf(string4) + " /* Error -- Cannot gen code for types other than primitive types */\n";
        } else {
            string4 = String.valueOf(string4) + "    return  ";
            string4 = String.valueOf(string4) + GenUtil.fieldVariable(uMLAttribute.getAttrName());
            string4 = String.valueOf(string4) + ";\n";
        }
        string4 = String.valueOf(string4) + "  }\n";
        return String.valueOf(string3) + "\n" + string4;
    }

    public String genImplGenSetOperation(UMLClass uMLClass, UMLAttribute uMLAttribute) {
        String string = uMLAttribute.getAttrTypeName();
        if (uMLAttribute.isEnumType()) {
            string = "enum";
        }
        String string2 = JavaMappingTables.instance().getImplMethodForPrimitiveType(string);
        String string3 = GenUtil.genSetOperInterface(uMLAttribute.getAttrName(), string, 16);
        String string4 = "  {" + GenConstants.NEW_LINE;
        if (uMLAttribute.isEnumType()) {
            string4 = String.valueOf(string4) + "    MOFTypedObjectSupport";
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + "setEnumValue";
            string4 = String.valueOf(string4) + "(";
            string4 = String.valueOf(string4) + "this";
            string4 = String.valueOf(string4) + ", ";
            string4 = String.valueOf(string4) + GenOptions.instance().getImplFactoryClassName();
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + uMLClass.getGenName() + "_" + uMLAttribute.getAttrName();
            string4 = String.valueOf(string4) + ", ";
            string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
            string4 = String.valueOf(string4) + ");" + GenConstants.NEW_LINE;
        } else {
            string4 = String.valueOf(string4) + "    setValue";
            string4 = String.valueOf(string4) + "(";
            string4 = String.valueOf(string4) + GenOptions.instance().getImplFactoryClassName();
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + uMLClass.getGenName() + "_" + uMLAttribute.getAttrName();
            string4 = String.valueOf(string4) + ", ";
            if (uMLAttribute.isPrimitiveType() & uMLAttribute.getPrimTypeToObjectFunc() != null) {
                string4 = String.valueOf(string4) + "new ";
                string4 = String.valueOf(string4) + uMLAttribute.getPrimTypeToObjectFunc();
                string4 = String.valueOf(string4) + "(";
                string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
                string4 = String.valueOf(string4) + ")";
            } else {
                string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
            }
            string4 = String.valueOf(string4) + ");" + GenConstants.NEW_LINE;
        }
        string4 = String.valueOf(string4) + "  }" + GenConstants.NEW_LINE;
        return String.valueOf(string3) + GenConstants.NEW_LINE + string4;
    }

    public String genImplGenSetOperation_v1(UMLClass uMLClass, UMLAttribute uMLAttribute) {
        String string = uMLAttribute.getAttrTypeName();
        if (uMLAttribute.isEnumType()) {
            string = "enum";
        }
        String string2 = JavaMappingTables.instance().getImplMethodForPrimitiveType(string);
        String string3 = GenUtil.genSetOperInterface(uMLAttribute.getAttrName(), string, 16);
        String string4 = "  {\n";
        if (string2 == null) {
            string4 = String.valueOf(string4) + " /* Error -- Cannot gen code for types other than primitive types */\n";
        } else if (uMLAttribute.isEnumType()) {
            string4 = String.valueOf(string4) + "    MOFTypedObjectSupport";
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + "setEnumValue";
            string4 = String.valueOf(string4) + "(";
            string4 = String.valueOf(string4) + "this";
            string4 = String.valueOf(string4) + ", ";
            string4 = String.valueOf(string4) + GenOptions.instance().getImplFactoryClassName();
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + uMLClass.getGenName() + "_" + uMLAttribute.getAttrName();
            string4 = String.valueOf(string4) + ", ";
            string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
            string4 = String.valueOf(string4) + ");\n";
        } else {
            string4 = String.valueOf(string4) + "    setValue";
            string4 = String.valueOf(string4) + "(";
            string4 = String.valueOf(string4) + GenOptions.instance().getImplFactoryClassName();
            string4 = String.valueOf(string4) + ".";
            string4 = String.valueOf(string4) + uMLClass.getGenName() + "_" + uMLAttribute.getAttrName();
            string4 = String.valueOf(string4) + ", ";
            if (uMLAttribute.isPrimitiveType() & uMLAttribute.getPrimTypeToObjectFunc() != null) {
                string4 = String.valueOf(string4) + "new ";
                string4 = String.valueOf(string4) + uMLAttribute.getPrimTypeToObjectFunc();
                string4 = String.valueOf(string4) + "(";
                string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
                string4 = String.valueOf(string4) + ")";
            } else {
                string4 = String.valueOf(string4) + GenUtil.getParmName(uMLAttribute.getAttrName());
            }
            string4 = String.valueOf(string4) + ");\n";
        }
        string4 = String.valueOf(string4) + "  }\n";
        return String.valueOf(string3) + "\n" + string4;
    }

    public void genImplGenVars(UMLClass uMLClass, PrintWriter printWriter) {
        printWriter.println(this.genImplGenVarsForProperties(uMLClass));
        printWriter.println(this.genImplGenVarsForAssociations(uMLClass));
        Vector vector = uMLClass.getParentClasses();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            if (++n <= 1 && !uMLClass2.isReservedClass()) continue;
            this.genImplGenVarsForPropertiesForParents(uMLClass2, printWriter);
            this.genImplGenVarsForAssociationsForParents(uMLClass2, printWriter);
        }
    }

    public String genImplGenVarsForAssociations(UMLClass uMLClass) {
        String string = "";
        Enumeration enumeration = uMLClass.getAssociationEnds().elements();
        while (enumeration.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)enumeration.nextElement();
            if (!uMLAssociationEnd.isNavigable()) continue;
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "protected ";
            string = String.valueOf(string) + uMLAssociationEnd.getTargetClass().getInterfaceClassName();
            string = String.valueOf(string) + (uMLAssociationEnd.isMultiplicityMany() ? "[]" : "");
            string = String.valueOf(string) + "  ";
            string = String.valueOf(string) + GenUtil.fieldVariable(uMLAssociationEnd.getRoleName());
            string = String.valueOf(string) + (uMLAssociationEnd.isMultiplicityMany() ? " = {}" : "");
            string = String.valueOf(string) + ";\n";
        }
        return string;
    }

    public void genImplGenVarsForAssociationsForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("// Variables for Model Relations from Parent Interface  :  " + string);
            printWriter.println(this.genImplGenVarsForAssociations(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenVarsForAssociationsForParents(uMLClass2, printWriter);
        }
    }

    public String genImplGenVarsForProperties(UMLClass uMLClass) {
        String string = "";
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            UMLAttribute uMLAttribute = (UMLAttribute)enumeration.nextElement();
            string = String.valueOf(string) + "\n    ";
            string = String.valueOf(string) + "protected ";
            string = String.valueOf(string) + (uMLAttribute.isEnumType() ? "int" : uMLAttribute.getJavaMappedAttrTypeName());
            string = String.valueOf(string) + " ";
            string = String.valueOf(string) + GenUtil.fieldVariable(uMLAttribute.getAttrName());
            string = String.valueOf(string) + " = ";
            string = String.valueOf(string) + uMLAttribute.getDefaultValue();
            string = String.valueOf(string) + ";";
        }
        return string;
    }

    public void genImplGenVarsForPropertiesForParents(UMLClass uMLClass, PrintWriter printWriter) {
        String string = null;
        string = uMLClass.isReservedClass() ? uMLClass.getImplClassNameForReservedClass() : uMLClass.getInterfaceClassName();
        if (string != null && !uMLClass.isReservedClass()) {
            printWriter.println("\n");
            printWriter.println("// Variables  for Model Properties from Parent Interface  :  " + string);
            printWriter.println(this.genImplGenVarsForProperties(uMLClass));
        }
        Vector vector = uMLClass.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
            this.genImplGenVarsForPropertiesForParents(uMLClass2, printWriter);
        }
    }

    public void genImplementations(Hashtable hashtable) {
        UMLClass uMLClass = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            this.genImplGenClass(uMLClass);
            this.genImplClass(uMLClass);
        }
    }

    public String getFrameWorkImplImports() {
        String string = "";
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + GenConstants.FRAMEWORK_IMPORTS_EBAF : String.valueOf(string) + GenConstants.FRAMEWORK_IMPORTS_XMI;
        return string;
    }

    private String getFrameWorkImplName() {
        String string = "";
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + "RefObjectExtnImpl" : String.valueOf(string) + "EMFObjectImplBase";
        return string;
    }
}

