/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.GenFileUtil;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.GenUtil;
import com.ibm.ebaf.gen.base.UMLAssociation;
import com.ibm.ebaf.gen.base.UMLAssociationEnd;
import com.ibm.ebaf.gen.base.UMLAttribute;
import com.ibm.ebaf.gen.base.UMLClass;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GenInterfaces {
    Hashtable classIdTable = null;

    private String genAssociations(UMLAssociation uMLAssociation, String string) {
        UMLAssociationEnd uMLAssociationEnd = uMLAssociation.getAssociationEndForTargetClass(string);
        return uMLAssociationEnd.genInterfaces();
    }

    private String genDocumentGenInterfaceImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage();
        string = String.valueOf(string) + ".*;\n";
        string = String.valueOf(string) + "import com.ibm.xmi.xmi11temp.IBMXMIDocument;\n";
        return string;
    }

    private String genDocumentGenInterfaceName() {
        String string = "public interface " + GenOptions.instance().getDocumentGenInterface();
        return string;
    }

    private String genDocumentGenSpecificInterfaces() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string4 = "  public  ";
        string4 = String.valueOf(string4) + "IBMXMIDocument";
        string2 = "getXMIDocument";
        string3 = "()";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string4 = "  public  ";
        string4 = String.valueOf(string4) + "void ";
        string2 = "save";
        string3 = "()";
        string3 = String.valueOf(string3) + "  throws java.io.IOException";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        return string;
    }

    public void genDocumentInterface() {
        String string = String.valueOf(GenFileUtil.getInterfaceDirPath()) + File.separator + GenOptions.instance().getDocumentInterface() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceHeader());
        printWriter.println(this.genInterfacePackage());
        printWriter.println(this.genDocumentInterfaceImports());
        printWriter.println(this.genDocumentInterfaceName());
        printWriter.println("{");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public void genDocumentInterfaceGen(Hashtable hashtable) {
        String string = String.valueOf(GenFileUtil.getInterfaceGenDirPath()) + File.separator + GenOptions.instance().getDocumentGenInterface() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceHeader());
        printWriter.println(this.genInterfaceGenPackage());
        printWriter.println(this.genDocumentGenInterfaceImports());
        printWriter.println(this.genDocumentGenInterfaceName());
        printWriter.println("{");
        printWriter.println(this.genDocumentGenSpecificInterfaces());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isAbstract() || uMLClass.isEnumType() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            printWriter.println(GenUtil.genAddRemListOperations(uMLClass));
        }
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    private String genDocumentInterfaceImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfaceGenPackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    private String genDocumentInterfaceName() {
        String string = "public interface " + GenOptions.instance().getDocumentInterface() + " extends " + GenOptions.instance().getDocumentGenInterface();
        return string;
    }

    private String genFactoryGenInterfaceImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfacePackage();
        string = String.valueOf(string) + ".*;\n";
        string = String.valueOf(string) + GenConstants.FACTORY_INTF_IMPORTS;
        string = String.valueOf(string) + "\n";
        return string;
    }

    private String genFactoryGenInterfaceName() {
        String string = "public interface " + GenOptions.instance().getFactoryGenInterface();
        return string;
    }

    private String genFactoryGenSpecificInterfaces() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string4 = "  public  ";
        string4 = String.valueOf(string4) + GenOptions.instance().getDocumentInterface();
        string2 = "createDocument";
        string3 = "(String  name)";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string4 = "  public  ";
        string4 = String.valueOf(string4) + GenOptions.instance().getDocumentInterface();
        string2 = "loadDocument";
        string3 = "(String  name) throws java.io.FileNotFoundException";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string4 = "  public  ";
        string4 = String.valueOf(string4) + "IBMXMIDocument";
        string2 = "getCurrentDocument";
        string3 = "()";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string4 = "  public  ";
        string4 = String.valueOf(string4) + "void ";
        string2 = "setCurrentDocument";
        string3 = "(IBMXMIDocument doc)";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        string4 = "  public  ";
        string4 = String.valueOf(string4) + GenOptions.instance().getDocumentInterface();
        string2 = "createDocumentProxyFor";
        string3 = "(IBMXMIDocument doc)";
        string = String.valueOf(string) + string4 + GenUtil.paddedReturnSpace(string4.length(), 32) + string2 + string3;
        string = String.valueOf(string) + ";" + GenConstants.NEW_LINE;
        return string;
    }

    public void genFactoryInterface() {
        String string = String.valueOf(GenFileUtil.getInterfaceDirPath()) + File.separator + GenOptions.instance().getFactoryInterface() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceHeader());
        printWriter.println(this.genInterfacePackage());
        printWriter.println(this.genFactoryInterfaceImports());
        printWriter.println(this.genFactoryInterfaceName());
        printWriter.println("{");
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public void genFactoryInterfaceGen(Hashtable hashtable) {
        String string = String.valueOf(GenFileUtil.getInterfaceGenDirPath()) + File.separator + GenOptions.instance().getFactoryGenInterface() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceHeader());
        printWriter.println(this.genInterfaceGenPackage());
        printWriter.println(this.genFactoryGenInterfaceImports());
        printWriter.println(this.genFactoryGenInterfaceName());
        printWriter.println("{");
        printWriter.println(this.genFactoryGenSpecificInterfaces());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isAbstract() || uMLClass.isEnumType() || uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            printWriter.println(GenUtil.genCreateOperations(uMLClass));
        }
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    private String genFactoryInterfaceImports() {
        String string = "";
        string = String.valueOf(string) + "import " + GenOptions.instance().getInterfaceGenPackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    private String genFactoryInterfaceName() {
        String string = "public interface " + GenOptions.instance().getFactoryInterface() + " extends " + GenOptions.instance().getFactoryGenInterface();
        return string;
    }

    public void genInterface(UMLClass uMLClass) {
        String string = String.valueOf(GenFileUtil.getInterfaceDirPath()) + File.separator + uMLClass.getInterfaceClassName() + ".java";
        if (GenFileUtil.fileExists(string)) {
            return;
        }
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceHeader());
        printWriter.println("package " + uMLClass.getInterfacePackage() + ";");
        printWriter.println(this.genInterfaceImports(uMLClass));
        printWriter.println(this.genInterfaceName(uMLClass));
        printWriter.println("{");
        this.genInterfaceBody(uMLClass, printWriter);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public void genInterfaceBody(UMLClass uMLClass, PrintWriter printWriter) {
    }

    public void genInterfaceGen(UMLClass uMLClass) {
        String string = String.valueOf(GenFileUtil.getInterfaceGenDirPath()) + File.separator + uMLClass.getInterfaceGenClassName() + ".java";
        PrintWriter printWriter = GenFileUtil.createPrintWriterFile(string);
        printWriter.println(this.genInterfaceGenHeader());
        printWriter.println("package " + uMLClass.getInterfaceGenPackage() + ";");
        printWriter.println(this.genInterfaceGenImports(uMLClass));
        printWriter.println(this.genInterfaceGenName(uMLClass));
        printWriter.println("{");
        this.genInterfaceGenBody(uMLClass, printWriter);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    public void genInterfaceGenBody(UMLClass uMLClass, PrintWriter printWriter) {
        Object object;
        if (uMLClass.isEnumType()) {
            printWriter.println("\n");
            printWriter.println("// Enumeration Constants ");
            printWriter.println(GenUtil.genEnumerationConstants(uMLClass.getEnumerationValues()));
            return;
        }
        printWriter.println("\n");
        printWriter.println("// Model Properties ");
        Enumeration enumeration = uMLClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            object = (UMLAttribute)enumeration.nextElement();
            if (((UMLAttribute)object).getVisibility() != GenConstants.PUBLIC) continue;
            printWriter.println(GenUtil.genAttributeOperations((UMLAttribute)object));
        }
        printWriter.println("\n");
        printWriter.println("// Model Relations  ");
        object = uMLClass.getAssociationEnds().elements();
        while (object.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)object.nextElement();
            if (uMLAssociationEnd.getVisibility() != GenConstants.PUBLIC) continue;
            printWriter.println(uMLAssociationEnd.genInterfaces());
        }
    }

    private String genInterfaceGenHeader() {
        return GenConstants.INTF_HEADER;
    }

    private String genInterfaceGenImports(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceImport();
        string = String.valueOf(string) + this.getFrameWorkInterfaceImports();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForParent();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAssociations();
        string = String.valueOf(string) + uMLClass.getInterfaceImportForAttributes();
        return string;
    }

    private String genInterfaceGenName(UMLClass uMLClass) {
        String string = "public interface " + uMLClass.getInterfaceGenClassName();
        if (uMLClass.isEnumType()) {
            return string;
        }
        Vector vector = uMLClass.getParentClasses();
        switch (vector.size()) {
            case 0: {
                string = String.valueOf(string) + " extends " + this.getFrameWorkInterfaceName();
                break;
            }
            case 1: {
                String string2 = uMLClass.getParentClass().getName();
                if (uMLClass.getParentClass().isReservedClass()) {
                    string = String.valueOf(string) + " extends " + uMLClass.getParentClass().getInterfaceNameForReservedClass();
                    break;
                }
                string = String.valueOf(string) + " extends " + uMLClass.getParentClass().getInterfaceClassName();
                break;
            }
            default: {
                int n = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    UMLClass uMLClass2 = (UMLClass)enumeration.nextElement();
                    String string3 = null;
                    String string4 = uMLClass2.getName();
                    if (string4 != null & string4.compareTo("") != 0) {
                        string3 = uMLClass2.isReservedClass() ? uMLClass2.getInterfaceNameForReservedClass() : uMLClass2.getInterfaceClassName();
                    }
                    if (string3 == null) continue;
                    string = n++ >= 1 ? String.valueOf(string) + " , " + string3 : String.valueOf(string) + " extends " + string3;
                }
                break block0;
            }
        }
        return string;
    }

    private String genInterfaceGenPackage() {
        String string = "package ";
        string = String.valueOf(string) + GenOptions.instance().getInterfaceGenPackage();
        string = String.valueOf(string) + ";";
        return string;
    }

    private String genInterfaceHeader() {
        return GenConstants.INTF_HEADER;
    }

    private String genInterfaceImports(UMLClass uMLClass) {
        String string = "";
        string = String.valueOf(string) + uMLClass.getInterfaceGenImport();
        return string;
    }

    private String genInterfaceName(UMLClass uMLClass) {
        String string = "public interface " + uMLClass.getInterfaceClassName();
        string = String.valueOf(string) + " extends " + uMLClass.getInterfaceGenClassName();
        return string;
    }

    private String genInterfacePackage() {
        String string = "package ";
        string = String.valueOf(string) + GenOptions.instance().getInterfacePackage();
        string = String.valueOf(string) + ";";
        return string;
    }

    public void genInterfaces(Hashtable hashtable) {
        this.classIdTable = hashtable;
        GenFileUtil.deleteGenDirs();
        GenFileUtil.createGenDirs();
        UMLClass uMLClass = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass.isReservedClass() || uMLClass.isPrimitiveType() || uMLClass.isFromDifferentPackage()) continue;
            System.out.println("GenInterfaces: Class Name = " + uMLClass.getName() + " Id= " + uMLClass.getId());
            this.genInterfaceGen(uMLClass);
            this.genInterface(uMLClass);
        }
        this.genDocumentInterfaceGen(hashtable);
        this.genDocumentInterface();
        this.genFactoryInterfaceGen(hashtable);
        this.genFactoryInterface();
    }

    private String getFrameWorkInterfaceImports() {
        String string = "";
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_EBAF : String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_XMI;
        return string;
    }

    private String getFrameWorkInterfaceName() {
        String string = "";
        string = GenOptions.instance().isGenForEBAF() ? String.valueOf(string) + "RefObjectExtn" : String.valueOf(string) + "EMFObject";
        return string;
    }

    private void insertUserDefinedMethods(PrintWriter printWriter, String string) {
        printWriter.println("\n");
        printWriter.println("// Begin User Defined Methods");
        printWriter.println("\n");
        if (string.trim().compareTo("") != 0) {
            printWriter.println(string);
        }
        printWriter.println("// End  User Defined Methods");
    }
}

