/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.UMLClass;
import java.util.Hashtable;

public class JavaMappingTables {
    private static JavaMappingTables fTables = null;
    private static PrimitiveTypeTable primitiveTypeTable = null;
    private static ImplMethodTableForPrimitiveType implMethodTableForPrimitiveType = null;
    private static ReservedNamesTable reservedNamesTable = null;
    private static ReservedClassTable reservedClassTable = null;

    private JavaMappingTables() {
        primitiveTypeTable = new PrimitiveTypeTable();
        implMethodTableForPrimitiveType = new ImplMethodTableForPrimitiveType();
        reservedNamesTable = new ReservedNamesTable();
        reservedClassTable = new ReservedClassTable();
    }

    public String getImplClassNameForReservedClass(String string) {
        String string2 = (String)reservedClassTable.get(string);
        String string3 = string2.substring(0, string2.indexOf(",")).trim();
        if (string3.compareTo("null") == 0) {
            return null;
        }
        return string3;
    }

    public String getImplMethodForPrimitiveType(String string) {
        return (String)implMethodTableForPrimitiveType.get(string);
    }

    public String getInterfaceNameForReservedClass(String string) {
        String string2 = (String)reservedClassTable.get(string);
        String string3 = string2.substring(string2.indexOf(",") + 1).trim();
        if (string3.compareTo("null") == 0) {
            return null;
        }
        return string3;
    }

    public String getJavaMappingForType(UMLClass uMLClass) {
        String string = (String)primitiveTypeTable.get(uMLClass.getName());
        if (string == null) {
            string = uMLClass.getInterfaceClassName();
        }
        return string;
    }

    public String getJavaMappingForType(String string) {
        String string2 = (String)primitiveTypeTable.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String getModifiedNameIfReservedName(String string) {
        String string2 = (String)reservedNamesTable.get(string);
        if (string2 != null) {
            return String.valueOf(string) + "_X";
        }
        return string;
    }

    public static JavaMappingTables instance() {
        if (fTables == null) {
            fTables = new JavaMappingTables();
        }
        return fTables;
    }

    public boolean isPrimitiveType(String string) {
        String string2 = (String)primitiveTypeTable.get(string);
        return string2 != null;
    }

    public boolean isReservedClass(String string) {
        String string2 = (String)reservedClassTable.get(string);
        return string2 != null;
    }

    private class PrimitiveTypeTable
    extends Hashtable {
        PrimitiveTypeTable() {
            this.put("any", new String("any"));
            this.put("boolean", new String("boolean"));
            this.put("Boolean", new String("boolean"));
            this.put("char", new String("char"));
            this.put("wchar", new String("wchar"));
            this.put("double", new String("double"));
            this.put("float", new String("float"));
            this.put("void", new String("void"));
            this.put("long", new String("long"));
            this.put("long long", new String("long"));
            this.put("short", new String("short"));
            this.put("string", new String("String"));
            this.put("wstring", new String("String"));
            this.put("unsigned long", new String("long"));
            this.put("unsigned short", new String("short"));
            this.put("octet", new String("byte"));
            this.put("int", new String("int"));
            this.put("integer", new String("int"));
            this.put("String", new String("String"));
            this.put("Integer", new String("int"));
            this.put("Date", new String("String"));
            this.put("BigDecimal", new String("String"));
            this.put("enum", new String("int"));
        }
    }

    private class ImplMethodTableForPrimitiveType
    extends Hashtable {
        ImplMethodTableForPrimitiveType() {
            this.put("int", new String("Integer"));
            this.put("integer", new String("Integer"));
            this.put("Integer", new String("Integer"));
            this.put("String", new String("String"));
            this.put("string", new String("String"));
            this.put("boolean", new String("Boolean"));
            this.put("Boolean", new String("Boolean"));
            this.put("Date", new String("String"));
            this.put("BigDecimal", new String("String"));
            this.put("enum", new String("EnumValue"));
        }
    }

    private class ReservedNamesTable
    extends Hashtable {
        ReservedNamesTable() {
            this.put("abstract", new String("abstract"));
            this.put("boolean", new String("boolean"));
            this.put("break", new String("break"));
            this.put("byte", new String("byte"));
            this.put("case", new String("case"));
            this.put("catch", new String("catch"));
            this.put("char", new String("char"));
            this.put("class", new String("class"));
            this.put("const", new String("const"));
            this.put("continue", new String("continue"));
            this.put("default", new String("default"));
            this.put("do", new String("do"));
            this.put("double", new String("double"));
            this.put("else", new String("else"));
            this.put("extends", new String("extends"));
            this.put("final", new String("final"));
            this.put("finally", new String("finally"));
            this.put("float", new String("float"));
            this.put("for", new String("for"));
            this.put("goto", new String("goto"));
            this.put("if", new String("if"));
            this.put("implements", new String("implements"));
            this.put("imports", new String("imports"));
            this.put("instanceof", new String("instanceof"));
            this.put("int", new String("int"));
            this.put("interface", new String("interface"));
            this.put("long", new String("long"));
            this.put("native", new String("native"));
            this.put("new", new String("new"));
            this.put("package", new String("package"));
            this.put("private", new String("private"));
            this.put("public", new String("public"));
            this.put("return", new String("return"));
            this.put("short", new String("short"));
            this.put("static", new String("static"));
            this.put("String", new String("String"));
            this.put("Strictfp", new String("Strictfp"));
            this.put("super", new String("super"));
            this.put("switch", new String("switch"));
            this.put("synchronized", new String("synchronized"));
            this.put("this", new String("this"));
            this.put("throw", new String("throw"));
            this.put("throws", new String("throws"));
            this.put("transient", new String("transient"));
            this.put("try", new String("try"));
            this.put("void", new String("void"));
            this.put("volatile", new String("volatile"));
            this.put("while", new String("while"));
            this.put("any", new String("any"));
            this.put("false", new String("false"));
            this.put("integer", new String("int"));
            this.put("Integer", new String("int"));
            this.put("long long", new String("long long"));
            this.put("octet", new String("byte"));
            this.put("Object", new String("Object"));
            this.put("unsigned long", new String("long"));
            this.put("unsigned short", new String("short"));
            this.put("true", new String("true"));
            this.put("wchar", new String("wchar"));
            this.put("wstring", new String("wstring"));
        }
    }

    private class ReservedClassTable
    extends Hashtable {
        ReservedClassTable() {
            this.put("Class", new String("MofClassExtnImpl,MofClassExtn"));
            this.put("MOFClass", new String("MofClassExtnImpl,MofClassExtn"));
            this.put("Attribute", new String("AttributeExtnImpl,AttributeExtn"));
            this.put("MOFAttribute", new String("AttributeExtnImpl,AttributeExtn"));
            this.put("DataType", new String("DataTypeExtnImpl, DataTypeExtn"));
            this.put("MOFDataType", new String("DataTypeExtnImpl, DataTypeExtn"));
            this.put("Feature", new String("FeatureExtnImpl, FeatureExtn"));
            this.put("MOFFeature", new String("FeatureExtnImpl, FeatureExtn"));
            this.put("Operation", new String("OperationExtnImpl, OperationExtn"));
            this.put("MOFOperation", new String("OperationExtnImpl, OperationExtn"));
            this.put("Parameter", new String("ParameterExtnImpl, ParameterExtn"));
            this.put("MOFParameter", new String("ParameterExtnImpl, ParameterExtn"));
            this.put("MOFObject", new String("RefObjectExtnImpl,RefObjectExtn"));
            this.put("Object", new String("RefObjectExtnImpl,RefObjectExtn"));
            this.put("RefObject", new String("RefObjectExtnImpl,RefObjectExtn"));
            this.put("MOFString", new String("MOFStringClass,IBMMOFClass"));
            this.put("MOFEnumeration", new String("MOFEnumerationImpl,MofClassExtn"));
            this.put("Enumeration", new String("MOFEnumerationImpl,MofClassExtn"));
            this.put("MOFLiteral", new String("MOFLiteralClass,IBMMOFClass"));
            this.put("Literal", new String("MOFLiteralClass,IBMMOFClass"));
            this.put("Namespace", new String("NamespaceExtnImpl,NamespaceExtn"));
            this.put("MOFNamespace", new String("NamespaceExtnImpl,NamespaceExtn"));
            this.put("Package", new String("PackageExtnImpl,PackageExtn"));
            this.put("MOFPackage", new String("PackageExtnImpl,PackageExtn"));
        }
    }
}

