/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.JavaMappingTables;
import com.ibm.ebaf.gen.base.UMLBase;
import com.ibm.ebaf.gen.base.UMLClass;
import com.ibm.ebaf.gen.base.UMLEnumerationValue;
import java.util.Vector;

public class UMLAttribute
extends UMLBase {
    private int attrType = 2;
    private UMLClass attrClass = null;
    private UMLClass attrTypeClass = null;
    private String typeName = null;
    private String defaultValue = null;
    private int visibility = GenConstants.PUBLIC;
    private String ownerScope = null;
    private String changeable = null;
    private String targetScope = null;
    private String multiplicity = null;
    private String enumStr = null;

    public UMLClass getAttrClass() {
        return this.attrClass;
    }

    public String getAttrName() {
        return this.getBaseName();
    }

    public UMLClass getAttrTypeClass() {
        return this.attrType == 0 ? null : this.attrTypeClass;
    }

    public String getAttrTypeName() {
        if (this.attrTypeClass != null) {
            return this.attrTypeClass.getInterfaceClassName();
        }
        return this.typeName;
    }

    public String getChangeable() {
        return this.changeable;
    }

    public String getDefaultValue() {
        if (this.isEnumType()) {
            return String.valueOf(this.getAttrTypeClass().getInterfaceClassName()) + "." + (this.defaultValue == null ? ((UMLEnumerationValue)this.getEnumeratedValues().firstElement()).getLabel() : this.defaultValue);
        }
        String string = this.getJavaMappedAttrTypeName();
        if (string.compareTo("String") == 0) {
            return this.defaultValue == null ? null : "\"" + this.defaultValue + "\" ";
        }
        if (string.compareTo("int") == 0) {
            return this.defaultValue == null ? "0" : this.defaultValue;
        }
        if (string.compareTo("boolean") == 0) {
            return this.defaultValue == null ? "false" : this.defaultValue;
        }
        return this.defaultValue;
    }

    public Vector getEnumeratedValues() {
        if (this.isEnumType()) {
            return this.attrTypeClass.getEnumerationValues();
        }
        return null;
    }

    public String getJavaMappedAttrTypeName() {
        return JavaMappingTables.instance().getJavaMappingForType(this.getAttrTypeName());
    }

    public String getMultiplicity() {
        return this.multiplicity;
    }

    public String getObjectToPrimTypeFunc() {
        String string = this.getJavaMappedAttrTypeName();
        if (string.compareTo("int") == 0) {
            return "intValue()";
        }
        if (string.compareTo("boolean") == 0) {
            return "booleanValue()";
        }
        return null;
    }

    public String getOwnerScope() {
        return this.ownerScope;
    }

    public String getPrimTypeToObjectFunc() {
        String string = this.getJavaMappedAttrTypeName();
        if (string.compareTo("int") == 0) {
            return "Integer";
        }
        if (string.compareTo("boolean") == 0) {
            return "Boolean";
        }
        return null;
    }

    public String getTargetScope() {
        return this.targetScope;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public boolean isEnumType() {
        if (this.attrTypeClass != null && this.attrTypeClass.isEnumType()) {
            return true;
        }
        return this.attrType == 1;
    }

    public boolean isPrimitiveType() {
        if (this.attrTypeClass != null && JavaMappingTables.instance().isPrimitiveType(this.attrTypeClass.getName())) {
            return true;
        }
        return this.attrType == 0;
    }

    public void setAttrClass(UMLClass uMLClass) {
        this.attrClass = uMLClass;
    }

    public void setAttrType(int n) {
        this.attrType = n;
    }

    public void setAttrTypeClass(UMLClass uMLClass) {
        this.attrTypeClass = uMLClass;
    }

    public void setAttrTypeName(String string) {
        this.typeName = string;
    }

    public void setChangeable(String string) {
        this.changeable = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setMultiplicity(String string) {
        this.multiplicity = string;
    }

    public void setOwnerScope(String string) {
        this.ownerScope = string;
    }

    public void setTargetScope(String string) {
        this.targetScope = string;
    }

    public void setVisibility(int n) {
        this.visibility = n;
    }
}

