/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.gen.base;

import com.ibm.ebaf.gen.base.GenConstants;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.gen.base.JavaMappingTables;
import com.ibm.ebaf.gen.base.UMLAssociation;
import com.ibm.ebaf.gen.base.UMLAssociationEnd;
import com.ibm.ebaf.gen.base.UMLAttribute;
import com.ibm.ebaf.gen.base.UMLBase;
import com.ibm.ebaf.gen.base.UMLEnumerationValue;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UMLClass
extends UMLBase {
    private Vector parentClasses = new Vector();
    private Vector childClasses = new Vector();
    private Vector attributes = new Vector();
    private Vector associations = new Vector();
    private Vector associationEnds = new Vector();
    private int inheritanceLevel = 0;
    private int compositionLevel = 0;
    private boolean hasXMIUUID = false;
    private String stereotype = null;
    private Vector enumValues = new Vector();
    private String documentation = null;
    private boolean enumType = false;
    private int visibility = GenConstants.PUBLIC;
    private boolean root = false;
    private boolean leaf = false;
    private boolean xabstract = false;
    private boolean active = false;
    private String fimplPackage = null;
    private String fimplPrefix = null;
    private String fimplPostfix = null;
    private String finterfacePackage = null;
    private String finterfacePrefix = null;
    private String finterfacePostfix = null;

    public void addAssociation(UMLAssociation uMLAssociation) {
        this.associations.addElement(uMLAssociation);
    }

    public void addAssociationEnd(UMLAssociationEnd uMLAssociationEnd) {
        this.associationEnds.addElement(uMLAssociationEnd);
    }

    public void addAttribute(UMLAttribute uMLAttribute) {
        this.attributes.addElement(uMLAttribute);
    }

    public void addChildClass(UMLClass uMLClass) {
        this.childClasses.addElement(uMLClass);
    }

    public void addParentClass(UMLClass uMLClass) {
        this.parentClasses.addElement(uMLClass);
    }

    private void assignValuesToEnumeration() {
        int[] nArray = new int[this.enumValues.size()];
        int n = 0;
        Object[] objectArray = new UMLEnumerationValue[this.enumValues.size()];
        this.enumValues.copyInto(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (((UMLEnumerationValue)objectArray[n2]).getValue() != Integer.MIN_VALUE) {
                nArray[n++] = ((UMLEnumerationValue)objectArray[n2]).getValue();
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (((UMLEnumerationValue)objectArray[n4]).getValue() == Integer.MIN_VALUE) {
                while (true) {
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < n) {
                        if (n3 == nArray[n5]) {
                            bl = true;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl) break;
                    ++n3;
                }
                ((UMLEnumerationValue)objectArray[n4]).setValue(n3++);
            }
            ++n4;
        }
    }

    private void assignValuesToEnumeration_old() {
        Enumeration enumeration = this.enumValues.elements();
        UMLEnumerationValue uMLEnumerationValue = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            uMLEnumerationValue = (UMLEnumerationValue)enumeration.nextElement();
            if (uMLEnumerationValue.getValue() == Integer.MIN_VALUE) {
                uMLEnumerationValue.setValue(n++);
                continue;
            }
            if (uMLEnumerationValue.getValue() <= n) continue;
            n = uMLEnumerationValue.getValue() + 1;
        }
    }

    public Vector associations() {
        return this.associations;
    }

    public Vector childClasses() {
        return this.childClasses;
    }

    public int compositionLevel() {
        return this.compositionLevel;
    }

    public void compositionLevel(int n) {
        this.compositionLevel = n;
    }

    public void enumType(boolean bl) {
        this.enumType = bl;
    }

    public Vector getAssociationEnds() {
        return this.associationEnds;
    }

    public Vector getAssociationEnds_old() {
        Vector<UMLAssociationEnd> vector = new Vector<UMLAssociationEnd>();
        Enumeration enumeration = this.associations().elements();
        while (enumeration.hasMoreElements()) {
            UMLAssociation uMLAssociation = (UMLAssociation)enumeration.nextElement();
            UMLAssociationEnd uMLAssociationEnd = uMLAssociation.getAssociationEndForTargetClass(this.getId());
            vector.addElement(uMLAssociationEnd);
        }
        return vector;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public Vector getEnumerationValues() {
        return this.enumValues;
    }

    public String getGenName() {
        String string = this.getBaseName();
        if (this.isPrimitiveType()) {
            return string;
        }
        if (this.isReservedClass()) {
            return JavaMappingTables.instance().getInterfaceNameForReservedClass(string);
        }
        return string;
    }

    public String getImplClassName() {
        String string = this.getBaseName();
        if (this.isPrimitiveType()) {
            return string;
        }
        if (this.isReservedClass()) {
            return JavaMappingTables.instance().getInterfaceNameForReservedClass(string);
        }
        return String.valueOf(this.getImplPrefix()) + string + this.getImplPostfix();
    }

    public String getImplClassNameForReservedClass() {
        return JavaMappingTables.instance().getImplClassNameForReservedClass(this.getName());
    }

    public String getImplGenClassName() {
        String string = this.getBaseName();
        if (this.isPrimitiveType()) {
            return string;
        }
        if (this.isReservedClass()) {
            return JavaMappingTables.instance().getInterfaceNameForReservedClass(string);
        }
        return String.valueOf(GenOptions.instance().getImplGenPrefix()) + string + GenOptions.instance().getImplGenPostfix();
    }

    public String getImplGenImport() {
        String string = "";
        string = String.valueOf(string) + "import " + this.getImplGenPackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    public String getImplGenPackage() {
        return GenOptions.instance().getImplGenPackage();
    }

    public String getImplImport() {
        String string = "";
        string = String.valueOf(string) + "import " + this.getImplPackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    public String getImplImportForParent() {
        String string = "";
        UMLClass uMLClass = this.getParentClass();
        if (uMLClass != null && uMLClass.isReservedClass()) {
            return "";
        }
        if (uMLClass != null && uMLClass.isFromDifferentPackage()) {
            string = String.valueOf(string) + "import " + uMLClass.getImplPackage() + "." + uMLClass.getImplClassName() + ";\n";
        }
        return string;
    }

    public String getImplPackage() {
        if (this.fimplPackage == null) {
            return "";
        }
        return this.fimplPackage;
    }

    public String getImplPostfix() {
        return this.fimplPostfix == null ? "Impl" : this.fimplPostfix;
    }

    public String getImplPrefix() {
        return this.fimplPrefix == null ? "" : this.fimplPrefix;
    }

    public String getInterfaceClassName() {
        String string = this.getBaseName();
        if (this.isPrimitiveType()) {
            return string;
        }
        if (this.isReservedClass()) {
            return JavaMappingTables.instance().getInterfaceNameForReservedClass(string);
        }
        return String.valueOf(this.getInterfacePrefix()) + string + this.getInterfacePostfix();
    }

    public String getInterfaceGenClassName() {
        String string = this.getBaseName();
        if (this.isPrimitiveType()) {
            return string;
        }
        if (this.isReservedClass()) {
            return JavaMappingTables.instance().getInterfaceNameForReservedClass(string);
        }
        return String.valueOf(GenOptions.instance().getInterfaceGenPrefix()) + string + GenOptions.instance().getInterfaceGenPostfix();
    }

    public String getInterfaceGenImport() {
        String string = "";
        string = String.valueOf(string) + "import " + this.getInterfaceGenPackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    public String getInterfaceGenPackage() {
        return GenOptions.instance().getInterfaceGenPackage();
    }

    public String getInterfaceGenPackageName() {
        return String.valueOf(GenOptions.instance().getInterfacePackage()) + "." + "gen";
    }

    public String getInterfaceImport() {
        String string = "";
        string = String.valueOf(string) + "import " + this.getInterfacePackage();
        string = String.valueOf(string) + ".*;\n";
        return string;
    }

    public String getInterfaceImportForAssociations() {
        String string = "";
        Enumeration enumeration = this.getAssociationEnds().elements();
        while (enumeration.hasMoreElements()) {
            UMLAssociationEnd uMLAssociationEnd = (UMLAssociationEnd)enumeration.nextElement();
            UMLClass uMLClass = uMLAssociationEnd.getTargetClass();
            if (uMLClass == null || uMLClass.isPrimitiveType()) continue;
            if (uMLClass.isReservedClass()) {
                string = String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_EBAF_OTHER;
                return string;
            }
            if (!uMLClass.isFromDifferentPackage()) continue;
            string = String.valueOf(string) + "import " + uMLClass.getInterfacePackage() + "." + uMLClass.getInterfaceClassName() + ";\n";
        }
        return string;
    }

    public String getInterfaceImportForAttributes() {
        String string = "";
        Enumeration enumeration = this.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            UMLAttribute uMLAttribute = (UMLAttribute)enumeration.nextElement();
            UMLClass uMLClass = uMLAttribute.getAttrTypeClass();
            if (uMLClass == null || uMLClass.isPrimitiveType()) continue;
            if (uMLClass.isReservedClass()) {
                string = String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_EBAF_OTHER;
                return string;
            }
            if (!uMLClass.isFromDifferentPackage()) continue;
            string = String.valueOf(string) + "import " + uMLClass.getInterfacePackage() + "." + uMLClass.getInterfaceClassName() + ";" + GenConstants.NEW_LINE;
        }
        return string;
    }

    public String getInterfaceImportForParent() {
        String string = "";
        Vector vector = this.getParentClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UMLClass uMLClass = (UMLClass)enumeration.nextElement();
            if (uMLClass != null && uMLClass.isReservedClass()) {
                string = String.valueOf(string) + GenConstants.FRAMEWORK_INTF_IMPORTS_EBAF_OTHER;
            }
            if (uMLClass == null || !uMLClass.isFromDifferentPackage()) continue;
            string = String.valueOf(string) + "import " + uMLClass.getInterfacePackage() + "." + uMLClass.getInterfaceClassName() + ";\n";
        }
        return string;
    }

    public String getInterfaceNameForReservedClass() {
        return JavaMappingTables.instance().getInterfaceNameForReservedClass(this.getName());
    }

    public String getInterfacePackage() {
        if (this.finterfacePackage != null) {
            return this.finterfacePackage;
        }
        String string = this.getImplPackage();
        if (string.endsWith(".impl")) {
            string = string.substring(0, string.lastIndexOf(".impl"));
        }
        return string;
    }

    public String getInterfacePackageName() {
        String string = GenOptions.instance().getImplPackage();
        if (string.endsWith(".impl")) {
            string = string.substring(0, string.lastIndexOf(".impl"));
        }
        return string;
    }

    public String getInterfacePostfix() {
        return this.finterfacePostfix == null ? "" : this.finterfacePostfix;
    }

    public String getInterfacePrefix() {
        return this.finterfacePrefix == null ? this.getImplPrefix() : this.finterfacePrefix;
    }

    public String getName() {
        String string = this.getBaseName();
        if (string.compareTo("Object") == 0) {
            return "Ref" + string;
        }
        return string;
    }

    public UMLClass getParentClass() {
        if (this.parentClasses.isEmpty()) {
            return null;
        }
        return (UMLClass)this.parentClasses.firstElement();
    }

    public Vector getParentClasses() {
        return this.parentClasses;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public boolean hasProperties() {
        if (this.attributes.size() > 0) {
            return true;
        }
        int n = 0;
        while (n < this.parentClasses.size()) {
            if (((UMLClass)this.parentClasses.elementAt(n)).hasProperties()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasXMIUUID() {
        boolean bl = this.hasXMIUUID;
        int n = 0;
        while (n < this.parentClasses.size()) {
            bl |= ((UMLClass)this.parentClasses.elementAt(n)).hasXMIUUID();
            ++n;
        }
        return bl;
    }

    public void hasXMIUUID(boolean bl) {
        this.hasXMIUUID = bl;
    }

    public int inheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void inheritanceLevel(int n) {
        this.inheritanceLevel = n;
    }

    public boolean isAbstract() {
        return this.xabstract;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEnumType() {
        return this.enumType;
    }

    public boolean isFromCurrentPackage() {
        boolean bl = false;
        if (this.getImplPackage().compareTo(GenOptions.instance().getImplPackage()) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFromDifferentPackage() {
        return this.isFromCurrentPackage() ^ true;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isPrimitiveType() {
        return JavaMappingTables.instance().isPrimitiveType(this.getName());
    }

    public boolean isReservedClass() {
        return JavaMappingTables.instance().isReservedClass(this.getName());
    }

    public boolean isRoot() {
        return this.root;
    }

    private void parseAndBuildEnumeration(String string) {
        this.enumValues.removeAllElements();
        if (string == null) {
            return;
        }
        String string2 = null;
        UMLEnumerationValue uMLEnumerationValue = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " =,\t\r\n", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("") || string2.equals(",")) continue;
            if (string2.equals("=")) {
                bl = uMLEnumerationValue != null;
                continue;
            }
            if (bl) {
                try {
                    uMLEnumerationValue.setValue(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(numberFormatException.getMessage());
                    System.out.println("Enumeration value specified for Label ignored because it is not integer");
                    System.out.println("Label Name : " + uMLEnumerationValue.getLabel() + "    Specified Value : " + string2);
                }
                bl = false;
                continue;
            }
            uMLEnumerationValue = new UMLEnumerationValue();
            uMLEnumerationValue.setLabel(string2);
            this.enumValues.addElement(uMLEnumerationValue);
        }
        this.assignValuesToEnumeration();
    }

    public void setAbstract(boolean bl) {
        this.xabstract = bl;
    }

    public void setActive(String string) {
        if (string != null) {
            this.active = string.compareTo("false") != 0;
        }
    }

    public void setDocumentation(String string) {
        this.documentation = string;
        this.parseAndBuildEnumeration(string);
    }

    public void setEnumerationValues(Vector vector) {
        this.enumValues = vector;
        this.assignValuesToEnumeration();
    }

    public void setImplPackage(String string) {
        this.fimplPackage = string;
    }

    public void setImplPostfix(String string) {
        this.fimplPostfix = string;
    }

    public void setImplPrefix(String string) {
        this.fimplPrefix = string;
    }

    public void setInterfacePackage(String string) {
        this.finterfacePackage = string;
    }

    public void setInterfacePostfix(String string) {
        this.finterfacePostfix = string;
    }

    public void setInterfacePrefix(String string) {
        this.finterfacePrefix = string;
    }

    public void setLeaf(String string) {
        if (string != null) {
            this.leaf = string.compareTo("false") != 0;
        }
    }

    public void setRoot(String string) {
        if (string != null) {
            this.root = string.compareTo("false") != 0;
        }
    }

    public void setVisibility(int n) {
        this.visibility = n;
    }

    public String stereotype() {
        return this.stereotype;
    }

    public void stereotype(String string) {
        this.stereotype = string;
    }

    public String toString() {
        return "aUMLClass(" + this.getName() + ")";
    }
}

