/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.rosebridge;

import com.ibm.ebaf.gen.base.DocumentToJava;
import com.ibm.ebaf.gen.base.GenFileUtil;
import com.ibm.ebaf.gen.base.GenOptions;
import com.ibm.ebaf.rosebridge.Association;
import com.ibm.mof.mof13.ModelElement;
import com.ibm.mof.mof13.extn.AssociationEndExtn;
import com.ibm.mof.mof13.extn.MofClassExtn;
import com.ibm.mof.mof13.extn.impl.AttributeExtnImpl;
import com.ibm.mof.mof13.extn.impl.ClassifierExtnImpl;
import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.mof.mof13.extn.impl.MOFConstants;
import com.ibm.mof.mof13.extn.impl.MOFEnumValue;
import com.ibm.mof.mof13.extn.impl.MofClassExtnImpl;
import com.ibm.mof.mof13.extn.impl.MultiplicityTypeExtnImpl;
import com.ibm.mof.mof13.extn.impl.NamespaceExtnImpl;
import com.ibm.mof.mof13.extn.impl.PackageExtnImpl;
import com.ibm.mof.mof13.extn.impl.TypedElementExtnImpl;
import com.ibm.mof.mof13.extn.impl.XMIReferenceImpl;
import com.ibm.mof.mof13.ref.extn.RefObjectExtn;
import com.ibm.mof.mof13.ref.extn.impl.RefBaseObjectExtnImpl;
import com.ibm.mof.mof13.ref.extn.impl.RefObjectExtnImpl;
import com.ibm.psh.rb30.RoseUtil;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UMLException;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xmi.xmi11temp.impl.DeferredAttributeSetting;
import com.ibm.xmi.xmi11temp.impl.XMIClassNotFoundException;
import com.ibm.xmi.xmi11temp.impl.XMIDOMSerializerImpl;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentImpl;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RoseToNamespace {
    private Id roseModelId;
    private IBMXMIDocument myDoc = null;
    private static Hashtable packagesToNamespaces = new Hashtable();
    private static Hashtable packagesToDocuments = new Hashtable();
    private static boolean Debug = true;
    private static boolean fgenSchemasForAllPackages = false;
    private static String topLevelPackageName;
    private String modelFileName;
    private String implPackagePrefix;
    private String mofPackageName;
    private String mofPrefix;
    private String mofPostfix;
    private String interfacePackagePrefix;
    private String mofIPackageName;
    private String mofIPrefix;
    private String mofIPostfix;
    private Vector deferredAttributeSettings = new Vector();
    private Vector mofClasses = new Vector();
    private static String MOFOwnedElements;
    private static String MOFName;
    private static String MOFMultiplicity;
    private static String MOFClass;
    private static String MOFAttribute;
    private static String MOFType;
    private static String MOFSuperclass;
    private static String MOFAssoication;
    private static String MOFAssoicationEnd;
    private static String MOFAssoicationEnds;
    private static String MOFValue;
    private static String MOFAggregate;
    private static String MOFNavigable;
    private static String MOFEnumeration;
    private static String ImplJavaClassMap;
    private static String MOFEnumValue;
    private static String MOFInitValue;
    private static String MOFVisibility;
    private static String MOFAbstract;
    private MofClassExtn mofClass;
    private MofClassExtn mofEnumeration;
    private MofClassExtn mofAssociation;
    private MofClassExtn mofAssociationEnd;
    private MofClassExtn mofAttribute;
    private AssociationEndExtn mofType;
    private MofClassExtn mofEnumValue;
    private String mofNamesapceURL;
    private String implNamespaceURL;
    private MofClassExtn implClass;

    static {
        MOFOwnedElements = "ownedElements";
        MOFName = "name";
        MOFMultiplicity = "multiplicity";
        MOFClass = "Class";
        MOFAttribute = "Attribute";
        MOFType = "type";
        MOFSuperclass = "superclass";
        MOFAssoication = "Association";
        MOFAssoicationEnd = "AssociationEnd";
        MOFAssoicationEnds = "associationEnds";
        MOFValue = "value";
        MOFAggregate = "aggregation";
        MOFNavigable = "isNavigable";
        MOFEnumeration = "Enumeration";
        ImplJavaClassMap = "JavaClassMap";
        MOFEnumValue = "EnumValue";
        MOFInitValue = "defaultValue";
        MOFVisibility = "visibility";
        MOFAbstract = "isAbstract";
    }

    public RoseToNamespace() {
        MOFConstants.initializeNamespaces();
        this.mofNamesapceURL = MOFConstants.mofNS;
        this.mofClass = MOFConstants.mofClass;
        this.mofAttribute = MOFConstants.mofAttribute;
        this.mofAssociation = MOFConstants.mofAssociation;
        this.mofAssociationEnd = MOFConstants.mofAssociationEnd;
        this.mofType = MOFConstants.mofTypedElementTypeRole;
        this.mofEnumeration = MOFConstants.mofEnumeration;
        this.mofEnumValue = MOFConstants.mofEnumValue;
        this.implNamespaceURL = MOFConstants.implNS;
    }

    public RoseToNamespace(String string, String string2) {
        this();
        this.modelFileName = string;
        topLevelPackageName = string.substring(0, string.indexOf(".mdl"));
        topLevelPackageName = topLevelPackageName.substring(topLevelPackageName.lastIndexOf(File.separator) + 1);
        this.implPackagePrefix = GenOptions.instance().getImplPackagePrefix();
        this.mofPackageName = GenOptions.instance().getImplPackage();
        this.mofPrefix = GenOptions.instance().getImplPrefix();
        this.mofPostfix = GenOptions.instance().getImplPostfix();
        this.interfacePackagePrefix = GenOptions.instance().getInterfacePackagePrefix();
        this.mofIPackageName = GenOptions.instance().getInterfacePackage();
        this.mofIPrefix = GenOptions.instance().getInterfacePrefix();
        this.mofIPostfix = GenOptions.instance().getInterfacePostfix();
        RoseUtil roseUtil = new RoseUtil();
        roseUtil.rLoad(string, true, string2, false, false, true, false);
        this.roseModelId = RoseUtil.modelId;
        if (this.myDoc == null) {
            this.myDoc = new XMIDocumentImpl();
        }
    }

    private void addDeferredAttributeSetting(MOFAttributeSetting mOFAttributeSetting) {
        this.deferredAttributeSettings.addElement(mOFAttributeSetting);
    }

    private void addDeferredAttributeSetting(Object object) {
        this.deferredAttributeSettings.addElement(object);
    }

    public void addPackages(Id id, Hashtable hashtable) {
        try {
            hashtable.put(RoseToNamespace.getQualifiedName(id), id);
            Vector vector = id.get(Type.PACKAGE, false);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Id id2 = (Id)vector.elementAt(n);
                    this.addPackages(id2, hashtable);
                    ++n;
                }
            }
        }
        catch (UMLException uMLException) {}
    }

    private void analyzeRose() {
    }

    private RefObjectExtnImpl createAssociation(PackageExtnImpl packageExtnImpl, String string, Id id, String string2) {
        Association association = new Association(id, string);
        if (!association.isInherited()) {
            RefObjectExtnImpl refObjectExtnImpl = this.getDocument().newInstance(this.mofAssociation);
            refObjectExtnImpl.setID(association.getAssociationID());
            MOFAttributeSetting mOFAttributeSetting = this.createAssociationEnd(id, refObjectExtnImpl, association, true);
            MOFAttributeSetting mOFAttributeSetting2 = this.createAssociationEnd(id, refObjectExtnImpl, association, false);
            packageExtnImpl.addContents((ModelElement)((Object)refObjectExtnImpl));
            mOFAttributeSetting.apply();
            mOFAttributeSetting2.apply();
            refObjectExtnImpl.initializeAfterLoad();
            return refObjectExtnImpl;
        }
        return null;
    }

    private MOFAttributeSetting createAssociationEnd(Id id, RefObjectExtnImpl refObjectExtnImpl, Association association, boolean bl) {
        MOFAttributeSetting mOFAttributeSetting;
        RefObjectExtnImpl refObjectExtnImpl2 = this.getDocument().newInstance(this.mofAssociationEnd);
        MOFAttributeSetting mOFAttributeSetting2 = this.getDocument().newAttributeSetting(MOFConstants.mofAssociationEndsRole);
        mOFAttributeSetting2.setSubject(refObjectExtnImpl);
        if (bl) {
            refObjectExtnImpl2.setID(association.getSourceRoleId());
            this.setAttributeValue(refObjectExtnImpl2, MOFName, association.getSourceLabel());
            this.setAttributeValue(refObjectExtnImpl2, MOFMultiplicity, association.getSourceMultiplicity());
            this.setAttributeValue(refObjectExtnImpl2, MOFNavigable, association.getSourceNavigable());
            this.setAttributeValue(refObjectExtnImpl2, MOFAggregate, association.getSourceAggregation());
            mOFAttributeSetting = this.createMofType(association.getSourceTypeNSName(), association.getSourceTypeName());
        } else {
            refObjectExtnImpl2.setID(association.getTargetRoleId());
            this.setAttributeValue(refObjectExtnImpl2, MOFName, association.getTargetLabel());
            this.setAttributeValue(refObjectExtnImpl2, MOFMultiplicity, association.getTargetMultiplicity());
            this.setAttributeValue(refObjectExtnImpl2, MOFNavigable, association.getTargetNavigable());
            this.setAttributeValue(refObjectExtnImpl2, MOFAggregate, association.getTargetAggregation());
            mOFAttributeSetting = this.createMofType(association.getTargetTypeNSName(), association.getTargetTypeName());
        }
        mOFAttributeSetting2.setObject(refObjectExtnImpl2);
        mOFAttributeSetting.setSubject(refObjectExtnImpl2);
        return mOFAttributeSetting2;
    }

    private ClassifierExtnImpl createEnumType(Id id) {
        ClassifierExtnImpl classifierExtnImpl = null;
        try {
            String string;
            String string2 = string = id.get(Property.NAME);
            RoseToNamespace.debug("     Enum Type name =" + string);
            classifierExtnImpl = (ClassifierExtnImpl)this.getDocument().newInstance(this.mofEnumeration);
            classifierExtnImpl.setID(string2);
            this.myDoc.registerMOFObject(classifierExtnImpl);
            String string3 = id.get("", "documentation");
            RoseToNamespace.debug("enumValue = " + string3);
            Vector vector = id.get(Type.ENUMERATION_LITERAL, false);
            if (vector != null) {
                AssociationEndExtn associationEndExtn = MOFConstants.mofEnumValuesRole;
                MOFAttributeSetting mOFAttributeSetting = this.getDocument().newAttributeSetting(associationEndExtn);
                int n = 0;
                int n2 = 0;
                while (n < vector.size()) {
                    Id id2 = (Id)vector.elementAt(n);
                    String string4 = id2.get(Property.EL_NAME);
                    if (string4 != null && !string4.equals("")) {
                        DeferredAttributeSetting deferredAttributeSetting = new DeferredAttributeSetting(MOFConstants.mofEnumValuesRole.getName(), this.myDoc);
                        deferredAttributeSetting.setSubject(classifierExtnImpl);
                        this.addDeferredAttributeSetting(deferredAttributeSetting);
                        n2 = this.createEnumValue(deferredAttributeSetting, string2, string4, n2);
                    }
                    ++n;
                    ++n2;
                }
            }
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        return classifierExtnImpl;
    }

    private int createEnumValue(MOFAttributeSetting mOFAttributeSetting, String string, String string2, int n) {
        RefObjectExtnImpl refObjectExtnImpl = this.getDocument().newInstance(this.mofEnumValue);
        String[] stringArray = this.getEnumValue(string2, n);
        refObjectExtnImpl.setID(RoseToNamespace.qualifiedName(string, stringArray[0]));
        this.setAttributeValue(refObjectExtnImpl, MOFName, stringArray[0]);
        this.setAttributeValue(refObjectExtnImpl, "number", new Integer(stringArray[1]));
        mOFAttributeSetting.addObject(refObjectExtnImpl);
        RoseToNamespace.debug("\tCreate EnumValue = (" + string2 + ")");
        return Integer.parseInt(stringArray[1]);
    }

    private int createEnumValue(DeferredAttributeSetting deferredAttributeSetting, String string, String string2, int n) {
        RefObjectExtnImpl refObjectExtnImpl = this.getDocument().newInstance(this.mofEnumValue);
        String[] stringArray = this.getEnumValue(string2, n);
        refObjectExtnImpl.setID(RoseToNamespace.qualifiedName(string, stringArray[0]));
        this.setAttributeValue(refObjectExtnImpl, MOFName, stringArray[0]);
        this.setAttributeValue(refObjectExtnImpl, "number", new Integer(stringArray[1]));
        deferredAttributeSetting.setObject(refObjectExtnImpl);
        RoseToNamespace.debug("\tCreate EnumValue = (" + string2 + ")");
        return Integer.parseInt(stringArray[1]);
    }

    private RefObjectExtn createMofAttribute(MofClassExtnImpl mofClassExtnImpl, String string, Id id, Id id2) {
        String[] stringArray;
        Vector vector = null;
        AttributeExtnImpl attributeExtnImpl = (AttributeExtnImpl)this.getDocument().newInstance(this.mofAttribute);
        try {
            String string2 = id.get(Property.NAME);
            String string3 = id.get(Property.ME_VISIBILITY);
            vector = id.get(Link.INITIAL_VALUE, false);
            stringArray = this.getMultiplicity(string2);
            attributeExtnImpl.setID(RoseToNamespace.qualifiedName(string, stringArray[0]));
            this.setAttributeValue(attributeExtnImpl, MOFName, stringArray[0]);
            this.setAttributeValue(attributeExtnImpl, MOFMultiplicity, new MultiplicityTypeExtnImpl(stringArray[1]));
            if (string3.compareTo("public") != 0) {
                this.setAttributeValue(attributeExtnImpl, MOFVisibility, this.getVisibilityEnum(string3));
            }
            String string4 = this.getTypeNameFromId(id, Link.SF_TYPE);
            MOFAttributeSetting mOFAttributeSetting = null;
            String string5 = this.getPackageNameFromId(id, Link.SF_TYPE);
            String string6 = this.getPackageNameFromId(id2);
            System.out.println("Attr PackageName = " + string5 + " class package = " + string6);
            mOFAttributeSetting = string5 != null && string5.compareTo(string6) != 0 ? this.createMofType(string5, string4) : this.createMofType(string4);
            mOFAttributeSetting.setSubject(attributeExtnImpl);
            if (vector != null) {
                Id id3 = (Id)vector.firstElement();
                String string7 = id3.get(Property.EXPRESSION_BODY);
                GenOptions.debug("Attribuite default value = " + string7);
                if (this.isTypeEnumeration(id, Link.SF_TYPE)) {
                    this.setAttributeValue(attributeExtnImpl, MOFInitValue, new String(string7));
                } else if (string4.compareTo("String") == 0) {
                    this.setAttributeValue(attributeExtnImpl, MOFInitValue, new String(string7));
                } else if (string4.compareTo("Integer") == 0) {
                    this.setAttributeValue(attributeExtnImpl, MOFInitValue, new Integer(string7));
                } else if (string4.compareTo("Boolean") == 0) {
                    this.setAttributeValue(attributeExtnImpl, MOFInitValue, new Boolean(string7));
                }
            }
            GenOptions.debug("\t   create MOF Attribute = " + string2 + "  Type = " + string4 + " Visibility = " + string3);
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        stringArray = this.getDocument().newAttributeSetting(MOFConstants.mofNamespaceContentsRole);
        stringArray.setSubject(mofClassExtnImpl);
        stringArray.setObject(attributeExtnImpl);
        this.addDeferredAttributeSetting((MOFAttributeSetting)stringArray);
        return attributeExtnImpl;
    }

    private MofClassExtnImpl createMofClass(Id id, String string) {
        MofClassExtnImpl mofClassExtnImpl = null;
        Vector vector = null;
        try {
            String string2 = id.get(Property.NAME);
            String string3 = id.get(Property.IS_ABSTRACT);
            String string4 = string2;
            if (this.isMofClass(string2)) {
                return null;
            }
            RoseToNamespace.debug("   create MOF Class = " + string2 + " isAbstract = " + string3);
            String string5 = id.get("Rose", "stereotype");
            if (string5 != null) {
                RoseToNamespace.debug("WARNING!!! StereoType " + string5 + " isNotSupported");
                RoseToNamespace.debug("WARNING!!! You must define enumeration as enumeration and it is case sensitive");
            }
            vector = id.get(Type.ENUMERATION, false);
            mofClassExtnImpl = (MofClassExtnImpl)this.getDocument().newInstance(this.mofClass);
            mofClassExtnImpl.setID(string4);
            if (string3 != null && string3.compareTo("true") == 0) {
                this.setAttributeValue(mofClassExtnImpl, MOFAbstract, new Boolean(true));
            }
            this.myDoc.registerMOFObject(mofClassExtnImpl);
            vector = id.get(Type.ATTRIBUTE, false);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Id id2 = (Id)vector.elementAt(n);
                    this.createMofAttribute(mofClassExtnImpl, string4, id2, id);
                    ++n;
                }
            }
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        return mofClassExtnImpl;
    }

    private PackageExtnImpl createMofPackage(PackageExtnImpl packageExtnImpl, Id id) {
        PackageExtnImpl packageExtnImpl2 = null;
        try {
            String string = id.get(Property.NAME);
            if (string.endsWith("DataTypePackageForModel")) {
                return null;
            }
            RoseToNamespace.debug("------------ Create Mof Package = " + string);
            this.myDoc = new XMIDocumentImpl();
            packageExtnImpl2 = (PackageExtnImpl)this.myDoc.newInstance(MOFConstants.mofPackage);
            PackageTableTargetInfo packageTableTargetInfo = new PackageTableTargetInfo();
            packageTableTargetInfo.pId = id;
            packageTableTargetInfo.doc = this.myDoc;
            packageTableTargetInfo.fullName = RoseToNamespace.getQualifiedName(id);
            packagesToDocuments.put(packageExtnImpl2, packageTableTargetInfo);
            packageExtnImpl2.setID(string);
            if (packageExtnImpl == null) {
                if (fgenSchemasForAllPackages) {
                    packageExtnImpl2.setValue(MOFConstants.mofPackagePackageNameAttr, (Object)(String.valueOf(this.implPackagePrefix.compareTo("") == 0 ? "" : String.valueOf(this.implPackagePrefix) + ".") + packageTableTargetInfo.fullName + ".impl"));
                    packageExtnImpl2.setValue(MOFConstants.mofIPackagePackageNameAttr, (Object)(String.valueOf(this.interfacePackagePrefix.compareTo("") == 0 ? "" : String.valueOf(this.interfacePackagePrefix) + ".") + packageTableTargetInfo.fullName));
                } else {
                    packageExtnImpl2.setValue(MOFConstants.mofPackagePackageNameAttr, (Object)this.mofPackageName);
                    packageExtnImpl2.setValue(MOFConstants.mofIPackagePackageNameAttr, (Object)this.mofIPackageName);
                }
                packageExtnImpl2.setValue(MOFConstants.mofPackagePostfixAttr, (Object)this.mofPostfix);
                packageExtnImpl2.setValue(MOFConstants.mofPackagePrefixAttr, (Object)this.mofPrefix);
                packageExtnImpl2.setValue(MOFConstants.mofIPackagePostfixAttr, (Object)this.mofIPostfix);
                packageExtnImpl2.setValue(MOFConstants.mofIPackagePrefixAttr, (Object)this.mofIPrefix);
                ((XMIDocumentImpl)this.myDoc).createDocumentRoot();
                ((XMIDocumentImpl)this.myDoc).addToContents(packageExtnImpl2);
                ((XMIDocumentImpl)this.myDoc).addStandardImports();
                ((XMIDocumentImpl)this.myDoc).addImport("mof", MOFConstants.mofNS);
            } else {
                packageExtnImpl.addContents(packageExtnImpl2);
            }
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        return packageExtnImpl2;
    }

    private PackageExtnImpl createMofPackage(Id id) {
        return this.createMofPackage(null, id);
    }

    private XMIReferenceImpl createMofRef(String string) {
        return this.createMofRef("", string);
    }

    private XMIReferenceImpl createMofRef(String string, String string2) {
        String string3 = string2;
        XMIReferenceImpl xMIReferenceImpl = null;
        xMIReferenceImpl = (XMIReferenceImpl)((XMIDocumentImpl)this.getDocument()).getFactory().newReference(this.mofClass);
        if (string3 == null) {
            xMIReferenceImpl.setXMIDocument(this.myDoc);
        } else if (this.isMofClass(string2) || string.startsWith("MOF")) {
            int n = string3.indexOf("MOF");
            n = n == -1 ? 0 : 3;
            string3 = String.valueOf(this.mofNamesapceURL) + "#" + string2.substring(n);
            xMIReferenceImpl.setXMIDocument(this.mofClass.getXMIDocument());
        } else {
            if (string.compareTo("") != 0) {
                string3 = "/" + string + ".xmi" + "#" + string2;
                String string4 = string.substring(string.lastIndexOf(47) + 1);
                ((XMIDocumentImpl)this.myDoc).addImport(string4, "/" + string + ".xmi");
            }
            xMIReferenceImpl.setXMIDocument(this.myDoc);
        }
        xMIReferenceImpl.setURL(string3);
        return xMIReferenceImpl;
    }

    private MOFAttributeSetting createMofType(String string) {
        return this.createMofType("", string);
    }

    private MOFAttributeSetting createMofType(String string, String string2) {
        MOFAttributeSetting mOFAttributeSetting = this.getDocument().newAttributeSetting(this.mofType);
        XMIReferenceImpl xMIReferenceImpl = this.createMofRef(string, string2);
        mOFAttributeSetting.setObject(xMIReferenceImpl);
        this.addDeferredAttributeSetting(mOFAttributeSetting);
        return mOFAttributeSetting;
    }

    private void createMomNamespace(Id id) {
        PackageExtnImpl packageExtnImpl = this.processPackageAndClasses(id);
        this.processDeferredAttributeSettings();
    }

    public static IBMXMIDocument createSchema(String string, String string2) {
        String string3 = GenOptions.instance().getGenDir();
        String string4 = GenOptions.instance().getNamespaceName();
        Date date = new Date();
        System.out.println("Begin from Rose to Schema : " + date.toString());
        RoseToNamespace roseToNamespace = new RoseToNamespace(string, string2);
        roseToNamespace.createMomNamespace(roseToNamespace.roseModelId);
        roseToNamespace.serialize(String.valueOf(string3) + File.separator + string4 + ".xmi");
        Date date2 = new Date();
        System.out.println("End from Rose to Schema : " + date2.toString());
        return roseToNamespace.getDocument();
    }

    public static IBMXMIDocument createSchemaAndGenCode(String string, String string2) {
        IBMXMIDocument iBMXMIDocument = RoseToNamespace.createSchema(string, string2);
        if (iBMXMIDocument == null) {
            return null;
        }
        Date date = new Date();
        System.out.println("Begin from Schema to Java : " + date.toString());
        String string3 = GenOptions.instance().getNamespaceName();
        String string4 = GenOptions.instance().getGenDir();
        DocumentToJava documentToJava = new DocumentToJava(iBMXMIDocument);
        documentToJava.setGenDir(string4);
        documentToJava.setSchemaDocument(String.valueOf(string3) + ".xmi");
        documentToJava.generate();
        Date date2 = new Date();
        System.out.println("End from Schema to Java : " + date2.toString());
        return iBMXMIDocument;
    }

    public static IBMXMIDocument createSchemaForPackage(String string, String string2, String string3) {
        String string4 = GenOptions.instance().getGenDir();
        String string5 = GenOptions.instance().getNamespaceName();
        Date date = new Date();
        System.out.println("Begin from Rose to Schema : " + date.toString());
        RoseToNamespace roseToNamespace = new RoseToNamespace(string, string2);
        Id id = roseToNamespace.selectPackage(string3);
        if (id == null) {
            System.out.println("package not found->" + string3);
            return null;
        }
        roseToNamespace.createMomNamespace(id);
        roseToNamespace.serialize(String.valueOf(string4) + File.separator + string5 + ".xmi");
        Date date2 = new Date();
        System.out.println("End from Rose to Schema : " + date2.toString());
        return roseToNamespace.getDocument();
    }

    public static IBMXMIDocument createSchemaForPackageAndGenCode(String string, String string2, String string3) {
        IBMXMIDocument iBMXMIDocument = RoseToNamespace.createSchemaForPackage(string, string2, string3);
        if (iBMXMIDocument == null) {
            return null;
        }
        Date date = new Date();
        System.out.println("Begin from Schema to Java : " + date.toString());
        String string4 = GenOptions.instance().getNamespaceName();
        String string5 = GenOptions.instance().getGenDir();
        DocumentToJava documentToJava = new DocumentToJava(iBMXMIDocument);
        documentToJava.setGenDir(string5);
        documentToJava.setSchemaDocument(String.valueOf(string4) + ".xmi");
        documentToJava.generate();
        Date date2 = new Date();
        System.out.println("End from Schema to Java : " + date2.toString());
        return iBMXMIDocument;
    }

    public static void createSchemasForAllPackages(String string, String string2) {
        Object object;
        String string3 = GenOptions.instance().getGenDir();
        Date date = new Date();
        System.out.println("Begin -- Generate Schemas for all packages in the model  : " + date.toString());
        RoseToNamespace roseToNamespace = new RoseToNamespace(string, string2);
        fgenSchemasForAllPackages = true;
        roseToNamespace.createMomNamespace(roseToNamespace.roseModelId);
        Enumeration enumeration = packagesToDocuments.keys();
        while (enumeration.hasMoreElements()) {
            object = (PackageExtnImpl)enumeration.nextElement();
            PackageTableTargetInfo packageTableTargetInfo = (PackageTableTargetInfo)packagesToDocuments.get(object);
            IBMXMIDocument iBMXMIDocument = packageTableTargetInfo.doc;
            String string4 = packageTableTargetInfo.fullName;
            System.out.println("packageName = " + string4 + " packageId = " + ((RefBaseObjectExtnImpl)object).getID());
            Collection collection = ((NamespaceExtnImpl)object).getContents();
            if (collection.isEmpty()) continue;
            roseToNamespace.setDocument(iBMXMIDocument);
            System.out.println(" ----------- Create Document for Package :  " + string4);
            String string5 = string4.replace('.', '/');
            roseToNamespace.serialize(String.valueOf(string3) + File.separator + string5 + ".xmi");
        }
        object = new Date();
        System.out.println("End  -- Generate Schemas for all packages in the model  : " + ((Date)object).toString());
    }

    public static void debug(String string) {
        if (Debug) {
            System.out.println(string);
        }
    }

    public Hashtable getAllPackages() {
        Hashtable hashtable = new Hashtable();
        if (this.roseModelId != null) {
            this.addPackages(this.roseModelId, hashtable);
        }
        return hashtable;
    }

    public Vector getDeferredAttributeSettings() {
        return this.deferredAttributeSettings;
    }

    public IBMXMIDocument getDocument() {
        return this.myDoc;
    }

    private String[] getEnumValue(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        stringArray2[0] = stringArray[0];
        if (n2 == 1) {
            stringArray2[1] = String.valueOf(n);
        } else if (n2 == 2) {
            stringArray2[1] = stringArray[1];
            if (Integer.parseInt(stringArray[1]) > n + 1) {
                RoseToNamespace.debug("enum value " + string + " !=" + n);
            }
        } else {
            RoseToNamespace.debug("expecting enum format a=b but got " + string);
        }
        return stringArray2;
    }

    private String[] getMultiplicity(String string) {
        Object var2_2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[2];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        stringArray2[0] = stringArray[0];
        if (n == 1) {
            stringArray2[1] = "1..1";
        } else {
            stringTokenizer = new StringTokenizer(stringArray[1], "]");
            n = stringTokenizer.countTokens();
            String[] stringArray3 = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray3[n3] = stringTokenizer.nextToken();
                ++n3;
            }
            stringArray2[1] = n == 0 ? "0..*" : "1.." + stringArray3[0];
        }
        return stringArray2;
    }

    public static String getNamespaceNameForPackage(Id id) {
        String string = RoseToNamespace.getQualifiedName(id);
        String string2 = string.replace('.', '/');
        if (string2.compareTo("DataTypePackageForModel") == 0) {
            return null;
        }
        return string2;
    }

    private String getPackageName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (n > 2) {
            string2 = stringArray[1];
            int n3 = 2;
            while (n3 < n - 1) {
                string2 = String.valueOf(string2) + "." + stringArray[n3];
                ++n3;
            }
        }
        return string2;
    }

    private String getPackageNameFromId(Id id) throws UMLException {
        Id id2 = id;
        String string = id2.get(Property.NAME);
        Vector vector = id2.get(Link.NAMESPACE, false);
        if (vector == null) {
            return null;
        }
        Id id3 = (Id)vector.firstElement();
        String string2 = RoseToNamespace.getNamespaceNameForPackage(id3);
        return string2;
    }

    private String getPackageNameFromId(Id id, Link link) throws UMLException {
        Vector vector = id.get(link, false);
        if (vector != null && vector.size() == 1) {
            Id id2 = (Id)vector.elementAt(0);
            String string = id2.get(Property.NAME);
            Vector vector2 = id2.get(Link.NAMESPACE, false);
            if (vector2 == null) {
                return null;
            }
            Id id3 = (Id)vector2.firstElement();
            String string2 = RoseToNamespace.getNamespaceNameForPackage(id3);
            return string2;
        }
        return null;
    }

    public static String getQualifiedName(Id id) {
        String string = null;
        try {
            string = id.get(Property.NAME);
            Vector vector = id.get(Link.NAMESPACE, false);
            while (vector != null) {
                Id id2 = (Id)vector.firstElement();
                string = String.valueOf(id2.get(Property.NAME)) + "." + string;
                vector = id2.get(Link.NAMESPACE, false);
            }
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        if (string.startsWith(String.valueOf(topLevelPackageName) + ".")) {
            string = string.substring(string.indexOf(46) + 1);
        }
        RoseToNamespace.debug(" Qualified PackageName = " + string);
        return string;
    }

    public static String getQualifiedName_old(Id id) {
        String string = null;
        try {
            Vector vector;
            string = id.get(Property.NAME);
            Id id2 = null;
            while ((vector = id.get(Link.NAMESPACE, false)) != null && (Id)vector.firstElement() != id2) {
                id2 = (Id)vector.firstElement();
                string = String.valueOf(id2.get(Property.NAME)) + "." + string;
            }
        }
        catch (UMLException uMLException) {}
        RoseToNamespace.debug(" Qualified PackageName = " + string);
        return string;
    }

    private String getTypeClassNameFromId(Id id, Link link) throws UMLException {
        Vector vector = id.get(link, false);
        if (vector != null && vector.size() == 1) {
            Id id2 = (Id)vector.elementAt(0);
            String string = id2.get(Property.NAME);
            return string;
        }
        return null;
    }

    private String getTypeNameFromId(Id id, Link link) throws UMLException {
        Vector vector = id.get(link, false);
        if (vector != null && vector.size() == 1) {
            Id id2 = (Id)vector.elementAt(0);
            String string = id2.get(Property.NAME);
            if (string.equalsIgnoreCase("integer") || string.equalsIgnoreCase("int")) {
                return "Integer";
            }
            if (string.equalsIgnoreCase("string")) {
                return "String";
            }
            if (string.equalsIgnoreCase("float")) {
                return "Float";
            }
            if (string.equalsIgnoreCase("boolean")) {
                return "Boolean";
            }
            if (string.equalsIgnoreCase("enumeration")) {
                return "Enumeration";
            }
            return string;
        }
        return null;
    }

    private MOFEnumValue getVisibilityEnum(String string) {
        MOFEnumValue mOFEnumValue = null;
        if (string.compareTo("protected") == 0) {
            mOFEnumValue = new MOFEnumValue(MOFConstants.mofDocument, MOFConstants.mofEnumValue, "PROTECTED", MOFConstants.VK_protected.toInt());
            return mOFEnumValue;
        }
        if (string.compareTo("private") == 0) {
            mOFEnumValue = new MOFEnumValue(MOFConstants.mofDocument, MOFConstants.mofEnumValue, "PRIVATE", MOFConstants.VK_private.toInt());
            return mOFEnumValue;
        }
        mOFEnumValue = new MOFEnumValue(MOFConstants.mofDocument, MOFConstants.mofEnumValue, "PUBLIC", MOFConstants.VK_public.toInt());
        return mOFEnumValue;
    }

    private boolean isMofClass(String string) {
        return string.startsWith("MOF") || string.equals("String") || string.equals("Boolean") || string.equals("boolean") || string.equals("Integer") || string.equals("Float");
    }

    public boolean isTopLevelObject(Id id) throws UMLException {
        return id.get(Link.NAMESPACE, false) == null ? true : id.get(Link.NAMESPACE, false).firstElement() == this.roseModelId;
    }

    private boolean isTypeEnumeration(Id id, Link link) throws UMLException {
        Id id2;
        String string;
        Vector vector = id.get(link, false);
        return vector != null && vector.size() == 1 && (string = (id2 = (Id)vector.elementAt(0)).get("Rose", "stereotype")) != null && string.compareTo("\"enumeration\"") == 0;
    }

    public static void mapPackageToNamespaceName(String string, String string2) {
        packagesToNamespaces.put(string, string2);
    }

    private void processAssociation(PackageExtnImpl packageExtnImpl, Id id, String string) {
        try {
            String string2 = id.get(Property.NAME);
            RoseToNamespace.debug("      Association.." + string2);
            this.createAssociation(packageExtnImpl, string2, id, null);
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
    }

    public void processDeferredAttributeSettings() {
        Enumeration enumeration = this.getDeferredAttributeSettings().elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof MOFAttributeSetting) {
                ((MOFAttributeSetting)e).apply();
                continue;
            }
            ((DeferredAttributeSetting)e).apply();
        }
    }

    private void processEnumTypes(PackageExtnImpl packageExtnImpl, Id id) throws UMLException {
        Object var3_3 = null;
        RoseToNamespace.debug("    Process EnumTypes..");
        Vector vector = id.get(Type.ENUMERATION, false);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Id id2 = (Id)vector.elementAt(n);
                ClassifierExtnImpl classifierExtnImpl = this.createEnumType(id2);
                packageExtnImpl.addContents(classifierExtnImpl);
                ++n;
            }
        }
    }

    private void processInheritance(Id id) {
        try {
            String string = this.getTypeClassNameFromId(id, Link.SUBTYPE);
            String string2 = this.getPackageNameFromId(id, Link.SUBTYPE);
            String string3 = this.getTypeClassNameFromId(id, Link.SUPERTYPE);
            String string4 = this.getPackageNameFromId(id, Link.SUPERTYPE);
            RoseToNamespace.debug("    create Inheritance, subType = " + string + " subTypePackage = " + string2 + " SuperType = " + string3 + " SuperTypePackage = " + string4);
            MofClassExtnImpl mofClassExtnImpl = null;
            try {
                mofClassExtnImpl = this.myDoc.getMOFClass(string);
            }
            catch (XMIClassNotFoundException xMIClassNotFoundException) {
                xMIClassNotFoundException.printStackTrace();
            }
            if (mofClassExtnImpl == null) {
                return;
            }
            if (string3 == null) {
                return;
            }
            TypedElementExtnImpl typedElementExtnImpl = (TypedElementExtnImpl)((MofClassExtnImpl)mofClassExtnImpl.getMetaObject()).getTypedElement(MOFSuperclass);
            MOFAttributeSetting mOFAttributeSetting = this.getDocument().newAttributeSetting(typedElementExtnImpl);
            mOFAttributeSetting.setSubject(mofClassExtnImpl);
            XMIReferenceImpl xMIReferenceImpl = null;
            xMIReferenceImpl = string4.compareTo(string2) != 0 ? this.createMofRef(string4, string3) : this.createMofRef(string3);
            mOFAttributeSetting.setObject(xMIReferenceImpl);
            this.addDeferredAttributeSetting(mOFAttributeSetting);
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
    }

    private PackageExtnImpl processPackageAndClasses(PackageExtnImpl packageExtnImpl, Id id) {
        PackageExtnImpl packageExtnImpl2 = null;
        String string = "null";
        try {
            if (id.get(Link.OWNED_ELEMENT, false) != null) {
                Object object;
                Object object2;
                packageExtnImpl2 = this.createMofPackage(packageExtnImpl, id);
                Vector vector = id.get(Type.PACKAGE, false);
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        object2 = (Id)vector.elementAt(n);
                        this.processPackageAndClasses(null, (Id)object2);
                        ++n;
                    }
                }
                if ((string = id.get(Property.NAME)).endsWith("DataTypePackageForModel")) {
                    return null;
                }
                PackageTableTargetInfo packageTableTargetInfo = (PackageTableTargetInfo)packagesToDocuments.get(packageExtnImpl2);
                this.myDoc = packageTableTargetInfo.doc;
                RoseToNamespace.debug("  ------------  Process Package = " + string);
                RoseToNamespace.debug("       ------------  Process Classes  ----------- ");
                this.processEnumTypes(packageExtnImpl2, id);
                object2 = id.get(Type.CLASS, false);
                if (object2 != null) {
                    int n = 0;
                    while (n < ((Vector)object2).size()) {
                        object = (Id)((Vector)object2).elementAt(n);
                        MofClassExtnImpl mofClassExtnImpl = this.createMofClass((Id)object, string);
                        if (mofClassExtnImpl != null) {
                            this.mofClasses.addElement(mofClassExtnImpl);
                            packageExtnImpl2.addContents(mofClassExtnImpl);
                        }
                        ++n;
                    }
                }
                RoseToNamespace.debug("       ------------  Process Inheritance   ----------- ");
                Vector vector2 = id.get(Type.GENERALIZATION, false);
                if (vector2 != null) {
                    int n = 0;
                    while (n < vector2.size()) {
                        this.processInheritance((Id)vector2.elementAt(n));
                        ++n;
                    }
                }
                RoseToNamespace.debug("       ------------  Process Associations  ----------- ");
                object = id.get(Type.ASSOCIATION, false);
                if (object != null) {
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        Id id2 = (Id)((Vector)object).elementAt(n);
                        this.processAssociation(packageExtnImpl2, id2, string);
                        ++n;
                    }
                }
            }
        }
        catch (UMLException uMLException) {
            uMLException.printStackTrace();
        }
        RoseToNamespace.debug("End of process package " + string);
        return packageExtnImpl2;
    }

    private PackageExtnImpl processPackageAndClasses(Id id) {
        return this.processPackageAndClasses(null, id);
    }

    public static String qualifiedName(String string, String string2) {
        return String.valueOf(string) + "_" + string2;
    }

    public Id selectPackage(String string) {
        return (Id)this.getAllPackages().get(string);
    }

    public void serialize(String string) {
        XMIDOMSerializerImpl xMIDOMSerializerImpl = new XMIDOMSerializerImpl();
        xMIDOMSerializerImpl.setDocument(this.myDoc);
        GenFileUtil.createDirPath(string);
        xMIDOMSerializerImpl.serialize(string);
    }

    private void setAttributeValue(RefObjectExtn refObjectExtn, String string, Object object) {
        MOFAttributeSetting mOFAttributeSetting;
        if (object == null) {
            return;
        }
        AttributeExtnImpl attributeExtnImpl = (AttributeExtnImpl)((MofClassExtnImpl)refObjectExtn.getMetaObject()).getTypedElement(string);
        if (attributeExtnImpl != null) {
            if (attributeExtnImpl.getID().equals(MOFValue) && attributeExtnImpl.getXMIDocument().getDocumentURL().equals(this.mofNamesapceURL)) {
                mOFAttributeSetting = (MOFAttributeSetting)((Object)refObjectExtn);
                mOFAttributeSetting.setObject(object);
            } else {
                mOFAttributeSetting = this.getDocument().newAttributeSetting(attributeExtnImpl);
                mOFAttributeSetting.setSubject(refObjectExtn);
                mOFAttributeSetting.setObject(object);
            }
        } else {
            throw new RuntimeException();
        }
        this.addDeferredAttributeSetting(mOFAttributeSetting);
    }

    public void setDocument(IBMXMIDocument iBMXMIDocument) {
        this.myDoc = iBMXMIDocument;
    }

    public String toString() {
        return this.myDoc.toString();
    }

    class PackageTableTargetInfo {
        String fullName;
        IBMXMIDocument doc;
        Id pId;

        PackageTableTargetInfo() {
        }
    }
}

