/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.testcases;

import com.ibm.mom.differences.MOFDifference;
import com.ibm.mom.differences.MOFXMIDocumentComparer;
import com.ibm.xmi.xmi11temp.XMIDocument;
import com.ibm.xmi.xmi11temp.impl.XMIDOMParser;
import com.ibm.xmi.xmi11temp.impl.XMIDOMSerializerImpl;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentImpl;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentRoot;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import test.framework.AssertionFailedError;
import test.framework.Test;
import test.framework.TestCase;
import test.framework.TestResult;
import test.ui.TestRunner;

public abstract class XMIDOMBaseTests
extends TestCase {
    protected TestResult testResult;
    protected String localXMI4eBAFResourcePath;
    protected static boolean throwFirstDifference = false;
    protected static boolean orderIsImportant = true;

    public XMIDOMBaseTests(String string) {
        super(string);
    }

    protected void assertXMIDocumentNotEmpty(XMIDocument xMIDocument) {
        XMIDocumentImpl xMIDocumentImpl = (XMIDocumentImpl)xMIDocument;
        if (((XMIDocumentRoot)xMIDocumentImpl.getDocumentRoot()).getMOFObjects().isEmpty()) {
            super.assert("A Document is empty!!!", false);
        }
    }

    protected void assertXMIDocumentsEqual(XMIDocument xMIDocument, XMIDocument xMIDocument2) throws AssertionFailedError {
        this.assertXMIDocumentsEqual(xMIDocument, xMIDocument2, throwFirstDifference, orderIsImportant);
    }

    protected void assertXMIDocumentsEqual(XMIDocument xMIDocument, XMIDocument xMIDocument2, boolean bl) throws AssertionFailedError {
        MOFXMIDocumentComparer mOFXMIDocumentComparer = null;
        try {
            try {
                mOFXMIDocumentComparer = MOFXMIDocumentComparer.compare(xMIDocument, xMIDocument2, bl);
                Enumeration enumeration = mOFXMIDocumentComparer.getAllDifferences().elements();
                while (enumeration.hasMoreElements()) {
                    MOFDifference mOFDifference = (MOFDifference)enumeration.nextElement();
                    this.getTestResult().addFailure((Test)this, (Throwable)this.assertionFailureFor(mOFDifference));
                }
            }
            catch (MOFDifference mOFDifference) {
                throw this.assertionFailureFor(mOFDifference);
            }
            Object var6_8 = null;
            if (mOFXMIDocumentComparer != null) {
                mOFXMIDocumentComparer.discard();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (mOFXMIDocumentComparer != null) {
                mOFXMIDocumentComparer.discard();
            }
            throw throwable;
        }
    }

    protected void assertXMIDocumentsEqual(XMIDocument xMIDocument, XMIDocument xMIDocument2, boolean bl, boolean bl2) throws AssertionFailedError {
        MOFXMIDocumentComparer mOFXMIDocumentComparer = null;
        try {
            try {
                mOFXMIDocumentComparer = MOFXMIDocumentComparer.compare(xMIDocument, xMIDocument2, bl, bl2);
                Enumeration enumeration = mOFXMIDocumentComparer.getAllDifferences().elements();
                while (enumeration.hasMoreElements()) {
                    MOFDifference mOFDifference = (MOFDifference)enumeration.nextElement();
                    this.getTestResult().addFailure((Test)this, (Throwable)this.assertionFailureFor(mOFDifference));
                }
            }
            catch (MOFDifference mOFDifference) {
                throw this.assertionFailureFor(mOFDifference);
            }
            Object var7_9 = null;
            if (mOFXMIDocumentComparer != null) {
                mOFXMIDocumentComparer.discard();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (mOFXMIDocumentComparer != null) {
                mOFXMIDocumentComparer.discard();
            }
            throw throwable;
        }
    }

    protected AssertionFailedError assertionFailureFor(MOFDifference mOFDifference) {
        return new AssertionFailedError(mOFDifference.getMessage());
    }

    public String convertToLocalXMI4eBAFPath(String string) {
        return String.valueOf(this.getLocalXMI4eBAFResourcePath()) + string;
    }

    protected void deleteFile(String string) {
        String string2 = string.charAt(0) == '/' ? string.substring(1) : string;
        File file = new File(string2);
        if (file != null) {
            file.delete();
        }
    }

    public String getLocalXMI4eBAFResourcePath() {
        if (this.localXMI4eBAFResourcePath == null) {
            this.initializeLocalXMI4eBAFResourcePath();
        }
        return this.localXMI4eBAFResourcePath;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public static void initializeArguments(String[] stringArray) {
        block9: {
            String string;
            block8: {
                string = "Usage: ATest [-t<throws_first_difference>] [-o<order_is_important>]";
                if (stringArray.length >= 1) break block8;
                System.out.println(string);
                break block9;
            }
            boolean bl = false;
            String string2 = "";
            String string3 = "";
            int n = 0;
            while (n < stringArray.length && !bl) {
                block12: {
                    String string4;
                    block13: {
                        block10: {
                            block11: {
                                string4 = stringArray[n].trim();
                                if (!string4.startsWith("-")) break block10;
                                if (string4.length() < 2) {
                                    System.out.println("Invalid option Specified :" + string4);
                                    bl = true;
                                    break;
                                }
                                if (string4.length() != 2) break block11;
                                string2 = string4;
                                if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
                                    System.out.println("Option value missing for parameter  :" + string4);
                                    bl = true;
                                    break;
                                }
                                break block12;
                            }
                            string2 = string4.substring(0, 2);
                            string3 = string4.substring(2).trim();
                            break block13;
                        }
                        string3 = string4;
                    }
                    if (string2.compareTo("-t") == 0) {
                        throwFirstDifference = Boolean.valueOf(string3);
                    } else if (string2.compareTo("-o") == 0) {
                        orderIsImportant = Boolean.valueOf(string3);
                    } else {
                        System.out.println("Invalid option Specified :" + string4);
                        bl = true;
                        break;
                    }
                    string2 = "";
                    string3 = "";
                }
                ++n;
            }
            if (bl) {
                System.out.println(string);
                System.exit(1);
            }
        }
    }

    private void initializeLocalXMI4eBAFResourcePath() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("java.home");
        int n = string2.length();
        String string3 = string2.substring(0, n - 7);
        stringBuffer.append(string3);
        stringBuffer.append("project_resources");
        stringBuffer.append(string);
        stringBuffer.append("MOFToolkit");
        stringBuffer.append(string);
        this.localXMI4eBAFResourcePath = stringBuffer.toString();
    }

    protected XMIDocument parseXMIFile(String string) {
        XMIDocument xMIDocument = null;
        try {
            xMIDocument = this.parseXMIFileNoErrorCatching(string);
        }
        catch (Exception exception) {
            this.assert("File: " + string + " Failure: " + exception.toString(), false);
        }
        return xMIDocument;
    }

    protected XMIDocument parseXMIFileNoErrorCatching(String string) {
        XMIDOMParser xMIDOMParser = new XMIDOMParser();
        xMIDOMParser.setDebug();
        XMIDocumentImpl xMIDocumentImpl = new XMIDocumentImpl();
        xMIDOMParser.setDocument(xMIDocumentImpl);
        try {
            xMIDOMParser.parseResource(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.assert(fileNotFoundException.toString(), false);
        }
        return xMIDocumentImpl;
    }

    public void run(TestResult testResult) {
        this.setTestResult(testResult);
        super.run(testResult);
    }

    public void serializeXMIDocument(XMIDocument xMIDocument, String string) {
        String string2 = string.charAt(0) == '/' ? string.substring(1) : string;
        XMIDOMSerializerImpl xMIDOMSerializerImpl = new XMIDOMSerializerImpl();
        xMIDOMSerializerImpl.setDocument(xMIDocument);
        xMIDOMSerializerImpl.serialize(string2);
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public static void startUITestRunner(String string) {
        String[] stringArray = new String[]{string};
        TestRunner.main((String[])stringArray);
    }

    protected void tearDown() {
        this.setTestResult(null);
        super.tearDown();
    }
}

