/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ebaf.testcases;

import com.ibm.ebaf.testcases.XMIDOMBaseTests;
import com.ibm.xmi.xmi11temp.XMIDocument;
import test.framework.Test;
import test.framework.TestSuite;

public class XMIDOMSerializingTest
extends XMIDOMBaseTests {
    private String fileName1;
    private String fileName2;
    private String fileName3;
    private String fileName4;
    private String serializedFileName1;
    private String serializedFileName2;
    private String serializedFileName3;
    private String serializedFileName4;
    static /* synthetic */ Class class$com$ibm$ebaf$testcases$XMIDOMSerializingTest;

    public XMIDOMSerializingTest(String string) {
        super(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        XMIDOMBaseTests.initializeArguments(stringArray);
        XMIDOMBaseTests.startUITestRunner("com.ibm.ebaf.testcases.XMIDOMSerializingTest");
    }

    protected void setUp() {
        this.fileName1 = "/com/ibm/ebaf/testcases/better-ACME2c.xmi";
        this.serializedFileName1 = "/com/ibm/ebaf/testcases/xmi_serialize1.out";
        this.fileName2 = "/com/ibm/ebaf/testcases/companyTest.xmi";
        this.serializedFileName2 = "/com/ibm/ebaf/testcases/xmi_serialize2.out";
        this.fileName3 = "/com/ibm/ebaf/testcases/university4.xmi";
        this.serializedFileName3 = "/com/ibm/ebaf/testcases/xmi_serialize3.out";
        this.fileName4 = "/com/ibm/ebaf/testcases/better-ACME2e.xmi";
        this.serializedFileName4 = "/com/ibm/ebaf/testcases/xmi_serialize4.out";
    }

    public static Test suite() {
        return new TestSuite(class$com$ibm$ebaf$testcases$XMIDOMSerializingTest != null ? class$com$ibm$ebaf$testcases$XMIDOMSerializingTest : (class$com$ibm$ebaf$testcases$XMIDOMSerializingTest = XMIDOMSerializingTest.class$("com.ibm.ebaf.testcases.XMIDOMSerializingTest")));
    }

    protected void tearDown() {
        super.tearDown();
        this.deleteFile(this.serializedFileName1);
        this.deleteFile(this.serializedFileName2);
        this.deleteFile(this.serializedFileName3);
        this.deleteFile(this.serializedFileName4);
    }

    public void testDoubleSerializeForMetadata() {
        XMIDocument xMIDocument = this.parseXMIFile(this.fileName2);
        this.assertXMIDocumentNotEmpty(xMIDocument);
        this.serializeXMIDocument(xMIDocument, this.serializedFileName2);
        XMIDocument xMIDocument2 = this.parseXMIFile(this.serializedFileName2);
        this.serializeXMIDocument(xMIDocument2, this.serializedFileName2);
        XMIDocument xMIDocument3 = this.parseXMIFile(this.serializedFileName2);
        this.assertXMIDocumentsEqual(xMIDocument2, xMIDocument3);
    }

    public void testSerializeForExistingFile() {
        XMIDocument xMIDocument = this.parseXMIFile(this.fileName1);
        this.assertXMIDocumentNotEmpty(xMIDocument);
        this.serializeXMIDocument(xMIDocument, this.serializedFileName1);
        XMIDocument xMIDocument2 = this.parseXMIFile(this.serializedFileName1);
        this.assertXMIDocumentsEqual(xMIDocument, xMIDocument2);
    }

    public void testSerializeForExistingMetadata() {
        XMIDocument xMIDocument = this.parseXMIFile(this.fileName2);
        this.assertXMIDocumentNotEmpty(xMIDocument);
        this.serializeXMIDocument(xMIDocument, this.serializedFileName2);
        XMIDocument xMIDocument2 = this.parseXMIFile(this.serializedFileName2);
        this.assertXMIDocumentsEqual(xMIDocument, xMIDocument2);
    }

    public void testSerializeForSharedAggregationFile() {
        XMIDocument xMIDocument = this.parseXMIFile(this.fileName4);
        this.assertXMIDocumentNotEmpty(xMIDocument);
        this.serializeXMIDocument(xMIDocument, this.serializedFileName4);
        XMIDocument xMIDocument2 = this.parseXMIFile(this.serializedFileName4);
        this.assertXMIDocumentsEqual(xMIDocument, xMIDocument2);
    }

    public void testUniversity2() {
        XMIDocument xMIDocument = this.parseXMIFile(this.fileName3);
        this.assertXMIDocumentNotEmpty(xMIDocument);
        this.serializeXMIDocument(xMIDocument, this.serializedFileName3);
        XMIDocument xMIDocument2 = this.parseXMIFile(this.serializedFileName3);
        this.serializeXMIDocument(xMIDocument2, this.serializedFileName3);
        XMIDocument xMIDocument3 = this.parseXMIFile(this.serializedFileName3);
        this.assertXMIDocumentsEqual(xMIDocument2, xMIDocument3);
    }
}

