/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi11temp.impl;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeferredAttributeSerialization {
    Node parentNode;
    String attributeName;
    boolean serialized = false;

    public DeferredAttributeSerialization(String string, Node node) {
        this.attributeName = string;
        this.parentNode = node;
    }

    public boolean mustSerializeAsNode() {
        return this.parentNode.hasChildNodes() || ((Element)this.parentNode).getAttributeNode(this.attributeName) != null;
    }

    public void serializeAsAttribute(String string) {
        if (this.serialized) {
            throw new RuntimeException();
        }
        Element element = (Element)this.parentNode;
        Attr attr = element.getAttributeNode("xmi:uuid");
        if (attr != null) {
            element.removeAttributeNode(attr);
        }
        element.setAttribute(this.attributeName, string);
        if (attr != null) {
            element.setAttributeNode(attr);
        }
        this.serialized = true;
    }

    public Node serializeAsNode() {
        if (this.serialized) {
            throw new RuntimeException();
        }
        Element element = null;
        Node node = ((Element)this.parentNode).getLastChild();
        if (node != null && this.attributeName.equals(node.getNodeName())) {
            element = (Element)node;
        }
        if (element == null) {
            Document document = this.parentNode.getOwnerDocument();
            element = document.createElement(this.attributeName);
            this.parentNode.appendChild(element);
        }
        this.serialized = true;
        return element;
    }
}

