/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi11temp.impl;

import com.ibm.mof.mof13.ref.extn.impl.RefObjectExtnImpl;
import com.ibm.xmi.xmi11temp.XMIDocument;
import com.ibm.xmi.xmi11temp.XMISerializer;
import com.ibm.xmi.xmi11temp.impl.DeferredAttributeSerialization;
import com.ibm.xmi.xmi11temp.impl.RootSerialization;
import com.ibm.xml.parser.TXDocument;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMIDOMSerializerImpl
implements XMISerializer {
    protected XMIDocument xmiDocument = null;
    protected TXDocument domDocument;
    protected Vector serializedObjects = new Vector();
    protected Vector deferredObjects = new Vector();
    protected int namespaceCount = 0;
    private final String ENCODING = "UTF-8";
    private static final String XMI_CONTENT = "xmi:Content";

    public XMIDOMSerializerImpl() {
    }

    public XMIDOMSerializerImpl(XMIDocument xMIDocument) {
        this.setDocument(xMIDocument);
    }

    protected void addDeferredObject(Object object) {
        if (!this.serializedObjects.contains(object) && !this.deferredObjects.contains(object)) {
            this.deferredObjects.addElement(object);
        }
    }

    public TXDocument createDOM(XMIDocument xMIDocument) {
        Object object;
        this.domDocument = new TXDocument();
        this.serializeXMIHeader(this.domDocument);
        xMIDocument.serializeDocument(this, new RootSerialization("documentRoot", (Node)this.domDocument));
        Node node = null;
        Element element = this.domDocument.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = (Element)nodeList.item(n);
            if (object.getNodeName() == "Content") {
                node = object;
                break;
            }
            ++n;
        }
        while (this.deferredObjects.size() > 0) {
            object = new DeferredAttributeSerialization("Content", node.getParentNode());
            RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)this.deferredObjects.firstElement();
            xMIDocument.serializeDeferredObject(refObjectExtnImpl, this, object);
        }
        return this.domDocument;
    }

    public TXDocument getDOMDocument() {
        return this.domDocument;
    }

    public XMIDocument getXMIDocument() {
        return this.xmiDocument;
    }

    public void markObjectSerialized(Object object) {
        if (this.deferredObjects.contains(object)) {
            this.deferredObjects.removeElement(object);
        }
        this.serializedObjects.addElement(object);
    }

    public String newNamespaceName() {
        return "ns" + String.valueOf(++this.namespaceCount);
    }

    public String serialize() {
        try {
            StringWriter stringWriter = new StringWriter();
            TXDocument tXDocument = this.createDOM(this.xmiDocument);
            tXDocument.printWithFormat((Writer)stringWriter);
            return stringWriter.getBuffer().toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void serialize(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            TXDocument tXDocument = this.createDOM(this.xmiDocument);
            tXDocument.printWithFormat((Writer)fileWriter);
        }
        catch (IOException iOException) {}
    }

    public Object serializeAttribute(String string, Object object) {
        return new DeferredAttributeSerialization(string, (Element)object);
    }

    public Object serializeObject(Object object, String string, String string2, String string3, Object object2) {
        DeferredAttributeSerialization deferredAttributeSerialization = (DeferredAttributeSerialization)object2;
        Node node = deferredAttributeSerialization.serializeAsNode();
        this.markObjectSerialized(object);
        Element element = this.getDOMDocument().createElement(string);
        node.appendChild(element);
        if (string2 != null) {
            element.setAttribute("xmi:id", string2);
        }
        if (string3 != null) {
            element.setAttribute("xmi:uuid", string3);
        }
        this.markObjectSerialized(object);
        return element;
    }

    public void serializeString(String string, Object object) {
        DeferredAttributeSerialization deferredAttributeSerialization = (DeferredAttributeSerialization)object;
        deferredAttributeSerialization.serializeAsAttribute(string);
    }

    public Node serializeXMIHeader(TXDocument tXDocument) {
        tXDocument.setVersion("1.0");
        tXDocument.setEncoding("UTF-8");
        return tXDocument;
    }

    public Object serializeXMIReference(Object object, String string, String string2, Object object2, boolean bl) {
        DeferredAttributeSerialization deferredAttributeSerialization = (DeferredAttributeSerialization)object2;
        if (bl || deferredAttributeSerialization.mustSerializeAsNode()) {
            Node node = deferredAttributeSerialization.serializeAsNode();
            Element element = node.getOwnerDocument().createElement(string);
            node.appendChild(element);
            if (string2.startsWith("#")) {
                if (object != null) {
                    this.addDeferredObject(object);
                }
                element.setAttribute("xmi:idRef", string2.substring(1, string2.length()));
            } else {
                element.setAttribute("xmi:href", string2);
            }
            return element;
        }
        if (string2.startsWith("#") && object != null) {
            this.addDeferredObject(object);
        }
        deferredAttributeSerialization.serializeAsAttribute(string2);
        return null;
    }

    public void setDocument(XMIDocument xMIDocument) {
        this.xmiDocument = xMIDocument;
    }
}

