/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi11temp.impl;

import com.ibm.mof.mof13.Classifier;
import com.ibm.mof.mof13.FactoryRegister;
import com.ibm.mof.mof13.MofClass;
import com.ibm.mof.mof13.XMIReference;
import com.ibm.mof.mof13.extn.IAbstractAdaptor;
import com.ibm.mof.mof13.extn.IAdaptable;
import com.ibm.mof.mof13.extn.IAdaptorFactory;
import com.ibm.mof.mof13.extn.MofClassExtn;
import com.ibm.mof.mof13.extn.TypedElementExtn;
import com.ibm.mof.mof13.extn.impl.ClassifierExtnImpl;
import com.ibm.mof.mof13.extn.impl.FactoryExtnImpl;
import com.ibm.mof.mof13.extn.impl.MOFAdaptorFactory;
import com.ibm.mof.mof13.extn.impl.MOFAttributeSetting;
import com.ibm.mof.mof13.extn.impl.MOFConstants;
import com.ibm.mof.mof13.extn.impl.MofClassExtnImpl;
import com.ibm.mof.mof13.extn.impl.XMIReferenceImpl;
import com.ibm.mof.mof13.ref.RefObject;
import com.ibm.mof.mof13.ref.extn.RefObjectExtn;
import com.ibm.mof.mof13.ref.extn.impl.RefObjectExtnImpl;
import com.ibm.xmi.xmi11temp.IBMDocumentImport;
import com.ibm.xmi.xmi11temp.IBMXMIDocument;
import com.ibm.xmi.xmi11temp.IBMXMIDocumentRoot;
import com.ibm.xmi.xmi11temp.XMIDocument;
import com.ibm.xmi.xmi11temp.XMISerializer;
import com.ibm.xmi.xmi11temp.impl.URIParser;
import com.ibm.xmi.xmi11temp.impl.URL;
import com.ibm.xmi.xmi11temp.impl.XMIAttributeNotFoundException;
import com.ibm.xmi.xmi11temp.impl.XMIClassNotFoundException;
import com.ibm.xmi.xmi11temp.impl.XMIConstants;
import com.ibm.xmi.xmi11temp.impl.XMIDOMSerializerImpl;
import com.ibm.xmi.xmi11temp.impl.XMIDocumentRoot;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMIDocumentImpl
implements IBMXMIDocument {
    public static final String DefaultDocumentURL = "?defaultDocumentURL?";
    static final String defaultNamespaceName = "";
    static Hashtable xmiDocuments = new Hashtable();
    protected XMIDocumentRoot documentRoot = null;
    protected String documentURL = null;
    protected FactoryExtnImpl factory = new FactoryExtnImpl();
    protected IAdaptorFactory[] adaptorFactories = new MOFAdaptorFactory[0];
    static IAdaptorFactory[] defaultAdaptorFactories = new MOFAdaptorFactory[0];
    Hashtable mofObjects = new Hashtable();

    public XMIDocumentImpl() {
        MOFConstants.initializeNamespaces();
    }

    public XMIDocumentImpl(String string) {
        this.documentURL = string;
        MOFConstants.initializeNamespaces();
    }

    public void addAdaptorFactory(IAdaptorFactory iAdaptorFactory) {
        int n = this.adaptorFactories.length;
        IAdaptorFactory[] iAdaptorFactoryArray = new IAdaptorFactory[n + 1];
        System.arraycopy(this.adaptorFactories, 0, iAdaptorFactoryArray, 0, n);
        this.adaptorFactories = iAdaptorFactoryArray;
        this.adaptorFactories[n] = iAdaptorFactory;
    }

    public static void addDefaultAdaptorFactory(IAdaptorFactory iAdaptorFactory) {
        int n = defaultAdaptorFactories.length;
        IAdaptorFactory[] iAdaptorFactoryArray = new IAdaptorFactory[n + 1];
        System.arraycopy(defaultAdaptorFactories, 0, iAdaptorFactoryArray, 0, n);
        defaultAdaptorFactories = iAdaptorFactoryArray;
        XMIDocumentImpl.defaultAdaptorFactories[n] = iAdaptorFactory;
    }

    public RefObjectExtnImpl addImport(MOFAttributeSetting mOFAttributeSetting) {
        MOFAttributeSetting mOFAttributeSetting2 = mOFAttributeSetting;
        URL uRL = new URL(((RefObjectExtnImpl)((Object)mOFAttributeSetting2.getMetaObject())).getID());
        String string = uRL.ID.length() > 5 ? uRL.ID.substring(6) : defaultNamespaceName;
        return this.addImport(string, (String)mOFAttributeSetting2.getObject());
    }

    public RefObjectExtnImpl addImport(String string, String string2) {
        RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)XMIConstants.xmiDocumentImport.refCreateInstance(null);
        refObjectExtnImpl.setXMIDocument(this);
        refObjectExtnImpl.setValue(XMIConstants.xmiImportAliasAttr, (Object)string);
        XMIReference xMIReference = MOFConstants.mofPackage.newReference();
        ((RefObjectExtnImpl)((Object)xMIReference)).setXMIDocument(this.documentRoot.getXMIDocument());
        xMIReference.setURL(string2);
        refObjectExtnImpl.setValue(XMIConstants.xmiImportedDocumentRole, (Object)xMIReference);
        this.documentRoot.setValue(XMIConstants.xmiDocumentImportsRole, (Object)refObjectExtnImpl);
        return refObjectExtnImpl;
    }

    public RefObjectExtnImpl[] addStandardImports() {
        RefObjectExtnImpl[] refObjectExtnImplArray = new RefObjectExtnImpl[3];
        refObjectExtnImplArray[0] = this.addImport("xmi", "/schemas/xmi.dtd");
        refObjectExtnImplArray[1] = this.addImport("mof", MOFConstants.mofNS);
        return refObjectExtnImplArray;
    }

    public void addToContents(Object object) {
        this.documentRoot.setValue(XMIConstants.xmiDocumentContents, object);
    }

    public void createDocumentRoot() {
        if (this.documentRoot != null) {
            throw new RuntimeException();
        }
        this.newInstance(XMIConstants.xmiXMI);
    }

    public RefObjectExtnImpl get(URL uRL) {
        return this.get(uRL.namespaceName, uRL.ID);
    }

    public RefObjectExtnImpl get(String string, String string2) {
        XMIDocumentImpl xMIDocumentImpl;
        if (!MOFConstants.initializedNamespaces) {
            MOFConstants.initializeNamespaces();
        }
        if ((xMIDocumentImpl = (XMIDocumentImpl)XMIDocumentImpl.getDocument(string, this)) == null) {
            return null;
        }
        return xMIDocumentImpl.getObject(string2);
    }

    public MofClassExtnImpl getClass(URL uRL) {
        return (MofClassExtnImpl)this.get(uRL.namespaceName, uRL.ID);
    }

    public MofClassExtnImpl getClass(String string, String string2) {
        return (MofClassExtnImpl)this.get(string, string2);
    }

    public static XMIDocument getDocument(String string) {
        return XMIDocumentImpl.getDocument(string, null);
    }

    public static XMIDocument getDocument(String string, XMIDocument xMIDocument) {
        XMIDocument xMIDocument2 = (XMIDocument)xmiDocuments.get(string.toLowerCase());
        if (xMIDocument2 == null) {
            if (string.equals(DefaultDocumentURL)) {
                xMIDocument2 = new XMIDocumentImpl(DefaultDocumentURL);
                xmiDocuments.put(DefaultDocumentURL, xMIDocument2);
            } else {
                xMIDocument2 = XMIDocumentImpl.parseDocument(string, xMIDocument);
                if (xMIDocument2 == null) {
                    return null;
                }
            }
        }
        return xMIDocument2;
    }

    public Object getDocumentRoot() {
        return this.documentRoot;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public FactoryExtnImpl getFactory() {
        return this.factory;
    }

    public MofClassExtnImpl getMOFClass(String string) throws XMIClassNotFoundException {
        try {
            return (MofClassExtnImpl)this.getMOFObject(string);
        }
        catch (Exception exception) {
            System.out.println("?????????????????");
            System.out.println(exception);
            throw new XMIClassNotFoundException();
        }
    }

    public RefObjectExtn getMOFObject(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = new URL(string);
        RefObjectExtnImpl refObjectExtnImpl = uRL.namespaceName.equals(defaultNamespaceName) || uRL.namespaceName == DefaultDocumentURL ? this.getObject(uRL.ID) : this.get(uRL);
        if (uRL.getAttributeNames() != null) {
            Enumeration enumeration = uRL.getAttributeNames().elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                TypedElementExtn typedElementExtn = ((MofClassExtn)refObjectExtnImpl.getMetaObject()).getTypedElement(string2);
                if (typedElementExtn == null) {
                    throw new RuntimeException();
                }
                refObjectExtnImpl = (RefObjectExtnImpl)refObjectExtnImpl.getValue(typedElementExtn);
            }
        }
        return refObjectExtnImpl;
    }

    public String getNamespaceName(String string) {
        Enumeration enumeration = ((IBMXMIDocumentRoot)this.getDocumentRoot()).getImports().elements();
        if (string != null) {
            while (enumeration.hasMoreElements()) {
                IBMDocumentImport iBMDocumentImport = (IBMDocumentImport)enumeration.nextElement();
                if (!iBMDocumentImport.getDocumentURL().toUpperCase().equals(string.toUpperCase())) continue;
                return iBMDocumentImport.getDocumentAlias();
            }
        }
        return defaultNamespaceName;
    }

    public RefObjectExtnImpl getObject(Object object) {
        return (RefObjectExtnImpl)this.mofObjects.get(object);
    }

    public TypedElementExtn getStructuralFeature(MofClass mofClass, String string) {
        return ((MofClassExtn)mofClass).getTypedElement(string);
    }

    public XMIDocument getXMIDocument(Object object) {
        return ((RefObjectExtnImpl)object).getXMIDocument();
    }

    public String getXMIID(Object object) {
        return ((RefObjectExtnImpl)object).getID();
    }

    public String getXMITag(Classifier classifier, XMISerializer xMISerializer) {
        return this.getXMITag((ClassifierExtnImpl)classifier, xMISerializer);
    }

    public String getXMITag(ClassifierExtnImpl classifierExtnImpl, XMISerializer xMISerializer) {
        String string;
        String string2;
        XMIDocument xMIDocument = classifierExtnImpl.getXMIDocument();
        XMIDocumentImpl xMIDocumentImpl = (XMIDocumentImpl)xMISerializer.getXMIDocument();
        String string3 = xMIDocumentImpl.getNamespaceName(string2 = xMIDocument.getDocumentURL());
        if (string3.length() == 0) {
            string = this.getNamespaceName(string2);
            xMIDocumentImpl.addImport(string, string2);
        } else {
            string = string3;
        }
        return string.length() > 0 ? String.valueOf(string) + ":" + classifierExtnImpl.getID() : classifierExtnImpl.getID();
    }

    public void initializeObject(Object object) {
        ((RefObjectExtnImpl)object).initializeAfterLoad();
    }

    public boolean isTransient() {
        return this.documentURL == null;
    }

    public IAbstractAdaptor newAdaptor(Object object, IAdaptable iAdaptable) {
        int n = 0;
        while (n < this.adaptorFactories.length) {
            if (this.adaptorFactories[n].isFactoryForType(object)) {
                return this.adaptorFactories[n].adapt(iAdaptable);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < defaultAdaptorFactories.length) {
            if (defaultAdaptorFactories[n2].isFactoryForType(object)) {
                return defaultAdaptorFactories[n2].adapt(iAdaptable);
            }
            ++n2;
        }
        return null;
    }

    public MOFAttributeSetting newAttributeSetting(RefObject refObject) {
        MOFAttributeSetting mOFAttributeSetting = this.getFactory().newAttributeSetting(refObject);
        mOFAttributeSetting.setXMIDocument(this);
        return mOFAttributeSetting;
    }

    public Object newAttributeSetting(Object object, TypedElementExtn typedElementExtn, Object object2) {
        RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)object;
        MOFAttributeSetting mOFAttributeSetting = this.newAttributeSetting(typedElementExtn);
        mOFAttributeSetting.setSubject(refObjectExtnImpl);
        Object object3 = object2 instanceof String ? mOFAttributeSetting.parseObjectFromString((String)object2, this) : object2;
        mOFAttributeSetting.setObject(object3);
        mOFAttributeSetting.setXMIDocument(this);
        return mOFAttributeSetting;
    }

    public Object newAttributeSetting(Object object, String string, Object object2) throws XMIAttributeNotFoundException {
        TypedElementExtn typedElementExtn;
        RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)object;
        try {
            typedElementExtn = this.getStructuralFeature((MofClass)refObjectExtnImpl.getMetaObject(), string);
        }
        catch (Exception exception) {
            throw new XMIAttributeNotFoundException(string);
        }
        return this.newAttributeSetting(object, typedElementExtn, object2);
    }

    public RefObjectExtnImpl newInstance(MofClassExtn mofClassExtn) {
        return (RefObjectExtnImpl)this.newInstance(mofClassExtn, null, null);
    }

    public Object newInstance(MofClassExtn mofClassExtn, String string, String string2) {
        Collection collection = FactoryRegister.getFactory().createCollection();
        collection.add(mofClassExtn);
        RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)this.getFactory().refCreateInstance(collection);
        refObjectExtnImpl.setXMIDocument(this);
        if (string != null) {
            refObjectExtnImpl.setID(string);
        }
        if (string2 == null) {
            if (this.getFactory().doGenerateUUID()) {
                refObjectExtnImpl.generateUUID();
            }
        } else {
            refObjectExtnImpl.setUUID(string2);
        }
        if (this.documentRoot == null && mofClassExtn == XMIConstants.xmiXMI) {
            this.documentRoot = (XMIDocumentRoot)refObjectExtnImpl;
        }
        return refObjectExtnImpl;
    }

    public Object newInstance(String string, String string2, String string3) throws XMIClassNotFoundException {
        MofClassExtnImpl mofClassExtnImpl;
        try {
            mofClassExtnImpl = this.getMOFClass(string);
        }
        catch (Exception exception) {
            throw new XMIClassNotFoundException(string);
        }
        return this.newInstance(mofClassExtnImpl, string2, string3);
    }

    public Object newReference(MofClassExtnImpl mofClassExtnImpl, String string) {
        XMIReferenceImpl xMIReferenceImpl = (XMIReferenceImpl)this.getFactory().newReference(mofClassExtnImpl);
        xMIReferenceImpl.setXMIDocument(this);
        xMIReferenceImpl.setURL(string);
        return xMIReferenceImpl;
    }

    public Object newReference(String string, String string2) throws XMIClassNotFoundException {
        MofClassExtnImpl mofClassExtnImpl;
        try {
            mofClassExtnImpl = this.getMOFClass(string);
        }
        catch (Exception exception) {
            throw new XMIClassNotFoundException(string2);
        }
        return this.newReference(mofClassExtnImpl, string2);
    }

    public static XMIDocument parseDocument(String string) {
        return XMIDocumentImpl.parseDocument(string, null);
    }

    public static XMIDocument parseDocument(String string, XMIDocument xMIDocument) {
        XMIDocument xMIDocument2 = URIParser.parseDocument(string, xMIDocument);
        if (xMIDocument2 != null) {
            xmiDocuments.put(xMIDocument2.getDocumentURL().toLowerCase(), xMIDocument2);
        }
        return xMIDocument2;
    }

    public static void putDocument(String string, XMIDocument xMIDocument) {
        xmiDocuments.put(string.toLowerCase(), xMIDocument);
    }

    public void putMOFObject(String string, RefObjectExtn refObjectExtn) {
        this.mofObjects.put(string, refObjectExtn);
    }

    public void register(String string, RefObjectExtn refObjectExtn) {
        if (string != null) {
            this.putMOFObject(string, refObjectExtn);
        }
    }

    public void registerMOFObject(RefObjectExtn refObjectExtn) {
        refObjectExtn.setXMIDocument(this);
        this.register(refObjectExtn.getID(), refObjectExtn);
        this.register(refObjectExtn.getUUID(), refObjectExtn);
    }

    public void removeMOFObject(String string) {
        this.mofObjects.remove(string);
    }

    public void save() throws IOException {
        String string = this.documentURL.charAt(0) == '/' ? this.documentURL.substring(1) : this.documentURL;
        FileWriter fileWriter = new FileWriter(string);
        XMIDOMSerializerImpl xMIDOMSerializerImpl = new XMIDOMSerializerImpl();
        xMIDOMSerializerImpl.setDocument(this);
        xMIDOMSerializerImpl.serialize(string);
    }

    public void serializeDeferredObject(Object object, XMISerializer xMISerializer, Object object2) {
        ((RefObjectExtnImpl)object).serializeAsObject(xMISerializer, object2);
    }

    public void serializeDocument(XMISerializer xMISerializer, Object object) {
        ((RefObjectExtnImpl)this.getDocumentRoot()).serializeAsObject(xMISerializer, object);
    }

    public void setAttributeValue(Object object, Object object2) {
        RefObjectExtnImpl refObjectExtnImpl = (RefObjectExtnImpl)object;
        refObjectExtnImpl.apply((MOFAttributeSetting)object2);
    }

    public void setDocumentURL(String string) {
        this.documentURL = string;
    }

    public void setFactory(FactoryExtnImpl factoryExtnImpl) {
        this.factory = factoryExtnImpl;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + (this.getDocumentURL() == null ? defaultNamespaceName : this.getDocumentURL()) + ")";
    }

    public void unregister(String string) {
        if (string != null) {
            this.removeMOFObject(string);
        }
    }
}

