/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.sketch.sqc;

import com.ibm.sketch.util.ArgumentException;
import com.ibm.sketch.util.CommandLineApplication;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.xml.ecm.schema.ProgressMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class SQCAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    public static final Plugin plugin = Platform.getPlugin((String)"com.ibm.etools.sketch.sqc");
    public static final String SQC_PROBLEM_MARKER = "org.eclipse.core.resources.problemmarker";
    public static final boolean DEBUG = false;
    public static URL styleSheetURL;
    public static final String ERROR_REPORT_SUFFIX = ".err.xml";
    public static final String WARNING_REPORT_SUFFIX = ".warn.xml";
    public static final String NO_ERROR_REPORT_SUFFIX = ".clean.xml";
    public static final String SCHEMA_ANALYSIS_DIR_NAME = "SchemaAnalysis";
    public static final String REVALIDATION_ACTION_ID = "com.ibm.etools.sketch.sqc.SQCRevalidation";
    public static final String SQC_EXTENSION_POINT = "com.ibm.etools.sketch.sqc.fileExtension";
    protected IStructuredSelection currentSeclection;
    protected IWorkbenchPart workbenchPart;
    private static HashMap fileExtension_options;
    private Vector warnings = new Vector();
    private Vector errors = new Vector();
    private boolean errorFound = false;
    private int numberOfProblems = 0;
    private StringBuffer filesWithProblems = null;
    private int numberOfFilesWithProblems = 0;
    private File commonDirOfInputFiles;
    private boolean inputFilesUnderTheSameDir = true;

    private static HashMap getFileExtensionMap() {
        if (fileExtension_options != null) {
            return fileExtension_options;
        }
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] iConfigurationElementArray = iPluginRegistry.getConfigurationElementsFor(SQC_EXTENSION_POINT);
        fileExtension_options = new HashMap();
        if (iConfigurationElementArray == null) {
            return fileExtension_options;
        }
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string2 = iConfigurationElement.getAttribute("fileExtension");
            if (string2 != null && (string = iConfigurationElement.getAttribute("options")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                Vector<String> vector = (Vector<String>)fileExtension_options.get(string2);
                if (vector == null) {
                    vector = new Vector<String>();
                    fileExtension_options.put(string2, vector);
                }
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            ++n;
        }
        return fileExtension_options;
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.workbenchPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        int n;
        Object object;
        this.warnings.clear();
        this.errors.clear();
        this.numberOfProblems = 0;
        this.filesWithProblems = new StringBuffer();
        this.errorFound = false;
        Shell shell = this.workbenchPart.getSite().getShell();
        if (styleSheetURL == null) {
            try {
                styleSheetURL = new URL(Platform.resolve((URL)plugin.getDescriptor().getInstallURL()), "SimpleErrorReport.xsl");
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("stylesheet not found due to the following error :\n " + exception.getMessage()));
            }
        }
        try {
            object = this;
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            StringWriter stringWriter = new StringWriter();
            invocationTargetException.printStackTrace(new PrintWriter(stringWriter));
            throw new RuntimeException(stringWriter.getBuffer().toString());
        }
        catch (InterruptedException interruptedException) {
            StringWriter stringWriter = new StringWriter();
            interruptedException.printStackTrace(new PrintWriter(stringWriter));
            throw new RuntimeException(stringWriter.getBuffer().toString());
        }
        if (this.errors.size() > 0) {
            if (this.warnings.size() > 0) {
                object = new StringBuffer();
                n = 0;
                while (n < this.errors.size()) {
                    ((StringBuffer)object).append("\n" + this.errors.get(n).toString());
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.warnings.size()) {
                    ((StringBuffer)object).append("\n" + this.errors.get(n2).toString());
                    ++n2;
                }
                boolean bl = this.warnings.size() > 1;
                MessageDialog.openError((Shell)shell, (String)"Errors", (String)(this.warnings.size() + this.errors.size() + " problem" + (bl ? "s" : "") + " found. " + object));
            } else {
                object = new StringBuffer();
                n = this.errors.size() > 1 ? 1 : 0;
                int n3 = 0;
                while (n3 < this.errors.size()) {
                    ((StringBuffer)object).append("\n" + this.errors.get(n3).toString());
                    ++n3;
                }
                MessageDialog.openError((Shell)shell, (String)"Errors", (String)(this.errors.size() + " error" + (n != 0 ? "s" : "") + " found. " + object));
            }
        }
        if (this.numberOfProblems == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"Valid Schema(s)", (String)"No problem found");
        } else {
            boolean bl = this.numberOfProblems > 1;
            int n4 = n = this.numberOfFilesWithProblems > 1 ? 1 : 0;
            if (!this.errorFound) {
                MessageDialog.openWarning((Shell)shell, (String)"Warnings ", (String)(this.numberOfProblems + " warning" + (bl ? "s" : "") + " found. Please look at the following file" + (n != 0 ? "s" : "") + " : \n" + this.filesWithProblems));
            } else {
                MessageDialog.openError((Shell)shell, (String)"Errors", (String)(this.numberOfProblems + " problem" + (bl ? "s" : "") + " found. Please look at the following file" + (n != 0 ? "s" : "") + " : \n" + this.filesWithProblems));
            }
        }
    }

    public void run(IProgressMonitor iProgressMonitor) {
        File[] fileArray;
        Serializable serializable;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Vector<File> vector2 = new Vector<File>();
        Iterator iterator = this.currentSeclection.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof IFile)) continue;
            object = (IFile)object2;
            if (this.inputFilesUnderTheSameDir) {
                serializable = object.getLocation().toFile();
                fileArray = ((File)serializable).getParentFile();
                if (this.commonDirOfInputFiles == null) {
                    if (fileArray != null) {
                        this.commonDirOfInputFiles = fileArray;
                    } else {
                        this.inputFilesUnderTheSameDir = false;
                    }
                } else if (!this.commonDirOfInputFiles.equals(fileArray)) {
                    this.inputFilesUnderTheSameDir = false;
                }
            }
            vector2.add(object.getLocation().toFile());
        }
        object2 = new SQCProgressMonitor(iProgressMonitor);
        object = new HashMap();
        serializable = new HashMap();
        if (vector2.size() > 0) {
            fileArray = new File[vector2.size()];
            fileArray = vector2.toArray(fileArray);
            try {
                int n = SchemaQualityChecker.getTotalWork(fileArray, (Map)object, (Map)((Object)serializable));
                object2.beginTask("Validating schema document 1 of " + fileArray.length, n);
            }
            catch (Exception exception) {
                object2.beginTask("Validating schema document 1 of " + fileArray.length, 100);
                object2.done();
                object2 = null;
            }
        }
        int n = 0;
        try {
            try {
                Iterator iterator2 = this.currentSeclection.iterator();
                while (iterator2.hasNext()) {
                    Object object3;
                    Node node;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    File file;
                    Object object9;
                    IFile iFile;
                    block62: {
                        Object object10;
                        if (object2 != null && object2.isCanceled()) break;
                        Object e = iterator2.next();
                        if (!(e instanceof IFile)) continue;
                        iFile = (IFile)e;
                        if (++n > 1 && object2 != null) {
                            object2.setTaskName("Validating schema document " + n + " of " + vector2.size());
                        }
                        if (iFile.toString().endsWith(ERROR_REPORT_SUFFIX) || iFile.toString().endsWith(WARNING_REPORT_SUFFIX) || iFile.toString().endsWith(NO_ERROR_REPORT_SUFFIX)) {
                            object9 = iFile.toString().endsWith(ERROR_REPORT_SUFFIX) ? ERROR_REPORT_SUFFIX : (iFile.toString().endsWith(WARNING_REPORT_SUFFIX) ? WARNING_REPORT_SUFFIX : NO_ERROR_REPORT_SUFFIX);
                            object10 = iFile.getLocation().toFile();
                            file = ((File)object10).getParentFile();
                            if (new String(SCHEMA_ANALYSIS_DIR_NAME).equals(file.getName()) && file.getParentFile() != null) {
                                file = file.getParentFile();
                                object8 = ((File)object10).getName();
                                int n2 = ((String)object8).indexOf((String)object9);
                                if (n2 != -1) {
                                    object8 = ((String)object8).substring(0, n2);
                                    object10 = new File(file, (String)object8);
                                    object7 = iFile;
                                    iFile = iWorkspaceRoot.getFileForLocation((IPath)new Path(((File)object10).toString()));
                                    if (iFile == null) {
                                        this.errors.add("Input file not found :" + object10);
                                        continue;
                                    }
                                    try {
                                        object7.getLocation().toFile().delete();
                                        object7.getParent().refreshLocal(1, null);
                                    }
                                    catch (Exception exception) {
                                        plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, exception.getMessage(), (Throwable)exception));
                                        this.errors.add("error while deleting " + object7 + " (see log for more details):" + exception.getMessage());
                                        continue;
                                    }
                                }
                            } else {
                                this.errors.add("A schema analysis file must be under the SchemaAnalysis directory generated by SQC plugin.Invaid schema analysis : " + iFile);
                                continue;
                            }
                        }
                        object9 = iFile.getLocation().toFile();
                        object10 = ((File)object9).getParent();
                        file = new File(((File)object9).getParentFile(), SCHEMA_ANALYSIS_DIR_NAME);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        object8 = new File(file, ((File)object9).getName() + ERROR_REPORT_SUFFIX);
                        try {
                            object6 = iWorkspaceRoot.getFileForLocation((IPath)new Path(new File(file, ((File)object9).getName() + NO_ERROR_REPORT_SUFFIX).toString()));
                            if (object6 != null) {
                                object6.getParent().refreshLocal(1, null);
                                object6.delete(true, null);
                            }
                            if ((object6 = iWorkspaceRoot.getFileForLocation((IPath)new Path(new File(file, ((File)object9).getName() + WARNING_REPORT_SUFFIX).toString()))) == null) break block62;
                            object6.getParent().refreshLocal(1, null);
                            object6.delete(true, null);
                        }
                        catch (CoreException coreException) {
                            plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, coreException.getMessage(), (Throwable)coreException));
                            this.errors.add("error while deleting files. See log for more details.");
                            continue;
                        }
                    }
                    object6 = new SchemaQualityChecker();
                    if (object2 != null) {
                        ((SchemaQualityChecker)object6).setProgressMonitor((ProgressMonitor)object2);
                    }
                    ((SchemaQualityChecker)object6).getLint().setLocURI2Graph((Map)object);
                    ((SchemaQualityChecker)object6).getLint().setLocURI2XMLSchemaData((Map)((Object)serializable));
                    object7 = new Vector<String>(Arrays.asList("-indicateProgress", "-reportAsXML", ((File)object8).toString(), ((File)object9).toString()));
                    Collection collection = (Collection)SQCAction.getFileExtensionMap().get(iFile.getFileExtension());
                    if (collection == null) {
                        object5 = object7;
                    } else {
                        object5 = new Vector(collection);
                        object5.addAll(object7);
                    }
                    ((CommandLineApplication)object6).setThrowArgumentException(true);
                    try {
                        ((CommandLineApplication)object6).processFromCommandLine(object5.toArray(new String[object5.size()]));
                    }
                    catch (ArgumentException argumentException) {
                        object4 = plugin.getLog();
                        object4.log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, argumentException.getMessage(), (Throwable)argumentException));
                        this.errors.add("SQC command line arguments are not valid." + iFile.getFullPath().toString() + " was not processed. See log for more details");
                        Object var32_48 = null;
                        if (object2 != null) {
                            object2.done();
                        }
                        return;
                    }
                    Document document = ((SchemaQualityChecker)object6).getErrorReport();
                    if (object2 != null) {
                        object4 = !this.inputFilesUnderTheSameDir ? iFile.getFullPath().toString() : iFile.getName();
                        object2.subTask("Saving the schema analysis file of " + (String)object4);
                    }
                    if (styleSheetURL != null) {
                        boolean bl = false;
                        Node node2 = document.getFirstChild();
                        while (node2 != null) {
                            if (node2.getNodeType() == 7 && !bl && new String("xml-stylesheet").equals((node = (ProcessingInstruction)node2).getTarget())) {
                                object3 = "type=\"text/xsl\" href=\"" + styleSheetURL.toString() + "\"";
                                node.setData((String)object3);
                                bl = true;
                            }
                            node2 = node2.getNextSibling();
                        }
                    }
                    object4 = ((SchemaQualityChecker)object6).getOutputEncoding();
                    try {
                        SchemaQualityChecker.save(document, (File)object8, (String)object4);
                    }
                    catch (Exception exception) {
                        plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, exception.getMessage(), (Throwable)exception));
                        this.errors.add("error while saving " + object8 + " (see log for more details):" + exception.getMessage());
                        continue;
                    }
                    boolean bl = false;
                    node = document.getDocumentElement();
                    if (node != null) {
                        Object object11;
                        Object object12;
                        object3 = node.getElementsByTagName("error");
                        if (object3 != null) {
                            this.numberOfProblems += object3.getLength();
                            int n3 = 0;
                            while (n3 < object3.getLength() && !bl) {
                                object12 = (Element)object3.item(n3);
                                object11 = object12.getAttributeNS(null, "severity");
                                if (object11 != null && !((String)object11).equals("0")) {
                                    this.errorFound = true;
                                    bl = true;
                                }
                                ++n3;
                            }
                        }
                        Object object13 = object8;
                        if (object3 == null || object3.getLength() == 0) {
                            object8 = new File(file, ((File)object9).getName() + NO_ERROR_REPORT_SUFFIX);
                        } else if (!bl) {
                            object8 = new File(file, ((File)object9).getName() + WARNING_REPORT_SUFFIX);
                        }
                        if (object8 != object13) {
                            try {
                                object12 = iWorkspaceRoot.getFileForLocation((IPath)new Path(((File)object13).toString()));
                                if (object12 != null) {
                                    if (object12.getParent() != null) {
                                        object12.getParent().refreshLocal(1, null);
                                    }
                                    object12.move((IPath)new Path(((File)object8).getName()), true, null);
                                } else {
                                    int n4;
                                    object11 = object12.getContents(true);
                                    ((File)object8).createNewFile();
                                    FileOutputStream fileOutputStream = new FileOutputStream((File)object8);
                                    while ((n4 = ((InputStream)object11).read()) != -1) {
                                        ((OutputStream)fileOutputStream).write(n4);
                                    }
                                    ((InputStream)object11).close();
                                    ((OutputStream)fileOutputStream).close();
                                    object12.delete(true, null);
                                }
                            }
                            catch (IOException iOException) {
                                plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, iOException.getMessage(), (Throwable)iOException));
                                this.errors.add("error while saving or deleting files. See log for more details.");
                                continue;
                            }
                            catch (CoreException coreException) {
                                plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, coreException.getMessage(), (Throwable)coreException));
                                this.errors.add("error while saving or deleting files. See log for more details.");
                                continue;
                            }
                        }
                        object12 = iWorkspaceRoot.getFileForLocation((IPath)new Path(((File)object8).toString()));
                        if (object3 != null && object3.getLength() > 0 && object12 != null) {
                            object11 = !this.inputFilesUnderTheSameDir ? (object12.getFullPath() != null ? object12.getName() + " (in " + object12.getFullPath().toFile().getParent() + ")" : object12.toString()) : object12.getName() + " (in " + SCHEMA_ANALYSIS_DIR_NAME + ")";
                            vector.add(object11);
                        }
                    }
                    try {
                        if (iFile.getParent() == null) continue;
                        iFile.getParent().refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {
                        plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, coreException.getMessage(), (Throwable)coreException));
                        this.errors.add("error while refreshing directory " + iFile.getParent() + ". See log for more details.");
                    }
                }
                this.numberOfFilesWithProblems = vector.size();
                int n5 = 0;
                while (n5 < vector.size()) {
                    this.filesWithProblems.append(vector.get(n5).toString() + "\n");
                    ++n5;
                }
            }
            catch (Exception exception) {
                plugin.getLog().log((IStatus)new Status(4, plugin.getDescriptor().getUniqueIdentifier(), 0, exception.getMessage(), (Throwable)exception));
                this.errors.add("application error, see log for more details.");
                Object var32_50 = null;
                if (object2 != null) {
                    object2.done();
                }
            }
            Object var32_49 = null;
            if (object2 != null) {
                object2.done();
            }
        }
        catch (Throwable throwable) {
            Object var32_51 = null;
            if (object2 != null) {
                object2.done();
            }
            throw throwable;
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.currentSeclection = (IStructuredSelection)iSelection;
        }
    }

    static {
        fileExtension_options = null;
    }

    public class SQCProgressMonitor
    implements ProgressMonitor {
        private IProgressMonitor eclipseProgressMonitor;

        public SQCProgressMonitor(IProgressMonitor iProgressMonitor) {
            this.eclipseProgressMonitor = iProgressMonitor;
        }

        public void beginTask(String string, int n) {
            this.eclipseProgressMonitor.beginTask(string, n);
        }

        public void done() {
            this.eclipseProgressMonitor.done();
        }

        public void internalWorked(double d) {
            this.eclipseProgressMonitor.internalWorked(d);
        }

        public boolean isCanceled() {
            return this.eclipseProgressMonitor.isCanceled();
        }

        public void setCanceled(boolean bl) {
            this.eclipseProgressMonitor.setCanceled(bl);
        }

        public void setTaskName(String string) {
            this.eclipseProgressMonitor.setTaskName(string);
        }

        public void subTask(String string) {
            this.eclipseProgressMonitor.subTask(string);
        }

        public void worked(int n) {
            this.eclipseProgressMonitor.worked(n);
        }

        public void subTask(String string, boolean bl) {
            if (!SQCAction.this.inputFilesUnderTheSameDir) {
                if (bl) {
                    this.subTask("Validating schema " + string);
                } else {
                    this.subTask("Reading schema " + string);
                }
            } else {
                URL uRL;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    if (bl) {
                        this.subTask("Validating schema " + string);
                    } else {
                        this.subTask("Reading schema " + string);
                    }
                    return;
                }
                try {
                    String string2 = uRL.getProtocol();
                    File file = new File(uRL.getFile());
                    File file2 = file.getParentFile();
                    String string3 = uRL.getHost();
                    URL uRL2 = SQCAction.this.commonDirOfInputFiles.toURL();
                    if (string2.equals("file") && string3.equals(uRL2.getHost()) && SQCAction.this.commonDirOfInputFiles.equals(file2)) {
                        if (bl) {
                            this.subTask("Validating schema " + file.getName());
                        } else {
                            this.subTask("Reading schema " + file.getName());
                        }
                    } else if (bl) {
                        this.subTask("Validating schema " + string);
                    } else {
                        this.subTask("Reading schema " + string);
                    }
                }
                catch (Exception exception) {
                    if (bl) {
                        this.subTask("Validating schema " + string);
                    }
                    this.subTask("Reading schema " + string);
                }
            }
        }

        public void readingSubTask(String string) {
            this.subTask(string, false);
        }

        public void validationSubTask(String string) {
            this.subTask(string, true);
        }
    }
}

