/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.connection;

import com.ibm.sketch.connection.Debug;
import com.ibm.sketch.connection.PassThroughFilter;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ParserConnectionPool {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Hashtable poolDictionary = new Hashtable();
    protected int poolSize = 0;
    private static ParserConnectionPool instance;
    private int nberOfParsersCreated = 0;

    public static void main(String[] stringArray) throws Exception {
        XMLReader xMLReader = new ParserConnectionPool().acquireImpl();
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xMLReader.setFeature("http://xml.org/sax/features/validation", false);
        xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
        xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        xMLReader.parse(stringArray[0]);
    }

    protected ParserConnectionPool() {
    }

    public synchronized XMLReader acquireImpl() {
        if (Debug.DEBUG) {
            System.out.println("pool= " + this.poolDictionary);
            System.out.println("creation = " + this.nberOfParsersCreated);
        }
        ++this.nberOfParsersCreated;
        SAXParserImpl sAXParserImpl = null;
        try {
            sAXParserImpl = new SAXParserImpl();
            sAXParserImpl.setFeature("http://xml.org/sax/features/namespaces", true);
            sAXParserImpl.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            sAXParserImpl.setFeature("http://xml.org/sax/features/validation", false);
            sAXParserImpl.setFeature("http://apache.org/xml/features/validation/schema", false);
            sAXParserImpl.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            if (Debug.DEBUG) {
                sAXNotRecognizedException.printStackTrace(System.err);
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            if (Debug.DEBUG) {
                sAXNotSupportedException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(" Fatal Application Error : " + exception.getMessage());
        }
        return sAXParserImpl;
    }

    public synchronized XMLReader acquireImpl(Class clazz) throws SAXException {
        XMLReader xMLReader;
        block5: {
            if (Debug.DEBUG) {
                System.out.println("pool= " + this.poolDictionary);
                System.out.println("creation = " + this.nberOfParsersCreated);
            }
            ++this.nberOfParsersCreated;
            xMLReader = XMLReaderFactory.createXMLReader(clazz.getName());
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (Debug.DEBUG) {
                    sAXNotRecognizedException.printStackTrace(System.err);
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!Debug.DEBUG) break block5;
                sAXNotSupportedException.printStackTrace(System.err);
            }
        }
        return xMLReader;
    }

    public synchronized XMLReader acquireImpl(String string) throws SAXException {
        XMLReader xMLReader;
        block5: {
            if (Debug.DEBUG) {
                System.out.println("pool= " + this.poolDictionary);
                System.out.println("creation = " + this.nberOfParsersCreated);
            }
            ++this.nberOfParsersCreated;
            xMLReader = XMLReaderFactory.createXMLReader(string);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (Debug.DEBUG) {
                    sAXNotRecognizedException.printStackTrace(System.err);
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!Debug.DEBUG) break block5;
                sAXNotSupportedException.printStackTrace(System.err);
            }
        }
        return xMLReader;
    }

    public static ParserConnectionPool getInstance() {
        return ParserConnectionPool.instance();
    }

    public static ParserConnectionPool instance() {
        if (instance == null) {
            instance = new ParserConnectionPool();
        }
        return instance;
    }

    public synchronized void releaseImpl(XMLReader xMLReader) {
    }

    public static class SAXParserImpl
    extends SAXParser {
        private EncodingFinderParserConfiguration config;
        private String encoding;

        public SAXParserImpl() {
            this(new EncodingFinderParserConfiguration());
        }

        public SAXParserImpl(EncodingFinderParserConfiguration encodingFinderParserConfiguration) {
            super(encodingFinderParserConfiguration);
            this.config = encodingFinderParserConfiguration;
        }

        public XMLParserConfiguration getConfig() {
            return this.config;
        }

        public String getEncoding() {
            return this.config.getEncoding();
        }

        public void addAbstractSchema(ASModel aSModel) {
            if (aSModel == null) {
                return;
            }
            XMLGrammarPool xMLGrammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
            this.initGrammarPool((ASModelImpl)aSModel, xMLGrammarPool);
        }

        private void initGrammarPool(ASModelImpl aSModelImpl, XMLGrammarPool xMLGrammarPool) {
            Vector vector;
            SchemaGrammar schemaGrammar = null;
            schemaGrammar = aSModelImpl.getGrammar();
            if (schemaGrammar != null && schemaGrammar.getGrammarDescription() != null) {
                xMLGrammarPool.cacheGrammars(schemaGrammar.getGrammarDescription().getGrammarType(), new Grammar[]{schemaGrammar});
            }
            if ((vector = aSModelImpl.getInternalASModels()) != null) {
                int n = 0;
                while (n < vector.size()) {
                    this.initGrammarPool((ASModelImpl)vector.elementAt(n), xMLGrammarPool);
                    ++n;
                }
            }
        }
    }

    private static class EncodingFinderParserConfiguration
    extends StandardParserConfiguration {
        public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
        EncodingFinderXMLDocumentHandler handler;

        public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
            this.handler = new EncodingFinderXMLDocumentHandler();
            this.handler.setDocumentHandler(xMLDocumentHandler);
            super.setDocumentHandler(this.handler);
        }

        public String getEncoding() {
            return this.handler.getEncoding();
        }

        public EncodingFinderParserConfiguration() {
            super(null, new XMLGrammarPoolImpl(), null);
        }
    }

    private static class EncodingFinderXMLDocumentHandler
    extends PassThroughFilter {
        private String encoding;

        private EncodingFinderXMLDocumentHandler() {
        }

        public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
            this.encoding = string2;
            super.xmlDecl(string, string2, string3, augmentations);
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

