/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.graph;

import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.Graph;
import com.ibm.sketch.graph.GraphException;
import com.ibm.sketch.graph.GraphTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.TraverseEdgeCondition;
import com.ibm.sketch.graph.Vertex;
import java.util.Hashtable;

public class DepthFirstTraversal
extends GraphTraversal {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable parents = new Hashtable();

    public DepthFirstTraversal() {
    }

    public DepthFirstTraversal(TraverseEdgeCondition traverseEdgeCondition) {
        super(traverseEdgeCondition);
    }

    public Vertex getParent(Vertex vertex) {
        return (Vertex)this.parents.get(vertex);
    }

    protected void reset() {
        this.states.clear();
        this.parents.clear();
    }

    public synchronized void traverse(Graph graph, GraphVisitor graphVisitor) {
        Vertex[] vertexArray = graph.getVertices();
        if (vertexArray == null) {
            return;
        }
        this.reset();
        int n = 0;
        while (n < vertexArray.length) {
            if (this.states.get(vertexArray[n]) == null) {
                graphVisitor.initialize(vertexArray[n]);
                this.traverse(vertexArray[n], graphVisitor, false);
            }
            ++n;
        }
    }

    public synchronized void traverse(Graph graph, Vertex vertex, GraphVisitor graphVisitor) {
        this.traverse(vertex, graphVisitor);
    }

    public synchronized void traverse(Graph graph, Object object, GraphVisitor graphVisitor) throws GraphException {
        Vertex[] vertexArray = graph.getVertices();
        Vertex vertex = null;
        if (vertexArray != null) {
            int n = 0;
            while (n < vertexArray.length) {
                if (vertexArray[n].getObject().equals(object)) {
                    vertex = vertexArray[n];
                    break;
                }
                ++n;
            }
        }
        if (vertex == null) {
            throw new GraphException(object + " is not in the graph");
        }
        this.traverse(vertex, graphVisitor);
    }

    public synchronized void traverse(Vertex vertex, GraphVisitor graphVisitor) {
        graphVisitor.initialize(vertex);
        this.traverse(vertex, graphVisitor, true);
    }

    void traverse(Vertex vertex, GraphVisitor graphVisitor, boolean bl) {
        if (bl) {
            this.reset();
        }
        this.states.put(vertex, GraphTraversal.DISCOVERED);
        graphVisitor.discovered(vertex);
        graphVisitor.visitVertex(vertex);
        EdgeEnd[] edgeEndArray = vertex.getEdgeEnds();
        if (edgeEndArray != null) {
            int n = 0;
            while (n < edgeEndArray.length) {
                if (this.condition.traverse(vertex, edgeEndArray[n], graphVisitor)) {
                    graphVisitor.visitEdge(vertex, edgeEndArray[n]);
                    Vertex vertex2 = edgeEndArray[n].getVertex();
                    Object v = this.states.get(vertex2);
                    if (v == null) {
                        this.parents.put(vertex2, vertex);
                        this.traverse(vertex2, graphVisitor, false);
                    }
                }
                ++n;
            }
        }
        this.states.put(vertex, GraphTraversal.FINISHED);
        graphVisitor.finished(vertex);
    }
}

