/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.graph;

import com.ibm.sketch.graph.ComponentsInDifferentGraphsException;
import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.EdgeEndImpl;
import com.ibm.sketch.graph.Graph;
import com.ibm.sketch.graph.GraphException;
import com.ibm.sketch.graph.GraphTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexAlreadyInGraphException;
import com.ibm.sketch.graph.VertexImpl;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class GraphImpl
implements Graph {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MyCollection vertices;

    public GraphImpl() {
        this(null);
    }

    public GraphImpl(Comparator comparator) {
        this.vertices = comparator == null ? new LinkedListWithoutDuplicatedElements() : new MyTreeSet(comparator);
    }

    void add(VertexImpl vertexImpl) throws ComponentsInDifferentGraphsException, VertexAlreadyInGraphException {
        if (vertexImpl.getGraph() != this) {
            throw new ComponentsInDifferentGraphsException(this, vertexImpl);
        }
        boolean bl = this.vertices.add(vertexImpl);
        if (!bl) {
            throw new VertexAlreadyInGraphException();
        }
    }

    public void addEdge(Object object, Object object2, float f) {
        try {
            VertexImpl vertexImpl;
            VertexImpl vertexImpl2 = this.getVertex(object);
            if (vertexImpl2 == null) {
                vertexImpl2 = new VertexImpl(this, object);
            }
            if ((vertexImpl = this.getVertex(object2)) == null) {
                vertexImpl = new VertexImpl(this, object2);
            }
            EdgeEndImpl edgeEndImpl = new EdgeEndImpl(vertexImpl, f);
            vertexImpl2.add(edgeEndImpl);
        }
        catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
            componentsInDifferentGraphsException.printStackTrace();
        }
        catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
            vertexAlreadyInGraphException.printStackTrace();
        }
    }

    public Vertex addUserObject(Object object) throws VertexAlreadyInGraphException {
        return new VertexImpl(this, object);
    }

    private static void buildGraph(GraphImpl graphImpl) throws GraphException {
        int n = 1000;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        long l = Calendar.getInstance().getTime().getTime();
        System.err.println("start time = " + simpleDateFormat.format(Calendar.getInstance().getTime()) + " , " + l);
        System.err.println("building the graph ...");
        int n2 = 0;
        while (n2 < n) {
            graphImpl.addEdge(Integer.toString(n2), Integer.toString(n2 + 1), 0.0f);
            graphImpl.addEdge(Integer.toString(n - n2), Integer.toString(n - n2 + 1), 0.0f);
            if (n2 != 0) {
                graphImpl.addEdge(Integer.toString(n + n2), Integer.toString(n + n2 + 1), 0.0f);
            }
            ++n2;
        }
        graphImpl.addEdge(Integer.toString(n + n), Integer.toString(0), 0.0f);
        graphImpl.addEdge(Integer.toString(0), Integer.toString(1), 0.0f);
        graphImpl.addEdge("bb", "aa", 1.0f);
        graphImpl.addEdge("aa", "bb", 1.0f);
        graphImpl.addEdge("a", "b", 1.0f);
        graphImpl.addEdge("b", "c", 1.0f);
        graphImpl.addEdge("c", "d", 1.0f);
        graphImpl.addEdge("d", "a", 1.0f);
        graphImpl.addEdge("A", "B", 2.0f);
        graphImpl.addEdge("B", "C", 2.0f);
        graphImpl.addEdge("C", "D", 2.0f);
        graphImpl.addEdge("D", "E", 2.0f);
        graphImpl.addEdge("E", "F", 2.0f);
        graphImpl.addEdge("F", "G", 2.0f);
        graphImpl.addEdge("G", "H", 2.0f);
        graphImpl.addEdge("H", "A", 2.0f);
        graphImpl.addEdge("A", "a", 3.0f);
        graphImpl.addEdge("B", "b", 3.0f);
        graphImpl.addEdge("C", "c", 3.0f);
        graphImpl.addEdge("D", "d", 3.0f);
        graphImpl.addEdge("a", "A", 3.0f);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()) + " , " + (Calendar.getInstance().getTime().getTime() - l));
        System.out.println("graph :");
        System.out.println(graphImpl.toString());
        System.out.println();
    }

    public Object clone() {
        try {
            Iterator iterator = this.vertices.iterator();
            GraphImpl graphImpl = new GraphImpl();
            while (iterator.hasNext()) {
                EdgeEnd[] edgeEndArray;
                VertexImpl vertexImpl = (VertexImpl)iterator.next();
                VertexImpl vertexImpl2 = graphImpl.getVertex(vertexImpl.getObject());
                if (vertexImpl2 == null) {
                    vertexImpl2 = new VertexImpl(graphImpl, vertexImpl.getObject());
                }
                if ((edgeEndArray = vertexImpl.getEdgeEnds()) == null) continue;
                int n = 0;
                while (n < edgeEndArray.length) {
                    VertexImpl vertexImpl3 = graphImpl.getVertex(edgeEndArray[n].getVertex().getObject());
                    if (vertexImpl3 == null) {
                        vertexImpl3 = new VertexImpl(graphImpl, edgeEndArray[n].getVertex().getObject());
                    }
                    EdgeEndImpl edgeEndImpl = new EdgeEndImpl(vertexImpl3, edgeEndArray[n].getWeight(), edgeEndArray[n].getObject());
                    vertexImpl2.add(edgeEndImpl);
                    ++n;
                }
            }
            return graphImpl;
        }
        catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
            componentsInDifferentGraphsException.printStackTrace();
        }
        catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
            vertexAlreadyInGraphException.printStackTrace();
        }
        return null;
    }

    public EdgeEnd[] getEdgesIncidentFrom(Object object) throws GraphException {
        VertexImpl vertexImpl = this.getVertex(object);
        if (vertexImpl == null) {
            throw new GraphException(object + " is not in the graph");
        }
        return vertexImpl.getEdgeEnds();
    }

    public int getNumberOfEdges() {
        Iterator iterator = this.vertices.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += ((VertexImpl)iterator.next()).getDegree();
        }
        return n;
    }

    public int getNumberOfVertices() {
        return this.vertices.size();
    }

    public Object[] getUserObjects() {
        Object[] objectArray = new Vertex[this.vertices.size()];
        Iterator iterator = this.vertices.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            VertexImpl vertexImpl = (VertexImpl)iterator.next();
            objectArray[n] = vertexImpl.getObject();
            ++n;
        }
        return objectArray;
    }

    public VertexImpl getVertex(Object object) {
        try {
            if (this.vertices instanceof TreeSet) {
                TreeSet treeSet = (TreeSet)((Object)this.vertices);
                SortedSet<VertexImpl> sortedSet = treeSet.tailSet(new VertexImpl(new GraphImpl(), object));
                if (sortedSet.isEmpty()) {
                    return null;
                }
                VertexImpl vertexImpl = sortedSet.first();
                if (this.vertices.getComparator().compare(object, vertexImpl.getObject()) == 0) {
                    return vertexImpl;
                }
                return null;
            }
        }
        catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
            // empty catch block
        }
        Iterator iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            VertexImpl vertexImpl = (VertexImpl)iterator.next();
            if (vertexImpl.getObject().equals(object)) {
                return vertexImpl;
            }
            if (!this.vertices.isOrdered() || this.vertices.getComparator().compare(object, vertexImpl.getObject()) >= 0) continue;
            return null;
        }
        return null;
    }

    public Vertex[] getVertices() {
        return this.vertices.toArray(new Vertex[0]);
    }

    public static void main(String[] stringArray) throws GraphException {
        GraphImpl graphImpl = new GraphImpl();
        GraphImpl graphImpl2 = new GraphImpl(graphImpl.new DefaultComparator());
        graphImpl = new GraphImpl();
        GraphImpl.buildGraph(graphImpl);
        GraphImpl.buildGraph(graphImpl2);
        long l = Calendar.getInstance().getTime().getTime();
        System.out.println("cloning ..");
        graphImpl2.clone();
        System.out.println(Calendar.getInstance().getTime().getTime() - l);
        l = Calendar.getInstance().getTime().getTime();
        System.out.println("cloning ..");
        graphImpl.clone();
        System.out.println(Calendar.getInstance().getTime().getTime() - l);
    }

    public void remove(VertexImpl vertexImpl) {
        this.vertices.remove(vertexImpl);
    }

    public void removeUserObject(Object object) {
        try {
            if (this.vertices instanceof TreeSet) {
                TreeSet treeSet = (TreeSet)((Object)this.vertices);
                SortedSet<VertexImpl> sortedSet = treeSet.tailSet(new VertexImpl(new GraphImpl(), object));
                if (sortedSet.isEmpty()) {
                    return;
                }
                VertexImpl vertexImpl = sortedSet.first();
                if (this.vertices.getComparator().compare(object, vertexImpl.getObject()) == 0) {
                    sortedSet.remove(vertexImpl);
                }
                return;
            }
        }
        catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
            // empty catch block
        }
        Iterator iterator = this.vertices.iterator();
        MyCollection myCollection = this.vertices;
        synchronized (myCollection) {
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                if (object.equals(vertex.getObject())) {
                    iterator.remove();
                    break;
                }
                if (this.vertices.isOrdered() && this.vertices.getComparator().compare(object, vertex.getObject()) < 0) break;
            }
        }
    }

    public Vector[] stronglyConnectedComponents() {
        Object object;
        SortVerticesByIncreasingFinishingTimeVisitor sortVerticesByIncreasingFinishingTimeVisitor = new SortVerticesByIncreasingFinishingTimeVisitor(this);
        new DepthFirstTraversal().traverse(this, (GraphVisitor)sortVerticesByIncreasingFinishingTimeVisitor);
        Vector vector = sortVerticesByIncreasingFinishingTimeVisitor.getVerticesInOrderOfIncreasingFinishingTime();
        this.transpose();
        DepthFirstTraversal depthFirstTraversal = new DepthFirstTraversal();
        FindVerticesInTheSameDFSTreeVisitor findVerticesInTheSameDFSTreeVisitor = new FindVerticesInTheSameDFSTreeVisitor();
        int n = vector.size() - 1;
        while (n >= 0) {
            object = (Vertex)vector.get(n);
            if (depthFirstTraversal.getState((Vertex)object).equals(GraphTraversal.UNDISCOVERED)) {
                findVerticesInTheSameDFSTreeVisitor.initialize((Vertex)object);
                depthFirstTraversal.traverse((Vertex)object, findVerticesInTheSameDFSTreeVisitor, false);
            }
            --n;
        }
        object = findVerticesInTheSameDFSTreeVisitor.getVerticesInTheSameDFSTree();
        this.transpose();
        return object;
    }

    public Hashtable stronglyConnectedComponents(Comparator comparator) {
        Vector[] vectorArray = this.stronglyConnectedComponents();
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < vectorArray.length) {
            TreeSet treeSet = comparator != null ? new TreeSet(new WrapperComparatorForVertices(comparator)) : new TreeSet(new WrapperComparatorForVertices(new DefaultComparator()));
            treeSet.addAll(vectorArray[n]);
            Vector vector = vectorArray[n];
            int n2 = 0;
            while (n2 < vector.size()) {
                hashtable.put(vector.get(n2), treeSet);
                ++n2;
            }
            ++n;
        }
        return hashtable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + "\n");
        }
        return stringBuffer.toString();
    }

    public void transpose() {
        try {
            VertexImpl vertexImpl;
            if (this.vertices.isEmpty()) {
                return;
            }
            VertexImpl vertexImpl2 = (VertexImpl)this.vertices.iterator().next();
            EdgeEndImpl edgeEndImpl = new EdgeEndImpl(vertexImpl2);
            Iterator iterator = this.vertices.iterator();
            while (iterator.hasNext()) {
                vertexImpl = (VertexImpl)iterator.next();
                vertexImpl.add(edgeEndImpl);
            }
            iterator = this.vertices.iterator();
            while (iterator.hasNext()) {
                vertexImpl = (VertexImpl)iterator.next();
                EdgeEnd[] edgeEndArray = vertexImpl.getEdgeEnds();
                if (edgeEndArray == null) continue;
                int n = 0;
                while (n < edgeEndArray.length) {
                    EdgeEndImpl edgeEndImpl2 = (EdgeEndImpl)edgeEndArray[n];
                    if (edgeEndImpl2 == edgeEndImpl) break;
                    vertexImpl.remove(edgeEndImpl2);
                    VertexImpl vertexImpl3 = (VertexImpl)edgeEndImpl2.getVertex();
                    edgeEndImpl2.setVertex(vertexImpl);
                    vertexImpl3.add(edgeEndImpl2);
                    ++n;
                }
                vertexImpl.remove(edgeEndImpl);
            }
        }
        catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
            // empty catch block
        }
    }

    private class FindVerticesInTheSameDFSTreeVisitor
    extends DefaultGraphVisitor {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Vector trees = new Vector();
        private Vector vertices;

        private FindVerticesInTheSameDFSTreeVisitor() {
        }

        public Vector[] getVerticesInTheSameDFSTree() {
            Object[] objectArray = new Vector[this.trees.size()];
            this.trees.copyInto(objectArray);
            return objectArray;
        }

        public void discovered(Vertex vertex) {
            this.vertices.add(vertex);
        }

        public void initialize(Vertex vertex) {
            this.vertices = new Vector();
            this.trees.add(this.vertices);
        }
    }

    private class SortVerticesByIncreasingFinishingTimeVisitor
    extends DefaultGraphVisitor {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Vector vertices;

        public SortVerticesByIncreasingFinishingTimeVisitor(Graph graph) {
            Vertex[] vertexArray = graph.getVertices();
            this.vertices = vertexArray == null ? new Vector() : new Vector(vertexArray.length);
        }

        public void finished(Vertex vertex) {
            this.vertices.add(vertex);
        }

        public Vector getVerticesInOrderOfIncreasingFinishingTime() {
            return this.vertices;
        }
    }

    private class LinkedListWithoutDuplicatedElements
    extends LinkedList
    implements MyCollection {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private LinkedListWithoutDuplicatedElements() {
        }

        public Comparator getComparator() {
            return null;
        }

        public boolean isOrdered() {
            return false;
        }

        public boolean add(Object object) {
            if (this.contains(object)) {
                return false;
            }
            return super.add(object);
        }

        public boolean addAll(Collection collection) {
            if (collection.isEmpty()) {
                return false;
            }
            Iterator iterator = collection.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!bl) continue;
                bl = this.add(e);
            }
            return bl;
        }
    }

    private static class WrapperComparatorForVertices
    implements Comparator {
        private Comparator comparator;

        public WrapperComparatorForVertices(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object object, Object object2) {
            return this.comparator.compare(((Vertex)object).getObject(), ((Vertex)object2).getObject());
        }

        public Comparator getComparator() {
            return this.comparator;
        }
    }

    private class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }

    private class MyTreeSet
    extends TreeSet
    implements MyCollection {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public MyTreeSet(Comparator comparator) {
            super(new WrapperComparatorForVertices(comparator));
        }

        public Comparator getComparator() {
            return ((WrapperComparatorForVertices)this.comparator()).getComparator();
        }

        public boolean isOrdered() {
            return true;
        }
    }

    private static interface MyCollection
    extends Collection {
        public boolean isOrdered();

        public Comparator getComparator();
    }
}

