/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.graph;

import com.ibm.sketch.graph.DefaultTraverseEdgeCondition;
import com.ibm.sketch.graph.Graph;
import com.ibm.sketch.graph.GraphException;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.TraverseEdgeCondition;
import com.ibm.sketch.graph.Vertex;
import java.util.Hashtable;

public abstract class GraphTraversal {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Integer UNDISCOVERED = new Integer(0);
    public static final Integer DISCOVERED = new Integer(1);
    public static final Integer FINISHED = new Integer(2);
    protected Hashtable states = new Hashtable();
    protected static final TraverseEdgeCondition DEFAULTCONDITION = new DefaultTraverseEdgeCondition();
    protected TraverseEdgeCondition condition;

    public GraphTraversal() {
        this(DEFAULTCONDITION);
    }

    public GraphTraversal(TraverseEdgeCondition traverseEdgeCondition) {
        this.condition = traverseEdgeCondition;
    }

    public TraverseEdgeCondition getCondition() {
        return this.condition;
    }

    public Integer getState(Vertex vertex) {
        Object v = this.states.get(vertex);
        if (v != null) {
            return (Integer)v;
        }
        return UNDISCOVERED;
    }

    public void setCondition(TraverseEdgeCondition traverseEdgeCondition) {
        this.condition = traverseEdgeCondition;
    }

    public abstract void traverse(Graph var1, GraphVisitor var2);

    public abstract void traverse(Graph var1, Object var2, GraphVisitor var3) throws GraphException;

    public abstract void traverse(Vertex var1, GraphVisitor var2);
}

