/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.graph;

import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;

public class SequenceVisitor
extends DefaultGraphVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GraphVisitor[] visitors;

    public SequenceVisitor(GraphVisitor[] graphVisitorArray) {
        if (graphVisitorArray == null) {
            throw new NullPointerException();
        }
        this.visitors = graphVisitorArray;
    }

    public void discovered(Vertex vertex) {
        int n = 0;
        while (n < this.visitors.length) {
            this.visitors[n].discovered(vertex);
            ++n;
        }
    }

    public void finished(Vertex vertex) {
        int n = 0;
        while (n < this.visitors.length) {
            this.visitors[n].finished(vertex);
            ++n;
        }
    }

    public void initialize(Vertex vertex) {
        int n = 0;
        while (n < this.visitors.length) {
            this.visitors[n].initialize(vertex);
            ++n;
        }
    }

    public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
        int n = 0;
        while (n < this.visitors.length) {
            this.visitors[n].visitEdge(vertex, edgeEnd);
            ++n;
        }
    }

    public void visitVertex(Vertex vertex) {
        int n = 0;
        while (n < this.visitors.length) {
            this.visitors[n].visitVertex(vertex);
            ++n;
        }
    }
}

