/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.graph;

import com.ibm.sketch.graph.ComponentsInDifferentGraphsException;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.EdgeEndImpl;
import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexAlreadyInGraphException;
import java.util.Iterator;
import java.util.LinkedList;

public class VertexImpl
implements Vertex {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object object;
    private LinkedList outEdges = new LinkedList();
    private GraphImpl graph;

    public VertexImpl(GraphImpl graphImpl, Object object) throws VertexAlreadyInGraphException {
        if (graphImpl == null) {
            throw new NullPointerException();
        }
        this.graph = graphImpl;
        this.object = object;
        try {
            graphImpl.add(this);
        }
        catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
            // empty catch block
        }
    }

    public void add(EdgeEndImpl edgeEndImpl) throws ComponentsInDifferentGraphsException {
        if (edgeEndImpl.getGraph() != this.graph) {
            throw new ComponentsInDifferentGraphsException(this, edgeEndImpl);
        }
        this.outEdges.add(edgeEndImpl);
    }

    public boolean equals(Object object) {
        if (object instanceof Vertex) {
            return this.object.equals(((Vertex)object).getObject());
        }
        return false;
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public EdgeEnd[] getEdgeEnds() {
        return this.outEdges.toArray(new EdgeEnd[0]);
    }

    public GraphImpl getGraph() {
        return this.graph;
    }

    public Object getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public void remove(EdgeEndImpl edgeEndImpl) {
        this.outEdges.remove(edgeEndImpl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.object + " :");
        Iterator iterator = this.outEdges.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            Vertex vertex = edgeEnd.getVertex();
            stringBuffer.append(" (");
            stringBuffer.append(vertex.getObject());
            stringBuffer.append(" ; ");
            stringBuffer.append(edgeEnd.getWeight() + " )");
        }
        return stringBuffer.toString();
    }
}

