/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

import com.ibm.sketch.parser.S_Dispatcher;
import com.ibm.sketch.parser.SchemaComponent_ElementHandler;
import java.util.Stack;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class DOMDispatcher
extends S_Dispatcher
implements ContentHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Document defaultDoc = new DocumentImpl();
    private Node lastComponentRead;
    protected Locator fLocator;
    protected DocumentType fDocumentType = null;
    protected Node fCurrentNode = null;
    protected Stack fNodeStack = new Stack();
    protected Document fDocument;
    protected boolean fWithinElement = false;
    private boolean buildDOM;

    public DOMDispatcher(Document document) {
        this(document, document != null);
    }

    public DOMDispatcher(Document document, boolean bl) {
        this.fDocument = document;
        this.fCurrentNode = this.fDocument;
        this.buildDOM = bl;
    }

    public Node getCurrentNode() {
        if (this.buildDOM) {
            return this.fCurrentNode;
        }
        return null;
    }

    private Node getLastComponentReadAsNode() {
        if (this.buildDOM) {
            return this.lastComponentRead;
        }
        return null;
    }

    public Node getPreviousCurrentNode() {
        if (this.buildDOM) {
            return this.fCurrentNode.getLastChild() == null ? this.getLastComponentReadAsNode() : this.fCurrentNode.getLastChild();
        }
        return null;
    }

    protected SchemaComponent_ElementHandler getTopElementElementHandler(String string, String string2, String string3, Attributes attributes) {
        if (this.buildDOM) {
            this.fNodeStack.push(this.fCurrentNode);
            Element element = this.fDocument.createElementNS(string, string3);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                element.setAttributeNS(attributes.getURI(n2), attributes.getQName(n2), attributes.getValue(n2));
                ++n2;
            }
            this.fCurrentNode.appendChild(element);
            this.fCurrentNode = element;
            this.fWithinElement = true;
        }
        return null;
    }

    protected void mainCharacters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buildDOM) {
            Text text = null;
            if (this.fWithinElement && this.fCurrentNode.getNodeType() == 3 && this.fCurrentNode.getParentNode().getNodeType() == 1) {
                ((Text)this.fCurrentNode).appendData(new String(cArray, n, n2));
                return;
            }
            if (this.fWithinElement) {
                text = this.fDocument.createTextNode(new String(cArray, n, n2));
            }
            if (text == null) {
                return;
            }
            this.fCurrentNode.appendChild(text);
        }
    }

    protected void mainEndElement(String string, String string2, String string3) throws SAXException {
        if (this.buildDOM) {
            this.fCurrentNode = (Node)this.fNodeStack.pop();
            this.fWithinElement = false;
            if (this.fCurrentNode == this.fDocument) {
                this.reset();
            }
        }
    }

    protected void mainIgnorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    protected void mainProcessingInstruction(String string, String string2) throws SAXException {
        if (this.buildDOM) {
            ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, string2);
            this.fCurrentNode.appendChild(processingInstruction);
        }
    }

    protected void mainStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.buildDOM) {
            this.fNodeStack.push(this.fCurrentNode);
            Element element = this.fDocument.createElementNS(string, string3);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                element.setAttributeNS(attributes.getURI(n2), attributes.getQName(n2), attributes.getValue(n2));
                ++n2;
            }
            this.fCurrentNode.appendChild(element);
            this.fCurrentNode = element;
            this.fWithinElement = true;
        }
    }

    public void mainStartElt(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.buildDOM) {
            this.fNodeStack.push(this.fCurrentNode);
            Element element = this.fDocument.createElementNS(string, string3);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                element.setAttributeNS(attributes.getURI(n2), attributes.getQName(n2), attributes.getValue(n2));
                ++n2;
            }
            this.fCurrentNode.appendChild(element);
            this.fCurrentNode = element;
            this.fWithinElement = true;
        }
    }

    public void reset() {
        if (!this.buildDOM) {
            return;
        }
        this.lastComponentRead = this.fDocument.getDocumentElement();
        this.fDocument.removeChild(this.fDocument.getDocumentElement());
    }

    public void startDocument() throws SAXException {
        this.fCurrentNode = this.fDocument;
    }
}

