/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

import com.ibm.sketch.parser.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ReportErrorInXMLFormat
implements ErrorHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int nbrOfErrors = 0;
    private int nbrOfWarnings = 0;
    private int nbrOfFatalErrors = 0;
    private Document out;
    private Element input;
    private Element file;

    public ReportErrorInXMLFormat(Element element) {
        this.out = element.getOwnerDocument();
        this.file = element;
    }

    public void error(SAXParseException sAXParseException) {
        this.problem("ErrorAgainstDTD", sAXParseException);
        ++this.nbrOfErrors;
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.problem("WellformednessError", sAXParseException);
        ++this.nbrOfFatalErrors;
    }

    public int getNumberOfErrors() {
        return this.nbrOfErrors;
    }

    public int getNumberOfErrorsAndFatalErrors() {
        return this.nbrOfFatalErrors + this.nbrOfErrors;
    }

    public int getNumberOfFatalErrors() {
        return this.nbrOfFatalErrors;
    }

    public int getNumberOfWarnings() {
        return this.nbrOfWarnings;
    }

    private void problem(String string, SAXParseException sAXParseException) {
        Element element = this.out.createElement(string);
        element.setAttribute("systemID", sAXParseException.getSystemId());
        element.setAttribute("line", Integer.toString(sAXParseException.getLineNumber()));
        element.setAttribute("column", Integer.toString(sAXParseException.getColumnNumber()));
        element.appendChild(Util.toElement(sAXParseException, this.out));
        if (this.input == null) {
            this.input = this.out.createElement("XMLERRORS");
            this.file.appendChild(this.input);
        }
        this.input.appendChild(element);
    }

    public void warning(SAXParseException sAXParseException) {
        this.problem("warning", sAXParseException);
        ++this.nbrOfWarnings;
    }
}

