/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

public class SchemaTags {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG_LENGTH = "length";
    public static final String TAG_MAXLENGTH = "maxLength";
    public static final String TAG_MINLENGTH = "minLength";
    public static final String TAG_ENUMERATION = "enumeration";
    public static final String TAG_MININCLUSIVE = "minInclusive";
    public static final String TAG_MINEXCLUSIVE = "minExclusive";
    public static final String TAG_MAXINCLUSIVE = "maxInclusive";
    public static final String TAG_MAXEXCLUSIVE = "maxExclusive";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_PRECISION = "totalDigits";
    public static final String TAG_REDEFINE = "redefine";
    public static final String TAG_SCALE = "fractionDigits";
    public static final String TAG_DURATION = "duration";
    public static final String TAG_WHITESPACE = "whiteSpace";
    public static final String TAG_SCHEMA = "schema";
    public static final String TAG_DATATYPE = "simpleType";
    public static final String TAG_BASETYPE = "basetype";
    public static final String TAG_COMPLEXTYPE = "complexType";
    public static final String TAG_ELEMENT = "element";
    public static final String TAG_ATTRIBUTEDECL = "attribute";
    public static final String TAG_ATTRIBUTEGROUPDEF = "attributeGroup";
    public static final String TAG_ATTRIBUTEGROUPREF = "attributeGroup";
    public static final String TAG_ATTRIBUTEREF = "attribute";
    public static final String TAG_MODELGROUP = "group";
    public static final String TAG_MODELGROUPREF = "group";
    public static final String TAG_ALLGROUP = "all";
    public static final String TAG_SEQUENCEGROUP = "sequence";
    public static final String TAG_CHOICEGROUP = "choice";
    public static final String TAG_ATTRIBUTEWILDCARD = "anyAttribute";
    public static final String TAG_WILDCARD = "any";
    public static final String TAG_UNIQUE = "unique";
    public static final String TAG_KEY = "key";
    public static final String TAG_KEYREF = "keyref";
    public static final String TAG_ANNOTATION = "annotation";
    public static final String TAG_DOCUMENTATION = "documentation";
    public static final String TAG_APPINFO = "appinfo";
    public static final String TAG_NOTATIONDECL = "notation";
    public static final String TAG_SIMPLECONTENT = "simpleContent";
    public static final String TAG_SIMPLECONTENT_RESTRICTION = "restriction";
    public static final String TAG_SIMPLECONTENT_EXTENSION = "extension";
    public static final String TAG_COMPLEXCONTENT = "complexContent";
    public static final String TAG_COMPLEXCONTENT_RESTRICTION = "restriction";
    public static final String TAG_COMPLEXCONTENT_EXTENSION = "extension";
    public static final String TAG_SIMPLETYPE_RESTRICTION = "restriction";
    public static final String TAG_SIMPLETYPE_UNION = "union";
    public static final String TAG_SIMPLETYPE_LIST = "list";
    public static final String TAG_SELECTOR = "selector";
    public static final String TAG_FIELD = "field";
    public static final String TAG_INFO = "info";

    public static String getAttributeUse(int n) {
        switch (n) {
            case 4: {
                return "required";
            }
            case 3: {
                return "prohibited";
            }
            case 0: {
                return "optional";
            }
        }
        return null;
    }

    public static int getAttributeUse(String string) {
        if (string.equalsIgnoreCase("required")) {
            return 4;
        }
        if (string.equalsIgnoreCase("prohibited")) {
            return 3;
        }
        if (string.equalsIgnoreCase("optional")) {
            return 0;
        }
        return -1;
    }

    public static String getBlockSubstitution(int n) {
        switch (n) {
            case 10: {
                return "substitution";
            }
            case 1: {
                return "extension";
            }
            case 0: {
                return "restriction";
            }
            case 2: {
                return TAG_SIMPLETYPE_LIST;
            }
            case 4: {
                return TAG_SIMPLETYPE_UNION;
            }
        }
        return null;
    }

    public static int getBlockSubstitution(String string) {
        if (string.equals("substitution")) {
            return 10;
        }
        if (string.equals("restriction")) {
            return 0;
        }
        if (string.equals("extension")) {
            return 1;
        }
        if (string.equals(TAG_SIMPLETYPE_LIST)) {
            return 2;
        }
        if (string.equals(TAG_SIMPLETYPE_UNION)) {
            return 4;
        }
        return -1;
    }

    public static String getBlockSubstitutionForComplexType(int n) {
        switch (n) {
            case 10: {
                return "substitution";
            }
        }
        return SchemaTags.getFinal(n);
    }

    public static int getBlockSubstitutionForComplexType(String string) {
        if (string.equals("substitution")) {
            return 10;
        }
        return SchemaTags.getFinal(string);
    }

    public static String getFacetName(int n) {
        switch (n) {
            case 2: {
                return TAG_MININCLUSIVE;
            }
            case 1: {
                return TAG_MAXINCLUSIVE;
            }
            case 4: {
                return TAG_MINEXCLUSIVE;
            }
            case 3: {
                return TAG_MAXEXCLUSIVE;
            }
            case 6: {
                return TAG_ENUMERATION;
            }
            case 9: {
                return TAG_SCALE;
            }
            case 8: {
                return TAG_PRECISION;
            }
            case 7: {
                return TAG_LENGTH;
            }
            case 10: {
                return TAG_MAXLENGTH;
            }
            case 11: {
                return TAG_MINLENGTH;
            }
            case 5: {
                return TAG_PATTERN;
            }
            case 12: {
                return TAG_WHITESPACE;
            }
        }
        return null;
    }

    public static int getFacetType(String string) {
        if (TAG_MAXEXCLUSIVE.equals(string)) {
            return 3;
        }
        if (TAG_MAXINCLUSIVE.equals(string)) {
            return 1;
        }
        if (TAG_MININCLUSIVE.equals(string)) {
            return 2;
        }
        if (TAG_MINEXCLUSIVE.equals(string)) {
            return 4;
        }
        if (TAG_ENUMERATION.equals(string)) {
            return 6;
        }
        if (TAG_PRECISION.equals(string)) {
            return 8;
        }
        if (TAG_SCALE.equals(string)) {
            return 9;
        }
        if (TAG_LENGTH.equals(string)) {
            return 7;
        }
        if (TAG_MAXLENGTH.equals(string)) {
            return 10;
        }
        if (TAG_MINLENGTH.equals(string)) {
            return 11;
        }
        if (TAG_PATTERN.equals(string)) {
            return 5;
        }
        if (TAG_WHITESPACE.equals(string)) {
            return 12;
        }
        return 0;
    }

    public static String getFinal(int n) {
        switch (n) {
            case 1: {
                return "extension";
            }
            case 0: {
                return "restriction";
            }
        }
        return null;
    }

    public static int getFinal(String string) {
        if (string.equals("restriction")) {
            return 0;
        }
        if (string.equals("extension")) {
            return 1;
        }
        return -1;
    }

    public static String getFinalForSimpleType(int n) {
        switch (n) {
            case 0: {
                return "restriction";
            }
            case 2: {
                return TAG_SIMPLETYPE_LIST;
            }
            case 4: {
                return TAG_SIMPLETYPE_UNION;
            }
        }
        return null;
    }

    public static int getFinalForSimpleType(String string) {
        if (string.equals("restriction")) {
            return 0;
        }
        if (string.equals(TAG_SIMPLETYPE_LIST)) {
            return 2;
        }
        if (string.equals(TAG_SIMPLETYPE_UNION)) {
            return 4;
        }
        return -1;
    }

    public static final String getSchemaComponentType(int n) {
        String string = SchemaTags.getTopComponentTagName(n);
        if (string != null) {
            return string;
        }
        switch (n) {
            case 118: {
                return TAG_ANNOTATION;
            }
            case 115: {
                return "attributeDecl";
            }
            case 117: {
                return "attributesSpec";
            }
            case 116: {
                return TAG_ATTRIBUTEWILDCARD;
            }
            case 104: {
                return "contentModelWithElement";
            }
            case 102: {
                return "emptyContentModel";
            }
            case 103: {
                return "unconstrainedContentModel";
            }
            case 105: {
                return "group";
            }
            case 108: {
                return "elementDecl";
            }
            case 106: {
                return "group";
            }
            case 107: {
                return TAG_WILDCARD;
            }
            case 123: {
                return TAG_WILDCARD;
            }
            case 109: {
                return "facet";
            }
            case 114: {
                return "attributeGroupRef";
            }
            case 112: {
                return "elementRef";
            }
            case 113: {
                return "modelGroupRef";
            }
            case 111: {
                return "complexTypeRef";
            }
            case 110: {
                return "datatypeRef";
            }
            case 101: {
                return "complexTypeSpec";
            }
            case 100: {
                return "datatypeSpec";
            }
            case 119: {
                return "attributeRef";
            }
            case 120: {
                return TAG_UNIQUE;
            }
            case 121: {
                return TAG_KEY;
            }
            case 122: {
                return TAG_KEYREF;
            }
            case 124: {
                return TAG_APPINFO;
            }
            case 125: {
                return TAG_DOCUMENTATION;
            }
            case 126: {
                return "xpathContainer";
            }
        }
        return null;
    }

    public static final String getTopComponentTagName(int n) {
        switch (n) {
            case 1: {
                return TAG_DATATYPE;
            }
            case 3: {
                return TAG_ELEMENT;
            }
            case 5: {
                return "group";
            }
            case 4: {
                return "attributeGroup";
            }
            case 2: {
                return TAG_COMPLEXTYPE;
            }
            case 6: {
                return "attribute";
            }
            case 7: {
                return TAG_NOTATIONDECL;
            }
        }
        return null;
    }
}

