/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

import com.ibm.sketch.parser.Debug;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.Checker;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.ReferenceResolver_Checker;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class Util {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final URI schemaNS = FactoryImpl.instance().createURI();

    public static void checkReference(Reference reference) {
        Util.runChecker(reference, new ReferenceResolver_Checker(reference));
    }

    public static String getFileName(InputSource inputSource) throws MalformedURLException {
        return new URL(inputSource.getSystemId()).getFile();
    }

    public static boolean isSchemaNS(String string) {
        try {
            Factory factory = FactoryImpl.instance();
            URI uRI = factory.createURI(string);
            if (uRI != null) {
                return schemaNS.equals(uRI);
            }
            return false;
        }
        catch (DatatypeFormatException datatypeFormatException) {
            if (Debug.DEBUG) {
                datatypeFormatException.printStackTrace(System.err);
            }
            return false;
        }
    }

    public static boolean runChecker(SchemaObject schemaObject, Checker checker) {
        SchemaException[] schemaExceptionArray;
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        boolean bl = checkerManagerImpl.check(checker, false);
        if (!bl && (schemaExceptionArray = checker.getExceptions()) != null && schemaExceptionArray.length > 0) {
            schemaObject.getInvalidStateHandler().action(schemaObject, schemaExceptionArray);
        }
        return bl;
    }

    public static void runCheckersNeverActivateInInteractiveMode(SchemaObjectImpl schemaObjectImpl) {
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        Checker[] checkerArray = schemaObjectImpl.getCheckers();
        if (checkerArray != null) {
            int n = 0;
            while (n < checkerArray.length) {
                SchemaException[] schemaExceptionArray;
                if (checkerArray[n].isNeverActivateInInterativeMode() && !checkerManagerImpl.check(checkerArray[n], false) && (schemaExceptionArray = checkerArray[n].getExceptions()) != null && schemaExceptionArray.length > 0) {
                    schemaObjectImpl.getInvalidStateHandler().action(schemaObjectImpl, schemaExceptionArray);
                }
                ++n;
            }
        }
    }

    public static void save(Element element, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        OutputFormat outputFormat = new OutputFormat(element.getOwnerDocument());
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer(fileWriter, outputFormat);
        xMLSerializer.serialize(element);
        fileWriter.flush();
        fileWriter.close();
    }

    public static Element toElement(Exception exception, Document document) {
        Element element = document.createElement("exception");
        Element element2 = document.createElement("message");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(exception.getMessage()));
        if (Debug.DEBUG) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
            Element element3 = document.createElement("stackTrace");
            element.appendChild(element3);
            element3.appendChild(document.createTextNode(stringWriter.toString()));
        }
        return element;
    }

    public static String toString(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < attributes.getLength()) {
            stringBuffer.append(attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"  ");
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        schemaNS.setValue("http://www.w3.org/2001/XMLSchema");
    }
}

