/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

import com.ibm.sketch.connection.ParserConnectionPool;
import com.ibm.sketch.parser.AbstractParser;
import com.ibm.sketch.parser.Debug;
import com.ibm.sketch.parser.LocationParseState;
import com.ibm.sketch.parser.ParseException;
import com.ibm.sketch.parser.Parser;
import com.ibm.sketch.parser.XMLSchemaDocumentHandler;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParserImpl
extends AbstractParser
implements Parser {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private XMLSchemaDocumentHandler handler = new XMLSchemaDocumentHandler();
    private LocationParseState locationState;

    public XMLSchemaDocumentHandler getDocumentHandler() {
        return this.handler;
    }

    public LocationParseState getLocationParseState() {
        return this.handler.getLocationParseState();
    }

    public Schema[] parse(InputSource inputSource, LocationParseState locationParseState) throws ParseException, IOException {
        Schema[] schemaArray = null;
        this.setLocationParseState(locationParseState);
        try {
            this.handler.init();
            this.handler.setLocationParseState(locationParseState);
            this.handler.enableParseAllMode();
            XMLReader xMLReader = this.getSAXParser();
            xMLReader.setContentHandler(this.handler);
            xMLReader.parse(inputSource);
            ParserConnectionPool.instance().releaseImpl(xMLReader);
            schemaArray = this.handler.getSchemas();
        }
        catch (SAXException sAXException) {
            if (Debug.DEBUG && sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            }
            if (sAXException.getException() != null) {
                throw new ParseException(sAXException.getException());
            }
            throw new ParseException(sAXException);
        }
        return schemaArray;
    }

    public Schema parse(InputSource inputSource, URI uRI, int n, String string, LocationParseState locationParseState) throws ParseException, IOException {
        Schema schema = null;
        this.setLocationParseState(locationParseState);
        try {
            this.handler.init();
            this.handler.setLocationParseState(locationParseState);
            this.handler.setTopComponentToLookFor(uRI, n, string);
            XMLReader xMLReader = this.getSAXParser();
            xMLReader.setContentHandler(this.handler);
            xMLReader.parse(inputSource);
            ParserConnectionPool.instance().releaseImpl(xMLReader);
            Schema[] schemaArray = this.handler.getSchemas();
            schema = schemaArray == null || schemaArray.length == 0 ? null : schemaArray[0];
        }
        catch (SAXException sAXException) {
            if (Debug.DEBUG) {
                sAXException.printStackTrace(System.err);
                if (sAXException.getException() != null) {
                    sAXException.getException().printStackTrace(System.err);
                }
            }
            if (sAXException.getException() != null) {
                throw new ParseException(sAXException.getException());
            }
            throw new ParseException(sAXException);
        }
        return schema;
    }

    public Schema parse(InputSource inputSource, URI uRI, LocationParseState locationParseState) throws ParseException, IOException {
        Schema schema = null;
        this.setLocationParseState(locationParseState);
        try {
            this.handler.init();
            this.handler.setLocationParseState(locationParseState);
            this.handler.setTargetNamespaceToLookFor(uRI);
            XMLReader xMLReader = this.getSAXParser();
            xMLReader.setContentHandler(this.handler);
            xMLReader.parse(inputSource);
            ParserConnectionPool.instance().releaseImpl(xMLReader);
            Schema[] schemaArray = this.handler.getSchemas();
            schema = schemaArray == null || schemaArray.length == 0 ? null : schemaArray[0];
        }
        catch (SAXException sAXException) {
            if (Debug.DEBUG) {
                sAXException.printStackTrace(System.err);
                if (sAXException.getException() != null) {
                    sAXException.getException().printStackTrace(System.err);
                }
            }
            if (sAXException.getException() != null) {
                throw new ParseException(sAXException.getException());
            }
            throw new ParseException(sAXException);
        }
        return schema;
    }

    public void setLocationParseState(LocationParseState locationParseState) {
        this.locationState = locationParseState;
        this.handler.setLocationParseState(locationParseState);
    }
}

