/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.parser;

import com.ibm.sketch.connection.ParserConnectionPool;
import com.ibm.sketch.parser.Debug;
import com.ibm.sketch.parser.LocationParseState;
import com.ibm.sketch.parser.Parser;
import com.ibm.sketch.parser.S_Dispatcher;
import com.ibm.sketch.parser.SchemaComponent_ElementHandler;
import com.ibm.sketch.parser.SketchErrorHandler;
import com.ibm.sketch.parser.Util;
import com.ibm.xml.ecm.schema.Schema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XMLSchemaData {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int defaultBufferSize = 8192;
    protected String inputString;
    protected long numberOfLines = -1L;
    protected byte[] inputBytes;
    private String systemId;
    private String publicId;
    private ErrorHandler errHandler;
    private SketchErrorHandler sketchErrHandler;
    private String NonValidatingSAXParserClassName;
    private boolean isXMLSchema = false;
    private LocationParseState locState;
    private Parser parser;
    private Schema equivalentSchema;
    private String encoding;
    private String schemaNS;

    public XMLSchemaData() {
    }

    public XMLSchemaData(InputSource inputSource, ErrorHandler errorHandler, SketchErrorHandler sketchErrorHandler) throws IOException, SAXException {
        this.systemId = inputSource.getSystemId();
        this.publicId = inputSource.getPublicId();
        this.errHandler = errorHandler;
        this.sketchErrHandler = sketchErrorHandler;
        this.encoding = inputSource.getEncoding();
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            int n;
            StringWriter stringWriter = new StringWriter();
            while ((n = reader.read()) != -1) {
                stringWriter.write(n);
            }
            this.inputString = stringWriter.toString();
        } else {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream == null && inputSource.getSystemId() != null) {
                inputStream = new URL(inputSource.getSystemId()).openStream();
            }
            if (inputStream != null) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                this.inputBytes = byteArrayOutputStream.toByteArray();
            }
        }
        this.checkForRootSchema();
    }

    private void checkForRootSchema() throws SAXException, IOException {
        XMLReader xMLReader = this.createParser();
        try {
            block6: {
                try {
                    xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    if (Debug.DEBUG) {
                        sAXNotRecognizedException.printStackTrace(System.err);
                    }
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    if (!Debug.DEBUG) break block6;
                    sAXNotSupportedException.printStackTrace(System.err);
                }
            }
            xMLReader.setErrorHandler(this.errHandler);
            xMLReader.setContentHandler(new SchemaTargetNamespaceFinder());
            xMLReader.parse(this.getInputSource());
            this.encoding = ((ParserConnectionPool.SAXParserImpl)xMLReader).getEncoding();
            Object var5_4 = null;
            ParserConnectionPool.instance().releaseImpl(xMLReader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ParserConnectionPool.instance().releaseImpl(xMLReader);
            throw throwable;
        }
    }

    private XMLReader createParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader xMLReader;
        block7: {
            try {
                xMLReader = ParserConnectionPool.instance().acquireImpl();
            }
            catch (Exception exception) {
                System.err.println("WARNING : cannot load the SAX Parser specified by the user due to the following error");
                System.err.println(exception.getMessage());
                if (Debug.DEBUG) {
                    exception.printStackTrace(System.err);
                }
                xMLReader = ParserConnectionPool.instance().acquireImpl();
            }
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", false);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (Debug.DEBUG) {
                    sAXNotRecognizedException.printStackTrace(System.err);
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!Debug.DEBUG) break block7;
                sAXNotSupportedException.printStackTrace(System.err);
            }
        }
        return xMLReader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Schema getEquivalentSchema() {
        return this.equivalentSchema;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public InputSource getInputSource() {
        InputSource inputSource = null;
        inputSource = this.inputString != null ? new InputSource(new StringReader(this.inputString)) : (this.inputBytes != null ? new InputSource(new ByteArrayInputStream(this.inputBytes)) : new InputSource());
        if (this.systemId != null) {
            inputSource.setSystemId(this.systemId);
        }
        if (this.publicId != null) {
            inputSource.setPublicId(this.publicId);
        }
        return inputSource;
    }

    public LocationParseState getLocationParseState() {
        return this.locState;
    }

    public String getNonValidatingSAXParserClass() {
        return this.NonValidatingSAXParserClassName;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSchemaNS() {
        return this.schemaNS;
    }

    public SketchErrorHandler getSketchErrorHandler() {
        return this.sketchErrHandler;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean isXMLSchema() {
        return this.isXMLSchema;
    }

    public static void main(String[] stringArray) throws Exception {
    }

    public void setEquivalentSchema(Schema schema) {
        this.equivalentSchema = schema;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    public void setLocationParseState(LocationParseState locationParseState) {
        this.locState = locationParseState;
    }

    public void setNonValidatingSAXParserClass(String string) {
        this.NonValidatingSAXParserClassName = string;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    void setSchemaNS(String string) {
        this.schemaNS = string;
    }

    public void setSketchErrorHandler(SketchErrorHandler sketchErrorHandler) {
        this.sketchErrHandler = sketchErrorHandler;
    }

    public long getNumberOfLines() {
        block6: {
            if (this.numberOfLines >= 0L) break block6;
            this.numberOfLines = 1L;
            if (this.inputString != null) {
                int n = 0;
                while (n < this.inputString.length()) {
                    if (this.inputString.charAt(n) == '\n') {
                        ++this.numberOfLines;
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.inputBytes.length) {
                    if (this.inputBytes[n] == 10) {
                        ++this.numberOfLines;
                    }
                    ++n;
                }
            }
        }
        return this.numberOfLines;
    }

    private class SchemaTargetNamespaceFinder
    extends S_Dispatcher {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private SchemaTargetNamespaceFinder() {
        }

        protected void beforeChangingCurrentTopElementElementHandler(SchemaComponent_ElementHandler schemaComponent_ElementHandler) throws SAXException {
        }

        protected Enumeration getAllTopElementElementHandlers() {
            return new Vector().elements();
        }

        protected SchemaComponent_ElementHandler getTopElementElementHandler(String string, String string2, String string3, Attributes attributes) {
            return null;
        }

        private boolean isSchemaNS(String string) {
            return Util.isSchemaNS(string);
        }

        protected void mainCharacters(char[] cArray, int n, int n2) throws SAXException {
        }

        protected void mainEndElement(String string, String string2, String string3) throws SAXException {
        }

        protected void mainEndPrefixMapping(String string) {
        }

        protected void mainIgnorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        protected void mainProcessingInstruction(String string, String string2) throws SAXException {
        }

        protected void mainSkippedEntity(String string) {
        }

        protected void mainStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string2.equals("schema")) {
                return;
            }
            XMLSchemaData.this.schemaNS = string;
            if (!this.isSchemaNS(string)) {
                return;
            }
            XMLSchemaData.this.isXMLSchema = true;
        }

        public void mainStartPrefixMapping(String string, String string2) {
        }
    }
}

