/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DOMBuilder
implements ContentHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable namespaceDeclarations;
    protected Node fCurrentNode = null;
    protected Stack fNodeStack = new Stack();
    protected Document fDocument;
    protected boolean fWithinElement = false;

    public DOMBuilder(Document document) {
        this.fDocument = document;
        this.fCurrentNode = document;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Text text = null;
        if (this.fWithinElement && this.fCurrentNode.getNodeType() == 3 && this.fCurrentNode.getParentNode().getNodeType() == 1) {
            ((Text)this.fCurrentNode).appendData(new String(cArray, n, n2));
            return;
        }
        if (this.fWithinElement) {
            text = this.fDocument.createTextNode(new String(cArray, n, n2));
        }
        if (text == null) {
            return;
        }
        this.fCurrentNode.appendChild(text);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.fCurrentNode = (Node)this.fNodeStack.pop();
        this.fWithinElement = false;
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    private Hashtable getNamespaceDeclarations() {
        if (this.namespaceDeclarations == null) {
            this.namespaceDeclarations = new Hashtable();
        }
        return this.namespaceDeclarations;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, string2);
        this.fCurrentNode.appendChild(processingInstruction);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        this.fNodeStack.push(this.fCurrentNode);
        Element element = string.equals("") && !string2.equals(string3) ? this.fDocument.createElement(string3) : this.fDocument.createElementNS(string, string3);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = attributes.getURI(n2);
            if (object == null || ((String)object).equals("")) {
                element.setAttribute(attributes.getQName(n2), attributes.getValue(n2));
            } else {
                element.setAttributeNS((String)object, attributes.getQName(n2), attributes.getValue(n2));
            }
            ++n2;
        }
        this.fCurrentNode.appendChild(element);
        this.fCurrentNode = element;
        this.fWithinElement = true;
        object = this.getNamespaceDeclarations();
        Enumeration enumeration = ((Hashtable)object).keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string4.equals("")) {
                element.setAttribute("xmlns", (String)((Hashtable)object).get(string4));
                continue;
            }
            element.setAttribute("xmlns:" + string4, (String)((Hashtable)object).get(string4));
        }
        ((Hashtable)object).clear();
    }

    public final void startPrefixMapping(String string, String string2) throws SAXException {
        this.getNamespaceDeclarations().put(string, string2);
    }
}

