/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser;

import com.ibm.sketch.parser.ElementItemHeader;
import com.ibm.sketch.parser.FindATopComponent;
import com.ibm.sketch.parser.SchemaForParser;
import com.ibm.sketch.parser.SchemaPartiallyParsed_ElementHandler;
import com.ibm.sketch.parser.SchemaTags;
import com.ibm.sketch.parser.SketchErrorHandler;
import com.ibm.sketch.parser.XMLSchemaData;
import com.ibm.sketch.parser.XMLSchemaDocumentHandler;
import com.ibm.sketch.schemaparser.Debug;
import com.ibm.sketch.schemaparser.TopComponent_ElementHandler;
import com.ibm.sketch.util.ComparatorForEquality;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.ImportStatement;
import com.ibm.xml.ecm.schema.NamespaceDeclaration;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.io.IOException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class SchemaForParserImpl
extends SchemaImpl
implements SchemaForParser {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static boolean DEBUG = false;
    protected boolean parsingCompleted = false;
    Hashtable prefixes = new Hashtable();
    protected String location;
    protected XMLSchemaData schemaData;
    protected TreeSet notDefinedTopComponents = new TreeSet();
    private boolean processingResources = false;
    private boolean allResourcesProcessed = false;
    private static EltItemComparator comparator = new EltItemComparator();
    private TreeSet elementItemsAlreadyRead = new TreeSet();
    public static final String XMLSchema4SchemaNamespaceUsedAtParseTime = "http://www.w3.org/2001/XMLSchema";
    private SchemaImpl schemaUsedForReferenceResolution;
    protected Object docParseID = this;
    protected int numberOfForwardRefs = 0;
    private Hashtable importWithoutPrefix = new Hashtable();

    public void addElementItem(ElementItemHeader elementItemHeader) {
        this.elementItemsAlreadyRead.add(elementItemHeader);
    }

    public void addImportStatement(ImportStatement importStatement) {
        NamespaceDeclaration[] namespaceDeclarationArray;
        if (!(this.parsingCompleted || (namespaceDeclarationArray = this.getNamespaceDeclaration(importStatement.getExplicitTargetNamespace())) != null && namespaceDeclarationArray.length != 0)) {
            Locator locator = this.getLocator();
            if (locator != null) {
                locator = new LocatorImpl(locator);
            }
            this.addImportWithoutNamespacePrefix(importStatement, locator);
        }
        super.addImportStatement(importStatement);
    }

    void addImportWithoutNamespacePrefix(ImportStatement importStatement, Locator locator) {
        URI uRI = importStatement.getExplicitTargetNamespace();
        if (uRI == null) {
            return;
        }
        Vector<ImportStatement_Locator_Pair> vector = (Vector<ImportStatement_Locator_Pair>)this.importWithoutPrefix.get(uRI);
        if (vector == null) {
            vector = new Vector<ImportStatement_Locator_Pair>();
            this.importWithoutPrefix.put(uRI, vector);
        }
        vector.add(new ImportStatement_Locator_Pair(importStatement, locator));
    }

    public void addTopComponent(TopComponent topComponent) {
        super.addTopComponent(topComponent);
    }

    public boolean areAllResourcesProcessed() {
        return this.allResourcesProcessed;
    }

    public FindATopComponent createTopComponentDocumentHandler(SketchErrorHandler sketchErrorHandler, SchemaForParserImpl schemaForParserImpl, int n, String string) {
        return new TopComponentFinder(sketchErrorHandler, schemaForParserImpl, n, string);
    }

    public String getEquivalentPrefix(String string) {
        return (String)this.prefixes.get(string);
    }

    ImportStatement_Locator_Pair[] getImportWithoutNamespacePrefix() {
        Enumeration enumeration = this.importWithoutPrefix.elements();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addAll((Vector)enumeration.nextElement());
        }
        return vector.toArray(new ImportStatement_Locator_Pair[vector.size()]);
    }

    protected String getSchemaDocumentURL(String string) {
        int n = string.length();
        if (n < 8) {
            return null;
        }
        int n2 = string.indexOf(".xmi", n - 4);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(0, n - 4);
        n2 = string2.indexOf(".xsd", n - 8);
        if (n2 == -1) {
            return null;
        }
        return string2;
    }

    public SchemaImpl getSchemaUsedForReferenceResolution() {
        return this.schemaUsedForReferenceResolution;
    }

    public TopComponent getTopComponent(Stack stack, int n, String string, boolean bl, boolean bl2) {
        if (this.schemaUsedForReferenceResolution != null) {
            return this.schemaUsedForReferenceResolution.getTopComponent(stack, n, string, bl, bl2);
        }
        if (stack.contains(this)) {
            return null;
        }
        try {
            TopComponent topComponent = this.getExplicitlyDefinedTopComponent(n, string, bl2);
            if (topComponent != null) {
                return topComponent;
            }
            if (!bl && (this.isParsingCompleted() || this.isAlreadyRead_WhithoutLocationInfo(new ElementItemHeader(SchemaTags.getTopComponentTagName(n), string, 0, 0)))) {
                return topComponent;
            }
            if (Debug.DEBUG) {
                System.out.println("Ref ComponentType = " + n + " NCName = " + string);
            }
            topComponent = this.resolveForwardReference(n, string);
            if (Debug.DEBUG) {
                System.err.println("TopComponent found " + topComponent);
            }
            if (topComponent != null) {
                return topComponent;
            }
            if (Debug.DEBUG) {
                System.err.println("TopComponent not found in current schema type = " + n + " name= " + string);
            }
            if (bl) {
                stack.push(this);
                topComponent = this.getIncludedOrRedefinedTopComponent(stack, n, string, bl2);
                stack.pop();
            }
            return topComponent;
        }
        catch (SAXException sAXException) {
            if (Debug.DEBUG) {
                sAXException.getException().printStackTrace(System.err);
            }
            return null;
        }
        catch (IOException iOException) {
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            return null;
        }
    }

    public XMLSchemaData getXMLSchemaData() {
        return this.schemaData;
    }

    public boolean isAlreadyRead(ElementItemHeader elementItemHeader) {
        return this.elementItemsAlreadyRead.contains(elementItemHeader);
    }

    public boolean isAlreadyRead_WhithoutLocationInfo(ElementItemHeader elementItemHeader) {
        Iterator iterator = this.elementItemsAlreadyRead.iterator();
        while (iterator.hasNext()) {
            int n = comparator.compare((ElementItemHeader)iterator.next(), elementItemHeader);
            if (n == 0) {
                return true;
            }
            if (n <= 0) continue;
            return false;
        }
        return false;
    }

    public boolean isParsingCompleted() {
        return this.parsingCompleted;
    }

    public boolean isProcessingResources() {
        return this.processingResources;
    }

    protected boolean isSchemaDocumentURL(String string) {
        int n = string.length();
        if (n < 4) {
            return false;
        }
        return string.indexOf(".xsd", n - 4) != -1;
    }

    public static void main(String[] stringArray) {
        System.out.println(new Vector().toArray());
    }

    public void makeAllResourcesProcessed(boolean bl) {
        this.allResourcesProcessed = bl;
    }

    public void makeParsingCompleted(boolean bl) {
        this.parsingCompleted = bl;
        if (bl) {
            this.schemaData = null;
            this.notDefinedTopComponents.clear();
            this.importWithoutPrefix.clear();
        }
    }

    public void makeProcessingResources(boolean bl) {
        this.processingResources = bl;
    }

    public void removeEquivalentPrefix(String string) {
        this.prefixes.remove(string);
    }

    void removeImportWithoutNamespacePrefix(URI uRI) {
        URI uRI2 = uRI;
        if (uRI2 == null) {
            return;
        }
        this.importWithoutPrefix.remove(uRI2);
    }

    protected TopComponent resolveForwardReference(int n, String string) throws SAXException, IOException {
        if (this.notDefinedTopComponents.contains(new String(n + ":" + string))) {
            return null;
        }
        TopComponent topComponent = this.schemaData == null || this.schemaData.getEquivalentSchema() == null ? null : this.schemaData.getEquivalentSchema().getTopComponent(n, string, false);
        if (topComponent == null) {
            this.notDefinedTopComponents.add(new String(n + ":" + string));
        }
        return topComponent;
    }

    public void setEquivalentPrefix(String string, String string2) {
        this.prefixes.put(string2, string);
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setSchemaUsedForReferenceResolution(SchemaImpl schemaImpl) {
        this.schemaUsedForReferenceResolution = schemaImpl == null ? schemaImpl : schemaImpl;
    }

    public void setXMLSchemaData(XMLSchemaData xMLSchemaData) {
        this.schemaData = xMLSchemaData;
    }

    public void validationCompleted() {
        this.schemaData = null;
        this.notDefinedTopComponents = null;
    }

    public Object getDocParseID() {
        return this.docParseID;
    }

    void setDocParseID(Object object) {
        this.docParseID = object;
    }

    static class ImportStatement_Locator_Pair {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private ImportStatement importS;
        private Locator locator;

        public ImportStatement_Locator_Pair(ImportStatement importStatement, Locator locator) {
            this.importS = importStatement;
            this.locator = locator;
        }

        public ImportStatement getImport() {
            return this.importS;
        }

        public Locator getLocator() {
            return this.locator;
        }
    }

    private class TopComponentFinder
    extends XMLSchemaDocumentHandler
    implements FindATopComponent {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private FindATopComponent delegee;

        private TopComponentFinder(SketchErrorHandler sketchErrorHandler, SchemaForParser schemaForParser, int n, String string) {
            try {
                FactoryImpl factoryImpl = (FactoryImpl)FactoryImpl.instance();
                this.delegee = new TopComponent_ElementHandler(schemaForParser, n, string);
                this.setSchema_ElementHandlerForPartialParse(factoryImpl.createURI(SchemaForParserImpl.XMLSchema4SchemaNamespaceUsedAtParseTime), "schema", (SchemaPartiallyParsed_ElementHandler)((Object)this.delegee));
                this.setTopComponentToLookFor(schemaForParser.getTargetNamespace(), n, string);
            }
            catch (DatatypeFormatException datatypeFormatException) {
                datatypeFormatException.printStackTrace();
                throw new RuntimeException("UnExcepted Error :" + datatypeFormatException.getMessage());
            }
        }

        protected void setDefaultSchema_ElementHandler() {
        }

        public TopComponent getTopComponent() {
            return this.delegee.getTopComponent();
        }

        public Locator getLocator() {
            return this.delegee.getLocator();
        }
    }

    private static class EltItemComparator
    implements Comparator,
    ComparatorForEquality {
        private EltItemComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.toString((ElementItemHeader)object).compareTo(this.toString((ElementItemHeader)object2));
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object2) == 0;
        }

        private String toString(ElementItemHeader elementItemHeader) {
            return elementItemHeader.getTagName() + ":" + elementItemHeader.getNCName();
        }
    }
}

