/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser;

import com.ibm.sketch.parser.MultiplyDefinedException;
import com.ibm.sketch.parser.MultiplyDefinedFacetException;
import com.ibm.sketch.parser.MutuallyExclusiveValueForAnAttrException;
import com.ibm.sketch.parser.SchemaComponent_ElementHandler;
import com.ibm.sketch.parser.SchemaForParser;
import com.ibm.sketch.parser.SketchErrorHandler;
import com.ibm.sketch.parser.SketchSAXParseException;
import com.ibm.sketch.schemaparser.Debug;
import com.ibm.sketch.schemaparser.DuplicateNamesInWildcardConsideringTNSException;
import com.ibm.sketch.schemaparser.LocalComponent_ElementHandler;
import com.ibm.sketch.schemaparser.NamespaceNotAllowedInWildcardException;
import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ComplexTypeRef;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.DatatypeFormatException;
import com.ibm.xml.ecm.schema.DatatypeRef;
import com.ibm.xml.ecm.schema.DatatypeSpec;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.Facet;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.KeyRef;
import com.ibm.xml.ecm.schema.MalformedURIExceptionForSQC;
import com.ibm.xml.ecm.schema.MultipleInheritanceForbiddenException;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SimpleTypeDerivedFromComplexTypeException;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.TypeRef;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeDefImpl;
import com.ibm.xml.ecm.schema.impl.DatatypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.DoubleLiteral;
import com.ibm.xml.ecm.schema.impl.FloatLiteral;
import com.ibm.xml.ecm.schema.impl.KeyRefResolver_Checker;
import com.ibm.xml.ecm.schema.impl.ParticleValidOccurs_Checker;
import com.ibm.xml.ecm.schema.impl.ReferenceResolver_Checker;
import com.ibm.xml.ecm.schema.impl.URIImpl;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

class Util {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void addUsedtype(DatatypeSpec datatypeSpec, String string, SchemaForParser schemaForParser, Factory factory) {
        string = Util.preProcessReference(schemaForParser, string);
        DatatypeRef datatypeRef = factory.createDatatypeRef(string);
        try {
            datatypeSpec.addUsedtype(datatypeRef);
        }
        catch (MultipleInheritanceForbiddenException multipleInheritanceForbiddenException) {
            return;
        }
        try {
            if (CheckerManagerImpl.getInstance().getMaxCost() > 2) {
                datatypeRef.resolve(false);
            }
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            try {
                String string2 = Util.preProcessReference(schemaForParser, string);
                ComplexTypeRef complexTypeRef = factory.createComplexTypeRef(string);
                complexTypeRef.setParent(datatypeSpec);
                complexTypeRef.resolve(false);
                SimpleTypeDerivedFromComplexTypeException simpleTypeDerivedFromComplexTypeException = new SimpleTypeDerivedFromComplexTypeException(datatypeSpec, complexTypeRef);
                datatypeSpec.getInvalidStateHandler().action(datatypeSpec, new SchemaException[]{simpleTypeDerivedFromComplexTypeException});
            }
            catch (ReferenceResolutionException referenceResolutionException2) {
                if (Debug.DEBUG) {
                    referenceResolutionException2.printStackTrace(System.err);
                }
                datatypeRef.getInvalidStateHandler().action(datatypeRef, new SchemaException[]{referenceResolutionException});
            }
        }
    }

    public static void checkReference(KeyRef keyRef) {
        com.ibm.sketch.parser.Util.runChecker(keyRef, new KeyRefResolver_Checker(keyRef));
    }

    public static void checkReference(Reference reference) {
        com.ibm.sketch.parser.Util.runChecker(reference, new ReferenceResolver_Checker(reference));
    }

    public static int getContentTypeCategory(String string) {
        if (string.equals("empty")) {
            return 1;
        }
        if (string.equals("elementOnly")) {
            return 4;
        }
        if (string.equals("mixed")) {
            return 3;
        }
        if (string.equals("textOnly")) {
            return 2;
        }
        return -1;
    }

    public static int getDerivationType(String string) {
        if (string.equals("restriction")) {
            return 0;
        }
        if (string.equals("extension")) {
            return 1;
        }
        if (string.equals("list")) {
            return 2;
        }
        return -1;
    }

    public static int getProcessContentsCategory(String string) {
        if (string.equals("lax")) {
            return 2;
        }
        if (string.equals("skip")) {
            return 1;
        }
        if (string.equals("strict")) {
            return 0;
        }
        return -1;
    }

    public static int getWildcardCategory(LocalComponent_ElementHandler localComponent_ElementHandler, String string, String string2, Vector vector, Factory factory) {
        int n;
        if (string.trim().equals("##any")) {
            n = 0;
        } else if (string.trim().equals("##other")) {
            n = 1;
        } else {
            SchemaForParser schemaForParser;
            Object object;
            Object object2;
            Object object3;
            Object[][] objectArray;
            n = 3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f", false);
            int n2 = stringTokenizer.countTokens();
            Object[] objectArray2 = new String[n2];
            int n3 = 0;
            boolean bl = false;
            boolean bl2 = false;
            while (stringTokenizer.hasMoreTokens()) {
                Exception exception;
                objectArray = stringTokenizer.nextToken();
                objectArray2[n3++] = objectArray;
                if (objectArray.equals("##targetNamespace")) {
                    n = 4;
                    continue;
                }
                if (objectArray.equals("##local")) {
                    vector.add(null);
                    continue;
                }
                if (objectArray.equals("##any")) {
                    bl2 = true;
                    exception = null;
                    if (vector.size() > 0) {
                        exception = new NamespaceNotAllowedInWildcardException(string2);
                    } else if (n == 4) {
                        exception = new MutuallyExclusiveValueForAnAttrException(string2, "namespace", new String[]{"##any", "##targetNamespace"});
                    } else if (bl) {
                        exception = new MutuallyExclusiveValueForAnAttrException(string2, "namespace", new String[]{"##any", "##other"});
                    }
                    if (exception == null || localComponent_ElementHandler.getErrHandler() == null) continue;
                    object3 = localComponent_ElementHandler.getErrHandler();
                    object3.error(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), exception, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                    continue;
                }
                if (objectArray.equals("##other")) {
                    bl = true;
                    exception = null;
                    if (vector.size() > 0) {
                        exception = new NamespaceNotAllowedInWildcardException(string2);
                    } else if (n == 4) {
                        exception = new MutuallyExclusiveValueForAnAttrException(string2, "namespace", new String[]{"##other", "##targetNamespace"});
                    } else if (bl2) {
                        exception = new MutuallyExclusiveValueForAnAttrException(string2, "namespace", new String[]{"##other", "##any"});
                    }
                    if (exception == null || localComponent_ElementHandler.getErrHandler() == null) continue;
                    object3 = localComponent_ElementHandler.getErrHandler();
                    object3.error(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), exception, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                    continue;
                }
                exception = URIImpl.isValidAbsoluteURI((String)objectArray);
                object3 = null;
                if (exception != null) {
                    if (!URIImpl.isValidURI((String)objectArray)) {
                        object3 = new MalformedURIExceptionForSQC((String)objectArray, false);
                        if (localComponent_ElementHandler != null && localComponent_ElementHandler.getErrHandler() != null) {
                            object2 = localComponent_ElementHandler.getErrHandler();
                            object2.error(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), (Exception)object3, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                        }
                    } else if (!CheckerManagerImpl.getInstance().noWarning(CheckerManagerImpl.NO_WARNING_URI_OMITS_SCHEME)) {
                        object3 = new MalformedURIExceptionForSQC((String)objectArray, true, exception);
                        ((SchemaException)object3).setSchemaExceptionType(1);
                        if (localComponent_ElementHandler != null && localComponent_ElementHandler.getErrHandler() != null) {
                            object2 = localComponent_ElementHandler.getErrHandler();
                            object2.warning(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), (Exception)object3, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                        }
                    }
                }
                if (bl || bl2) {
                    object2 = new NamespaceNotAllowedInWildcardException(string2);
                    if (localComponent_ElementHandler != null && localComponent_ElementHandler.getErrHandler() != null) {
                        object = localComponent_ElementHandler.getErrHandler();
                        object.error(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), (Exception)object2, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                    }
                }
                object2 = factory.createURI();
                object2.setValue((String)objectArray);
                vector.add(object2);
            }
            Arrays.sort(objectArray2);
            objectArray = DuplicationFinder.getDuplicationsInAnOrderedArray((Comparable[])objectArray2);
            if (objectArray != null) {
                int n4 = 0;
                while (n4 < objectArray.length) {
                    object3 = new MultiplyDefinedException((String)objectArray[n4][0]);
                    object2 = localComponent_ElementHandler.getErrHandler();
                    object2.warning(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), (Exception)object3, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
                    ++n4;
                }
            }
            if (n == 4 && (schemaForParser = localComponent_ElementHandler.getSchema()) != null && vector.contains(object3 = schemaForParser.getTargetNamespace())) {
                object2 = object3 == null ? null : object3.toString();
                object = new DuplicateNamesInWildcardConsideringTNSException((String)object2);
                SketchErrorHandler sketchErrorHandler = localComponent_ElementHandler.getErrHandler();
                sketchErrorHandler.warning(new SketchSAXParseException(null, localComponent_ElementHandler.getLocator(), (Exception)object, localComponent_ElementHandler.getPath(), localComponent_ElementHandler.getCurrentNode()));
            }
        }
        return n;
    }

    static Group minimalize(Group group) {
        Particle[] particleArray;
        if (group.getMaxOccurs().equals("1") && group.getMinOccurs().equals("1") && (particleArray = group.listParticle()) != null && particleArray.length == 1 && particleArray[0].isGroup()) {
            group.removeParticle(particleArray[0]);
            return particleArray[0].asGroup();
        }
        return group;
    }

    static Particle minimalizeAtTheExtreme(Group group) {
        Particle[] particleArray;
        if (group.getMaxOccurs().equals("1") && group.getMinOccurs().equals("1") && (particleArray = group.listParticle()) != null && particleArray.length == 1 && particleArray[0].isGroup()) {
            group.removeParticle(particleArray[0]);
            return particleArray[0];
        }
        return group;
    }

    public static String preProcessReference(SchemaForParser schemaForParser, String string) {
        return string;
    }

    public static void setBasetype(ComplexType complexType, String string, SchemaForParser schemaForParser, Factory factory) {
        string = Util.preProcessReference(schemaForParser, string);
        TypeRef typeRef = factory.createTypeRef(string);
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        int n = checkerManagerImpl.getMaxCost();
        checkerManagerImpl.setMaxCost(-1);
        try {
            complexType.setBasetype(typeRef);
            Object var8_7 = null;
            checkerManagerImpl.setMaxCost(n);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            checkerManagerImpl.setMaxCost(n);
            throw throwable;
        }
        Util.checkReference(typeRef);
    }

    public static TypeRef setExplicitTypeRef(ElementDecl elementDecl, Factory factory, SchemaForParser schemaForParser, String string) {
        string = Util.preProcessReference(schemaForParser, string);
        TypeRef typeRef = factory.createTypeRef(string);
        CheckerManagerImpl.getInstance().enableInteractiveMode(false);
        elementDecl.setExplicitType(typeRef);
        CheckerManagerImpl.getInstance().enableInteractiveMode(true);
        Util.checkReference(typeRef);
        return typeRef;
    }

    public static void setFacet(Type type, Facet facet, SchemaComponent_ElementHandler schemaComponent_ElementHandler) {
        Object[] objectArray = facet.getValuesAsString();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        switch (facet.getFacetType()) {
            case 5: 
            case 6: {
                String[] stringArray;
                Object object;
                Facet facet2 = type.getFacetDefinedHere(facet.getFacetType());
                Object[] objectArray2 = null;
                if (facet.getFacetType() == 5) {
                    if (facet2 != null) {
                        objectArray2 = facet2.getValuesAsString();
                    }
                    objectArray = facet.getValuesAsString();
                } else {
                    try {
                        ContentType contentType;
                        int n;
                        String[] stringArray2;
                        object = null;
                        if (type.isSimpleType()) {
                            object = (Object[])type;
                        } else {
                            stringArray2 = CheckerManagerImpl.getInstance();
                            n = stringArray2.getMaxCost();
                            stringArray2.setMaxCost(-1);
                            try {
                                contentType = ((ComplexType)type).getEffectiveContentType();
                                stringArray = null;
                                stringArray2.setMaxCost(n);
                            }
                            catch (Throwable throwable) {
                                Object var11_17 = null;
                                stringArray2.setMaxCost(n);
                                throw throwable;
                            }
                            if (contentType != null && contentType.isSimpleType()) {
                                object = contentType.asSimpleType();
                            }
                        }
                        if (object != null) {
                            contentType = null;
                            if (object instanceof DatatypeDefImpl) {
                                contentType = (DatatypeSpecImpl)((DatatypeDefImpl)object).getDatatypeSpec();
                            } else if (object instanceof DatatypeSpecImpl) {
                                contentType = (DatatypeSpecImpl)object;
                            }
                            if (contentType != null) {
                                stringArray2 = null;
                                if (facet2 != null) {
                                    stringArray2 = facet2.getValuesAsString();
                                }
                                if (stringArray2 != null) {
                                    objectArray2 = new Object[stringArray2.length];
                                    n = 0;
                                    while (n < stringArray2.length) {
                                        objectArray2[n] = ((DatatypeSpecImpl)contentType).convert(stringArray2[n]);
                                        ++n;
                                    }
                                }
                                if ((stringArray2 = facet.getValuesAsString()) != null) {
                                    objectArray = new Object[stringArray2.length];
                                    n = 0;
                                    while (n < stringArray2.length) {
                                        objectArray[n] = ((DatatypeSpecImpl)contentType).convert(stringArray2[n]);
                                        Exception exception = null;
                                        if (objectArray[n] instanceof DoubleLiteral) {
                                            exception = ((DoubleLiteral)objectArray[n]).getWarning();
                                        } else if (objectArray[n] instanceof FloatLiteral) {
                                            exception = ((FloatLiteral)objectArray[n]).getWarning();
                                        }
                                        if (exception != null && schemaComponent_ElementHandler.getSketchErrorHandler() != null) {
                                            schemaComponent_ElementHandler.getSketchErrorHandler().warning(new SketchSAXParseException(null, schemaComponent_ElementHandler.getLocator(), exception, null, null));
                                        }
                                        ++n;
                                    }
                                }
                            }
                        }
                    }
                    catch (SchemaException schemaException) {
                        objectArray2 = null;
                        objectArray = null;
                    }
                    if (objectArray2 == null && facet2 != null) {
                        objectArray2 = facet2.getValuesAsString();
                    }
                    if (objectArray == null) {
                        objectArray = facet.getValuesAsString();
                    }
                }
                if (objectArray2 == null || objectArray2.length == 0) {
                    type.setFacet(facet.getFacetType(), facet.getValuesAsString());
                    break;
                }
                object = new Object[objectArray.length + objectArray2.length];
                int n = 0;
                while (n < objectArray2.length) {
                    object[n] = objectArray2[n];
                    ++n;
                }
                int n2 = 0;
                while (n2 < objectArray.length) {
                    object[n + n2] = objectArray[n2];
                    ++n2;
                }
                if (facet2 != null) {
                    type.removeFacet(facet2);
                }
                type.setFacet(facet.getFacetType(), facet.getValuesAsString());
                CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
                int n3 = checkerManagerImpl.getMaxCost();
                checkerManagerImpl.setMaxCost(-1);
                try {
                    stringArray = null;
                    if (object != null) {
                        stringArray = new String[((Object[])object).length];
                        int n4 = 0;
                        while (n4 < ((Object[])object).length) {
                            stringArray[n4] = object[n4].toString();
                            ++n4;
                        }
                    }
                    type.setFacet(facet.getFacetType(), stringArray);
                    Object var14_22 = null;
                    checkerManagerImpl.setMaxCost(n3);
                    break;
                }
                catch (Throwable throwable) {
                    Object var14_23 = null;
                    checkerManagerImpl.setMaxCost(n3);
                    throw throwable;
                }
            }
            case 0: {
                break;
            }
            default: {
                Object object;
                Facet facet3 = type.getFacetDefinedHere(facet.getFacetType());
                if (facet3 != null) {
                    object = new MultiplyDefinedFacetException(facet.getFacetTypeAsString());
                    if (schemaComponent_ElementHandler.getSketchErrorHandler() != null) {
                        schemaComponent_ElementHandler.getSketchErrorHandler().error(new SketchSAXParseException(null, schemaComponent_ElementHandler.getLocator(), (Exception)object, null, null));
                    }
                    type.removeFacet(facet3);
                }
                type.setFacet(facet.getFacetType(), facet.getValuesAsString());
                if (!facet.isFixed()) break;
                object = type.getFacetDefinedHere(facet.getFacetType());
                object.setFixed(true);
            }
        }
    }

    public static void setOccurs(SchemaComponent_ElementHandler schemaComponent_ElementHandler, Particle particle, String string, String string2) {
        SketchErrorHandler sketchErrorHandler = schemaComponent_ElementHandler.getSketchErrorHandler();
        CheckerManagerImpl.getInstance().enableCheckType(ParticleValidOccurs_Checker.ID, false);
        try {
            if (string2 != null && particle != null) {
                particle.setMaxOccurs(string2);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {
            sketchErrorHandler.error(new SketchSAXParseException(null, schemaComponent_ElementHandler.getLocator(), datatypeFormatException, schemaComponent_ElementHandler.getPath(), schemaComponent_ElementHandler.getCurrentNode()));
        }
        try {
            if (string != null && particle != null) {
                particle.setMinOccurs(string);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {
            sketchErrorHandler.error(new SketchSAXParseException(null, schemaComponent_ElementHandler.getLocator(), datatypeFormatException, schemaComponent_ElementHandler.getPath(), schemaComponent_ElementHandler.getCurrentNode()));
        }
        CheckerManagerImpl.getInstance().enableCheckType(ParticleValidOccurs_Checker.ID, true);
        com.ibm.sketch.parser.Util.runChecker(particle, new ParticleValidOccurs_Checker(particle));
    }
}

