/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser;

import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.graph.VertexImpl;
import com.ibm.sketch.parser.DispatcherForEmbeddedComponents;
import com.ibm.sketch.parser.Util;
import com.ibm.sketch.schemaparser.Debug;
import com.ibm.sketch.schemaparser.SchemaDocumentHandler;
import com.ibm.sketch.schemaparser.SchemaForParserImpl;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.schemaparser.composition.GraphBuilderForEmbeddedSchemas;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import java.net.MalformedURLException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSDParserForEmbeddedSchemas
extends XSDParserImpl {
    public XSDParserForEmbeddedSchemas() {
        this.setValidationAgainstSchemaForSchema(true);
    }

    public XSDParserForEmbeddedSchemas(String string, String string2) {
        super(string, string2);
        this.setValidationAgainstSchemaForSchema(true);
    }

    public GraphImpl buildGraph(InputSource inputSource) {
        URI uRI = this.getLocation(inputSource);
        try {
            return GraphBuilderForEmbeddedSchemas.buildGraph(uRI);
        }
        catch (MalformedURLException malformedURLException) {
            if (Debug.DEBUG) {
                malformedURLException.printStackTrace(System.err);
            }
            return null;
        }
    }

    protected VertexImpl[] getRoots(URI uRI) throws MalformedURLException {
        return GraphBuilderForEmbeddedSchemas.getRoots(this.graphImpl, uRI);
    }

    protected boolean readASpecificNamespace(VertexImpl vertexImpl) {
        return true;
    }

    protected URI getTargetNamespaceToRead(VertexImpl vertexImpl) {
        return ((GraphBuilderForEmbeddedSchemas.ExtendedLocation)vertexImpl.getObject()).getTargetNamespace();
    }

    protected XSDParserImpl.MultiSchemaDocumentHandler getMultiSchemaDocumentHandler(SchemaDocumentHandler schemaDocumentHandler) {
        schemaDocumentHandler.setEmbeddedSchemas(true);
        return new SchemaDocumentHandlerWrapper(schemaDocumentHandler);
    }

    protected boolean acceptEmbeddedSchema() {
        return true;
    }

    protected class SchemaDocumentHandlerWrapper
    extends DispatcherForEmbeddedComponents
    implements XSDParserImpl.MultiSchemaDocumentHandler {
        private SchemaDocumentHandler schemaHandler;
        private Vector schemas = new Vector();
        private Object parseID;

        protected SchemaDocumentHandlerWrapper(SchemaDocumentHandler schemaDocumentHandler) {
            this.schemaHandler = schemaDocumentHandler;
        }

        public Schema[] getSchemas() {
            if (this.schemas.size() == 0) {
                return null;
            }
            Schema[] schemaArray = new Schema[this.schemas.size()];
            return this.schemas.toArray(schemaArray);
        }

        protected ContentHandler accept(String string, String string2, String string3, Attributes attributes) {
            if (Util.isSchemaNS(string) && "schema".equals(string2)) {
                return this.schemaHandler;
            }
            return null;
        }

        protected void beforeChangingCurrentContentHandler(ContentHandler contentHandler) {
            if (contentHandler instanceof SchemaDocumentHandler) {
                Schema schema = ((SchemaDocumentHandler)contentHandler).getSchema();
                if (schema != null) {
                    this.schemas.add(schema);
                }
                if (schema instanceof SchemaForParserImpl) {
                    ((SchemaForParserImpl)schema).setDocParseID(this.parseID);
                }
            }
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.parseID = new Object();
        }
    }
}

