/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexImpl;
import com.ibm.sketch.parser.LocationParseState;
import com.ibm.sketch.parser.ParseException;
import com.ibm.sketch.parser.XMLSchemaData;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.schemaparser.composition.CompositionEdgeEnd;
import com.ibm.sketch.schemaparser.composition.DefaultCompositionHandler;
import com.ibm.sketch.utilities.Error;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class CompositionHandlerForWeaklyConnectedSchema
extends DefaultCompositionHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CompositionHandlerForWeaklyConnectedSchema(XSDParserImpl xSDParserImpl) {
        super(xSDParserImpl);
    }

    protected int getNumberOfErrors() {
        Error[] errorArray = this.parser.getErrors();
        int n = 0;
        if (errorArray != null) {
            Vector<Error> vector = new Vector<Error>(Arrays.asList(errorArray));
            int n2 = 0;
            while (n2 < errorArray.length) {
                if (errorArray[n2].getSeverity() == 0) {
                    vector.remove(errorArray[n2]);
                }
                ++n2;
            }
            n += vector.size();
        }
        return n;
    }

    public Schema getReferencedSchema(Schema schema, CompositionEdgeEnd compositionEdgeEnd, Vector vector) throws ParseException, IOException {
        try {
            OpenCloseManager openCloseManager = OpenCloseManagerImpl.getInstance();
            Vertex vertex = compositionEdgeEnd.getVertex();
            URI uRI = (URI)vertex.getObject();
            URI uRI2 = compositionEdgeEnd.getTargetNamespace();
            Schema[] schemaArray = null;
            if (this.parser.requireEachDocumentValid()) {
                schemaArray = openCloseManager.getSchemas(uRI2, new URI[]{uRI}, false);
            } else {
                URI uRI3 = (URI)compositionEdgeEnd.getVertex().getObject();
                URI uRI4 = compositionEdgeEnd.getTargetNamespace();
                XMLSchemaData xMLSchemaData = this.parser.getXMLSSchemaData(new InputSource(uRI3.getAbsoluteURL().toString()));
                if (xMLSchemaData == null) {
                    return null;
                }
                LocationParseState locationParseState = ((OpenCloseManagerImpl)FactoryImpl.instance().getOpenCloseManager()).getLocationParseState(uRI3);
                xMLSchemaData.setLocationParseState(locationParseState);
                Schema schema2 = this.parser.getSchemaWithPartialErrorChecking(uRI4, xMLSchemaData, this.parser.getGraph(), (VertexImpl)compositionEdgeEnd.getVertex(), vector);
                if (schema2 != null) {
                    schemaArray = new Schema[]{schema2};
                }
            }
            if (schemaArray != null && schemaArray.length > 0) {
                return schemaArray[0];
            }
            return null;
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == null) {
                throw new ParseException(sAXException);
            }
            throw new ParseException(sAXException.getException());
        }
    }
}

