/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.TraverseEdgeCondition;
import com.ibm.sketch.parser.ParseException;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.schemaparser.composition.CompositionEdgeEnd;
import com.ibm.sketch.schemaparser.composition.CompositionHandler;
import com.ibm.sketch.schemaparser.composition.Debug;
import com.ibm.sketch.schemaparser.composition.Or;
import com.ibm.sketch.schemaparser.composition.StoreInAppropriateCompositionStatementVisitor;
import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.Reference;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.CompositionStatementImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.TopComponentImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public abstract class DefaultCompositionHandler
extends CompositionHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected XSDParserImpl parser;

    public DefaultCompositionHandler(XSDParserImpl xSDParserImpl) {
        this.parser = xSDParserImpl;
    }

    public SchemaImpl getComposedSchemaToModify(Schema schema, Schema schema2, CompositionEdgeEnd compositionEdgeEnd) {
        CompositionStatement[] compositionStatementArray = DefaultCompositionHandler.getCompositionStatement(schema, compositionEdgeEnd);
        if (compositionStatementArray != null) {
            int n = 0;
            while (n < compositionStatementArray.length) {
                if (compositionStatementArray[n].getSchemaAfterComposition() != null) {
                    return (SchemaImpl)compositionStatementArray[n].getSchemaAfterComposition();
                }
                ++n;
            }
        }
        return (SchemaImpl)schema2;
    }

    public static CompositionStatement[] getCompositionStatement(Schema schema, CompositionEdgeEnd compositionEdgeEnd) {
        return DefaultCompositionHandler.getCompositionStatement(schema, (URI)compositionEdgeEnd.getVertex().getObject(), compositionEdgeEnd.getTargetNamespace(), compositionEdgeEnd.getWeight());
    }

    public static CompositionStatement[] getCompositionStatement(Schema schema, URI uRI, URI uRI2, float f) {
        return SchemaImpl.getCompositionStatement(schema, uRI, uRI2, f);
    }

    public TraverseEdgeCondition getModificationCondition() {
        return null;
    }

    public abstract Schema getReferencedSchema(Schema var1, CompositionEdgeEnd var2, Vector var3) throws ParseException, IOException;

    private static Reference[] getReferencesToRedefinedComponentInRedefineStatement(Schema schema, CompositionEdgeEnd compositionEdgeEnd) {
        float f = compositionEdgeEnd.getWeight();
        if (f != 3.0f && f != 4.0f) {
            return null;
        }
        CompositionStatement[] compositionStatementArray = DefaultCompositionHandler.getCompositionStatement(schema, compositionEdgeEnd);
        Vector<Reference> vector = new Vector<Reference>();
        if (compositionStatementArray != null) {
            int n = 0;
            while (n < compositionStatementArray.length) {
                RedefineStatement redefineStatement = (RedefineStatement)compositionStatementArray[n];
                TopComponent[] topComponentArray = redefineStatement.listRedefinedComponent();
                if (topComponentArray != null) {
                    int n2 = 0;
                    while (n2 < topComponentArray.length) {
                        TopComponentImpl topComponentImpl = (TopComponentImpl)topComponentArray[n2];
                        Reference[] referenceArray = topComponentImpl.getReferencesToRedefinedComponent();
                        if (referenceArray != null) {
                            vector.addAll(Arrays.asList(referenceArray));
                        } else {
                            TopComponentImpl topComponentImpl2 = (TopComponentImpl)redefineStatement.getTopComponent(topComponentImpl.getComponentType(), topComponentImpl.getNCName(), true);
                            if (topComponentImpl2 != null && topComponentImpl2.getSchema() != topComponentImpl.getSchema()) {
                                topComponentImpl2.setIsRedefined(true);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            Object[] objectArray = new Reference[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public TraverseEdgeCondition getStoreCondition() {
        return null;
    }

    public TraverseEdgeCondition getValidationCondition() {
        return new Or(this.getStoreCondition(), this.getModificationCondition());
    }

    protected void markRedefinedComponents(Schema schema, CompositionEdgeEnd compositionEdgeEnd) {
        Reference[] referenceArray = DefaultCompositionHandler.getReferencesToRedefinedComponentInRedefineStatement(schema, compositionEdgeEnd);
        if (referenceArray != null) {
            int n = 0;
            while (n < referenceArray.length) {
                block4: {
                    try {
                        referenceArray[n].resolve(false);
                    }
                    catch (ReferenceResolutionException referenceResolutionException) {
                        if (!Debug.DEBUG) break block4;
                        referenceResolutionException.printStackTrace(System.err);
                    }
                }
                ++n;
            }
        }
    }

    public void modify(Schema schema, Schema schema2, CompositionEdgeEnd compositionEdgeEnd) {
        CompositionStatement[] compositionStatementArray = DefaultCompositionHandler.getCompositionStatement(schema, compositionEdgeEnd);
        if (compositionStatementArray != null) {
            int n = 0;
            while (n < compositionStatementArray.length) {
                Boolean bl = (Boolean)compositionEdgeEnd.getObject();
                ((CompositionStatementImpl)compositionStatementArray[n]).setObject(bl);
                ++n;
            }
        }
    }

    public void storeInAppropriateCompositionStatement(Schema schema, Schema schema2, CompositionEdgeEnd compositionEdgeEnd) {
        DepthFirstTraversal depthFirstTraversal = new DepthFirstTraversal();
        TraverseEdgeCondition traverseEdgeCondition = this.getStoreCondition();
        if (traverseEdgeCondition != null) {
            depthFirstTraversal.setCondition(traverseEdgeCondition);
            depthFirstTraversal.traverse((SchemaImpl)schema2, (GraphVisitor)new StoreInAppropriateCompositionStatementVisitor(this.parser, depthFirstTraversal, (SchemaImpl)schema, (SchemaImpl)schema2, compositionEdgeEnd));
        }
    }
}

