/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.connection.ParserConnectionPool;
import com.ibm.sketch.graph.ComponentsInDifferentGraphsException;
import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexAlreadyInGraphException;
import com.ibm.sketch.graph.VertexImpl;
import com.ibm.sketch.parser.S_Dispatcher;
import com.ibm.sketch.parser.SchemaComponent_ElementHandler;
import com.ibm.sketch.parser.Util;
import com.ibm.sketch.schemaparser.composition.CompositionEdgeEnd;
import com.ibm.sketch.schemaparser.composition.Debug;
import com.ibm.sketch.schemaparser.composition.LocationComparator;
import com.ibm.sketch.utilities.Error;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class GraphBuilder
extends S_Dispatcher {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Integer DISCOVERED = new Integer(1);
    protected static final Integer FINISHED = new Integer(2);
    private URI location;
    private GraphImpl graph;
    private Hashtable locationStates;
    private VertexImpl source;
    private URI sourceTargetNamespace;
    private CompositionEdgeEnd edge;
    private VertexImpl root;
    private URI targetNamespace;
    private Vector errors;
    private boolean fatalError;
    private TreeSet edgesOfRoot;
    private static boolean DEBUG = false;
    private LocationInfo locationInfo;
    private boolean addInvalidComposition;

    public GraphBuilder(URI uRI) throws MalformedURLException {
        block3: {
            this.fatalError = false;
            this.edgesOfRoot = new TreeSet(new EdgeEndComparator());
            this.addInvalidComposition = false;
            if (uRI == null) {
                throw new NullPointerException();
            }
            this.location = GraphBuilder.getAbsoluteURI(uRI, true);
            this.locationStates = new Hashtable();
            this.errors = new Vector();
            this.graph = new GraphImpl(new LocationComparator());
            try {
                this.root = new VertexImpl(this.graph, this.location);
            }
            catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
                if (!Debug.DEBUG) break block3;
                vertexAlreadyInGraphException.printStackTrace(System.err);
            }
        }
    }

    protected GraphBuilder(Hashtable hashtable, Vector vector, GraphImpl graphImpl, VertexImpl vertexImpl, URI uRI, CompositionEdgeEnd compositionEdgeEnd) throws MalformedURLException {
        this.fatalError = false;
        this.edgesOfRoot = new TreeSet(new EdgeEndComparator());
        this.addInvalidComposition = false;
        this.locationStates = hashtable;
        this.source = vertexImpl;
        this.edge = compositionEdgeEnd;
        this.graph = graphImpl;
        this.root = (VertexImpl)compositionEdgeEnd.getVertex();
        this.location = GraphBuilder.getAbsoluteURI((URI)this.root.getObject(), true);
        this.sourceTargetNamespace = uRI;
        this.errors = vector;
    }

    protected void beforeChangingCurrentTopElementElementHandler(SchemaComponent_ElementHandler schemaComponent_ElementHandler) throws SAXException {
    }

    public static URI getAbsoluteURI(URI uRI, boolean bl) throws MalformedURLException {
        Factory factory = FactoryImpl.instance();
        String string = uRI.getAbsoluteURL().toString();
        URI uRI2 = factory.createURI();
        uRI2.setValue(string);
        return uRI2;
    }

    public boolean getAddInvalidComposition() {
        return this.addInvalidComposition;
    }

    protected Enumeration getAllTopElementElementHandlers() {
        return null;
    }

    public Error[] getExceptions() {
        if (this.errors.size() > 0) {
            Object[] objectArray = new Error[this.errors.size()];
            this.errors.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public GraphImpl getGraph() {
        return this.graph;
    }

    public VertexImpl getRoot() {
        return this.root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SchemaComponent_ElementHandler getTopElementElementHandler(String string, String string2, String string3, Attributes attributes) {
        XMLReader xMLReader;
        block32: {
            SchemaComponent_ElementHandler schemaComponent_ElementHandler;
            block31: {
                if (!Util.isSchemaNS(string)) {
                    return null;
                }
                if (!(string2.equals("import") || string2.equals("include") || string2.equals("redefine"))) {
                    return null;
                }
                String string4 = attributes.getValue("schemaLocation");
                if (string4 == null) {
                    return null;
                }
                xMLReader = null;
                CompositionEdgeEnd compositionEdgeEnd = null;
                try {
                    try {
                        LocationInfo locationInfo;
                        Object object;
                        VertexImpl vertexImpl;
                        URI uRI = FactoryImpl.instance().createURI();
                        uRI.setValue(string4);
                        uRI.setContext(this.location.getAbsoluteURL());
                        uRI = GraphBuilder.getAbsoluteURI(uRI, true);
                        try {
                            vertexImpl = this.graph.getVertex(uRI);
                            if (vertexImpl == null) {
                                vertexImpl = new VertexImpl(this.graph, uRI);
                            }
                        }
                        catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
                            if (!Debug.DEBUG) throw new RuntimeException("Fatal Application Error : " + vertexAlreadyInGraphException.getMessage());
                            vertexAlreadyInGraphException.printStackTrace(System.err);
                            throw new RuntimeException("Fatal Application Error : " + vertexAlreadyInGraphException.getMessage());
                        }
                        compositionEdgeEnd = new CompositionEdgeEnd(vertexImpl);
                        compositionEdgeEnd.setLocator(this.getLocator());
                        URI uRI2 = this.targetNamespace;
                        if (string2.equals("import")) {
                            object = attributes.getValue("namespace");
                            if (object == null) {
                                uRI2 = null;
                            } else {
                                uRI2 = FactoryImpl.instance().createURI();
                                uRI2.setValue((String)object);
                            }
                            if (this.targetNamespace == null && uRI2 == null || this.targetNamespace != null && this.targetNamespace.equals(uRI2)) {
                                if (!this.addInvalidComposition) {
                                    SchemaComponent_ElementHandler schemaComponent_ElementHandler2 = null;
                                    Object var17_20 = null;
                                    if (xMLReader == null) return schemaComponent_ElementHandler2;
                                    ParserConnectionPool.instance().releaseImpl(xMLReader);
                                    return schemaComponent_ElementHandler2;
                                }
                                compositionEdgeEnd.setWeight(5.0f);
                            } else {
                                compositionEdgeEnd.setWeight(5.0f);
                            }
                        } else if (string2.equals("include")) {
                            compositionEdgeEnd.setWeight(1.0f);
                        } else if (string2.equals("redefine")) {
                            compositionEdgeEnd.setWeight(3.0f);
                        }
                        compositionEdgeEnd.setTargetNamespace(uRI2);
                        object = new CompositionEdgeEnd((VertexImpl)compositionEdgeEnd.getVertex(), compositionEdgeEnd.getWeight(), compositionEdgeEnd.getObject());
                        ((CompositionEdgeEnd)object).setTargetNamespace(compositionEdgeEnd.getTargetNamespace());
                        if (this.edgesOfRoot.add(object)) {
                            this.root.add(compositionEdgeEnd);
                        }
                        if ((locationInfo = (LocationInfo)this.locationStates.get(GraphBuilder.getAbsoluteURI(uRI, true))) != null) {
                            this.modifyGraphDependingOnSourceAndDestinationNamespace(this.root, uRI2, compositionEdgeEnd, locationInfo.getTargetNamespace());
                            schemaComponent_ElementHandler = null;
                            break block31;
                        }
                        URL uRL = uRI.getAbsoluteURL();
                        InputSource inputSource = new InputSource(uRL.openStream());
                        xMLReader = ParserConnectionPool.instance().acquireImpl();
                        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                        xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                        GraphBuilder graphBuilder = new GraphBuilder(this.locationStates, this.errors, this.graph, this.root, uRI2, compositionEdgeEnd);
                        graphBuilder.setAddInvalidComposition(this.addInvalidComposition);
                        xMLReader.setContentHandler(graphBuilder);
                        xMLReader.parse(inputSource);
                        break block32;
                    }
                    catch (IOException iOException) {
                        if (!this.addInvalidComposition && compositionEdgeEnd != null) {
                            this.root.remove(compositionEdgeEnd);
                        }
                        if (Debug.DEBUG || DEBUG) {
                            iOException.printStackTrace(System.err);
                        }
                        Object var17_23 = null;
                        if (xMLReader == null) return null;
                        ParserConnectionPool.instance().releaseImpl(xMLReader);
                        return null;
                    }
                    catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
                        throw new RuntimeException(componentsInDifferentGraphsException.toString());
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        throw new RuntimeException(sAXNotSupportedException.toString());
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        throw new RuntimeException(sAXNotRecognizedException.toString());
                    }
                    catch (SAXException sAXException) {
                        if (Debug.DEBUG || DEBUG) {
                            sAXException.printStackTrace(System.err);
                        }
                        Object var17_24 = null;
                        if (xMLReader == null) return null;
                        ParserConnectionPool.instance().releaseImpl(xMLReader);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_25 = null;
                    if (xMLReader == null) throw throwable;
                    ParserConnectionPool.instance().releaseImpl(xMLReader);
                    throw throwable;
                }
            }
            Object var17_21 = null;
            if (xMLReader == null) return schemaComponent_ElementHandler;
            ParserConnectionPool.instance().releaseImpl(xMLReader);
            return schemaComponent_ElementHandler;
        }
        Object var17_22 = null;
        if (xMLReader == null) return null;
        ParserConnectionPool.instance().releaseImpl(xMLReader);
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLReader xMLReader = ParserConnectionPool.instance().acquireImpl();
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
        GraphBuilder graphBuilder = new GraphBuilder(FactoryImpl.instance().createURI("file:///C:/cygwin/home/achille/projects/Testcases/XMLSchemas/valid_schemas/IncludeWithNullTargetNamespace/includeASchemaWithoutNS.xsd"));
        xMLReader.setContentHandler(graphBuilder);
        long l = Calendar.getInstance().getTime().getTime();
        xMLReader.parse("file:///C:/cygwin/home/achille/projects/Testcases/XMLSchemas/valid_schemas/IncludeWithNullTargetNamespace/includeASchemaWithoutNS.xsd");
        System.out.println(Calendar.getInstance().getTime().getTime() - l);
        System.out.println(graphBuilder.getGraph());
    }

    protected void mainCharacters(char[] cArray, int n, int n2) throws SAXException {
    }

    protected void mainEndElement(String string, String string2, String string3) throws SAXException {
        this.locationInfo.setState(GraphBuilder.FINISHED);
        if (DEBUG) {
            System.out.println(this.location + " finished");
        }
    }

    protected void mainEndPrefixMapping(String string) throws SAXException {
    }

    protected void mainIgnorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    protected void mainProcessingInstruction(String string, String string2) throws SAXException {
    }

    protected void mainSkippedEntity(String string) throws SAXException {
    }

    protected void mainStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Factory factory = FactoryImpl.instance();
        String string4 = attributes.getValue("targetNamespace");
        if (string4 != null) {
            this.targetNamespace = factory.createURI();
            this.targetNamespace.setValue(string4);
        }
        this.locationInfo = new LocationInfo(DISCOVERED, this.targetNamespace);
        this.locationStates.put(this.location, this.locationInfo);
        if (DEBUG) {
            System.out.println(this.location + " discovered");
        }
        if (!Util.isSchemaNS(string)) {
            this.fatalError = true;
            return;
        }
        this.modifyGraphDependingOnSourceAndDestinationNamespace(this.source, this.sourceTargetNamespace, this.edge, this.targetNamespace);
    }

    protected void mainStartPrefixMapping(String string, String string2) throws SAXException {
    }

    protected void modifyGraphDependingOnSourceAndDestinationNamespace(VertexImpl vertexImpl, URI uRI, CompositionEdgeEnd compositionEdgeEnd, URI uRI2) {
        if (compositionEdgeEnd != null) {
            float f = compositionEdgeEnd.getWeight();
            if (f == 1.0f) {
                if (uRI == null) {
                    if (uRI2 != null && !this.addInvalidComposition) {
                        vertexImpl.remove(compositionEdgeEnd);
                    }
                } else if (uRI2 == null) {
                    compositionEdgeEnd.setWeight(2.0f);
                    compositionEdgeEnd.setTargetNamespace(null);
                } else if (!uRI2.equals(uRI) && !this.addInvalidComposition) {
                    vertexImpl.remove(compositionEdgeEnd);
                }
            } else if (f == 3.0f) {
                if (uRI == null) {
                    if (uRI2 != null && !this.addInvalidComposition) {
                        vertexImpl.remove(compositionEdgeEnd);
                    }
                } else if (uRI2 == null) {
                    compositionEdgeEnd.setWeight(4.0f);
                    compositionEdgeEnd.setTargetNamespace(null);
                } else if (!uRI2.equals(uRI) && !this.addInvalidComposition) {
                    vertexImpl.remove(compositionEdgeEnd);
                }
            } else if (f == 5.0f && (uRI == null && uRI2 != null || uRI != null && !uRI.equals(uRI2)) && !this.addInvalidComposition) {
                vertexImpl.remove(compositionEdgeEnd);
            }
        }
    }

    public void setAddInvalidComposition(boolean bl) {
        this.addInvalidComposition = bl;
    }

    private class LocationInfo {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private Integer state;
        private URI targetNamespace;

        private LocationInfo(Integer n, URI uRI) {
            this.state = n;
            this.targetNamespace = uRI;
        }

        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        public Integer getState() {
            return this.state;
        }

        private void setState(Integer n) {
            this.state = n;
        }
    }

    private class EdgeEndComparator
    implements Comparator {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private EdgeEndComparator() {
        }

        public String toString(CompositionEdgeEnd compositionEdgeEnd) {
            try {
                Vertex vertex = compositionEdgeEnd.getVertex();
                URI uRI = (URI)vertex.getObject();
                if (compositionEdgeEnd.getObject() == null) {
                    return compositionEdgeEnd.getWeight() + ":" + "0" + ":" + ":" + GraphBuilder.getAbsoluteURI(uRI, true);
                }
                return compositionEdgeEnd.getWeight() + ":" + "1" + ":" + compositionEdgeEnd.getTargetNamespace() + ":" + GraphBuilder.getAbsoluteURI(uRI, true);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException.toString());
            }
        }

        public int compare(Object object, Object object2) {
            return this.toString((CompositionEdgeEnd)object).compareTo(this.toString((CompositionEdgeEnd)object2));
        }
    }
}

