/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.connection.ParserConnectionPool;
import com.ibm.sketch.graph.ComponentsInDifferentGraphsException;
import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexAlreadyInGraphException;
import com.ibm.sketch.graph.VertexImpl;
import com.ibm.sketch.parser.DispatcherForEmbeddedComponents;
import com.ibm.sketch.parser.S_Dispatcher;
import com.ibm.sketch.parser.SchemaComponent_ElementHandler;
import com.ibm.sketch.parser.SilentErrorHandler;
import com.ibm.sketch.parser.Util;
import com.ibm.sketch.schemaparser.composition.CompositionEdgeEnd;
import com.ibm.sketch.schemaparser.composition.Debug;
import com.ibm.sketch.schemaparser.composition.GraphBuilder;
import com.ibm.sketch.schemaparser.composition.LocationComparator;
import com.ibm.sketch.util.URIComparator;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.URIImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GraphBuilderForEmbeddedSchemas
extends DispatcherForEmbeddedComponents {
    private URI location;
    private Map locationStates;
    private GraphImpl graph;
    private SchemaHandler schemaHandler = new SchemaHandler();

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            URI uRI = FactoryImpl.instance().createURI(stringArray[n]);
            long l = Calendar.getInstance().getTime().getTime();
            GraphImpl graphImpl = GraphBuilderForEmbeddedSchemas.buildGraph(uRI);
            System.out.println(Calendar.getInstance().getTime().getTime() - l);
            System.out.println(graphImpl);
            ++n;
        }
    }

    private GraphBuilderForEmbeddedSchemas(GraphImpl graphImpl, Map hashMap, URI uRI) {
        if (graphImpl == null) {
            graphImpl = new GraphImpl();
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.locationStates = hashMap;
        this.graph = graphImpl;
        this.location = uRI;
    }

    private GraphBuilderForEmbeddedSchemas(URI uRI) {
        this(null, null, uRI);
    }

    public static URI getAbsoluteURI(URI uRI, boolean bl) throws MalformedURLException {
        return GraphBuilder.getAbsoluteURI(uRI, bl);
    }

    public static GraphImpl buildGraph(URI uRI) throws MalformedURLException {
        GraphImpl graphImpl = new GraphImpl(new ExtendedLocationComparator());
        HashMap hashMap = new HashMap();
        GraphBuilderForEmbeddedSchemas.addVerticesIntoGraph(graphImpl, hashMap, uRI);
        RemoveOrChangeInvalidCompositionEdgeVisitor removeOrChangeInvalidCompositionEdgeVisitor = new RemoveOrChangeInvalidCompositionEdgeVisitor(hashMap);
        new DepthFirstTraversal().traverse(graphImpl, (GraphVisitor)removeOrChangeInvalidCompositionEdgeVisitor);
        return graphImpl;
    }

    public static VertexImpl[] getRoots(GraphImpl graphImpl, URI uRI) {
        Vertex[] vertexArray = graphImpl.getVertices();
        if (vertexArray == null) {
            return null;
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        int n = 0;
        while (n < vertexArray.length) {
            if (vertexArray[n].getObject().equals(uRI)) {
                arrayList.add(vertexArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        VertexImpl[] vertexImplArray = new VertexImpl[arrayList.size()];
        return arrayList.toArray(vertexImplArray);
    }

    protected static void addVerticesIntoGraph(GraphImpl graphImpl, Map map, URI uRI) throws MalformedURLException {
        block17: {
            InputSource inputSource;
            Object object;
            LocationInfo locationInfo = (LocationInfo)map.get(uRI = GraphBuilderForEmbeddedSchemas.getAbsoluteURI(uRI, true));
            if (locationInfo != null) {
                return;
            }
            GraphBuilderForEmbeddedSchemas graphBuilderForEmbeddedSchemas = new GraphBuilderForEmbeddedSchemas(graphImpl, map, uRI);
            locationInfo = new LocationInfo(uRI);
            map.put(uRI, locationInfo);
            try {
                object = uRI.getAbsoluteURL();
                inputSource = new InputSource(((URL)object).openStream());
            }
            catch (IOException iOException) {
                locationInfo.setIsFound(false);
                return;
            }
            locationInfo.setIsFound(true);
            object = null;
            try {
                try {
                    object = ParserConnectionPool.instance().acquireImpl();
                    object.setFeature("http://xml.org/sax/features/validation", false);
                    object.setFeature("http://apache.org/xml/features/validation/schema", false);
                    object.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    object.setErrorHandler(new SilentErrorHandler());
                    object.setContentHandler(graphBuilderForEmbeddedSchemas);
                    object.parse(inputSource);
                }
                catch (MalformedURLException malformedURLException) {
                    if (Debug.DEBUG) {
                        malformedURLException.printStackTrace(System.err);
                    }
                    Object var11_9 = null;
                    if (object != null) {
                        ParserConnectionPool.getInstance().releaseImpl((XMLReader)object);
                    }
                    break block17;
                }
                catch (SAXException sAXException) {
                    if (Debug.DEBUG) {
                        sAXException.printStackTrace(System.err);
                    }
                    Object var11_10 = null;
                    if (object != null) {
                        ParserConnectionPool.getInstance().releaseImpl((XMLReader)object);
                    }
                    break block17;
                }
                catch (IOException iOException) {
                    if (Debug.DEBUG) {
                        iOException.printStackTrace(System.err);
                    }
                    Object var11_11 = null;
                    if (object != null) {
                        ParserConnectionPool.getInstance().releaseImpl((XMLReader)object);
                    }
                }
                Object var11_8 = null;
                if (object != null) {
                    ParserConnectionPool.getInstance().releaseImpl((XMLReader)object);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (object != null) {
                    ParserConnectionPool.getInstance().releaseImpl((XMLReader)object);
                }
                throw throwable;
            }
        }
    }

    protected ContentHandler accept(String string, String string2, String string3, Attributes attributes) {
        if (Util.isSchemaNS(string) && "schema".equals(string2)) {
            return this.schemaHandler;
        }
        return null;
    }

    protected void beforeChangingCurrentContentHandler(ContentHandler contentHandler) throws SAXException {
        if (contentHandler instanceof SchemaHandler) {
            SchemaHandler schemaHandler = (SchemaHandler)contentHandler;
            ((LocationInfo)this.locationStates.get(this.location)).addTargetNamespace(schemaHandler.getTargetNamespace());
            URI[] uRIArray = schemaHandler.getReferencedLocations();
            if (uRIArray == null) {
                return;
            }
            int n = 0;
            while (n < uRIArray.length) {
                try {
                    if (this.locationStates.get(uRIArray[n]) == null) {
                        GraphBuilderForEmbeddedSchemas.addVerticesIntoGraph(this.graph, this.locationStates, uRIArray[n]);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    private static class LocationInfo {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private boolean found = false;
        private TreeSet targetNamespaces = new TreeSet(new URIComparator());
        private URI location;

        private LocationInfo(URI uRI) throws MalformedURLException {
            this.location = GraphBuilderForEmbeddedSchemas.getAbsoluteURI(uRI, true);
        }

        private void addTargetNamespace(URI uRI) {
            this.targetNamespaces.add(uRI);
        }

        public URI[] getTargetNamespaces() {
            if (this.targetNamespaces.size() == 0) {
                return null;
            }
            URI[] uRIArray = new URI[this.targetNamespaces.size()];
            return this.targetNamespaces.toArray(uRIArray);
        }

        public boolean hasTargetNamespace(URI uRI) {
            return this.targetNamespaces.contains(uRI);
        }

        public boolean isFound() {
            return this.found;
        }

        private void setIsFound(boolean bl) {
            this.found = bl;
        }
    }

    private class EdgeEndComparator
    implements Comparator {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private EdgeEndComparator() {
        }

        public String toString(CompositionEdgeEnd compositionEdgeEnd) {
            try {
                Vertex vertex = compositionEdgeEnd.getVertex();
                ExtendedLocation extendedLocation = (ExtendedLocation)vertex.getObject();
                if (compositionEdgeEnd.getObject() == null) {
                    if (extendedLocation.getTargetNamespace() == null) {
                        return compositionEdgeEnd.getWeight() + ":" + "0" + ":" + ":" + GraphBuilderForEmbeddedSchemas.getAbsoluteURI(extendedLocation, true) + ":0:";
                    }
                    return compositionEdgeEnd.getWeight() + ":" + "0" + ":" + ":" + GraphBuilderForEmbeddedSchemas.getAbsoluteURI(extendedLocation, true) + ":1:" + extendedLocation.getTargetNamespace();
                }
                if (extendedLocation.getTargetNamespace() == null) {
                    return compositionEdgeEnd.getWeight() + ":" + "1" + ":" + compositionEdgeEnd.getTargetNamespace() + ":" + GraphBuilderForEmbeddedSchemas.getAbsoluteURI(extendedLocation, true) + ":0:";
                }
                return compositionEdgeEnd.getWeight() + ":" + "1" + ":" + compositionEdgeEnd.getTargetNamespace() + ":" + GraphBuilderForEmbeddedSchemas.getAbsoluteURI(extendedLocation, true) + ":1:" + extendedLocation.getTargetNamespace();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException.toString());
            }
        }

        public int compare(Object object, Object object2) {
            return this.toString((CompositionEdgeEnd)object).compareTo(this.toString((CompositionEdgeEnd)object2));
        }
    }

    public static class ExtendedLocation
    extends URIImpl {
        private URI targetNamespace;

        public void setTargetNamespace(URI uRI) {
            this.targetNamespace = uRI;
        }

        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof ExtendedLocation)) return super.equals(object);
            ExtendedLocation extendedLocation = (ExtendedLocation)object;
            if (!super.equals(object)) return false;
            if (this.targetNamespace == null) {
                if (extendedLocation.getTargetNamespace() != null) return false;
                return true;
            }
            boolean bl = this.targetNamespace.equals(extendedLocation.getTargetNamespace());
            if (!bl) return false;
            return true;
        }
    }

    private class SchemaHandler
    extends S_Dispatcher {
        private URI targetNamespace;
        private TreeSet referencedLocations = new TreeSet(new LocationComparator());
        private VertexImpl currentVertex;
        private TreeSet edgesOfCurrentVertex = new TreeSet(new EdgeEndComparator());

        private SchemaHandler() {
        }

        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        public URI[] getReferencedLocations() {
            if (this.referencedLocations.size() == 0) {
                return null;
            }
            URI[] uRIArray = new URI[this.referencedLocations.size()];
            return this.referencedLocations.toArray(uRIArray);
        }

        protected void mainStartPrefixMapping(String string, String string2) throws SAXException {
        }

        protected void mainStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.referencedLocations.clear();
            String string4 = attributes.getValue("targetNamespace");
            if (string4 != null) {
                this.targetNamespace = FactoryImpl.instance().createURI();
                this.targetNamespace.setValue(string4);
            } else {
                this.targetNamespace = null;
            }
            ExtendedLocation extendedLocation = ((FactoryImpl)FactoryImpl.instance()).createExtendedLocation();
            try {
                extendedLocation.setValue(GraphBuilderForEmbeddedSchemas.getAbsoluteURI(GraphBuilderForEmbeddedSchemas.this.location, true).getValue());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            extendedLocation.setTargetNamespace(this.targetNamespace);
            try {
                this.currentVertex = GraphBuilderForEmbeddedSchemas.this.graph.getVertex(extendedLocation);
                if (this.currentVertex == null) {
                    this.currentVertex = (VertexImpl)GraphBuilderForEmbeddedSchemas.this.graph.addUserObject(extendedLocation);
                }
            }
            catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
                throw new RuntimeException("Application Exception : " + vertexAlreadyInGraphException.getMessage());
            }
        }

        protected void mainSkippedEntity(String string) throws SAXException {
        }

        protected void mainProcessingInstruction(String string, String string2) throws SAXException {
        }

        protected void mainIgnorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        protected void mainEndPrefixMapping(String string) throws SAXException {
        }

        protected void mainEndElement(String string, String string2, String string3) throws SAXException {
        }

        protected void mainCharacters(char[] cArray, int n, int n2) throws SAXException {
        }

        protected SchemaComponent_ElementHandler getTopElementElementHandler(String string, String string2, String string3, Attributes attributes) {
            Object object;
            if (!Util.isSchemaNS(string)) {
                return null;
            }
            if (!(string2.equals("import") || string2.equals("include") || string2.equals("redefine"))) {
                return null;
            }
            String string4 = attributes.getValue("schemaLocation");
            if (string4 == null) {
                return null;
            }
            URI uRI = FactoryImpl.instance().createURI();
            ExtendedLocation extendedLocation = null;
            try {
                uRI.setValue(string4);
                uRI.setContext(GraphBuilderForEmbeddedSchemas.this.location.getAbsoluteURL());
                this.referencedLocations.add(GraphBuilderForEmbeddedSchemas.getAbsoluteURI(uRI, true));
                extendedLocation = ((FactoryImpl)FactoryImpl.instance()).createExtendedLocation();
                extendedLocation.setValue(string4);
                extendedLocation.setContext(GraphBuilderForEmbeddedSchemas.this.location.getAbsoluteURL());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            URI uRI2 = this.targetNamespace;
            if (string2.equals("import")) {
                object = attributes.getValue("namespace");
                if (object == null) {
                    uRI2 = null;
                } else {
                    uRI2 = FactoryImpl.instance().createURI();
                    uRI2.setValue((String)object);
                }
                if (this.targetNamespace == null && uRI2 == null || this.targetNamespace != null && this.targetNamespace.equals(uRI2)) {
                    return null;
                }
            }
            extendedLocation.setTargetNamespace(uRI2);
            try {
                object = GraphBuilderForEmbeddedSchemas.this.graph.getVertex(extendedLocation);
                if (object == null) {
                    object = (VertexImpl)GraphBuilderForEmbeddedSchemas.this.graph.addUserObject(extendedLocation);
                }
            }
            catch (VertexAlreadyInGraphException vertexAlreadyInGraphException) {
                if (Debug.DEBUG) {
                    vertexAlreadyInGraphException.printStackTrace(System.err);
                }
                throw new RuntimeException("Fatal Application Error : " + vertexAlreadyInGraphException.getMessage());
            }
            CompositionEdgeEnd compositionEdgeEnd = new CompositionEdgeEnd((VertexImpl)object);
            if (string2.equals("import")) {
                compositionEdgeEnd.setWeight(5.0f);
            } else if (string2.equals("include")) {
                compositionEdgeEnd.setWeight(1.0f);
            } else if (string2.equals("redefine")) {
                compositionEdgeEnd.setWeight(3.0f);
            }
            compositionEdgeEnd.setLocator(this.getLocator());
            compositionEdgeEnd.setTargetNamespace(uRI2);
            CompositionEdgeEnd compositionEdgeEnd2 = new CompositionEdgeEnd((VertexImpl)compositionEdgeEnd.getVertex(), compositionEdgeEnd.getWeight(), compositionEdgeEnd.getObject());
            compositionEdgeEnd2.setTargetNamespace(compositionEdgeEnd.getTargetNamespace());
            try {
                if (this.edgesOfCurrentVertex.add(compositionEdgeEnd2)) {
                    this.currentVertex.add(compositionEdgeEnd);
                }
            }
            catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
                throw new RuntimeException("Appplication Error : " + componentsInDifferentGraphsException.getMessage());
            }
            return null;
        }

        protected Enumeration getAllTopElementElementHandlers() {
            return null;
        }

        protected void beforeChangingCurrentTopElementElementHandler(SchemaComponent_ElementHandler schemaComponent_ElementHandler) throws SAXException {
        }
    }

    public static class ExtendedLocationComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ExtendedLocationComparator.toString((ExtendedLocation)object).compareTo(ExtendedLocationComparator.toString((ExtendedLocation)object2));
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object2) == 0;
        }

        protected static String toString(ExtendedLocation extendedLocation) {
            try {
                if (extendedLocation == null) {
                    return "0:";
                }
                if (extendedLocation.getTargetNamespace() == null) {
                    return "1: 0:" + new StringBuffer(GraphBuilder.getAbsoluteURI(extendedLocation, true).toString()).reverse().toString();
                }
                return "1: 1:" + new StringBuffer(GraphBuilder.getAbsoluteURI(extendedLocation, true).toString()).reverse().toString() + ":" + extendedLocation.getTargetNamespace().toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class RemoveOrChangeInvalidCompositionEdgeVisitor
    extends DefaultGraphVisitor {
        private Map locationStates;

        private RemoveOrChangeInvalidCompositionEdgeVisitor(Map map) {
            this.locationStates = map;
        }

        public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
            ExtendedLocation extendedLocation = (ExtendedLocation)vertex.getObject();
            CompositionEdgeEnd compositionEdgeEnd = (CompositionEdgeEnd)edgeEnd;
            ExtendedLocation extendedLocation2 = (ExtendedLocation)compositionEdgeEnd.getVertex().getObject();
            LocationInfo locationInfo = (LocationInfo)this.locationStates.get(compositionEdgeEnd.getVertex().getObject());
            GraphImpl graphImpl = ((VertexImpl)vertex).getGraph();
            if (locationInfo == null) {
                return;
            }
            if (!locationInfo.isFound()) {
                ((VertexImpl)vertex).remove(compositionEdgeEnd);
                graphImpl.remove((VertexImpl)compositionEdgeEnd.getVertex());
            } else if (compositionEdgeEnd.getWeight() == 5.0f) {
                if (!locationInfo.hasTargetNamespace(compositionEdgeEnd.getTargetNamespace())) {
                    ((VertexImpl)vertex).remove(compositionEdgeEnd);
                    graphImpl.remove((VertexImpl)compositionEdgeEnd.getVertex());
                }
            } else if (compositionEdgeEnd.getTargetNamespace() != null) {
                if (!locationInfo.hasTargetNamespace(compositionEdgeEnd.getTargetNamespace()) && !locationInfo.hasTargetNamespace(null)) {
                    ((VertexImpl)vertex).remove(compositionEdgeEnd);
                    graphImpl.remove((VertexImpl)compositionEdgeEnd.getVertex());
                } else if (locationInfo.hasTargetNamespace(null) && !locationInfo.hasTargetNamespace(compositionEdgeEnd.getTargetNamespace())) {
                    ExtendedLocation extendedLocation3 = ((FactoryImpl)FactoryImpl.instance()).createExtendedLocation();
                    extendedLocation3.setValue(extendedLocation2.getValue());
                    extendedLocation3.setContext(extendedLocation2.getContext());
                    extendedLocation3.setTargetNamespace(null);
                    VertexImpl vertexImpl = graphImpl.getVertex(extendedLocation3);
                    try {
                        if (compositionEdgeEnd.getWeight() == 1.0f) {
                            compositionEdgeEnd.setWeight(2.0f);
                            graphImpl.remove((VertexImpl)compositionEdgeEnd.getVertex());
                            compositionEdgeEnd.setVertex(vertexImpl);
                            compositionEdgeEnd.setTargetNamespace(null);
                        } else if (compositionEdgeEnd.getWeight() == 3.0f) {
                            compositionEdgeEnd.setWeight(4.0f);
                            graphImpl.remove((VertexImpl)compositionEdgeEnd.getVertex());
                            compositionEdgeEnd.setVertex(vertexImpl);
                            compositionEdgeEnd.setTargetNamespace(null);
                        }
                    }
                    catch (ComponentsInDifferentGraphsException componentsInDifferentGraphsException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

