/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.viewandvisitor.UnlinkReferencesVisitor;
import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.RedefineStatement;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.IncludeStatementImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.util.Arrays;
import java.util.Vector;

class SimpleRedefineModificationVisitor
extends DefaultGraphVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected SchemaImpl redefiningSchema;
    private boolean stopAddingVirtualInclude = false;
    private TopComponent[] redefinedVersionsOfRedefinedTopComponents = null;

    public SimpleRedefineModificationVisitor(SchemaImpl schemaImpl) {
        this.redefiningSchema = schemaImpl;
        RedefineStatement[] redefineStatementArray = this.redefiningSchema.listRedefineStatement();
        if (redefineStatementArray != null) {
            Vector<TopComponent> vector = new Vector<TopComponent>();
            int n = 0;
            while (n < redefineStatementArray.length) {
                TopComponent[] topComponentArray = redefineStatementArray[n].listRedefinedComponent();
                if (topComponentArray != null) {
                    vector.addAll(Arrays.asList(topComponentArray));
                }
                ++n;
            }
            if (vector.size() > 0) {
                this.redefinedVersionsOfRedefinedTopComponents = new TopComponent[vector.size()];
                vector.copyInto(this.redefinedVersionsOfRedefinedTopComponents);
            }
        }
    }

    public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
        Schema schema = (Schema)vertex.getObject();
        URI uRI = schema.getTargetNamespace();
        URI uRI2 = ((Schema)edgeEnd.getVertex().getObject()).getTargetNamespace();
        if (uRI == null && uRI2 != null || uRI != null && !uRI.equals(uRI2)) {
            this.stopAddingVirtualInclude = true;
        }
    }

    public void visitVertex(Vertex vertex) {
        Schema schema = (Schema)vertex.getObject();
        if (this.redefinedVersionsOfRedefinedTopComponents != null) {
            new UnlinkReferencesVisitor(this.redefinedVersionsOfRedefinedTopComponents).visitSchema(schema);
        }
        if (!this.stopAddingVirtualInclude && schema != this.redefiningSchema) {
            URI uRI = this.redefiningSchema.getSaveAsLocation();
            CompositionStatement[] compositionStatementArray = SchemaImpl.getCompositionStatement(schema, uRI, this.redefiningSchema.getTargetNamespace(), 5.0f);
            if (schema.getIncludeStatement(uRI) == null && schema.getRedefineStatement(uRI) == null && (compositionStatementArray == null || compositionStatementArray.length == 0)) {
                IncludeStatementImpl includeStatementImpl = (IncludeStatementImpl)FactoryImpl.instance().createIncludeStatement();
                includeStatementImpl.setLocation(this.redefiningSchema.getSaveAsLocation());
                includeStatementImpl.makeVirtual(true);
                schema.addIncludeStatement(includeStatementImpl);
            }
        }
    }
}

