/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.graph.DefaultGraphVisitor;
import com.ibm.sketch.graph.DepthFirstTraversal;
import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.GraphVisitor;
import com.ibm.sketch.graph.TraverseEdgeCondition;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.graph.VertexImpl;
import com.ibm.sketch.parser.ParseException;
import com.ibm.sketch.parser.XMLSchemaData;
import com.ibm.sketch.schemaparser.SchemaForParserImpl;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.schemaparser.composition.CompositionEdgeEnd;
import com.ibm.sketch.schemaparser.composition.CompositionHandler;
import com.ibm.sketch.schemaparser.composition.Debug;
import com.ibm.xml.ecm.schema.CompositionStatement;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.CompositionStatementImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xml.sax.InputSource;

class StoreInAppropriateCompositionStatementVisitor
extends DefaultGraphVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected OpenCloseManagerImpl OCM = (OpenCloseManagerImpl)FactoryImpl.instance().getOpenCloseManager();
    protected XSDParserImpl parser;
    protected DepthFirstTraversal traversal;
    protected SchemaImpl fcomposingSchema;
    protected SchemaImpl fcomposedSchema;
    protected CompositionEdgeEnd fedge;
    private boolean initialized = false;
    private static TreeSet cloningSchemas = new TreeSet(new SchemaImplComparator());

    public StoreInAppropriateCompositionStatementVisitor(XSDParserImpl xSDParserImpl, DepthFirstTraversal depthFirstTraversal, SchemaImpl schemaImpl, SchemaImpl schemaImpl2, CompositionEdgeEnd compositionEdgeEnd) {
        this.parser = xSDParserImpl;
        this.traversal = depthFirstTraversal;
        this.fcomposedSchema = schemaImpl2;
        this.fcomposingSchema = schemaImpl;
        this.fedge = compositionEdgeEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema clone(SchemaForParserImpl schemaForParserImpl) throws ParseException, IOException {
        Object object;
        Schema schema = null;
        SortedSet<SchemaForParserImpl> sortedSet = cloningSchemas.tailSet(schemaForParserImpl);
        if (!sortedSet.isEmpty()) {
            object = sortedSet.first();
            if (cloningSchemas.comparator().compare(object, schemaForParserImpl) == 0) {
                return schemaForParserImpl;
            }
        }
        cloningSchemas.add(schemaForParserImpl);
        this.OCM.removeFromCache(schemaForParserImpl);
        try {
            try {
                object = schemaForParserImpl.getXMLSchemaData();
                if (object != null) {
                    schema = this.retrieve((XMLSchemaData)object, schemaForParserImpl.getTargetNamespace());
                }
                schema = this.retrieve(schemaForParserImpl.getSaveAsLocation(), schemaForParserImpl.getTargetNamespace());
            }
            catch (MalformedURLException malformedURLException) {
                if (Debug.DEBUG) {
                    malformedURLException.printStackTrace(System.err);
                }
                Object var6_7 = null;
                schemaForParserImpl = (SchemaForParserImpl)this.OCM.getLocationParseState(schemaForParserImpl.getSaveAsLocation()).addOrMergeSchemaRead(schemaForParserImpl);
                cloningSchemas.remove(schemaForParserImpl);
                return schema;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            schemaForParserImpl = (SchemaForParserImpl)this.OCM.getLocationParseState(schemaForParserImpl.getSaveAsLocation()).addOrMergeSchemaRead(schemaForParserImpl);
            cloningSchemas.remove(schemaForParserImpl);
            throw throwable;
        }
        schemaForParserImpl = (SchemaForParserImpl)this.OCM.getLocationParseState(schemaForParserImpl.getSaveAsLocation()).addOrMergeSchemaRead(schemaForParserImpl);
        cloningSchemas.remove(schemaForParserImpl);
        return schema;
    }

    public void initialize(Vertex vertex) {
        if (!this.initialized) {
            CompositionStatement[] compositionStatementArray = CompositionHandler.getCompositionStatement(this.fcomposingSchema, this.fedge);
            if (compositionStatementArray == null) {
                throw new RuntimeException("Fatal Application Error");
            }
            int n = 0;
            while (n < compositionStatementArray.length) {
                this.visitEdge(this.fcomposingSchema, (CompositionStatementImpl)compositionStatementArray[n]);
                ++n;
            }
            this.initialized = true;
        }
    }

    public boolean isUsedByMoreThanOneSchema(SchemaImpl schemaImpl) {
        VertexImpl vertexImpl = this.parser.transposedGraph().getVertex(schemaImpl.getSaveAsLocation());
        if (vertexImpl == null) {
            throw new RuntimeException("Application Fatal Error");
        }
        EdgeEnd[] edgeEndArray = vertexImpl.getEdgeEnds();
        return edgeEndArray != null && edgeEndArray.length > 1;
    }

    private Schema retrieve(XMLSchemaData xMLSchemaData, URI uRI) throws ParseException, IOException {
        Schema schema;
        CheckerManagerImpl checkerManagerImpl = CheckerManagerImpl.getInstance();
        int n = checkerManagerImpl.getMaxCost();
        OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)this.parser.getFactory().getOpenCloseManager();
        boolean bl = openCloseManagerImpl.isReferenceResolutionEnabled();
        checkerManagerImpl.setMaxCost(0);
        try {
            Schema[] schemaArray = this.parser.parse(true, uRI, xMLSchemaData);
            if (schemaArray != null && schemaArray.length > 0 && schemaArray[0] != null) {
                openCloseManagerImpl.removeFromCache(schemaArray[0]);
                Schema schema2 = schemaArray[0];
                Object var10_10 = null;
                checkerManagerImpl.setMaxCost(n);
                return schema2;
            }
            schema = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            checkerManagerImpl.setMaxCost(n);
            throw throwable;
        }
        Object var10_11 = null;
        checkerManagerImpl.setMaxCost(n);
        return schema;
    }

    private Schema retrieve(URI uRI, URI uRI2) throws MalformedURLException, IOException, ParseException {
        XMLSchemaData xMLSchemaData = this.parser.getXMLSSchemaData(new InputSource(uRI.getAbsoluteURL().toString()));
        if (xMLSchemaData != null) {
            xMLSchemaData.setLocationParseState(this.OCM.getLocationParseState(uRI));
            return this.retrieve(xMLSchemaData, uRI2);
        }
        return null;
    }

    public Schema searchAmongAncestorInTheDepthFirstTree(URI uRI, URI uRI2, Vertex vertex) {
        Vertex vertex2 = vertex;
        boolean bl = false;
        while (vertex2 != null) {
            SchemaImpl schemaImpl = (SchemaImpl)vertex2.getObject();
            if (schemaImpl.getSaveAsLocation().equals(uRI) && (uRI2 == null && schemaImpl.getTargetNamespace() == null || uRI2 != null && uRI2.equals(schemaImpl.getTargetNamespace()))) {
                return schemaImpl;
            }
            if (!bl) {
                if ((vertex2 = this.traversal.getParent(vertex2)) != null) continue;
                vertex2 = this.fcomposingSchema;
                bl = true;
                continue;
            }
            vertex2 = null;
        }
        return null;
    }

    public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
        block16: {
            CompositionStatementImpl compositionStatementImpl = (CompositionStatementImpl)edgeEnd;
            if (compositionStatementImpl.getVertex() != CompositionStatementImpl.NULLVERTEX) {
                return;
            }
            if (compositionStatementImpl.getLocation() == null) {
                return;
            }
            Schema schema = this.searchAmongAncestorInTheDepthFirstTree(compositionStatementImpl.getLocation(), compositionStatementImpl.getExplicitTargetNamespace(), vertex);
            if (schema == null && compositionStatementImpl.getWeight() != 5.0f) {
                schema = this.searchAmongAncestorInTheDepthFirstTree(compositionStatementImpl.getLocation(), null, vertex);
            }
            try {
                if (schema == null) {
                    schema = this.OCM.searchSchemaByLocation(compositionStatementImpl.getLocation(), compositionStatementImpl.getExplicitTargetNamespace());
                    if (schema == null && compositionStatementImpl.getWeight() != 5.0f) {
                        schema = this.OCM.searchSchemaByLocation(compositionStatementImpl.getLocation(), null);
                    }
                    if (schema != null) {
                        if (this.isUsedByMoreThanOneSchema((SchemaImpl)schema)) {
                            schema = this.clone((SchemaForParserImpl)schema);
                        } else {
                            this.OCM.removeFromCache(schema);
                        }
                    }
                }
                if (schema != null) {
                    compositionStatementImpl.setSchemaAfterComposition(schema);
                    CompositionStatement[] compositionStatementArray = CompositionHandler.getCompositionStatement((Schema)vertex.getObject(), compositionStatementImpl.getLocation(), compositionStatementImpl.getExplicitTargetNamespace(), compositionStatementImpl.getWeight());
                    if (compositionStatementArray != null) {
                        int n = 0;
                        while (n < compositionStatementArray.length) {
                            CompositionStatementImpl compositionStatementImpl2 = (CompositionStatementImpl)compositionStatementArray[n];
                            if (compositionStatementImpl2.getVertex() == CompositionStatementImpl.NULLVERTEX) {
                                compositionStatementImpl2.setSchemaAfterComposition(schema);
                            }
                            ++n;
                        }
                    }
                }
            }
            catch (ParseException parseException) {
                if (Debug.DEBUG) {
                    parseException.printStackTrace(System.err);
                }
            }
            catch (IOException iOException) {
                if (!Debug.DEBUG) break block16;
                iOException.printStackTrace(System.err);
            }
        }
    }

    class CountNumberOfReferencesToASchema
    extends DefaultGraphVisitor {
        private URI schemaLocation;
        private int nbOfRefs = 0;
        private Condition condition = new Condition();

        public CountNumberOfReferencesToASchema(URI uRI) {
            if (uRI == null) {
                throw new NullPointerException();
            }
            this.schemaLocation = uRI;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
            if (this.schemaLocation.equals(edgeEnd.getVertex())) {
                ++this.nbOfRefs;
            }
        }

        public int getNumberOfReferences() {
            return this.nbOfRefs;
        }

        class Condition
        extends TraverseEdgeCondition {
            public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

            Condition() {
            }

            public boolean traverse(Vertex vertex, EdgeEnd edgeEnd, GraphVisitor graphVisitor) {
                return CountNumberOfReferencesToASchema.this.nbOfRefs <= 1;
            }
        }
    }

    static class SchemaImplComparator
    implements Comparator {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        SchemaImplComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.toString(object).compareTo(this.toString(object2));
        }

        private String toString(Object object) {
            SchemaImpl schemaImpl = (SchemaImpl)object;
            return this.toString(schemaImpl.getSaveAsLocation(), schemaImpl.getTargetNamespace());
        }

        private String toString(URI uRI, URI uRI2) {
            return uRI + ":" + uRI2;
        }
    }
}

