/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.schemaparser.composition;

import com.ibm.sketch.graph.EdgeEnd;
import com.ibm.sketch.graph.Vertex;
import com.ibm.sketch.schemaparser.composition.SimpleRedefineModificationVisitor;
import com.ibm.xml.ecm.schema.OpenCloseManager;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.impl.CompositionStatementImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import java.util.Vector;

class StronglyConnectedSimpleRedefineModificationVisitor
extends SimpleRedefineModificationVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Vector modifiedEdges = new Vector();
    private OpenCloseManager OCM = FactoryImpl.instance().getOpenCloseManager();

    public StronglyConnectedSimpleRedefineModificationVisitor(SchemaImpl schemaImpl) {
        super(schemaImpl);
    }

    public void finished(Vertex vertex) {
        super.finished(vertex);
        this.restoreModifiedEdges();
    }

    protected void restoreModifiedEdges() {
        int n = 0;
        while (n < this.modifiedEdges.size()) {
            ((CompositionStatementImpl)this.modifiedEdges.get(n)).setSchemaAfterComposition(null);
            ++n;
        }
        this.modifiedEdges.clear();
    }

    public void visitEdge(Vertex vertex, EdgeEnd edgeEnd) {
        this.restoreModifiedEdges();
        CompositionStatementImpl compositionStatementImpl = (CompositionStatementImpl)edgeEnd;
        if (compositionStatementImpl.getLocation() == null) {
            return;
        }
        if (compositionStatementImpl.getVertex() != CompositionStatementImpl.NULLVERTEX) {
            super.visitEdge(vertex, edgeEnd);
            return;
        }
        Schema schema = this.OCM.searchSchemaByLocation(compositionStatementImpl.getLocation(), compositionStatementImpl.getExplicitTargetNamespace());
        if (schema != null) {
            compositionStatementImpl.setSchemaAfterComposition(schema);
            this.modifiedEdges.add(compositionStatementImpl);
        }
        super.visitEdge(vertex, edgeEnd);
    }
}

