/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.URIComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class CollectionWithDuplications {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TreeSet set;
    private int length = 0;
    private Comparator elementComparator;

    public CollectionWithDuplications(Comparator comparator) {
        this.set = new TreeSet(new EquivalenceClassComparator(comparator));
        this.elementComparator = comparator;
    }

    public boolean add(Object object) {
        EquivalenceClass equivalenceClass = this.get(object);
        if (equivalenceClass == null) {
            this.set.add(new EquivalenceClass(object));
            return true;
        }
        return equivalenceClass.addElement(object);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public boolean addEquivalenceClass(EquivalenceClass equivalenceClass) {
        EquivalenceClass equivalenceClass2 = this.get(equivalenceClass.first());
        if (equivalenceClass2 == null) {
            return this.set.add(equivalenceClass);
        }
        Vector vector = equivalenceClass.elements;
        int n = 0;
        while (n < vector.size()) {
            equivalenceClass2.addElement(vector.get(n));
            ++n;
        }
        return true;
    }

    public void clear() {
        this.set.clear();
        this.length = 0;
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public EquivalenceClass get(Object object) {
        SortedSet<Object> sortedSet = this.set.tailSet(object);
        if (sortedSet.isEmpty()) {
            return null;
        }
        EquivalenceClass equivalenceClass = (EquivalenceClass)sortedSet.first();
        if (this.elementComparator.compare(equivalenceClass.first(), object) != 0) {
            return null;
        }
        return equivalenceClass;
    }

    public EquivalenceClass[] getAllEquivalenceClasses() {
        return this.set.toArray(new EquivalenceClass[this.set.size()]);
    }

    public Object[][] getDuplications() {
        Object[][] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[][])iterator.next();
            if (objectArray.length() <= 1) continue;
            vector.add(objectArray.elements());
        }
        if (vector.size() > 0) {
            objectArray = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray);
            return objectArray;
        }
        return null;
    }

    public Object[] getElementsIdenticalTo(Object object) {
        EquivalenceClass equivalenceClass = this.get(object);
        if (equivalenceClass == null) {
            return null;
        }
        return equivalenceClass.elements();
    }

    public Object[] getElementsWithoutDuplications() {
        Object[] objectArray = new Object[this.set.size()];
        Iterator iterator = this.set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = ((EquivalenceClass)iterator.next()).first();
            ++n;
        }
        return objectArray;
    }

    public Object getFirstElementIdenticalTo(Object object) {
        EquivalenceClass equivalenceClass = this.get(object);
        if (equivalenceClass == null) {
            return null;
        }
        return equivalenceClass.first();
    }

    public TreeSet getSetOfAllEquivalenceClasses() {
        return (TreeSet)this.set.clone();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public static void main(String[] stringArray) {
        CollectionWithDuplications collectionWithDuplications = new CollectionWithDuplications(new URIComparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo((Comparable)object2);
            }
        });
        collectionWithDuplications.add("Type:1:http://www.example.com/IPO:1:Address");
        collectionWithDuplications.add("Type:1:http://www.example.com/IPO:1:USAddress");
        collectionWithDuplications.add("Type:1:http://www.example.com/IPO:1:UKAddress");
        collectionWithDuplications.add("Type:1:http://www.example.com/IPO:1:USState");
        collectionWithDuplications.add("Type:1:http://www.example.com/IPO:1:UKPostcode");
        Iterator iterator = collectionWithDuplications.set.iterator();
        while (iterator.hasNext()) {
            System.out.println(((EquivalenceClass)iterator.next()).first());
        }
    }

    public boolean remove(Object object, boolean bl) {
        SortedSet<Object> sortedSet = this.set.tailSet(object);
        if (sortedSet.isEmpty()) {
            return false;
        }
        EquivalenceClass equivalenceClass = (EquivalenceClass)sortedSet.first();
        if (this.elementComparator.compare(equivalenceClass.first(), object) != 0) {
            return false;
        }
        boolean bl2 = false;
        if (equivalenceClass != null) {
            bl2 = equivalenceClass.removeElement(object, bl);
            if (equivalenceClass.length() == 0) {
                equivalenceClass.addElement(object);
                sortedSet.remove(equivalenceClass);
                --this.length;
            }
        }
        return bl2;
    }

    public boolean removeEquivalenceClass(EquivalenceClass equivalenceClass) {
        return this.set.remove(equivalenceClass);
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            EquivalenceClass equivalenceClass = (EquivalenceClass)iterator.next();
            int n = 0;
            while (n < equivalenceClass.elements.size()) {
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(equivalenceClass.elements.get(n));
                ++n;
            }
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class EquivalenceClassComparator
    implements Comparator {
        private Comparator comparator;

        public EquivalenceClassComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object object, Object object2) {
            Object object3 = object instanceof EquivalenceClass ? ((EquivalenceClass)object).first() : object;
            Object object4 = object2 instanceof EquivalenceClass ? ((EquivalenceClass)object2).first() : object2;
            return this.comparator.compare(object3, object4);
        }
    }

    public class EquivalenceClass {
        protected Vector elements = new Vector();

        protected EquivalenceClass(Object object) {
            this.addElement(object);
        }

        protected boolean addElement(Object object) {
            int n = 0;
            while (n < this.elements.size()) {
                if (this.elements.get(n) == object) {
                    return false;
                }
                ++n;
            }
            this.elements.add(object);
            CollectionWithDuplications.this.length++;
            return true;
        }

        public int length() {
            return this.elements.size();
        }

        protected boolean removeElement(Object object, boolean bl) {
            if (!bl) {
                boolean bl2 = false;
                int n = 0;
                while (n < this.elements.size()) {
                    if (CollectionWithDuplications.this.elementComparator.compare(object, this.elements.get(n)) == 0) {
                        this.elements.remove(n);
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (bl2) {
                    CollectionWithDuplications.this.length--;
                }
                return bl2;
            }
            int n = 0;
            while (n < this.elements.size()) {
                if (object == this.elements.get(n)) {
                    this.elements.remove(n);
                    CollectionWithDuplications.this.length--;
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Object[] elements() {
            return this.elements.toArray();
        }

        public Object get(int n) {
            return this.elements.get(n);
        }

        public Object first() {
            return this.elements.get(0);
        }

        public String toString() {
            return this.first().toString();
        }
    }
}

