/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.ArgumentException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public abstract class CommandLineApplication {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean deep;
    private Vector files = new Vector();
    protected boolean throwArgumentException = false;

    public abstract String getApplicationName();

    public abstract String[] getFileExtensions();

    public File[] getFiles() {
        Object[] objectArray = null;
        if (this.files.size() > 0) {
            objectArray = new File[this.files.size()];
            this.files.copyInto(objectArray);
        }
        return objectArray;
    }

    protected void help(PrintStream printStream) {
        printStream.println("Usage : " + this.getApplicationName() + " [-options] file1 file2 ... fileN");
        printStream.println(" where options include :");
        printStream.println("-r  if fileI is a directory, all its subdirectories will be processed recursively");
        printStream.println("-? -help  help");
    }

    public boolean isDirectoriesRrocessedRecursively() {
        return this.deep;
    }

    protected Vector listFiles(File file) {
        if (this.deep) {
            return this.listFiles(file, new DeepFilter());
        }
        return this.listFiles(file, new SimpleFilter());
    }

    protected Vector listFiles(File file, FileFilter fileFilter) {
        Vector<File> vector = new Vector<File>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    vector.addAll(this.listFiles(fileArray[n], fileFilter));
                    ++n;
                }
            }
        } else {
            vector.add(file);
        }
        return vector;
    }

    protected void parseCommandLine(String[] stringArray) {
        if (stringArray.length == 0) {
            this.help(System.err);
            System.exit(0);
        }
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].substring(0, 1).equals("-") && !bl) {
                n += this.parseOption(stringArray, n);
            } else {
                this.parseFile(stringArray, n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.help(System.err);
            System.exit(0);
        }
    }

    protected void parseFile(String[] stringArray, int n) {
        if (stringArray[n] != null && stringArray[n].indexOf(42) >= 0) {
            return;
        }
        this.files.addAll(this.listFiles(new File(stringArray[n])));
    }

    protected int parseOption(String[] stringArray, int n) {
        String string = stringArray[n].substring(1);
        if (string.equals("?") || string.equals("help")) {
            this.help(System.out);
        } else if (string.equals("r")) {
            this.deep = true;
        } else {
            if (this.throwArgumentException) {
                throw new ArgumentException(string + " is an invalid option.\n\n" + this.help());
            }
            System.out.println(string + " is an invalid option.");
            this.help(System.out);
            System.exit(0);
        }
        return 0;
    }

    protected String help() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.help(new PrintStream(byteArrayOutputStream));
        String string = byteArrayOutputStream.toString();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    protected abstract void process();

    public void processFromCommandLine(String[] stringArray) {
        this.parseCommandLine(stringArray);
        this.process();
    }

    public void setThrowArgumentException(boolean bl) {
        this.throwArgumentException = bl;
    }

    public boolean throwArgumentException() {
        return this.throwArgumentException;
    }

    private class SimpleFilter
    implements FileFilter {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private SimpleFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String[] stringArray = CommandLineApplication.this.getFileExtensions();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (file.toString().endsWith("." + stringArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
    }

    private class DeepFilter
    implements FileFilter {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private DeepFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String[] stringArray = CommandLineApplication.this.getFileExtensions();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (file.toString().endsWith("." + stringArray[n])) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
    }
}

