/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.ComparatorForEquality;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class DuplicationFinder {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static int compare(Object object, Object object2, Comparator comparator) {
        if (comparator != null) {
            return comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    private static boolean equals(Object object, Object object2, ComparatorForEquality comparatorForEquality) {
        if (comparatorForEquality != null) {
            return comparatorForEquality.equals(object, object2);
        }
        return object.equals(object2);
    }

    public static Object[][] getDuplications(Object[] objectArray, Comparator comparator) {
        if (objectArray == null) {
            return null;
        }
        return DuplicationFinder.getDuplicationsInAnOrderedArray(DuplicationFinder.sort(objectArray, comparator), comparator);
    }

    public static Object[][] getDuplications(Object[] objectArray, boolean bl, Comparator comparator) throws ClassCastException {
        if (objectArray == null) {
            return null;
        }
        if (!bl) {
            return DuplicationFinder.getDuplicationsInAnOrderedArray(DuplicationFinder.sort(objectArray, comparator), comparator);
        }
        return DuplicationFinder.getDuplicationsInAnOrderedArray(objectArray, comparator);
    }

    public static Object[][] getDuplicationsInAnOrderedArray(Comparable[] comparableArray) {
        return DuplicationFinder.getDuplicationsInAnOrderedArray(comparableArray, null);
    }

    public static Object[][] getDuplicationsInAnOrderedArray(Object[] objectArray, Comparator comparator) {
        int n;
        Object[][] objectArray2;
        if (objectArray == null) {
            return null;
        }
        Vector<Object[][]> vector = new Vector<Object[][]>();
        int n2 = 0;
        if (objectArray == null || objectArray.length < 2) {
            return null;
        }
        int n3 = 1;
        while (n3 < objectArray.length) {
            if (DuplicationFinder.compare(objectArray[n3 - 1], objectArray[n3], comparator) != 0) {
                if (n3 - n2 >= 2) {
                    objectArray2 = new Object[n3 - n2];
                    n = n2;
                    while (n < n3) {
                        objectArray2[n - n2] = objectArray[n];
                        ++n;
                    }
                    vector.add(objectArray2);
                }
                n2 = n3;
            }
            ++n3;
        }
        if (DuplicationFinder.compare(objectArray[n3 - 2], objectArray[n3 - 1], comparator) == 0 && n3 - n2 >= 2) {
            objectArray2 = new Object[n3 - n2];
            n = n2;
            while (n < n3) {
                objectArray2[n - n2] = objectArray[n];
                ++n;
            }
            vector.add(objectArray2);
        }
        if (vector.size() > 0) {
            objectArray2 = new Object[vector.size()][];
            vector.copyInto((Object[])objectArray2);
            return objectArray2;
        }
        return null;
    }

    public static Object[] getObjectsEqualTo(Object[] objectArray, Object object, ComparatorForEquality comparatorForEquality) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (DuplicationFinder.equals(object, objectArray[n], comparatorForEquality)) {
                vector.add(object2);
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector.toArray();
        }
        return null;
    }

    public static Object[] getObjectsEqualToInAnOrderedArray(Object[] objectArray, Object object, Comparator comparator) {
        if (objectArray == null) {
            return null;
        }
        int n = comparator != null ? Arrays.binarySearch(objectArray, object, comparator) : Arrays.binarySearch(objectArray, object);
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            if (DuplicationFinder.compare(objectArray[n3], objectArray[n], comparator) != 0) {
                n2 = n3 + 1;
                break;
            }
            --n3;
        }
        int n4 = objectArray.length - 1;
        int n5 = n + 1;
        while (n5 < objectArray.length) {
            if (DuplicationFinder.compare(objectArray[n5], objectArray[n], comparator) != 0) {
                n4 = n5 - 1;
                break;
            }
            ++n5;
        }
        Object[] objectArray2 = new Object[n4 - n2 + 1];
        int n6 = n2;
        while (n6 <= n4) {
            objectArray2[n6 - n2] = objectArray[n6];
            ++n6;
        }
        return objectArray2;
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.add("coucou4");
        vector.add("coucou1");
        vector.add("coucou3");
        vector.add("coucou4");
        vector.add("coucou2");
        vector.add("coucou3");
        vector.add("coucou3");
        vector.add("coucou4");
        vector.add("coucou2");
        vector.add(new String("coucou4"));
        vector.add("poupou");
        System.out.println(vector);
        Object[][] objectArray = DuplicationFinder.getDuplications(vector.toArray(), null);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                System.out.println(Arrays.asList(objectArray[n]));
                ++n;
            }
        }
        System.out.println("coucou1 = " + Arrays.asList(DuplicationFinder.getObjectsEqualTo(vector.toArray(), "coucou1", null)));
        System.out.println("coucou2 = " + Arrays.asList(DuplicationFinder.getObjectsEqualTo(vector.toArray(), "coucou2", null)));
        System.out.println("coucou3 = " + Arrays.asList(DuplicationFinder.getObjectsEqualTo(vector.toArray(), "coucou3", null)));
        System.out.println("coucou4 = " + Arrays.asList(DuplicationFinder.getObjectsEqualTo(vector.toArray(), "coucou4", null)));
        System.out.println("poupou = " + Arrays.asList(DuplicationFinder.getObjectsEqualTo(vector.toArray(), "poupou", null)));
        System.out.println("youyou = " + DuplicationFinder.getObjectsEqualTo(vector.toArray(), "youyou", null));
    }

    private static Object[] sort(Object[] objectArray, Comparator comparator) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        if (comparator != null) {
            Arrays.sort(objectArray2, comparator);
        } else {
            Arrays.sort(objectArray2);
        }
        return objectArray2;
    }
}

