/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.CommandLineApplication;
import com.ibm.sketch.util.Debug;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.sketch.util.urlRedirection.LocationCorrespondance;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import com.ibm.xml.ecm.schema.Annotation;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.PropertyNotFoundException;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.appinfo;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.ComponentNormalizer;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Ecm2file
extends CommandLineApplication {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean DEBUG = false;
    public static final String version = "Alpha 1.0.3";
    private File outFile;
    private boolean allTypes = false;
    private boolean allGroup = false;
    private boolean allAttributegroups = false;
    private boolean allElements = false;
    private boolean allAttributes = false;
    private String typeName;
    private String elementName;
    private String attributeName;
    private String attGroupName;
    private String groupName;
    private boolean mutExOptSet = false;
    private Schema outSch;
    private String orig;
    private boolean showSteps = true;
    private boolean stopAtBuiltInComponents = false;

    protected void addOriginalComponents(Schema schema, Schema schema2) {
        if (this.orig == null) {
            return;
        }
        TopComponent[] topComponentArray = schema2.listTopComponent(true);
        if (topComponentArray == null) {
            return;
        }
        int n = 0;
        while (n < topComponentArray.length) {
            TopComponent topComponent;
            if (topComponentArray[n].getNCName() != null && (topComponent = schema.getTopComponent(topComponentArray[n].getComponentType(), topComponentArray[n].getNCName(), false)) != null && topComponent.getRedefine() == null) {
                schema.removeTopComponent(topComponent);
                String string = topComponent.getNCName();
                String string2 = this.orig;
                int n2 = 2;
                while (schema2.getTopComponent(topComponent.getComponentType(), string2 + "-" + string, false) != null) {
                    string2 = string2 + n2;
                    ++n2;
                }
                topComponent.setNCName(string2 + "-" + string);
                try {
                    schema2.insertBefore(topComponent, topComponentArray[n]);
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    public String getApplicationName() {
        return "ecm2file";
    }

    public String[] getFileExtensions() {
        return new String[]{"xsd"};
    }

    protected TopComponent[] getTopComponentToFlatten(Schema schema, File file) {
        if (schema != null) {
            TopComponent[] topComponentArray = null;
            if (this.typeName != null) {
                TopComponent topComponent = schema.getTopComponent(2, this.typeName, false);
                if (topComponent == null) {
                    topComponent = schema.getTopComponent(1, this.typeName);
                }
                if (topComponent == null) {
                    System.out.println("Type " + this.typeName + " not found at " + file);
                    return null;
                }
                topComponentArray = new TopComponent[]{topComponent};
            } else if (this.attGroupName != null) {
                TopComponent topComponent = schema.getTopComponent(4, this.attGroupName, false);
                if (topComponent == null) {
                    System.out.println("Attribute group " + this.attGroupName + " not found at " + file);
                    return null;
                }
                topComponentArray = new TopComponent[]{topComponent};
            } else if (this.attributeName != null) {
                TopComponent topComponent = schema.getTopComponent(6, this.attributeName, false);
                if (topComponent == null) {
                    System.out.println("Global attribute declaration  " + this.attributeName + " not found at " + file);
                    return null;
                }
                topComponentArray = new TopComponent[]{topComponent};
            } else if (this.elementName != null) {
                TopComponent topComponent = schema.getTopComponent(3, this.elementName, false);
                if (topComponent == null) {
                    System.out.println("Global element declaration " + this.elementName + " not found at " + file);
                    return null;
                }
                topComponentArray = new TopComponent[]{topComponent};
            } else if (this.groupName != null) {
                TopComponent topComponent = schema.getTopComponent(5, this.groupName, false);
                if (topComponent == null) {
                    System.out.println("Model group " + this.groupName + " not found at " + file);
                    return null;
                }
                topComponentArray = new TopComponent[]{topComponent};
            } else if (this.allGroup) {
                topComponentArray = schema.listTopComponent(5, true);
            } else if (this.allAttributegroups) {
                topComponentArray = schema.listTopComponent(4, true);
            } else if (this.allElements) {
                topComponentArray = schema.listTopComponent(3, true);
            } else if (this.allAttributes) {
                topComponentArray = schema.listTopComponent(6, true);
            } else {
                topComponentArray = schema.listTopComponent(true);
                if (topComponentArray != null) {
                    Vector<TopComponent> vector = new Vector<TopComponent>();
                    int n = 0;
                    while (n < topComponentArray.length) {
                        if (topComponentArray[n].getComponentType() == 1 || topComponentArray[n].getComponentType() == 2) {
                            vector.add(topComponentArray[n]);
                        }
                        ++n;
                    }
                    if (vector.size() > 0) {
                        topComponentArray = vector.toArray(new TopComponent[vector.size()]);
                    }
                }
            }
            return topComponentArray;
        }
        return null;
    }

    protected void help(PrintStream printStream) {
        printStream.println("Usage : " + this.getApplicationName() + " [-options] schemaFile");
        printStream.println(" where options include :");
        printStream.println("-? -help  help");
        printStream.println("-version, to get the version of number of " + this.getApplicationName());
        printStream.println("-out outputFile, outputFile is the file name where the output schema will be stored.");
        printStream.println("-t typeName, typeName is the name of the type which should be flattened.");
        printStream.println("-element name, indicate that the type of the global element whose name is 'name' should be flattened");
        printStream.println("-attribute name, indicate that the type of the global attribute whose name is 'name' should be flattened");
        printStream.println("-group name, indicate that the model group named 'name' should be flattened.");
        printStream.println("-attributeGroup name, indicate that the attribute group named 'name' should be flattened.");
        printStream.println("-alltypes, indicate that all global types defined in the input schema file should be flattened");
        printStream.println("-allgroups, indicate that all global model group definitions in the input schema file should be flattened");
        printStream.println("-allattributegroups, indicate that all global attribute group definitions in the input schema file should be flattened");
        printStream.println("-allelements, indicate that types of all global element declarations in the input schema file should be flattened");
        printStream.println("-allattributes, indicate that types of all global attribute declarations in the input schema file should be flattened");
        printStream.println("-stopAtBuiltInComponents, indicate that built-in components (like xsd:integer, xsd:NCName, etc) should not be flattened");
        printStream.println("NOTE: Options '-t', '-alltypes', '-allgroups', '-allattributegroups', '-allelements', '-allattributes', 'element name', 'attribute name', 'group name' and 'attributeGroup name' are mutually exclusive. When none of them is specified, " + this.getApplicationName() + " behaves as if option '-alltypes' was used");
        printStream.println("-orig prefix means that the original version of all top components that have been flattened are included in the output file, in the original form they used (not flattened), with a name of the form prefix-name. NOTE : if the original component is defined in a <redefine>, it will not be included in the output schema.");
        printStream.println("-showSteps (true | false), this option is used to indicate whether or not information about the orign of flattened components must be added into annotations.");
    }

    public static void main(String[] stringArray) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Ecm2file ecm2file = new Ecm2file();
        System.out.println("Initializing " + ((CommandLineApplication)ecm2file).getApplicationName() + ". Please wait ...");
        if (Debug.DEBUG) {
            System.err.println("Start time : " + simpleDateFormat.format(Calendar.getInstance().getTime()));
        }
        FactoryImpl.instance();
        ecm2file.processFromCommandLine(stringArray);
    }

    protected int parseOption(String[] stringArray, int n) {
        String string = stringArray[n].substring(1);
        String string2 = "options '-alltypes','-allgroups', '-allattributegroups', '-allelements', '-allattributes',  ' -t typeName', '-element name', 'attribute name', '-attributeGroup name', '-group name'  are mutually exclusive";
        if (string.equals("version")) {
            System.out.println(this.getApplicationName() + " version " + version);
            return 0;
        }
        if (string.equals("t")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            if (n + 1 < stringArray.length) {
                this.typeName = stringArray[n + 1];
                this.mutExOptSet = true;
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("alltypes")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            this.allTypes = true;
            this.mutExOptSet = true;
            return 0;
        }
        if (string.equals("allgroups")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            this.allGroup = true;
            this.mutExOptSet = true;
            return 0;
        }
        if (string.equals("allattributegroups")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            this.allAttributegroups = true;
            this.mutExOptSet = true;
            return 0;
        }
        if (string.equals("-allelements")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            this.allElements = true;
            this.mutExOptSet = true;
            return 0;
        }
        if (string.equals("-allattributes")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            this.allAttributes = true;
            this.mutExOptSet = true;
            return 0;
        }
        if (string.equals("attributeGroup")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            if (n + 1 < stringArray.length) {
                this.attGroupName = stringArray[n + 1];
                this.mutExOptSet = true;
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("attribute")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            if (n + 1 < stringArray.length) {
                this.attributeName = stringArray[n + 1];
                this.mutExOptSet = true;
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("element")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            if (n + 1 < stringArray.length) {
                this.elementName = stringArray[n + 1];
                this.mutExOptSet = true;
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("group")) {
            if (this.mutExOptSet) {
                System.err.println(string2);
                System.exit(0);
            }
            if (n + 1 < stringArray.length) {
                this.groupName = stringArray[n + 1];
                this.mutExOptSet = true;
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("out")) {
            if (n + 1 < stringArray.length) {
                this.outFile = new File(stringArray[n + 1]);
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("orig")) {
            if (n + 1 < stringArray.length) {
                this.orig = stringArray[n + 1];
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("showSteps")) {
            if (n + 1 < stringArray.length && (stringArray[n + 1].equalsIgnoreCase("true") || stringArray[n + 1].equalsIgnoreCase("false"))) {
                this.showSteps = stringArray[n + 1].equalsIgnoreCase("true");
                return 1;
            }
            this.help(System.err);
            System.exit(0);
            return 0;
        }
        if (string.equals("?") || string.equals("help")) {
            this.help(System.out);
            System.exit(0);
            return 0;
        }
        if (string.equals("stopAtBuiltInComponents")) {
            this.stopAtBuiltInComponents = true;
            return 0;
        }
        System.out.println(string + " is an invalid option.");
        this.help(System.out);
        System.exit(0);
        return 0;
    }

    protected void process() {
        File[] fileArray = this.getFiles();
        if (fileArray == null || fileArray.length == 0 || fileArray.length > 1) {
            this.help(System.err);
            System.exit(0);
            return;
        }
        boolean bl = ComponentNormalizer.addInfoAboutSchemaObjectOrigin();
        boolean bl2 = ComponentNormalizer.stopAtBuiltInComponents();
        try {
            ComponentNormalizer.setAddInfoAboutSchemaObjectOrigin(this.showSteps);
            ComponentNormalizer.setStopAtBuiltInComponents(this.stopAtBuiltInComponents);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            System.out.println(this.getApplicationName() + " has been initialized");
            System.err.println("PROCESSING " + fileArray[0] + " time : " + simpleDateFormat.format(Calendar.getInstance().getTime()) + " ...");
            Schema[] schemaArray = this.process(fileArray[0]);
            if (this.outSch == null) {
                System.out.println("Type flattening was not performed");
            } else {
                Object object;
                if (this.outFile == null) {
                    int n = fileArray[0].toString().lastIndexOf(".");
                    String string = this.typeName != null ? "Type_" + this.typeName : (this.elementName != null ? "Element_" + this.elementName : (this.attributeName != null ? "Attribute_" + this.attributeName : (this.groupName != null ? "Group_" + this.groupName : (this.attGroupName != null ? "AttributeGroup_" + this.attributeName : (this.allGroup ? "allTopGroupsFlattened" : (this.allAttributegroups ? "allAttributeGroupFlattened" : (this.allElements ? "allTopElementsFlattened" : (this.allAttributes ? "allAttributesFlattened" : "allTopTypesFlattened"))))))));
                    object = n == -1 ? fileArray[0] + "-" + string + ".xsd" : fileArray[0].toString().substring(0, n) + "-" + string + fileArray[0].toString().substring(n);
                    this.outFile = new File((String)object);
                }
                DocumentImpl documentImpl = new DocumentImpl();
                object = (Element)this.outSch.toXMLRepresentation(documentImpl);
                documentImpl.appendChild((Node)object);
                try {
                    SchemaQualityChecker.save((Document)documentImpl, this.outFile, null);
                }
                catch (IOException iOException) {
                    System.out.println("IOError: cannot save data to " + this.outFile + "\n" + iOException.getMessage());
                }
            }
            System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            ComponentNormalizer.setAddInfoAboutSchemaObjectOrigin(bl);
            ComponentNormalizer.setAddInfoAboutSchemaObjectOrigin(bl2);
            throw throwable;
        }
        ComponentNormalizer.setAddInfoAboutSchemaObjectOrigin(bl);
        ComponentNormalizer.setAddInfoAboutSchemaObjectOrigin(bl2);
    }

    protected Schema[] process(File file) {
        OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)OpenCloseManagerImpl.getInstance();
        LocationCorrespondance locationCorrespondance = openCloseManagerImpl.getLocationCorrespondance();
        try {
            locationCorrespondance.getUse(file.toURL()).openConnection();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file : " + file.toString());
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            return null;
        }
        Vector vector = new Vector();
        try {
            try {
                CheckerManagerImpl.getInstance().reset();
                Lint lint = new Lint();
                System.out.println("Checking the validity of schema located at " + file);
                Error[] errorArray = lint.findErrors(file.toURL(), 10, "USEnglish", "", vector, false, false);
                if (errorArray != null && errorArray.length > 0) {
                    new SchemaQualityChecker().textErrorReport(errorArray);
                    System.out.println("\n" + errorArray.length + " errors and warnings were found. Some type flattenings might fail.");
                } else {
                    System.out.println("No error found.");
                }
                Schema schema = null;
                if (vector.size() > 0) {
                    schema = (Schema)vector.get(0);
                }
                if (schema != null) {
                    TopComponent[] topComponentArray = this.getTopComponentToFlatten(schema, file);
                    if (topComponentArray != null) {
                        TopComponent topComponent = null;
                        int n = 0;
                        while (n < topComponentArray.length) {
                            try {
                                topComponent = ComponentNormalizer.normalize(topComponentArray[n], this.outSch, null);
                            }
                            catch (SchemaException schemaException) {
                                System.out.println(topComponentArray[n] + " was not flattened because it is invalid or one of the components it uses is invalid. The following error occurs during type flattening :");
                                System.out.println(schemaException.getMessage());
                            }
                            if (this.outSch == null && topComponent != null) {
                                this.outSch = topComponent.getSchema();
                                Factory factory = FactoryImpl.instance();
                                Annotation annotation = factory.createAnnotation();
                                appinfo appinfo2 = ComponentNormalizer.createDECMAppInfo(factory);
                                annotation.addInfo(appinfo2);
                                DocumentImpl documentImpl = new DocumentImpl();
                                Element element = documentImpl.createElementNS("http://w3.research.ibm.com/SKETCH/ecm", "ec:exec");
                                element.setAttribute("version", version);
                                element.setAttribute("stopAtBuiltInComponents", this.stopAtBuiltInComponents ? "true" : "false");
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                element.setAttribute("dateTime", simpleDateFormat.format(Calendar.getInstance().getTime()));
                                appinfo2.addNode(element);
                                this.outSch.removeTopComponent(topComponent);
                                this.outSch.addAnnotation(annotation);
                                this.outSch.addTopComponent(topComponent);
                            }
                            ++n;
                        }
                        if (this.orig != null) {
                            this.addOriginalComponents(schema, this.outSch);
                        }
                    } else {
                        System.out.println("No type found at " + file);
                        Schema[] schemaArray = null;
                        Object var18_21 = null;
                        openCloseManagerImpl.closeAllOpenedSchemas();
                        return schemaArray;
                    }
                }
                Object var18_22 = null;
                openCloseManagerImpl.closeAllOpenedSchemas();
            }
            catch (IOException iOException) {
                if (Debug.DEBUG) {
                    iOException.printStackTrace(System.err);
                } else {
                    System.out.println(iOException.getMessage());
                }
                Object var18_23 = null;
                openCloseManagerImpl.closeAllOpenedSchemas();
            }
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            openCloseManagerImpl.closeAllOpenedSchemas();
            throw throwable;
        }
        return null;
    }

    public static String getVersion() {
        return version;
    }
}

