/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.ComparatorForEquality;
import com.ibm.sketch.util.Debug;
import com.ibm.sketch.util.DuplicationFinder;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.SchemaComponent;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.TopComponent;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Locator;

public class SchemaLintTester
extends SchemaQualityChecker {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IDComparator anIDComparator = new IDComparator();
    protected String invalidSchemasNS = "http://w3.research.ibm.com/Sketch/InvalidSchemas";
    private static String nsSeparator = "";
    private static String schemaNS = "http://www.w3.org/2001/XMLSchema";

    public SchemaLintTester() {
        SchemaQualityChecker.rootElementName = "schemaLintTester";
    }

    public State[] getStates(Document document) {
        NodeList nodeList = this.getValidationInfoElements(document);
        System.out.println("list = " + nodeList);
        if (nodeList != null) {
            Object[] objectArray;
            Vector<State> vector = new Vector<State>(nodeList.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                objectArray = (Object[])nodeList.item(n);
                String string = objectArray.getAttribute("IDREF");
                String string2 = objectArray.getAttribute("isValid");
                if (string != null && !string.equals("")) {
                    boolean bl = false;
                    if (string2 != null && string2.equalsIgnoreCase("true")) {
                        bl = true;
                    }
                    vector.add(new State(string, bl));
                }
                ++n;
            }
            if (vector.size() > 0) {
                objectArray = new State[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
        }
        return null;
    }

    protected NodeList getValidationInfoElements(Document document) {
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            try {
                Element element2;
                if (node instanceof Element && new URL((element2 = (Element)node).getNamespaceURI()).equals(new URL(schemaNS)) && element2.getLocalName().equals("annotation")) {
                    return element2.getElementsByTagNameNS(this.invalidSchemasNS, "validationInfo");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        System.out.println("Initializing SchemaLintTester. Please wait ...");
        if (Debug.DEBUG) {
            System.err.println("Start time : " + simpleDateFormat.format(Calendar.getInstance().getTime()));
        }
        new SchemaLintTester().processFromCommandLine(stringArray);
    }

    protected Schema[] process(File file) {
        Object[] objectArray;
        try {
            if (!file.exists()) {
                System.out.println("File not found : " + file.toString());
                return null;
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Cannot read file : " + file.toString());
            if (Debug.DEBUG) {
                securityException.printStackTrace(System.err);
            }
            return null;
        }
        Vector vector = new Vector();
        try {
            block18: {
                try {
                    objectArray = new Lint();
                    objectArray.setSqc(this);
                    Object[] objectArray2 = objectArray.findErrors(file.toURL(), this.getCost(), "USEnglish", "", vector, false);
                    DOMParser dOMParser = new DOMParser();
                    dOMParser.setProperty("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.DocumentImpl");
                    dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    dOMParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                    dOMParser.parse(file.toURL().toString());
                    Document document = dOMParser.getDocument();
                    State[] stateArray = this.getStates(document);
                    if (stateArray == null) break block18;
                    Arrays.sort(stateArray, this.anIDComparator);
                    if (objectArray2 != null) {
                        Arrays.sort(objectArray2, this.anIDComparator);
                    }
                    boolean bl = true;
                    int n = 0;
                    while (n < stateArray.length) {
                        Element element;
                        Object[] objectArray3 = null;
                        if (objectArray2 != null) {
                            objectArray3 = DuplicationFinder.getObjectsEqualToInAnOrderedArray(objectArray2, stateArray[n], this.anIDComparator);
                        }
                        if (stateArray[n].isValid()) {
                            if (objectArray3 != null && objectArray3.length > 0) {
                                element = this.doc.createElement("ImplementationError");
                                this.currentFile.appendChild(element);
                                element.setAttribute("ID", stateArray[n].getID());
                                int n2 = 0;
                                while (n2 < objectArray3.length) {
                                    Element element2 = this.xmlErrorReport((Error)objectArray3[n2]);
                                    element.appendChild(element2);
                                    ++n2;
                                }
                                bl = false;
                            }
                        } else if (objectArray3 == null || objectArray3.length == 0) {
                            element = this.doc.createElement("ImplementationError");
                            this.currentFile.appendChild(element);
                            element.setAttribute("ID", stateArray[n].getID());
                            bl = false;
                        }
                        ++n;
                    }
                    if (!bl) break block18;
                    this.currentFile.appendChild(this.doc.createElement("perfect"));
                }
                catch (Exception exception) {
                    Element element;
                    Object object;
                    if (this.reportAsXML) {
                        object = new Error(null, null, 1, 2, exception);
                        element = this.xmlErrorReport((Error)object);
                        this.currentFile.appendChild(element);
                    }
                    object = new StringWriter();
                    exception.printStackTrace(new PrintWriter((Writer)object));
                    element = this.doc.createElement("FatalImplementationError");
                    element.appendChild(this.doc.createTextNode(((StringWriter)object).toString()));
                    this.currentFile.appendChild(element);
                    Object var15_19 = null;
                    FactoryImpl.instance().getOpenCloseManager().closeAllOpenedSchemas();
                }
            }
            Object var15_18 = null;
            FactoryImpl.instance().getOpenCloseManager().closeAllOpenedSchemas();
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            FactoryImpl.instance().getOpenCloseManager().closeAllOpenedSchemas();
            throw throwable;
        }
        if (vector.size() > 0) {
            objectArray = new Schema[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    protected Element xmlErrorReport(Error error) {
        Element element;
        Locator locator = error.getLocator();
        Element element2 = this.doc.createElement("error");
        element2.setAttribute("severity", String.valueOf(error.getSeverity()));
        element2.setAttribute("type", String.valueOf(error.getErrorType()));
        if (locator != null) {
            int n;
            String string;
            element = this.doc.createElement("source");
            element2.appendChild(element);
            element.setAttribute("location", locator.getSystemId());
            String string2 = string = locator.getSystemId();
            if (string != null && (n = string.lastIndexOf("/")) >= 0 && n < string.length() - 1) {
                string2 = string2.substring(n + 1);
            }
            element.setAttribute("locationWithoutPath", string2);
            element.setAttribute("line", String.valueOf(locator.getLineNumber()));
            element.setAttribute("column", String.valueOf(locator.getColumnNumber()));
        }
        element = this.doc.createElement("message");
        element2.appendChild(element);
        element.appendChild(this.doc.createTextNode(error.getMessage()));
        return element2;
    }

    private class IDComparator
    implements Comparator,
    ComparatorForEquality {
        private IDComparator() {
        }

        private TopComponent getTopComponentAncestor(SchemaComponent schemaComponent) {
            if (schemaComponent instanceof TopComponent) {
                return (TopComponent)schemaComponent;
            }
            SchemaObject schemaObject = schemaComponent.getParent();
            while (schemaObject != null && !(schemaObject instanceof TopComponent)) {
                schemaObject = schemaObject.getParent();
            }
            return (TopComponent)schemaObject;
        }

        private String toString(Object object) {
            if (object instanceof Error) {
                SchemaObject schemaObject = ((Error)object).getInvalidSchemaObject();
                if (schemaObject instanceof SchemaComponent) {
                    TopComponent topComponent = this.getTopComponentAncestor((SchemaComponent)schemaObject);
                    return "1:" + topComponent.getID();
                }
                return "0:";
            }
            if (object instanceof State) {
                return "1:" + ((State)object).getID();
            }
            throw new ClassCastException();
        }

        public int compare(Object object, Object object2) {
            return this.toString(object).compareTo(this.toString(object2));
        }

        public boolean equals(Object object, Object object2) {
            return this.compare(object, object2) == 0;
        }
    }

    protected class State {
        public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private String ID;
        private boolean valid;

        private State(String string, boolean bl) {
            this.ID = string;
            this.valid = bl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getID() {
            return this.ID;
        }
    }
}

