/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.graph.GraphImpl;
import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.util.ArgumentException;
import com.ibm.sketch.util.CommandLineApplication;
import com.ibm.sketch.util.Debug;
import com.ibm.sketch.util.urlRedirection.LocationCorrespondance;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.ProgressMonitor;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import com.ibm.xml.ecm.schema.impl.PercentageOfWorkDoneIndicator;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import com.ibm.xml.ecm.schema.impl.TopComponentImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class SchemaQualityChecker
extends CommandLineApplication {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private int maxCost = 10;
    private boolean debug = false;
    protected boolean reportAsXML = false;
    protected File xmlOutput;
    private Element output;
    protected Element currentFile;
    protected Document doc;
    public static String appVersion = "2.2";
    public static String schemaLanguageVersion = "2001-05-02";
    public static String rootElementName = "schemaAnalysis";
    protected String styleSheet;
    private String errorReportDTD = "";
    private String errorReportSchema = "";
    private boolean haltAtFirstError = false;
    private File locationCorrespondanceFile;
    private boolean debugMemory = false;
    private String reportAsErrorExt;
    private boolean requireEachDocumentValid = false;
    private boolean requireEachDocumentValidOptionSpecified = false;
    private boolean entireSchemaValidOptionSpecified = false;
    private boolean noWarningEncoding = false;
    private boolean noWarningURIOmitsScheme = false;
    private boolean outputExceptionName = false;
    protected Lint lint = new Lint();
    private String outputEncoding = null;
    protected boolean indicateProgress;
    protected ProgressMonitor progressMonitor = null;

    public SchemaQualityChecker() {
        this.setDebug(false);
    }

    public String getApplicationName() {
        return "SchemaQualityChecker";
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public int getCost() {
        return this.maxCost;
    }

    public Element getCurrentFile() {
        return this.currentFile;
    }

    public Document getDoc() {
        return this.doc;
    }

    public String getErrorReportDTD() {
        return this.errorReportDTD;
    }

    public String getErrorReportSchema() {
        return this.errorReportSchema;
    }

    public String[] getFileExtensions() {
        return new String[]{"xsd"};
    }

    public Document getErrorReport() {
        return this.doc;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public File getXmlOutput() {
        return this.xmlOutput;
    }

    protected void help(PrintStream printStream) {
        super.help(printStream);
        printStream.println("-debugInfo print on the standard error output messages useful for debugging");
        printStream.println("-cost maxCost , where maxCost is the maximum cost of an allowed check operation. The default maxCost is 10");
        printStream.println("-reportAsXML outputFile, where outputFile is the file where the output messages will be saved as an XML document");
        printStream.println("-styleSheet URI, where URI is the location of the stylesheet used for the error report");
        printStream.println("-version, print out version number information");
        printStream.println("-indicateProgress, print out percentage of tasks alreading performed");
        printStream.println("-haltAtFirstError, stops processing when first error or warning encountered");
        printStream.println("-locationCorrespondence  file, where file is the location correspondance file");
        printStream.println("-errorReportDTD dtdURL, indicate that SQC should include into the reportAsXML document a DOCTYPE declaration with the specified URL location of the dtd for SQC output.");
        printStream.println("-errorReportSchema schemaURL, indicate that SQC should set the 'xsi:noNamespaceSchemaLocation' attribute of the root element of the output document to the URL location of the schema for SQC output.");
        printStream.println("-requireEachDocumentValid, indicate that each schema file used by the main schema file must be valid by itself");
        printStream.println("-entireSchemaValid, indicate that SQC should not try to validate schemas used by the main schema by themselves");
        printStream.println("-noWarning encoding, indicate that SQC should not issue a warning message if the schema file to read does not specify an encoding");
        printStream.println("-noWarning URIomitsScheme, indicate that SQC should not issue a warning message if relative URIs are used where absolute URIs are recommended.");
        printStream.println("-outputExceptionName, indicate that the schemaAnalysis report should provide the fully qualified name of exceptions and errors which were detected.");
        printStream.println("-emb, indicate that SQC should also validate embedded schemas");
        printStream.println("-wsdl, indicate that SQC should validate embedded schemas in WSDL documents.");
        printStream.println("-xform, indicate that SQC should validate embedded schemas in XForms.");
        printStream.println("-schemaLocation namespace locationURL, indicate the location of the schema definition to use to validate an element whose namespace is 'namespace'. 'locationURL' must be a valid absolute URL. This option is particularly important when option '-emb' is specified.");
        printStream.println("-noNSSchemaLocation locationURL, indicate the location of the schema definition to use to validate unqualified elements. 'locationURL' must be a valid absolute URL. This option is particularly important when option '-emb' is specified.");
        printStream.println("-fullProcessingDescAxis indicate that SQC should detect warnings due to possible inconsistencies in identity constraints which have at least one field xpath containing a descendant axis ('.//'). If this option is not set, SQC will not issue the following warnings for previously described identity constraints : \n 1. a field evaluates to an element whose type is a complex type.\n 2. a field evaluates to a node set containing nodes that may appear at the same time.");
        printStream.println("-reportLocWithoutPath, print locations of errors in the message section of an error without full path information.");
    }

    public boolean isHaltAtFirstError() {
        return this.haltAtFirstError;
    }

    public boolean isReportAsXML() {
        return this.reportAsXML;
    }

    public static void main(String[] stringArray) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        System.out.println("Initializing Schema Quality Checker. Please wait ...");
        if (Debug.DEBUG) {
            System.err.println("Start time : " + simpleDateFormat.format(Calendar.getInstance().getTime()));
        }
        FactoryImpl.instance();
        new SchemaQualityChecker().processFromCommandLine(stringArray);
    }

    protected void parseCommandLine(String[] stringArray) {
        if (stringArray.length == 0) {
            this.help(System.err);
            System.exit(0);
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].substring(0, 1).equals("-") && !bl) {
                n2 += this.parseOption(stringArray, n2);
            } else {
                if (this.reportAsErrorExt != null && ++n > 1) {
                    this.help(System.err);
                    System.exit(0);
                } else if (this.reportAsErrorExt != null) {
                    this.xmlOutput = new File(stringArray[n2] + "." + this.reportAsErrorExt);
                }
                this.parseFile(stringArray, n2);
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.help(System.err);
            System.exit(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int parseOption(String[] stringArray, int n) {
        try {
            String string = stringArray[n].substring(1);
            if (string.equals("debugInfo")) {
                this.setDebug(true);
                return 0;
            }
            if (string.equals("cost")) {
                if (n + 1 >= stringArray.length) return 0;
                this.setCost(Integer.parseInt(stringArray[n + 1]));
                return 1;
            }
            if (string.equals("reportAsXML")) {
                if (n + 1 < stringArray.length) {
                    if (stringArray[n + 1] == null || stringArray[n + 1].indexOf(".xsd") != -1 && stringArray[n + 1].length() - 4 == stringArray[n + 1].indexOf(".xsd")) {
                        String string2 = "\n" + stringArray[n + 1] + " is not permitted to be where the SchemaQualityChecker report is written.\n" + "Please use another filename that does not end with \".xsd\".  Or check if you inadvertently\n" + "omitted the filename you wanted SchemaQualityChecker to use for its report.\n\n";
                        if (this.throwArgumentException) {
                            throw new ArgumentException(string2 + this.help());
                        }
                        System.out.println(string2);
                        this.help(System.out);
                        System.exit(0);
                        return 0;
                    }
                    if (stringArray[n + 1].charAt(0) == '.') {
                        this.reportAsErrorExt = stringArray[n + 1].substring(1, stringArray[n + 1].length());
                        this.reportAsXML = true;
                        return 1;
                    }
                    this.xmlOutput = new File(stringArray[n + 1]);
                    this.reportAsXML = true;
                    return 1;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("styleSheet")) {
                if (n + 1 < stringArray.length) {
                    this.styleSheet = stringArray[n + 1];
                    return 1;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("indicateProgress")) {
                this.indicateProgress = true;
                return 0;
            }
            if (string.equals("debugMemory")) {
                SchemaObjectImpl.DEBUG_MEMORY = true;
                return 0;
            }
            if (string.equals("haltAtFirstError")) {
                this.haltAtFirstError = true;
                return 0;
            }
            if (string.equals("errorReportDTD")) {
                if (n + 1 < stringArray.length) {
                    this.errorReportDTD = stringArray[n + 1];
                    return 1;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("errorReportSchema")) {
                if (n + 1 < stringArray.length) {
                    this.errorReportSchema = stringArray[n + 1];
                    return 1;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("version")) {
                System.out.println("IBM SchemaQualityChecker version " + appVersion + ", W3C Schema language version " + schemaLanguageVersion + "\n");
                return 0;
            }
            if (string.equals("locationCorrespondence")) {
                if (n + 1 < stringArray.length) {
                    this.processLocationCorrespondanceFile(stringArray[n + 1]);
                    return 1;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("requireEachDocumentValid")) {
                if (this.entireSchemaValidOptionSpecified) {
                    String string3 = "options '-requireEachDocumentValid' and '-entireSchemaValid' are mutually exclusive\n";
                    if (this.throwArgumentException) {
                        throw new ArgumentException(string3);
                    }
                    System.out.println(string3);
                    System.exit(0);
                }
                this.requireEachDocumentValidOptionSpecified = true;
                this.requireEachDocumentValid = true;
                return 0;
            }
            if (string.equals("entireSchemaValid")) {
                if (this.requireEachDocumentValidOptionSpecified) {
                    String string4 = "options '-requireEachDocumentValid' and '-entireSchemaValid' are mutually exclusive\n";
                    if (this.throwArgumentException) {
                        throw new ArgumentException(string4);
                    }
                    System.out.println(string4);
                    System.exit(0);
                }
                this.entireSchemaValidOptionSpecified = true;
                this.requireEachDocumentValid = false;
                return 0;
            }
            if (string.equals("noWarning")) {
                if (n + 1 < stringArray.length) {
                    if (stringArray[n + 1].equals("encoding")) {
                        this.noWarningEncoding = true;
                        CheckerManagerImpl.getInstance().setNoWarning(CheckerManagerImpl.NO_WARNING_ENCODING, true);
                        return 1;
                    }
                    if (stringArray[n + 1].equals("URIomitsScheme")) {
                        this.noWarningURIOmitsScheme = true;
                        CheckerManagerImpl.getInstance().setNoWarning(CheckerManagerImpl.NO_WARNING_URI_OMITS_SCHEME, true);
                        return 1;
                    }
                    String string5 = "'-noWarning' must be followed by 'encoding' or 'URIomitsScheme'\n";
                    if (this.throwArgumentException) {
                        throw new ArgumentException(string5);
                    }
                    System.out.println(string5);
                    System.exit(0);
                    return 0;
                }
                if (this.throwArgumentException) {
                    throw new ArgumentException(this.help());
                }
                this.help(System.out);
                System.exit(0);
                return 0;
            }
            if (string.equals("outputExceptionName")) {
                this.outputExceptionName = true;
                return 0;
            }
            if (string.equals("emb")) {
                this.lint.setEmbedddedSchemas(true);
                return 0;
            }
            if (string.equals("wsdl")) {
                this.lint.setWSDL(true);
                return 0;
            }
            if (string.equals("xform")) {
                this.lint.setXFORM(true);
                return 0;
            }
            if (string.equals("schemaLocation")) {
                if (n + 2 < stringArray.length) {
                    URL uRL = null;
                    try {
                        uRL = new URL(stringArray[n + 2]);
                        uRL.openConnection();
                        URI uRI = FactoryImpl.instance().createURI();
                        uRI.setValue(stringArray[n + 1]);
                        this.lint.setSchemaLocation(uRI, uRL);
                        return 2;
                    }
                    catch (IOException iOException) {
                        String string6 = "XML Schema Quality Checker  fails to access the resource located at " + uRL + " due to the following error:\n" + iOException.getMessage() + "\n" + "Please make sure that you use an abslolute URL that points to your resource.\n";
                        if (this.throwArgumentException) {
                            throw new ArgumentException(string6);
                        }
                        System.out.println(string6);
                        System.exit(0);
                        return 0;
                    }
                }
                String string7 = "Option '-schemaLocation' must be followed by two parameters : the first for the namespace URI and the second for the absolute URL pointing to the schema\n";
                if (this.throwArgumentException) {
                    throw new ArgumentException(string7);
                }
                System.out.println(string7);
                System.exit(0);
                return 0;
            }
            if (string.equals("noNSSchemaLocation")) {
                if (n + 1 < stringArray.length) {
                    URL uRL = null;
                    try {
                        uRL = new URL(stringArray[n + 1]);
                        uRL.openConnection();
                        this.lint.setSchemaLocation((URI)null, uRL);
                        return 1;
                    }
                    catch (IOException iOException) {
                        String string8 = "XML Schema Quality Checker  fails to access the resource located at " + uRL + " due to the following error:\n" + iOException.getMessage() + "\n" + "Please make sure that you use an abslolute URL that points to your resource.\n";
                        if (this.throwArgumentException) {
                            throw new ArgumentException(string8);
                        }
                        System.out.println(string8);
                        System.exit(0);
                        return 0;
                    }
                }
                String string9 = "Option '-noNSSchemaLocation' must be followed by a valid absolute URL\n";
                if (this.throwArgumentException) {
                    throw new ArgumentException(string9);
                }
                System.out.println(string9);
                System.exit(0);
                return 0;
            }
            if (string.equals("fullProcessingDescAxis")) {
                CheckerManagerImpl.getInstance().setUnrestrictedWarningDetectionForDescendantAxis(true);
                return 0;
            }
            if (!string.equals("reportLocWithoutPath")) return super.parseOption(stringArray, n);
            TopComponentImpl.printWithFullLocationPath = false;
            return 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException.getMessage());
            return 0;
        }
    }

    protected void process() {
        boolean bl;
        block29: {
            Factory factory = FactoryImpl.instance();
            File[] fileArray = this.getFiles();
            bl = true;
            if (fileArray != null) {
                Schema[] schemaArray;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                System.out.println(this.getApplicationName() + " has been initialized");
                if (Debug.DEBUG) {
                    System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
                }
                if (this.reportAsXML) {
                    this.doc = new DocumentImpl();
                    this.output = this.doc.createElement(rootElementName);
                    this.doc.appendChild(this.output);
                    this.output.setAttribute(this.getApplicationName() + "Version", appVersion);
                    this.output.setAttribute("schemaLanguageVersion", schemaLanguageVersion);
                    this.output.setAttribute("cost", Integer.toString(this.maxCost));
                    this.output.setAttribute("haltAtFirstError", this.haltAtFirstError ? "true" : "false");
                    this.output.setAttribute("requireEachDocumentValid", this.requireEachDocumentValid ? "true" : "false");
                    this.output.setAttribute("anyWarningsRequestedToBeSuppressed", this.noWarningEncoding || this.noWarningURIOmitsScheme ? "true" : "false");
                }
                this.outputEncoding = null;
                OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)factory.getOpenCloseManager();
                try {
                    if (this.indicateProgress) {
                        if (this.progressMonitor == null) {
                            this.progressMonitor = new PercentageOfWorkDoneIndicator(false);
                            bl = false;
                            HashMap hashMap = new HashMap();
                            schemaArray = new HashMap();
                            int n = SchemaQualityChecker.getTotalWork(fileArray, hashMap, schemaArray);
                            this.lint.setLocURI2XMLSchemaData((Map)schemaArray);
                            this.lint.setLocURI2Graph(hashMap);
                            this.progressMonitor.beginTask("Validating" + fileArray.length + " schema(s)", n);
                        }
                        openCloseManagerImpl.setProgressMonitor(this.progressMonitor);
                    } else {
                        openCloseManagerImpl.setProgressMonitor(null);
                    }
                }
                catch (Exception exception) {
                    openCloseManagerImpl.setProgressMonitor(null);
                    OpenCloseManagerImpl.setIndicateProgress(false);
                    exception.printStackTrace();
                }
                int n = 0;
                while (n < fileArray.length) {
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) break;
                    System.err.println("PROCESSING " + fileArray[n] + " time : " + simpleDateFormat.format(Calendar.getInstance().getTime()) + " ...");
                    if (this.reportAsXML) {
                        this.currentFile = this.doc.createElement("file");
                        this.output.appendChild(this.currentFile);
                        this.currentFile.setAttribute("filename", fileArray[n].toString());
                        int n2 = fileArray[n].toString().lastIndexOf("\\");
                        if (n2 >= 0 && n2 < fileArray[n].toString().length() - 1) {
                            this.currentFile.setAttribute("fileNameWithoutPath", fileArray[n].toString().substring(n2 + 1));
                        } else {
                            this.currentFile.setAttribute("fileNameWithoutPath", fileArray[n].toString());
                        }
                        Element element = this.doc.createElement("startdatetime");
                        this.currentFile.appendChild(element);
                        element.appendChild(this.doc.createTextNode(simpleDateFormat.format(Calendar.getInstance().getTime())));
                    } else {
                        System.out.println(fileArray[n] + " (file " + (n + 1) + " of " + fileArray.length + ") now being read ...");
                    }
                    if (this.debugMemory) {
                        Runtime.getRuntime().runFinalization();
                        Runtime.getRuntime().gc();
                        long l = Runtime.getRuntime().freeMemory();
                        long l2 = Runtime.getRuntime().totalMemory();
                        System.out.println("free memory= " + l);
                        System.out.println("total memory= " + l2);
                    }
                    schemaArray = this.process(fileArray[n]);
                    if (this.outputEncoding == null && schemaArray != null && schemaArray.length > 0) {
                        this.outputEncoding = ((SchemaImpl)schemaArray[0]).getEncoding();
                    }
                    schemaArray = null;
                    if (this.debugMemory) {
                        Runtime.getRuntime().gc();
                        long l = Runtime.getRuntime().freeMemory();
                        long l3 = Runtime.getRuntime().totalMemory();
                        System.out.println("free memory= " + l);
                        System.out.println("total memory= " + l3);
                    }
                    System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
                    if (this.reportAsXML) {
                        Element element = this.doc.createElement("enddatetime");
                        this.currentFile.appendChild(element);
                        element.appendChild(this.doc.createTextNode(simpleDateFormat.format(Calendar.getInstance().getTime())));
                    }
                    ++n;
                }
                if (this.reportAsXML) {
                    try {
                        block28: {
                            try {
                                if (this.styleSheet == null) {
                                    this.styleSheet = this.getClass().getResource("/ErrorReport.xsl").toString();
                                }
                                schemaArray = this.doc.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + this.styleSheet + "\"");
                                Element element = this.doc.getDocumentElement();
                                this.doc.insertBefore((Node)schemaArray, element);
                                if (!this.errorReportDTD.equals("")) {
                                    DocumentType documentType = ((DocumentImpl)this.doc).createDocumentType("errorReportDocType", null, this.errorReportDTD);
                                    this.doc.insertBefore(documentType, element);
                                }
                                if (!this.errorReportSchema.equals("") && element != null) {
                                    element.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:xsi", SCHEMA_INSTANCE_NS);
                                    element.setAttributeNS(SCHEMA_INSTANCE_NS, "xsi:noNamespaceSchemaLocation", this.errorReportSchema);
                                }
                            }
                            catch (Exception exception) {
                                if (!this.debug) break block28;
                                exception.printStackTrace(System.err);
                            }
                        }
                        SchemaQualityChecker.save(this.doc, this.xmlOutput, this.outputEncoding);
                    }
                    catch (IOException iOException) {
                        if (this.debug) {
                            iOException.printStackTrace();
                            break block29;
                        }
                        System.out.println("IOError: cannot save data to " + this.xmlOutput + "\n" + iOException.getMessage());
                    }
                }
            } else {
                System.err.println("no valid files specified");
            }
        }
        if (this.progressMonitor != null && !bl) {
            this.progressMonitor.done();
        }
    }

    protected Schema[] process(File file) {
        Object[] objectArray;
        Vector vector;
        block18: {
            OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)OpenCloseManagerImpl.getInstance();
            LocationCorrespondance locationCorrespondance = openCloseManagerImpl.getLocationCorrespondance();
            try {
                locationCorrespondance.getUse(file.toURL()).openConnection();
            }
            catch (IOException iOException) {
                System.out.println("Cannot read file : " + file.toString());
                if (Debug.DEBUG) {
                    iOException.printStackTrace(System.err);
                }
                return null;
            }
            vector = new Vector();
            try {
                block17: {
                    try {
                        objectArray = CheckerManagerImpl.getInstance();
                        objectArray.reset();
                        if (this.noWarningEncoding) {
                            objectArray.setNoWarning(CheckerManagerImpl.NO_WARNING_ENCODING, true);
                        }
                        if (this.noWarningURIOmitsScheme) {
                            objectArray.setNoWarning(CheckerManagerImpl.NO_WARNING_URI_OMITS_SCHEME, true);
                        }
                        this.lint.setSqc(this);
                        Error[] errorArray = this.lint.findErrors(file.toURL(), this.maxCost, "USEnglish", "", vector, false, this.requireEachDocumentValid);
                        if (this.reportAsXML) {
                            this.xmlErrorReport(errorArray);
                        } else {
                            this.textErrorReport(errorArray);
                        }
                        if (!this.debug) break block17;
                        if (vector.size() > 0) {
                            int n = 0;
                            while (n < vector.size()) {
                                System.out.print("SCHEMA = " + ((Schema)vector.get(n)).toXMLString());
                                ++n;
                            }
                            break block17;
                        }
                        System.err.println(" No schema at : " + file.toURL().toString());
                    }
                    catch (IOException iOException) {
                        if (Debug.DEBUG) {
                            iOException.printStackTrace(System.err);
                        } else {
                            System.out.println(iOException.getMessage());
                        }
                        Object var9_12 = null;
                        openCloseManagerImpl.closeAllOpenedSchemas();
                        break block18;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        Object var9_13 = null;
                        openCloseManagerImpl.closeAllOpenedSchemas();
                    }
                }
                Object var9_11 = null;
                openCloseManagerImpl.closeAllOpenedSchemas();
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                openCloseManagerImpl.closeAllOpenedSchemas();
                throw throwable;
            }
        }
        if (vector.size() > 0) {
            objectArray = new Schema[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    protected void processLocationCorrespondanceFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("location correspondance file was not found at : " + file.toString());
            return;
        }
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setProperty("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.DocumentImpl");
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            dOMParser.parse(file.toURL().toString());
            Document document = dOMParser.getDocument();
            Element element = document.getDocumentElement();
            if (element != null) {
                OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)OpenCloseManagerImpl.getInstance();
                openCloseManagerImpl.getLocationCorrespondance().add(element);
            }
        }
        catch (Exception exception) {
            if (Debug.DEBUG) {
                exception.printStackTrace(System.err);
            }
            System.out.println("The following error occured while reading the location correspondance file at" + file.toString());
            System.out.println(exception.getMessage());
        }
    }

    public static void save(Document document, File file, String string) throws IOException {
        OutputStreamWriter outputStreamWriter;
        block2: {
            try {
                outputStreamWriter = string != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string) : new OutputStreamWriter(new FileOutputStream(file));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                if (!Debug.DEBUG) break block2;
                unsupportedEncodingException.printStackTrace(System.err);
            }
        }
        SchemaQualityChecker.save(document, outputStreamWriter, string);
    }

    protected static void save(Document document, Writer writer, String string) throws IOException {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        if (string != null) {
            outputFormat.setEncoding(string);
        }
        XMLSerializer xMLSerializer = new XMLSerializer(writer, outputFormat);
        xMLSerializer.serialize(document);
        writer.flush();
        writer.close();
    }

    public void setCost(int n) {
        this.maxCost = n;
        ((FactoryImpl)FactoryImpl.instance()).getCheckerController().setMaxCost(n);
    }

    protected void setDebug(boolean bl) {
        this.debug = bl;
        Debug.DEBUG = bl;
        com.ibm.sketch.parser.Debug.DEBUG = bl;
        com.ibm.sketch.schemaparser.Debug.DEBUG = bl;
        com.ibm.xml.ecm.schema.impl.Debug.DEBUG = bl;
    }

    public void setErrorReportDTD(String string) {
        this.errorReportDTD = string;
    }

    public void setHaltAtFirstError(boolean bl) {
        this.haltAtFirstError = bl;
    }

    public void textErrorReport(Error[] errorArray) {
        if (errorArray == null || errorArray.length == 0) {
            System.out.println(" NO ERROR ");
        } else {
            int n = 0;
            while (n < errorArray.length) {
                Exception[] exceptionArray;
                Locator locator = errorArray[n].getLocator();
                System.out.println("ERROR");
                if (locator != null) {
                    System.out.println(" file = " + locator.getSystemId() + " line " + locator.getLineNumber() + " column " + locator.getColumnNumber());
                }
                System.out.println("SEVERITY: " + errorArray[n].getSeverity());
                System.out.println("ERROR TYPE: " + errorArray[n].getErrorType());
                String string = "";
                int n2 = 0;
                while (n2 < errorArray[n].getMessage().length()) {
                    if (errorArray[n].getMessage().charAt(n2) == '<' && n2 + "<speclink".length() <= errorArray[n].getMessage().length() && errorArray[n].getMessage().substring(n2, n2 + "<speclink".length()).equals("<speclink")) {
                        n2 += "<speclink".length();
                        while (n2 < errorArray[n].getMessage().length() && errorArray[n].getMessage().charAt(n2) != '>') {
                            ++n2;
                        }
                        ++n2;
                        continue;
                    }
                    if (errorArray[n].getMessage().charAt(n2) == '<' && n2 + "</speclink>".length() <= errorArray[n].getMessage().length() && errorArray[n].getMessage().substring(n2, n2 + "</speclink>".length()).equals("</speclink>")) {
                        n2 += "</speclink>".length();
                        continue;
                    }
                    string = string + errorArray[n].getMessage().charAt(n2);
                    ++n2;
                }
                if (this.outputExceptionName && (exceptionArray = errorArray[n].getExceptions()) != null) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    int n3 = 0;
                    while (n3 < exceptionArray.length) {
                        treeSet.add(exceptionArray[n3].getClass().getName());
                        ++n3;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator iterator = treeSet.iterator();
                    boolean bl = true;
                    while (iterator.hasNext()) {
                        if (bl) {
                            bl = false;
                            stringBuffer.append((String)iterator.next());
                            continue;
                        }
                        stringBuffer.append(", " + (String)iterator.next());
                    }
                    System.out.print("EXCEPTIONS : ");
                    System.out.println(stringBuffer.toString());
                }
                System.out.println("MESSAGE ");
                System.out.println(string);
                if (this.debug) {
                    System.out.println("EXCEPTIONS");
                    exceptionArray = errorArray[n].getExceptions();
                    if (exceptionArray != null) {
                        int n4 = 0;
                        while (n4 < exceptionArray.length) {
                            exceptionArray[n4].printStackTrace();
                            ++n4;
                        }
                    }
                }
                System.out.println("   ------------------------------------------------------------------------ ");
                ++n;
            }
        }
    }

    public void xmlErrorReport(Error[] errorArray) {
        if (errorArray == null || errorArray.length == 0) {
            Element element = this.doc.createElement("noErrorFound");
            this.currentFile.appendChild(element);
        } else {
            int n = 0;
            while (n < errorArray.length) {
                this.currentFile.appendChild(this.xmlErrorReport(errorArray[n]));
                ++n;
            }
        }
    }

    protected Element xmlErrorReport(Error error) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        Element element;
        Locator locator = error.getLocator();
        Element element2 = this.doc.createElement("error");
        element2.setAttribute("severity", String.valueOf(error.getSeverity()));
        element2.setAttribute("type", String.valueOf(error.getErrorType()));
        if (locator != null) {
            element = this.doc.createElement("source");
            element2.appendChild(element);
            element.setAttribute("location", locator.getSystemId());
            object4 = object5 = locator.getSystemId();
            if (object5 != null && (n = ((String)object5).lastIndexOf("/")) >= 0 && n < ((String)object5).length() - 1) {
                object4 = ((String)object4).substring(n + 1);
            }
            element.setAttribute("locationWithoutPath", (String)object4);
            element.setAttribute("line", String.valueOf(locator.getLineNumber()));
            element.setAttribute("column", String.valueOf(locator.getColumnNumber()));
        }
        element = this.doc.createElement("message");
        element2.appendChild(element);
        if (this.outputExceptionName && (object5 = error.getExceptions()) != null) {
            object4 = new TreeSet();
            n = 0;
            while (n < ((Object)object5).length) {
                ((TreeSet)object4).add(object5[n].getClass().getName());
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            object3 = ((TreeSet)object4).iterator();
            boolean bl = true;
            while (object3.hasNext()) {
                if (bl) {
                    bl = false;
                    stringBuffer.append((String)object3.next());
                    continue;
                }
                stringBuffer.append(", " + (String)object3.next());
            }
            element.setAttribute("exceptions", stringBuffer.toString());
        }
        object5 = "";
        object4 = "";
        n = 0;
        boolean bl = false;
        while (n < error.getMessage().length()) {
            if (error.getMessage().charAt(n) == '<' && n + "<speclink".length() <= error.getMessage().length() && error.getMessage().substring(n, n + "<speclink".length()).equals("<speclink")) {
                n += "<speclink".length();
                object4 = "<speclink";
                bl = true;
                if (((String)object5).equals("")) continue;
                element.appendChild(this.doc.createTextNode((String)object5));
                object5 = "";
                continue;
            }
            if (error.getMessage().charAt(n) == '<' && n + "</speclink>".length() <= error.getMessage().length() && error.getMessage().substring(n, n + "</speclink>".length()).equals("</speclink>")) {
                n += "</speclink>".length();
                object4 = (String)object4 + "</speclink>";
                object3 = new DOMParser();
                try {
                    ((DOMParser)object3).parse(new InputSource(new StringReader((String)object4)));
                    Document document = ((AbstractDOMParser)object3).getDocument();
                    object2 = document.getElementsByTagName("speclink");
                    object = this.doc.importNode(object2.item(0), true);
                    NamedNodeMap namedNodeMap = object2.item(0).getAttributes();
                    Node node = this.doc.importNode(namedNodeMap.item(0), true);
                    node.setNodeValue(namedNodeMap.item(0).getNodeValue());
                    ((Element)object).setAttributeNode((Attr)node);
                    element.appendChild((Node)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object4 = "";
                bl = false;
                continue;
            }
            if (bl) {
                object4 = (String)object4 + error.getMessage().charAt(n);
            } else {
                object5 = (String)object5 + error.getMessage().charAt(n);
            }
            ++n;
        }
        if (!((String)object5).equals("")) {
            element.appendChild(this.doc.createTextNode((String)object5));
        }
        if (this.debug && (object3 = error.getExceptions()) != null) {
            int n2 = 0;
            while (n2 < ((Exception[])object3).length) {
                object2 = this.doc.createElement("exception");
                element2.appendChild((Node)object2);
                object = new StringWriter();
                object3[n2].printStackTrace(new PrintWriter((Writer)object, true));
                object2.appendChild(this.doc.createTextNode(((StringWriter)object).getBuffer().toString()));
                ++n2;
            }
        }
        return element2;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public static int getTotalWork(File[] fileArray, Map map, Map map2) throws Exception {
        XSDParserImpl xSDParserImpl = new XSDParserImpl();
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            URL uRL = fileArray[n2].toURL();
            URI uRI = FactoryImpl.instance().createURI();
            uRI.setValue(uRL.toString());
            GraphImpl graphImpl = xSDParserImpl.buildGraph(uRL);
            n += xSDParserImpl.estimateTotalWork(graphImpl);
            if (map != null) {
                map.put(uRI, graphImpl);
            }
            ++n2;
        }
        if (map2 != null) {
            map2.putAll(xSDParserImpl.getLocURI2XMLSchemaData());
        }
        return n;
    }

    public Lint getLint() {
        return this.lint;
    }
}

