/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util;

import com.ibm.sketch.util.CommandLineApplication;
import com.ibm.sketch.util.Debug;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.sketch.util.urlRedirection.LocationCorrespondance;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import com.ibm.sketch.viewandvisitor.PSVInfosetXmlDocumentVisitorImpl;
import com.ibm.xml.ecm.schema.Schema;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.OpenCloseManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;

public class XSD2SchemaComponents
extends CommandLineApplication {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean DEBUG = false;
    public static final String version = "Alpha 1.0.1";

    public String getApplicationName() {
        return "XSD2SchemaComponents";
    }

    public String[] getFileExtensions() {
        return new String[]{"xsd"};
    }

    public static String getVersion() {
        return version;
    }

    protected void help(PrintStream printStream) {
        super.help(printStream);
        printStream.println("-version, to get the version of number of " + this.getApplicationName());
    }

    public static void main(String[] stringArray) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        XSD2SchemaComponents xSD2SchemaComponents = new XSD2SchemaComponents();
        System.out.println("Initializing " + ((CommandLineApplication)xSD2SchemaComponents).getApplicationName() + ". Please wait ...");
        if (Debug.DEBUG) {
            System.err.println("Start time : " + simpleDateFormat.format(Calendar.getInstance().getTime()));
        }
        FactoryImpl.instance();
        xSD2SchemaComponents.processFromCommandLine(stringArray);
    }

    protected int parseOption(String[] stringArray, int n) {
        String string = stringArray[n].substring(1);
        String string2 = "options '-alltypes','-allgroups', '-allattributegroups', '-allelements', '-allattributes',  ' -t typeName', '-element name', 'attribute name', '-attributeGroup name', '-group name'  are mutually exclusive";
        if (string.equals("version")) {
            System.out.println(this.getApplicationName() + " version " + version);
            return 0;
        }
        return super.parseOption(stringArray, n);
    }

    protected void process() {
        File[] fileArray = this.getFiles();
        if (fileArray == null || fileArray.length == 0 || fileArray.length > 1) {
            this.help(System.err);
            System.exit(0);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        System.out.println(this.getApplicationName() + " has been initialized");
        System.err.println("PROCESSING " + fileArray[0] + " time : " + simpleDateFormat.format(Calendar.getInstance().getTime()) + " ...");
        Schema[] schemaArray = this.process(fileArray[0]);
        System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
    }

    protected Schema[] process(File file) {
        OpenCloseManagerImpl openCloseManagerImpl = (OpenCloseManagerImpl)OpenCloseManagerImpl.getInstance();
        LocationCorrespondance locationCorrespondance = openCloseManagerImpl.getLocationCorrespondance();
        try {
            locationCorrespondance.getUse(file.toURL()).openConnection();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file : " + file.toString());
            if (Debug.DEBUG) {
                iOException.printStackTrace(System.err);
            }
            return null;
        }
        Vector vector = new Vector();
        try {
            block13: {
                try {
                    CheckerManagerImpl.getInstance().reset();
                    Lint lint = new Lint();
                    System.out.println("Checking the validity of schema located at " + file);
                    Error[] errorArray = lint.findErrors(file.toURL(), 10, "USEnglish", "", vector, false, false);
                    CheckerManagerImpl.getInstance().setMaxCost(10);
                    if (errorArray != null && errorArray.length > 0) {
                        new SchemaQualityChecker().textErrorReport(errorArray);
                        System.out.println("\n" + errorArray.length + " errors and warnings were found. Conversion might fail.");
                    } else {
                        System.out.println("No error found.");
                    }
                    Schema schema = null;
                    if (vector.size() > 0) {
                        schema = (Schema)vector.get(0);
                    }
                    if (schema != null) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        DocumentImpl documentImpl = new DocumentImpl();
                        documentImpl.appendChild(documentImpl.createComment("Generated by " + this.getApplicationName() + " version " + version + " on " + simpleDateFormat.format(Calendar.getInstance().getTime())));
                        schema.accept(new PSVInfosetXmlDocumentVisitorImpl(documentImpl));
                        SchemaQualityChecker.save((Document)documentImpl, new File(file.toString() + ".psv"), null);
                        break block13;
                    }
                    System.out.println("Conversion was not performed");
                }
                catch (IOException iOException) {
                    if (Debug.DEBUG) {
                        iOException.printStackTrace(System.err);
                    } else {
                        System.out.println(iOException.getMessage());
                    }
                    Object var11_13 = null;
                    openCloseManagerImpl.closeAllOpenedSchemas();
                }
            }
            Object var11_12 = null;
            openCloseManagerImpl.closeAllOpenedSchemas();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            openCloseManagerImpl.closeAllOpenedSchemas();
            throw throwable;
        }
        return null;
    }
}

