/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.util.xpath;

import com.ibm.sketch.util.xpath.XPath;
import com.ibm.xml.ecm.schema.AttributeDecl;
import com.ibm.xml.ecm.schema.AttributeWildcard;
import com.ibm.xml.ecm.schema.CircularDefinitionException;
import com.ibm.xml.ecm.schema.ComplexType;
import com.ibm.xml.ecm.schema.ContentType;
import com.ibm.xml.ecm.schema.ElementDecl;
import com.ibm.xml.ecm.schema.ElementRef;
import com.ibm.xml.ecm.schema.GlobalElementDecl;
import com.ibm.xml.ecm.schema.Group;
import com.ibm.xml.ecm.schema.LocalElementDecl;
import com.ibm.xml.ecm.schema.ModelGroupDef;
import com.ibm.xml.ecm.schema.ModelGroupRef;
import com.ibm.xml.ecm.schema.Particle;
import com.ibm.xml.ecm.schema.ParticleWildcard;
import com.ibm.xml.ecm.schema.ReferenceResolutionException;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.Type;
import com.ibm.xml.ecm.schema.URI;
import com.ibm.xml.ecm.schema.gen.impl.FactoryImplGen;
import com.ibm.xml.ecm.schema.impl.CheckerManagerImpl;
import com.ibm.xml.ecm.schema.impl.CircularDefinitionInAGroup_Checker;
import com.ibm.xml.ecm.schema.impl.ComplexTypeDefImpl;
import com.ibm.xml.ecm.schema.impl.ComplexTypeSpecImpl;
import com.ibm.xml.ecm.schema.impl.SchemaObjectImpl;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class XPathEvaluator {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static boolean contain(Path path, Stack stack, SchemaObject schemaObject) {
        Iterator iterator = ((AbstractList)stack).iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != schemaObject) continue;
            return true;
        }
        return path.contains(schemaObject);
    }

    private static AttributeDecl[] getAttributes(ComplexType complexType) throws SchemaException {
        Object object;
        Object object2;
        if (complexType instanceof ComplexTypeSpecImpl) {
            object2 = ((ComplexTypeSpecImpl)complexType).getEffectiveAttributesWithoutErrorChecking();
        } else if (complexType instanceof ComplexTypeDefImpl) {
            object = (ComplexTypeSpecImpl)((ComplexTypeDefImpl)complexType).getComplexTypeSpec();
            object2 = ((ComplexTypeSpecImpl)object).getEffectiveAttributesWithoutErrorChecking();
        } else {
            object2 = complexType.getEffectiveAttributes();
        }
        if (object2 != null) {
            object = new Vector();
            int n = 0;
            while (n < ((AttributeDecl[])object2).length) {
                if (object2[n].getUse() != 3) {
                    ((Vector)object).add(object2[n]);
                }
                ++n;
            }
            object2 = ((Vector)object).size() > 0 ? ((Vector)object).toArray(new AttributeDecl[((Vector)object).size()]) : null;
        }
        return object2;
    }

    private static AttributeWildcard getAttributeWildcard(ComplexType complexType) throws SchemaException {
        AttributeWildcard attributeWildcard;
        if (complexType instanceof ComplexTypeSpecImpl) {
            attributeWildcard = ((ComplexTypeSpecImpl)complexType).getEffectiveAttributeWildcardWithoutChecking();
        } else if (complexType instanceof ComplexTypeDefImpl) {
            ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)((ComplexTypeDefImpl)complexType).getComplexTypeSpec();
            attributeWildcard = complexTypeSpecImpl.getEffectiveAttributeWildcardWithoutChecking();
        } else {
            attributeWildcard = complexType.getEffectiveAttributeWildcard();
        }
        return attributeWildcard;
    }

    private static ContentType getContentType(ComplexType complexType) throws SchemaException {
        ContentType contentType;
        if (complexType instanceof ComplexTypeSpecImpl) {
            contentType = ((ComplexTypeSpecImpl)complexType).getEffectiveContentTypeWithoutErrorChecking();
        } else if (complexType instanceof ComplexTypeDefImpl) {
            ComplexTypeSpecImpl complexTypeSpecImpl = (ComplexTypeSpecImpl)((ComplexTypeDefImpl)complexType).getComplexTypeSpec();
            contentType = complexTypeSpecImpl.getEffectiveContentTypeWithoutErrorChecking();
        } else {
            contentType = complexType.getEffectiveContentType();
        }
        return contentType;
    }

    /*
     * Unable to fully structure code
     */
    private static Path[] getPaths(Path[] var0, XPath.NodeTest var1_1) throws SchemaException {
        if (var0 == null) {
            return null;
        }
        switch (var1_1.type) {
            case 2: {
                return var0;
            }
            case 3: {
                var2_2 = new Vector<Path>();
                var3_4 = 0;
                while (var3_4 < var0.length) {
                    if (var0[var3_4].getTargetNodeAsElementDecl() != null || var0[var3_4].getTargetNodeAsParticleWildcard() != null) {
                        var2_2.add(var0[var3_4]);
                    }
                    ++var3_4;
                }
                var0 = var2_2.toArray(new Path[var2_2.size()]);
                break;
            }
            case 1: {
                var2_3 = new Vector<Path>();
                var3_5 = 0;
                while (var3_5 < var0.length) {
                    var4_6 = var1_1.name;
                    var5_7 = var0[var3_5].getTargetNodeDecl();
                    if (!(var5_7 instanceof ParticleWildcard) && !(var5_7 instanceof AttributeWildcard)) {
                        if (var5_7 instanceof ElementDecl) {
                            if (var4_6 != null && !var4_6.localpart.equals("") && ((ElementDecl)var5_7).getNCName() != null && var4_6.localpart.equals(((ElementDecl)var5_7).getNCName())) {
                                var2_3.add(var0[var3_5]);
                            }
                        } else if (var5_7 instanceof AttributeDecl && var4_6 != null && !var4_6.localpart.equals("") && ((AttributeDecl)var5_7).getNCName() != null && var4_6.localpart.equals(((AttributeDecl)var5_7).getNCName())) {
                            var2_3.add(var0[var3_5]);
                        }
                    }
                    ++var3_5;
                }
                var0 = var2_3.toArray(new Path[var2_3.size()]);
            }
            case 4: {
                var2_3 = new Vector<E>();
                var3_5 = 0;
                while (var3_5 < var0.length) {
                    var4_6 = var1_1.name;
                    var5_7 = var0[var3_5].getTargetNodeDecl();
                    if (var4_6.prefix.equals("")) ** GOTO lbl46
                    if (var4_6.uri == null) ** GOTO lbl71
                    var6_8 = (URI)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.URI_MOFClass);
                    var6_8.setValue(var4_6.uri);
                    ** GOTO lbl51
lbl46:
                    // 1 sources

                    if (var4_6.uri != null) {
                        var6_8 = (URI)SchemaObjectImpl.getDefaultXMIDocument().newInstance(FactoryImplGen.URI_MOFClass);
                        var6_8.setValue(var4_6.uri);
                    } else {
                        var6_8 = null;
                    }
lbl51:
                    // 3 sources

                    if (var5_7 instanceof ParticleWildcard) {
                        if (((ParticleWildcard)var5_7).getWildcard().validate(var6_8)) {
                            var2_3.add(var0[var3_5]);
                        }
                    } else if (var5_7 instanceof AttributeWildcard) {
                        if (((AttributeWildcard)var5_7).getWildcard().validate(var6_8)) {
                            var2_3.add(var0[var3_5]);
                        }
                    } else if (var5_7 instanceof ElementDecl) {
                        var7_9 = ((ElementDecl)var5_7).getTargetNamespace();
                        if (var7_9 == null && var6_8 == null || var7_9 != null && var7_9.equals(var6_8)) {
                            var2_3.add(var0[var3_5]);
                        }
                    } else if (var5_7 instanceof AttributeDecl && ((var7_9 = ((AttributeDecl)var5_7).getTargetNamespace()) == null && var6_8 == null || var7_9 != null && var7_9.equals(var6_8))) {
                        var2_3.add(var0[var3_5]);
                    }
                    var0 = var2_3.toArray(new Path[var2_3.size()]);
lbl71:
                    // 2 sources

                    ++var3_5;
                }
                break;
            }
        }
        return var0;
    }

    private static Path[] getPaths(Path path, Stack stack, ElementDecl elementDecl, XPath.Step step) throws SchemaException {
        Path[] pathArray = null;
        switch (step.axis.type) {
            case 3: {
                pathArray = new Path[]{new Path(elementDecl, elementDecl)};
                break;
            }
            case 1: {
                Particle particle;
                ContentType contentType;
                Type type = elementDecl.getEffectiveType();
                if (type == null || !type.isComplexType() || (contentType = XPathEvaluator.getContentType((ComplexType)type)) == null || !contentType.isContentModel() || contentType.asContentModel().isEmptyContentModel() || (particle = contentType.asContentModel().getParticle()) == null) break;
                pathArray = XPathEvaluator.getPathsToChildren(new Path(elementDecl), particle);
                break;
            }
            case 4: {
                pathArray = XPathEvaluator.getPathsToDescendantOrSelf(new Path(elementDecl, elementDecl), new Hashtable());
                break;
            }
            case 2: {
                Type type = elementDecl.getEffectiveType();
                if (type == null || !type.isComplexType()) break;
                AttributeWildcard attributeWildcard = XPathEvaluator.getAttributeWildcard((ComplexType)type);
                AttributeDecl[] attributeDeclArray = XPathEvaluator.getAttributes((ComplexType)type);
                Vector<Path> vector = new Vector<Path>();
                if (attributeWildcard != null) {
                    vector.add(new Path(elementDecl, attributeWildcard));
                }
                if (attributeDeclArray != null) {
                    int n = 0;
                    while (n < attributeDeclArray.length) {
                        vector.add(new Path(elementDecl, attributeDeclArray[n]));
                        ++n;
                    }
                }
                if (vector.size() <= 0) break;
                pathArray = vector.toArray(new Path[vector.size()]);
            }
        }
        return XPathEvaluator.getPaths(pathArray, step.nodeTest);
    }

    public static Path[] getPaths(ElementDecl elementDecl, XPath.LocationPath locationPath, Integer[] integerArray, Boolean[] booleanArray) throws SchemaException {
        if (locationPath == null) {
            return null;
        }
        Vector vector = XPathEvaluator.getPathsAsVector(elementDecl, locationPath, integerArray, booleanArray);
        if (vector.size() > 0) {
            return vector.toArray(new Path[vector.size()]);
        }
        return null;
    }

    public static Path[] getPaths(ElementDecl elementDecl, XPath.Step step) throws SchemaException {
        if (step == null) {
            return null;
        }
        return XPathEvaluator.getPaths(null, new Stack(), elementDecl, step);
    }

    public static Path[] getPaths(ElementDecl elementDecl, XPath xPath, Integer[] integerArray, Boolean[] booleanArray) throws SchemaException {
        if (xPath == null) {
            return null;
        }
        XPath.LocationPath[] locationPathArray = xPath.getLocationPaths();
        if (locationPathArray == null) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < locationPathArray.length) {
            Integer[] integerArray2 = new Integer[1];
            Boolean[] booleanArray2 = new Boolean[1];
            if (vector.size() > 0) {
                vector.addAll(XPathEvaluator.getPathsAsVector(elementDecl, locationPathArray[n], null, null));
            } else {
                vector.addAll(XPathEvaluator.getPathsAsVector(elementDecl, locationPathArray[n], integerArray2, booleanArray2));
            }
            try {
                if (integerArray != null && booleanArray != null) {
                    integerArray[n] = integerArray2[0];
                    booleanArray[n] = booleanArray2[0];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector.toArray(new Path[vector.size()]);
        }
        return null;
    }

    private static Vector getPathsAsVector(ElementDecl elementDecl, XPath.LocationPath locationPath, Integer[] integerArray, Boolean[] booleanArray) throws SchemaException {
        XPath.Step[] stepArray = locationPath.steps;
        if (stepArray == null) {
            return new Vector();
        }
        Vector<Path> vector = new Vector<Path>();
        int n = 0;
        while (n < stepArray.length) {
            if (n == 0) {
                vector.add(new Path(elementDecl, elementDecl));
            }
            Iterator iterator = ((AbstractList)vector).iterator();
            Vector<Path> vector2 = new Vector<Path>();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                ElementDecl elementDecl2 = path.getTargetNodeAsElementDecl();
                if (elementDecl2 == null) continue;
                Path[] pathArray = XPathEvaluator.getPaths(elementDecl2, stepArray[n]);
                if (pathArray != null) {
                    int n2 = 0;
                    while (n2 < pathArray.length) {
                        vector2.add(new Path(path, true, pathArray[n2]));
                        ++n2;
                    }
                }
                iterator.remove();
            }
            vector.addAll(vector2);
            if (vector.size() == 0) {
                if (integerArray != null && integerArray.length > 0) {
                    integerArray[0] = new Integer(n);
                }
                if (n == stepArray.length - 1 && stepArray[n].axis.type == 1 && booleanArray != null && booleanArray.length > 0) {
                    booleanArray[0] = new Boolean(XPathEvaluator.validIfEndedWithAnAttributeNode(elementDecl, stepArray));
                }
            }
            ++n;
        }
        return vector;
    }

    private static Path[] getPathsToChildren(Path path, Particle particle) throws SchemaException {
        switch (particle.getParticleType()) {
            case 2: {
                return XPathEvaluator.getPathsToDirectChildren(path, particle.asElementDecl());
            }
            case 1: {
                return XPathEvaluator.getPathsToDirectChildren(path, particle.asElementRef());
            }
            case 4: {
                return XPathEvaluator.getPathsToDirectChildren(path, particle.asWildcard());
            }
            case 0: {
                return XPathEvaluator.getPathsToDirectChildren(path, particle.asGroup());
            }
            case 3: {
                return XPathEvaluator.getPathsToDirectChildren(path, particle.asModelGroupRef());
            }
        }
        return null;
    }

    private static Path[] getPathsToDescendantOrSelf(Path path, Hashtable hashtable) throws SchemaException {
        Path[] pathArray = CheckerManagerImpl.getInstance().unrestrictedWarningDetectionForDescendantAxis() ? XPathEvaluator.getPathsToDescendantOrSelf(path, hashtable, null) : XPathEvaluator.getPathsToDescendantOrSelf_Fast(path);
        return pathArray;
    }

    private static ElementDecl[] getDescendantOrSelf(ElementDecl elementDecl, HashSet hashSet) throws SchemaException {
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        HashSet<Object> hashSet2 = new HashSet<Object>();
        hashSet2.add(elementDecl);
        hashSet.add(elementDecl);
        HashSet<ElementDecl> hashSet3 = new HashSet<ElementDecl>();
        Type type = elementDecl.getEffectiveType();
        if (type != null && type.isComplexType() && (object2 = XPathEvaluator.getContentType((ComplexType)type)) != null && object2.isContentModel() && !object2.asContentModel().isEmptyContentModel() && (object = object2.asContentModel().getParticle()) != null && (objectArray = XPathEvaluator.getPathsToChildren(new Path(elementDecl), (Particle)object)) != null) {
            n = 0;
            while (n < objectArray.length) {
                ElementDecl elementDecl2 = ((Path)objectArray[n]).getTargetNodeAsElementDecl();
                if (elementDecl2 != null) {
                    hashSet3.add(elementDecl2);
                }
                ++n;
            }
        }
        object2 = hashSet3.iterator();
        while (object2.hasNext()) {
            object = (ElementDecl)object2.next();
            if (!hashSet.add(object) || (objectArray = XPathEvaluator.getDescendantOrSelf((ElementDecl)object, hashSet)) == null) continue;
            n = 0;
            while (n < objectArray.length) {
                hashSet2.add(objectArray[n]);
                ++n;
            }
        }
        return ((AbstractCollection)hashSet2).toArray(new ElementDecl[hashSet2.size()]);
    }

    private static Path[] getPathsToDescendantOrSelf_Fast(Path path) throws SchemaException {
        ElementDecl elementDecl = path.getTargetNodeAsElementDecl();
        if (elementDecl == null) {
            return new Path[]{new Path(path)};
        }
        ElementDecl[] elementDeclArray = XPathEvaluator.getDescendantOrSelf(elementDecl, new HashSet());
        if (elementDeclArray == null) {
            return null;
        }
        Path[] pathArray = new Path[elementDeclArray.length];
        int n = 0;
        while (n < elementDeclArray.length) {
            pathArray[n] = new Path(elementDeclArray[n], elementDeclArray[n]);
            ++n;
        }
        return pathArray;
    }

    private static Path[] getPathsToDescendantOrSelf(Path path, Hashtable hashtable, Path path2) throws SchemaException {
        ElementDecl elementDecl = path.getTargetNodeAsElementDecl();
        if (elementDecl == null) {
            return new Path[]{new Path(path)};
        }
        Vector<Path> vector = new Vector<Path>();
        Vector<Path> vector2 = null;
        if (elementDecl instanceof GlobalElementDecl || elementDecl instanceof LocalElementDecl) {
            vector2 = (Vector<Path>)hashtable.get(elementDecl);
        }
        if (vector2 == null) {
            Path[] pathArray;
            Path[] pathArray2;
            ContentType contentType;
            Type type;
            vector2 = new Vector<Path>();
            Vector<Path> vector3 = new Vector<Path>();
            if (elementDecl instanceof GlobalElementDecl || elementDecl instanceof LocalElementDecl) {
                hashtable.put(elementDecl, vector2);
            }
            if ((type = elementDecl.getEffectiveType()) != null && type.isComplexType() && (contentType = XPathEvaluator.getContentType((ComplexType)type)) != null && contentType.isContentModel() && !contentType.asContentModel().isEmptyContentModel() && (pathArray2 = contentType.asContentModel().getParticle()) != null && (pathArray = XPathEvaluator.getPathsToChildren(new Path(elementDecl), (Particle)pathArray2)) != null) {
                vector3.addAll(Arrays.asList(pathArray));
                vector2.addAll(Arrays.asList(pathArray));
            }
            vector2.add(new Path(elementDecl, elementDecl));
            int n = 0;
            while (n < vector3.size()) {
                pathArray2 = XPathEvaluator.getPathsToDescendantOrSelf((Path)vector3.get(n), hashtable, path);
                if (pathArray2 != null) {
                    vector2.addAll(Arrays.asList(pathArray2));
                }
                ++n;
            }
        } else {
            if (path2 != null && path2.contains((SchemaObject)((Object)elementDecl), false)) {
                return null;
            }
            if (path.contains((SchemaObject)((Object)elementDecl), false)) {
                return null;
            }
        }
        int n = 0;
        while (n < vector2.size()) {
            vector.add(new Path(path, false, (Path)vector2.get(n)));
            ++n;
        }
        if (vector.size() > 0) {
            return vector.toArray(new Path[vector.size()]);
        }
        return null;
    }

    private static Path[] getPathsToDirectChildren(Path path, ElementRef elementRef) throws SchemaException {
        if (elementRef.getMaxOccurs().equals("0")) {
            return null;
        }
        Path path2 = new Path(path);
        path2.addParticle(elementRef);
        path2.setTargetNode((ElementDecl)((Object)elementRef.asElementRef().resolve(false)));
        return new Path[]{path2};
    }

    private static Path[] getPathsToDirectChildren(Path path, Group group) throws SchemaException {
        if (group.getMaxOccurs().equals("0")) {
            return null;
        }
        Particle[] particleArray = group.listParticle();
        if (particleArray == null) {
            return null;
        }
        CircularDefinitionException circularDefinitionException = CircularDefinitionInAGroup_Checker.checkCircularDefinitionException(group);
        if (circularDefinitionException != null) {
            throw circularDefinitionException;
        }
        Vector<Path> vector = new Vector<Path>();
        int n = 0;
        while (n < particleArray.length) {
            if (!particleArray[n].getMaxOccurs().equals("0")) {
                Path path2 = new Path(path);
                path2.addParticle(group);
                switch (particleArray[n].getParticleType()) {
                    case 2: {
                        Path[] pathArray = XPathEvaluator.getPathsToDirectChildren(path, particleArray[n].asElementDecl());
                        if (pathArray == null) break;
                        vector.addAll(Arrays.asList(pathArray));
                        break;
                    }
                    case 1: {
                        Path[] pathArray = XPathEvaluator.getPathsToDirectChildren(path, particleArray[n].asElementRef());
                        if (pathArray == null) break;
                        vector.addAll(Arrays.asList(pathArray));
                        break;
                    }
                    case 4: {
                        Path[] pathArray = XPathEvaluator.getPathsToDirectChildren(path, particleArray[n].asWildcard());
                        if (pathArray == null) break;
                        vector.addAll(Arrays.asList(pathArray));
                        break;
                    }
                    case 0: {
                        Path[] pathArray = XPathEvaluator.getPathsToDirectChildren(path, particleArray[n].asGroup());
                        if (pathArray == null) break;
                        vector.addAll(Arrays.asList(pathArray));
                        break;
                    }
                    case 3: {
                        Path[] pathArray = XPathEvaluator.getPathsToDirectChildren(path, particleArray[n].asModelGroupRef());
                        if (pathArray == null) break;
                        vector.addAll(Arrays.asList(pathArray));
                    }
                }
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector.toArray(new Path[vector.size()]);
        }
        return null;
    }

    private static Path[] getPathsToDirectChildren(Path path, LocalElementDecl localElementDecl) throws SchemaException {
        if (localElementDecl.getMaxOccurs().equals("0")) {
            return null;
        }
        Path path2 = new Path(path);
        path2.addParticle(localElementDecl);
        path2.setTargetNode(localElementDecl);
        return new Path[]{path2};
    }

    private static Path[] getPathsToDirectChildren(Path path, ModelGroupRef modelGroupRef) throws SchemaException {
        if (modelGroupRef.getMaxOccurs().equals("0")) {
            return null;
        }
        ModelGroupDef modelGroupDef = (ModelGroupDef)modelGroupRef.resolve(false);
        path = new Path(path);
        path.addParticle(modelGroupRef);
        Group group = modelGroupDef.getGroup();
        if (group != null) {
            return XPathEvaluator.getPathsToDirectChildren(path, group);
        }
        return null;
    }

    private static Path[] getPathsToDirectChildren(Path path, ParticleWildcard particleWildcard) throws SchemaException {
        if (particleWildcard.getMaxOccurs().equals("0")) {
            return null;
        }
        Path path2 = new Path(path);
        path2.setTargetNode(particleWildcard);
        return new Path[]{path2};
    }

    private static boolean validIfEndedWithAnAttributeNode(ElementDecl elementDecl, XPath.Step[] stepArray) throws SchemaException {
        boolean bl = true;
        int n = 0;
        while (n < stepArray.length - 1) {
            if (stepArray[n].nodeTest.type == 2 || stepArray[n].nodeTest.type == 4) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            XPath.Step[] stepArray2 = new XPath.Step[stepArray.length];
            System.arraycopy(stepArray, 0, stepArray2, 0, stepArray.length - 1);
            XPath.Step step = new XPath.Step(stepArray[stepArray.length - 1]);
            step.axis.type = (short)2;
            stepArray2[stepArray2.length - 1] = step;
            Vector vector = XPathEvaluator.getPathsAsVector(elementDecl, new XPath.LocationPath(new XPath.LocationPath(stepArray2)), null, null);
            return vector != null && vector.size() > 0;
        }
        return false;
    }

    public static class Path {
        public static short ELEMENT_TARGET = 0;
        public static short ATTRIBUTE_TARGET = 1;
        public static short PARTICLEWILDCARD_TARGET = (short)2;
        public static short ATTRIBUTEWILDCARD_TARGET = (short)3;
        private short fType = (short)-1;
        private SchemaObject fTargetNodeDecl;
        private ElementDecl fContextNodeDecl;
        private Vector pathFromContextToTargetNodeDecl = new Vector();
        private Vector listOfRelativePaths = null;

        private void setTargetNode(ElementDecl elementDecl) {
            this.fTargetNodeDecl = (SchemaObject)((Object)elementDecl);
            this.fType = ELEMENT_TARGET;
        }

        private Path(ElementDecl elementDecl) {
            this.fContextNodeDecl = elementDecl;
        }

        private Path(ElementDecl elementDecl, ElementDecl elementDecl2) {
            this.fContextNodeDecl = elementDecl;
            this.setTargetNode(elementDecl2);
        }

        private Path(ElementDecl elementDecl, AttributeDecl attributeDecl) {
            this.fContextNodeDecl = elementDecl;
            this.setTargetNode(attributeDecl);
        }

        private Path(ElementDecl elementDecl, AttributeWildcard attributeWildcard) {
            this.fContextNodeDecl = elementDecl;
            this.setTargetNode(attributeWildcard);
        }

        private Path(ElementDecl elementDecl, ParticleWildcard particleWildcard) {
            this.fContextNodeDecl = elementDecl;
            this.setTargetNode(particleWildcard);
        }

        private Path(Path path) {
            this.fContextNodeDecl = path.fContextNodeDecl;
            this.fTargetNodeDecl = path.fTargetNodeDecl;
            this.fType = path.fType;
            this.pathFromContextToTargetNodeDecl = (Vector)path.pathFromContextToTargetNodeDecl.clone();
        }

        private Path(Path path, boolean bl, Path path2) {
            this.fContextNodeDecl = path.fContextNodeDecl;
            this.fTargetNodeDecl = path2.fTargetNodeDecl;
            this.fType = path2.fType;
            this.pathFromContextToTargetNodeDecl = (Vector)path.pathFromContextToTargetNodeDecl.clone();
            this.pathFromContextToTargetNodeDecl.addAll(path2.pathFromContextToTargetNodeDecl);
        }

        private void setTargetNode(AttributeDecl attributeDecl) {
            this.fTargetNodeDecl = (SchemaObject)((Object)attributeDecl);
            this.fType = ATTRIBUTE_TARGET;
        }

        private void setTargetNode(AttributeWildcard attributeWildcard) {
            this.fTargetNodeDecl = attributeWildcard;
            this.fType = ATTRIBUTEWILDCARD_TARGET;
        }

        private void setTargetNode(ParticleWildcard particleWildcard) {
            this.fTargetNodeDecl = particleWildcard;
            this.fType = PARTICLEWILDCARD_TARGET;
        }

        private Particle getLastParticle() {
            int n = this.pathFromContextToTargetNodeDecl.size();
            return n > 0 ? (Particle)this.pathFromContextToTargetNodeDecl.get(n - 1) : null;
        }

        private void setTargetNode(SchemaObject schemaObject) {
            if (schemaObject instanceof AttributeDecl) {
                this.setTargetNode((AttributeDecl)((Object)schemaObject));
            } else if (schemaObject instanceof AttributeWildcard) {
                this.setTargetNode((AttributeWildcard)schemaObject);
            } else if (schemaObject instanceof ElementDecl) {
                this.setTargetNode((ElementDecl)((Object)schemaObject));
            } else {
                this.setTargetNode((ParticleWildcard)schemaObject);
            }
        }

        public SchemaObject getTargetNodeDecl() {
            return this.fTargetNodeDecl;
        }

        public boolean isAlwaysInInstances() {
            Iterator iterator = ((AbstractList)this.pathFromContextToTargetNodeDecl).iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                if (particle.getMinOccursAsInt() != 0) continue;
                return false;
            }
            return true;
        }

        public boolean mayAppearAtSameTimeAs(Path path) {
            if (this.fTargetNodeDecl == path.fTargetNodeDecl) {
                return true;
            }
            int n = this.pathFromContextToTargetNodeDecl.size() - 1;
            while (n >= 0) {
                Particle particle = (Particle)this.pathFromContextToTargetNodeDecl.get(n);
                int n2 = path.pathFromContextToTargetNodeDecl.size() - 1;
                while (n2 >= 0) {
                    Particle particle2 = (Particle)path.pathFromContextToTargetNodeDecl.get(n2);
                    if (particle == particle2) {
                        if (particle.isGroup()) {
                            return particle.asGroup().getCompositor() == 1;
                        }
                        return true;
                    }
                    --n2;
                }
                --n;
            }
            return true;
        }

        public ElementDecl getTargetNodeAsElementDecl() {
            if (this.fType == ELEMENT_TARGET) {
                return (ElementDecl)((Object)this.fTargetNodeDecl);
            }
            return null;
        }

        public AttributeDecl getTargetNodeAsAttributeDecl() {
            if (this.fType == ATTRIBUTE_TARGET) {
                return (AttributeDecl)((Object)this.fTargetNodeDecl);
            }
            return null;
        }

        public ParticleWildcard getTargetNodeAsParticleWildcard() {
            if (this.fType == PARTICLEWILDCARD_TARGET) {
                return (ParticleWildcard)this.fTargetNodeDecl;
            }
            return null;
        }

        public AttributeWildcard getTargetNodeAsAttributeWildcard() {
            if (this.fType == ATTRIBUTEWILDCARD_TARGET) {
                return (AttributeWildcard)this.fTargetNodeDecl;
            }
            return null;
        }

        public ElementDecl getContextNodeDecl() {
            return this.fContextNodeDecl;
        }

        public short getTargetNodeType() {
            return this.fType;
        }

        public Particle[] getPathFromContextToTargetNodefDecl() {
            return this.pathFromContextToTargetNodeDecl.toArray(new Particle[this.pathFromContextToTargetNodeDecl.size()]);
        }

        public boolean contains(SchemaObject schemaObject) {
            return this.contains(schemaObject, true);
        }

        public boolean contains(SchemaObject schemaObject, boolean bl) {
            if (bl && schemaObject == this.fTargetNodeDecl) {
                return true;
            }
            if (schemaObject == this.fContextNodeDecl) {
                return true;
            }
            int n = this.pathFromContextToTargetNodeDecl.size() - 1;
            while (n >= 0) {
                Particle particle = (Particle)this.pathFromContextToTargetNodeDecl.get(n);
                if (particle == schemaObject) {
                    return true;
                }
                try {
                    if (n < this.pathFromContextToTargetNodeDecl.size() - 1 && particle.isElementRef() && particle.asElementRef().resolve(false).equals(schemaObject)) {
                        return true;
                    }
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    // empty catch block
                }
                --n;
            }
            return false;
        }

        private void addParticle(Particle particle) {
            this.pathFromContextToTargetNodeDecl.add(particle);
        }

        public String toString() {
            return "source = " + this.fContextNodeDecl + "; target = " + this.fTargetNodeDecl + "; mandatory = " + this.isAlwaysInInstances();
        }
    }
}

