/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.utilities;

import com.ibm.sketch.utilities.IError;
import com.ibm.xml.ecm.schema.SchemaObject;
import com.ibm.xml.ecm.schema.impl.SchemaImpl;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class Error
implements IError {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int type;
    private int severity;
    private Exception[] exceptions;
    private SchemaObject invalidSchemaObject;
    private Locator locator;

    public Error(SchemaObject schemaObject, Locator locator, int n, int n2, Exception[] exceptionArray) {
        this.invalidSchemaObject = schemaObject;
        this.locator = locator;
        this.type = n;
        this.severity = n2;
        this.exceptions = exceptionArray;
    }

    public Error(SchemaObject schemaObject, Locator locator, int n, int n2, Exception exception) {
        this(schemaObject, locator, n, n2, new Exception[]{exception});
    }

    public static Locator createLocator(String string, String string2, int n, int n2) {
        LocatorImpl locatorImpl = new LocatorImpl();
        if (string != null) {
            locatorImpl.setSystemId(string);
        }
        if (string2 != null) {
            locatorImpl.setPublicId(string2);
        }
        locatorImpl.setLineNumber(n);
        locatorImpl.setColumnNumber(n2);
        return locatorImpl;
    }

    public String getEncoding() {
        SchemaImpl schemaImpl;
        String string = null;
        SchemaObject schemaObject = this.getInvalidSchemaObject();
        if (schemaObject != null && (schemaImpl = (SchemaImpl)schemaObject.getSchema()) != null) {
            string = schemaImpl.getEncoding();
        }
        return string;
    }

    public int getErrorType() {
        return this.type;
    }

    public Exception[] getExceptions() {
        return this.exceptions;
    }

    public SchemaObject getInvalidSchemaObject() {
        return this.invalidSchemaObject;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exceptions != null) {
            int n = 0;
            while (n < this.exceptions.length) {
                stringBuffer.append(this.exceptions[n].getMessage() + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public int getSeverity() {
        return this.severity;
    }
}

