/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.utilities;

import com.ibm.sketch.schemaparser.XSDParserImpl;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.sketch.utilities.Debug;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import com.ibm.xml.ecm.schema.InvalidStateHandler;
import com.ibm.xml.ecm.schema.SchemaException;
import com.ibm.xml.ecm.schema.SchemaObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class LintInvalidStateHandler
implements InvalidStateHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TreeSet errors = new TreeSet(new Lint.ErrorComparator());
    private XSDParserImpl parser;
    private SchemaQualityChecker sqc;

    public LintInvalidStateHandler(XSDParserImpl xSDParserImpl) {
        this.parser = xSDParserImpl;
    }

    public void action(SchemaObject schemaObject, SchemaException[] schemaExceptionArray) {
        Locator locator = this.parser.getLocator();
        if (locator != null) {
            locator = new LocatorImpl(locator);
        }
        boolean bl = false;
        int n = 0;
        while (schemaExceptionArray != null && n < schemaExceptionArray.length) {
            if (schemaExceptionArray[n].getSchemaExceptionType() == 0) {
                bl = true;
            }
            ++n;
        }
        Error error = null;
        error = bl ? new Error(schemaObject, locator, 2, 1, schemaExceptionArray) : new Error(schemaObject, locator, 2, 0, schemaExceptionArray);
        this.addError(error);
    }

    public void addError(Error error) {
        if (error != null) {
            this.errors.add(error);
            SchemaQualityChecker schemaQualityChecker = this.getSqc();
            if (schemaQualityChecker != null && schemaQualityChecker.isHaltAtFirstError()) {
                Error[] errorArray = new Error[]{error};
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                if (schemaQualityChecker.isReportAsXML()) {
                    Node node;
                    if (schemaQualityChecker.getDoc() != null && schemaQualityChecker.getCurrentFile() != null) {
                        node = schemaQualityChecker.getDoc().createElement("enddatetime");
                        schemaQualityChecker.getCurrentFile().appendChild(node);
                        node.appendChild(schemaQualityChecker.getDoc().createTextNode(simpleDateFormat.format(Calendar.getInstance().getTime())));
                    }
                    schemaQualityChecker.xmlErrorReport(errorArray);
                    if (schemaQualityChecker.getDoc() != null) {
                        node = schemaQualityChecker.getDoc();
                        try {
                            String string = schemaQualityChecker.getStyleSheet();
                            if (string == null) {
                                string = this.getClass().getResource("/ErrorReport.xsl").toString();
                            }
                            ProcessingInstruction processingInstruction = node.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + string + "\"");
                            Element element = node.getDocumentElement();
                            node.insertBefore(processingInstruction, element);
                            if (schemaQualityChecker.getErrorReportDTD() != null && !schemaQualityChecker.getErrorReportDTD().equals("")) {
                                DocumentType documentType = ((DocumentImpl)node).createDocumentType("errorReportDocType", null, schemaQualityChecker.getErrorReportDTD());
                                node.insertBefore(documentType, element);
                            }
                            if (schemaQualityChecker.getXmlOutput() != null) {
                                SchemaQualityChecker.save((Document)node, schemaQualityChecker.getXmlOutput(), error.getEncoding());
                            }
                        }
                        catch (Exception exception) {
                            if (Debug.DEBUG) {
                                exception.printStackTrace(System.err);
                            }
                        }
                    }
                } else {
                    schemaQualityChecker.textErrorReport(errorArray);
                }
                System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
                System.exit(0);
            }
        }
    }

    public Vector getErrors() {
        return new Vector(this.errors);
    }

    public XSDParserImpl getParser() {
        return this.parser;
    }

    public SchemaQualityChecker getSqc() {
        return this.sqc;
    }

    public void setSqc(SchemaQualityChecker schemaQualityChecker) {
        this.sqc = schemaQualityChecker;
    }
}

