/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.utilities;

import com.ibm.sketch.parser.SketchErrorHandler;
import com.ibm.sketch.parser.SketchSAXParseException;
import com.ibm.sketch.util.SchemaQualityChecker;
import com.ibm.sketch.utilities.Debug;
import com.ibm.sketch.utilities.Error;
import com.ibm.sketch.utilities.Lint;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class LintSketchErrorHandler
implements SketchErrorHandler {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TreeSet errors = new TreeSet(new Lint.ErrorComparator());
    private SchemaQualityChecker sqc;

    public void addError(Error error) {
        if (error != null) {
            this.errors.add(error);
            SchemaQualityChecker schemaQualityChecker = this.getSqc();
            if (schemaQualityChecker != null && schemaQualityChecker.isHaltAtFirstError()) {
                Error[] errorArray = new Error[]{error};
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                if (schemaQualityChecker.isReportAsXML()) {
                    Node node;
                    if (schemaQualityChecker.getDoc() != null && schemaQualityChecker.getCurrentFile() != null) {
                        node = schemaQualityChecker.getDoc().createElement("enddatetime");
                        schemaQualityChecker.getCurrentFile().appendChild(node);
                        node.appendChild(schemaQualityChecker.getDoc().createTextNode(simpleDateFormat.format(Calendar.getInstance().getTime())));
                    }
                    schemaQualityChecker.xmlErrorReport(errorArray);
                    if (schemaQualityChecker.getDoc() != null) {
                        node = schemaQualityChecker.getDoc();
                        try {
                            String string = schemaQualityChecker.getStyleSheet();
                            if (string == null) {
                                string = this.getClass().getResource("/ErrorReport.xsl").toString();
                            }
                            ProcessingInstruction processingInstruction = node.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + string + "\"");
                            Element element = node.getDocumentElement();
                            node.insertBefore(processingInstruction, element);
                            if (schemaQualityChecker.getErrorReportDTD() != null && !schemaQualityChecker.getErrorReportDTD().equals("")) {
                                DocumentType documentType = ((DocumentImpl)node).createDocumentType("errorReportDocType", null, schemaQualityChecker.getErrorReportDTD());
                                node.insertBefore(documentType, element);
                            }
                            if (schemaQualityChecker.getXmlOutput() != null) {
                                SchemaQualityChecker.save((Document)node, schemaQualityChecker.getXmlOutput(), error.getEncoding());
                            }
                        }
                        catch (Exception exception) {
                            if (Debug.DEBUG) {
                                exception.printStackTrace(System.err);
                            }
                        }
                    }
                } else {
                    schemaQualityChecker.textErrorReport(errorArray);
                }
                System.err.println("end time = " + simpleDateFormat.format(Calendar.getInstance().getTime()));
                System.exit(0);
            }
        }
    }

    public void error(SketchSAXParseException sketchSAXParseException) {
        Exception exception = sketchSAXParseException.getException();
        if (exception == null) {
            exception = sketchSAXParseException;
        }
        this.addError(new Error(null, (Locator)new LocatorImpl(sketchSAXParseException.getLocator()), 1, 1, exception));
    }

    public void fatalError(SketchSAXParseException sketchSAXParseException) {
        Exception exception = sketchSAXParseException.getException();
        if (exception == null) {
            exception = sketchSAXParseException;
        }
        this.addError(new Error(null, (Locator)new LocatorImpl(sketchSAXParseException.getLocator()), 1, 2, exception));
    }

    public Vector getErrors() {
        return new Vector(this.errors);
    }

    public SchemaQualityChecker getSqc() {
        return this.sqc;
    }

    public void setSqc(SchemaQualityChecker schemaQualityChecker) {
        this.sqc = schemaQualityChecker;
    }

    public void warning(SketchSAXParseException sketchSAXParseException) {
        Exception exception = sketchSAXParseException.getException();
        if (exception == null) {
            exception = sketchSAXParseException;
        }
        this.addError(new Error(null, (Locator)new LocatorImpl(sketchSAXParseException.getLocator()), 1, 0, exception));
    }
}

