/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sketch.utilities;

import com.ibm.sketch.parser.SchemaTags;
import com.ibm.xml.ecm.schema.BuiltInDatatypeDef;
import com.ibm.xml.ecm.schema.Factory;
import com.ibm.xml.ecm.schema.TypeInfo;
import com.ibm.xml.ecm.schema.impl.BuiltInDatatypeFactory;
import com.ibm.xml.ecm.schema.impl.FactoryImpl;
import com.ibm.xml.ecm.schema.impl.PrimitiveDatatypeImpl;
import java.util.Enumeration;
import java.util.Hashtable;

public class ListBuiltInTypes {
    public static final String copyright = "Licensed Materials - Property of IBM (C) Copyright IBM Corp. 2000, 2001, 2002    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Creating factory...\n");
        Factory factory = FactoryImpl.instance();
        BuiltInDatatypeFactory builtInDatatypeFactory = BuiltInDatatypeFactory.getInstance();
        Hashtable hashtable = builtInDatatypeFactory.getRegistry();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            BuiltInDatatypeDef builtInDatatypeDef = (BuiltInDatatypeDef)enumeration.nextElement();
            if (builtInDatatypeDef != null) {
                System.out.println(builtInDatatypeDef.getNCName() + ":");
                TypeInfo typeInfo = builtInDatatypeDef.getBasetype();
                if (typeInfo != null) {
                    System.out.print("\tBasetype: ");
                    System.out.println(typeInfo.resolveToType());
                } else {
                    System.out.println("\tBasetype: " + factory.getBuiltInDatatype("anySimpleType"));
                }
                BuiltInDatatypeDef builtInDatatypeDef2 = null;
                int n = -1;
                try {
                    if (builtInDatatypeDef.isSimpleType()) {
                        int n2;
                        Object[] objectArray;
                        builtInDatatypeDef2 = builtInDatatypeDef;
                        n = builtInDatatypeDef2.getVariety();
                        System.out.print("\tVariety= ");
                        switch (n) {
                            case 0: {
                                System.out.println("ATOMIC");
                                break;
                            }
                            case 1: {
                                System.out.println("LIST");
                                TypeInfo[] typeInfoArray = builtInDatatypeDef.listUsedtype();
                                System.out.println("\titemType= " + typeInfoArray[0].resolveToType());
                                if (typeInfoArray.length <= 1) break;
                                throw new RuntimeException("more than one itemType");
                            }
                            case 2: {
                                System.out.println("UNION");
                                TypeInfo[] typeInfoArray = builtInDatatypeDef.listUsedtype();
                                System.out.print("\tmembers= ");
                                int n3 = 0;
                                while (n3 < typeInfoArray.length) {
                                    System.out.print(typeInfoArray[n3].resolveToType() + "   ");
                                    ++n3;
                                }
                                System.out.println();
                                break;
                            }
                            default: {
                                System.out.println("unknown");
                            }
                        }
                        if (builtInDatatypeDef2.getPrimitiveDatatype() != null && (objectArray = (Object[])((PrimitiveDatatypeImpl)builtInDatatypeDef2.getPrimitiveDatatype()).getTheAllowedFacets()) != null) {
                            System.out.print("\tAllowed Facets:\n\t\t");
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                System.out.print(SchemaTags.getFacetName((int)objectArray[n2]) + (n2 == objectArray.length - 1 ? "\n" : ", "));
                                ++n2;
                            }
                        }
                        if ((objectArray = builtInDatatypeDef2.getFacets()) != null) {
                            System.out.println("\tFacets:");
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                System.out.print("\t\t" + objectArray[n2].getFacetTypeAsString() + ": ");
                                String[] stringArray2 = objectArray[n2].getValuesAsString();
                                if (stringArray2 != null) {
                                    int n4 = 0;
                                    while (n4 < stringArray2.length) {
                                        System.out.print(stringArray2[n4] + (n4 == stringArray2.length - 1 ? "\n" : ", "));
                                        ++n4;
                                    }
                                }
                                ++n2;
                            }
                        } else {
                            System.out.println();
                        }
                    } else {
                        System.out.println("\t" + builtInDatatypeDef.getNCName() + " is not a SimpleType");
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            System.out.println();
        }
    }
}

